/*  MikMod example player
	(c) 2003 Raphael Assenat and others - see file AUTHORS for
	complete list.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

/*==============================================================================

  $Id: attr.c,v 1.14 2003/10/05 02:00:34 raph Exp $

  Functions called to set the color attributes for different area in the display

==============================================================================*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_NCURSES_H
	#include <ncurses.h>
#else
	#include <curses.h>
#endif

#include <mikmod.h>
#include "display.h"
#include "player.h"



static int color_supported = 0;
#define MAY_DO_COLOR (color_supported && config.color)

void attr_init_colors(int quiet)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!quiet)
	{		
		color_supported = has_colors();
		if (color_supported)
		{
			start_color();
			init_pair(1, COLOR_RED, COLOR_BLACK);
			init_pair(2, COLOR_GREEN, COLOR_BLACK);
			init_pair(3, COLOR_YELLOW, COLOR_BLACK);
			init_pair(4, COLOR_BLUE, COLOR_BLACK);
			init_pair(5, COLOR_MAGENTA, COLOR_BLACK);
			init_pair(6, COLOR_CYAN, COLOR_BLACK);
			init_pair(7, COLOR_WHITE, COLOR_BLACK);
			init_pair(8, COLOR_BLACK, COLOR_BLACK);			
			init_pair(9, COLOR_BLACK, COLOR_CYAN); // version
		}
	}
#endif
}

void attr_banner(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD|COLOR_PAIR(6));
#endif
}

void attr_banner1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

void attr_version(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(9));
#endif
}

void attr_normal(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_NORMAL);
#endif
}

/* Name: <song name>
   ^^^^^
    Use for this
*/
void attr_song_name1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* Name: song name
         ^^^^^^^^^
           Use for this
*/
void attr_song_name2(void)
{	
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD|COLOR_PAIR(2));
#endif
}

/* File: filename <(archive)>
 * ^^^^^
 *   Use for this
 */
void attr_file1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* File: filename <(archive)>
 *       ^^^^^
 *         Use for this
 */
void attr_file2(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD|COLOR_PAIR(5));
#endif
}

/* File: filename <(archive)>
 *                ^^^^^
 *       Use for this
 */
void attr_file3(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD|COLOR_PAIR(1));
#endif
}

/* Output: 'drivername', %d bit 'surround/normal/interpolated', %d hz, 'reverb/no/value'
 *  ^^^^^^
 *   use for this
 */
void attr_driver1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* Driver: 'drivername', %d bit 'surround/normal/interpolated', %d hz, 'reverb/no/value'
 *         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
 *           use for this
 */
void attr_driver2(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	//attrset(A_BOLD|COLOR_PAIR(4));
	//attrset(COLOR_PAIR(4));
	attrset(A_BOLD);
#endif
}

/* Type: 'module type', Periods: 'period type', 'linear/log'
 * ^^^^^
 *       Use for this
 */
void attr_type1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* Type: 'module type', Periods: 'period type', 'linear/log'
 *       ^^^^^^^^^^^^^
 *       Use for this
 */
void attr_type2(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* Type: 'module type', Periods: 'period type', 'linear/log'
 *                      ^^^^^^^^
 *                 Use for this
 */
void attr_type3(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* Type: 'module type', Periods: 'period type', 'linear/log'
 *                               ^^^^^^^^^^^^^^
 *                          Use for this
 */
void attr_type4(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* Type: 'module type', Periods: 'period type', 'linear/log'
 *                                              ^^^^^^^^^^^^^^
 *                                      Use for this
 */
void attr_type5(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 * ^^^^
 *   Use for this
 * */
void attr_status_line1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *     ^^^^^^^^^
 *        Use for this
 * */
void attr_status_line2(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *               ^^^^
 *             Use for this
 * */
void attr_status_line3(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                   ^^^^^^
 *                 Use for this
 * */
void attr_status_line4(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                          ^^^^
 *                       Use for this
 * */
void attr_status_line5(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                              ^^^^^^^
 *                         Use for this
 * */
void attr_status_line6(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                                      ^^^^
 *                                  Use for this
 * */
void attr_status_line7(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                                          ^^^^^^^^^^^
 *                                          Use for this
 * */
void attr_status_line8(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                                                      ^^^^^
 *                                                   Use for this
 * */
void attr_status_line9(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                                                           ^^^^^^^^^^^^^^^^^^^^^
 *                                                               Use for this
 * */
void attr_status_line10(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                                                                                 ^^^^
 *                                                                        Use for this
 * */
void attr_status_line11(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
}

/* pat:%03d/%03d pos:%02.2X spd:%2d/%3d vol:%3d%%/%3d%% time:%2d:%02d/<total time> chn:%d/%d
 *                                                                                     ^^^^^
 *                                                                            Use for this
 * */
void attr_status_line12(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* [ panel title ] -- H:[help] S:[samples] C:[config] 
 * ^^^^^^^^^^^^^^
 *   Use for this
 * */
void attr_info1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(9));
#endif
}

/* [ %d Modules ] -- H:[help] S:[samples] C:[config] 
 *                ^^
 *           Use for this
 * */
void attr_info2(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* [ %d Modules ] -- H:[help] S:[samples] C:[config] 
 *                   ^^       ^^          ^^
 *              Use for this
 * */
void attr_info3(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(A_BOLD);
#endif
}

/* [ %d Modules ] -- H:[help] S:[samples] C:[config] 
 *                     ^^^^^^   ^^^^^^^^^   ^^^^^^^^
 *              Use for this
 * */
void attr_info4(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(9));
#endif
}

void attr_sample_num(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
	
}

void attr_sample_name(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(7));
#endif
}

void attr_inst_num(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(6));
#endif
	
}

void attr_inst_name(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attrset(COLOR_PAIR(7));
#endif
}


void attr_list_num(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attron(COLOR_PAIR(6));
#endif
}

void attr_list_sort(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attron(A_BOLD|COLOR_PAIR(7));
#endif
}

void attr_list_name(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attron(COLOR_PAIR(7));
#endif
}

void attr_list_time(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attron(A_BOLD|COLOR_PAIR(2));
#endif
}

void attr_list_pack(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attron(A_BOLD|COLOR_PAIR(1));
#endif
}

/* The status line  */
void attr_bottom_status_line1(void)
{
#ifdef ENABLE_COLOR_INTERFACE
	if (!MAY_DO_COLOR) return;
	attron(A_BOLD|COLOR_PAIR(8));	

#endif
}

