#!/bin/sh

VERSION=$2
TAR=../mp4parser_$VERSION.orig.tar.xz
DIR=mp4parser-$VERSION

mkdir $DIR
tar -xf $3 --strip-components=1 -C $DIR
rm $3

XZ_OPT=--best tar -c -v -J -f $TAR \
    --exclude='examples/src' \
    --exclude='androidtest/src' \
    --exclude='*.3gp' \
    --exclude='*.aac' \
    --exclude='*.ac3' \
    --exclude='*.f4v' \
    --exclude='*.m4a' \
    --exclude='*.m4p' \
    --exclude='*.m4s' \
    --exclude='*.mp4' \
    --exclude='*.mp4f' \
    --exclude='*.h264' \
    --exclude='*.srt' \
    --exclude='*.odf' \
    $DIR
rm -Rf $DIR
