/* util-tcl.c
  
   Tcl utility functions

   Copyright (C) 2007, 2008, 2009, 2010 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "includes.h"

/*
 * Variables predefined by Network Expect are retrieved using this routine
 * which looks in the global space if they are not in the local space.  This
 * allows the user to localize them if desired, and also to avoid having to put
 * "global" in procedure definitions.
 */
const char *
nexp_get_var(Tcl_Interp *interp, char *varname)
{
    const char *val;

    if ( (val = Tcl_GetVar(interp, varname, 0 /* local */) ) != NULL)
	return(val);

    return Tcl_GetVar(interp, varname, TCL_GLOBAL_ONLY);
}

/*
 * Same as previous function but returns a Tcl_Obj pointer.
 */
Tcl_Obj *
nexp_get_var2ex(Tcl_Interp *interp, char *varname)
{
    Tcl_Obj *val;

    if ( (val = Tcl_GetVar2Ex(interp, varname, NULL, 0 /* local */) ) != NULL)
	return(val);

    return Tcl_GetVar2Ex(interp, varname, NULL, TCL_GLOBAL_ONLY);
}

/* Do not terminate format strings with \n!!! */
void
nexp_error TCL_VARARGS_DEF(Tcl_Interp *, arg1)
{
    Tcl_Interp *interp;
    char *fmt;
    va_list args;
    char buffer[2000];

    interp = TCL_VARARGS_START(Tcl_Interp *, arg1, args);
    fmt = va_arg(args, char *);
    vsnprintf(buffer, sizeof(buffer), fmt, args);
    Tcl_SetResult(interp, buffer, TCL_VOLATILE);
    va_end(args);
}

/*
 * Copy Tcl obj vector into a new buffer, concatenating arguments with
 * spaces (based on copy_argv(), stolen from tcpdump)
 */
char *
copy_objv(int objc, Tcl_Obj * const *objv)
{
    int len;
    char *buf, *str;
    Tcl_Obj *strobj;

    strobj = Tcl_ConcatObj(objc, objv);
    str = Tcl_GetStringFromObj(strobj, &len);

    if (len == 0)
	return NULL;

    buf = xmalloc(len + 1);

    strlcpy(buf, str, len + 1);

    return buf;
}
