/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.transform.JDOMSource;

public class SimpleTransformer {
    Hashtable mParams = new Hashtable();

    public void setParameter(String name, Object expression) {
        this.mParams.put(name, expression);
    }

    public void clearParameters() {
        this.mParams.clear();
    }

    public String transform(String xsltpath, String data) throws JDOMException, TransformerConfigurationException, TransformerException, IOException {
        InputStream xslt = this.getClass().getClassLoader().getResourceAsStream(xsltpath);
        return this.transform(xslt, data);
    }

    public String transform(String xsltpath, InputStream data) throws JDOMException, TransformerConfigurationException, TransformerException, IOException {
        InputStream xslt = this.getClass().getClassLoader().getResourceAsStream(xsltpath);
        return this.transform(xslt, data);
    }

    public String transform(InputStream xslt, String data) throws JDOMException, TransformerConfigurationException, TransformerException, IOException {
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(data.getBytes());
        return this.transform(xslt, (InputStream)xmlStream);
    }

    public String transform(InputStream xslt, InputStream xmlStream) throws JDOMException, TransformerConfigurationException, TransformerException, IOException {
        ByteArrayOutputStream xformResult = new ByteArrayOutputStream();
        StreamResult out = new StreamResult(xformResult);
        SAXBuilder sb = new SAXBuilder();
        Document xmlDoc = sb.build(xmlStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslt));
        Enumeration keys = this.mParams.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            transformer.setParameter(key, this.mParams.get(key));
        }
        transformer.transform(new JDOMSource(xmlDoc), out);
        return xformResult.toString();
    }

    public static void main(String[] args) {
        String xmlFile = args[0];
        String xsltFile = args[1];
        String model = args[2];
        try {
            SimpleTransformer st = new SimpleTransformer();
            st.setParameter("modelid", model);
            String html = st.transform((InputStream)new FileInputStream(xsltFile), (InputStream)new FileInputStream(xmlFile));
            System.out.println(html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

