#!/usr/bin/perl
# !/bin/sh
#echo RENAMED.2
#exit

# Script for converting ObexTool language files from German to template files
# Copyright Jrgen Elgaard Larsen (jel@elgaard.net),  2005
# Feel fre to use under the *GNU GPL Licence version 2 or above
#
# version 0.1

##############################################################
#
#  USAGE:
#
#    The script reads all files ending with ".de" in the 
#    present working directory and makes copies of them in
#    the same directory.
#  
#    It takes one argument, which is the language code
#    of the files to be generated, e.g.
#
#        ./AllFromGerman.pl en
#
#    There is one option, "-copyEnglish" which makes the script
#    copy the English description to the new language, e.g.
#        ./AllFromGerman.pl -copyEnglish da
#    The default is to clear all strings.
#
#    Thus, giving the command
#        ./AllFromGerman.pl -copyEnglish en
#    will automagically create complete English language files
#    for ObexTool. No further action needed!
#
##############################################################



##############################################################
# init

my $from_dir = '.';  # Directory to read files from
my $to_dir = '.';    # Directory to write files to
my $copy = 0;
my $lang = '';


##############################################################
# Program

# Read parameters
while ($lang = shift @ARGV){
    # Is this an option?
    if ( $lang =~ m/\-/){
	if ($lang = '-copyEnglish'){
	    $copy = 1;
	} else {
	    print STDERR "Unknown option: $lang\n";
	    print STDERR "See script file for usage\n\n";
	    exit 3;
	}	
    } else {
	# Not an option, must be language
	last;
    }
}

# Check, that language is set
unless ($lang){
    print STDERR "No language code given\n";
    print STDERR "See script file for usage\n\n";
    exit 4;
}

# Check that no further arguments are given:
if ((scalar @ARGV) > 0){
    print STDERR "Too many arguments\n";
    print STDERR "See script file for usage\n\n";
    exit 5;
}


my $Lang = uc($lang);

# Open directory for reading
unless (opendir DIR, $from_dir){
    print STDERR "Could not open directory for reading: $!\n";
    print STDERR "See script file for usage\n\n";
    exit 7;
}
my @files = readdir DIR;
closedir DIR;

# Run through all files ending with .de
foreach $file (@files){
    next unless ($file =~ m/\.de$/o);

    # Read file content
    unless (open FILE, "<${from_dir}/$file"){
	print STDERR "Could not open file $file: $!\n";
	next;
    }
    my @context = <FILE>;
    close FILE;

    # Make new filename
    my $newfile = $file;

    $newfile =~ s/\.de$/.$lang/;

    # Open new file for writing
    unless (open FILE, ">${to_dir}/$newfile"){
	print STDERR "Could not write file $newfile: $!\n - skipping.\n\n";
	next;
    }

    # Run through lines
    foreach $line (@context){
    
	# Replace language name
	$line =~ s/German\s+language\s+file/$Lang language file/i;
	
	# Change translation
	if ($copy){
	    $line =~ s/\"([^"]*)\"\s+\"([^"]*)\"/\"$1\" \"$1\"/;

	    # It seems there can up to 3 pais on one line, so we need this dirty hack:
	    $line =~ s/(\"[^"]*\"\s+\"[^"]*\")\s+\"([^"]*)\"\s+\"([^"]*)\"/$1 \"$2\" \"$2\"/;
	    $line =~ s/(\"[^"]*\"\s+\"[^"]*\"\s+\"[^"]*\"\s+\"[^"]*\")\s+\"([^"]*)\"\s+\"([^"]*)\"/$1 \"$2\" \"$2\"/;
	} else {
	    $line =~ s/\"([^"]*)\"\s+\"([^"]*)\"/\"$1\" \"\"/;

	    # It seems there can up to 3 pais on one line, so we need this dirty hack:
	    $line =~ s/(\"[^"]*\"\s+\"[^"]*\")\s+\"([^"]*)\"\s+\"([^"]*)\"/$1 \"$2\" \"\"/;
	    $line =~ s/(\"[^"]*\"\s+\"[^"]*\"\s+\"[^"]*\"\s+\"[^"]*\")\s+\"([^"]*)\"\s+\"([^"]*)\"/$1 \"$2\" \"\"/;
	}

	print FILE $line;
    }

    close FILE;

}


exit;

    
