#include "jdxnumbers.h"
#include "jdxblock.h" // for UnitTest
#include <tjutils/tjtest.h>

///////////////////////////////////////////////////////////////

template<class T>
void JDXnumber<T>::set_defaults() {
  val=T(0);
  minval=0.0;
  maxval=0.0;
  parx_equiv.type=TypeTraits::type2label(val);
}

template<class T>
JDXnumber<T>::JDXnumber(T v,const STD_string& name,bool userParameter,
            compatMode mode,parameterMode parameter_mode,
            const STD_string& parx_equivalent,
            float parx_assign_factor,float parx_assign_offset)  {
  set_defaults();
  val=v;
  set_label(name);
  JcampDxClass::set_compatmode(mode); // Do NOT call virtual function in constructor!
  set_userDefParameter(userParameter);
  parx_equiv.name=parx_equivalent;
  parx_equiv.factor=parx_assign_factor;
  parx_equiv.offset=parx_assign_offset;
  JcampDxClass::set_parmode(parameter_mode); // Do NOT call virtual function in constructor!
}

template<class T>
JDXnumber<T>& JDXnumber<T>::operator = (const JDXnumber<T>& bi) {
  JcampDxClass::operator = (bi);
  val=bi.val;
  parx_equiv=bi.parx_equiv;
  minval=bi.minval;
  maxval=bi.maxval;
  return *this;
}


template<class T>
STD_string JDXnumber<T>::printvalstring() const {
  return TypeTraits::type2string(val);
}


template<class T>
bool JDXnumber<T>::parsevalstring(const STD_string& parstring) {
  TypeTraits::string2type(parstring,val);
  return true;
}


template<class T>
STD_string JDXnumber<T>::get_parx_code(parxCodeType type, const ParxEquiv& equiv) const {
#ifdef PARAVISION_PLUGIN
  Log<JcampDx> odinlog(this,"get_parx_code");
  STD_string result=JcampDxClass::get_parx_code(type,equiv);

  if(type==parx_def) result=get_parx_def_string(get_typeInfo(),0);

  if(type==parx_passval) {
    STD_string transformation;
    if (equiv.offset) transformation+=ftos(equiv.offset)+"+";
    if (equiv.factor!=1.0) transformation+=ftos(equiv.factor)+"*";
    result=equiv.name+"="+transformation+get_label()+";\n";
  }

  return result;
#else
  return "";
#endif
}



///////////////////////////////////////////////////////////////////
// Instantiations

template class JDXnumber<int>;
template class JDXnumber<float>;
template class JDXnumber<double>;
template class JDXnumber<STD_complex>;


///////////////////////////////////////////////////////////////////

#ifndef NO_UNIT_TEST
class JDXintTest : public UnitTest {

 public:
  JDXintTest() : UnitTest("JDXint") {}

 private:
  bool check() const {
    Log<UnitTest> odinlog(this,"check");

    // testing JDXint
    JDXint testint(23,"testint");
    STD_string expected="##$testint=23\n";
    STD_string printed=testint.print();
    if(printed!=expected) {
      ODINLOG(odinlog,errorLog) << "JDXint::print() failed: got >" << printed << "<, but expected >" << expected << "<" << STD_endl;
      return false;
    }
    JcampDxBlock builtinblock;
    builtinblock.append(testint);
    builtinblock.parseblock("##TITLE=builtinblock\n##$testint=46\n##END=");
    if(int(testint)!=46) {
      ODINLOG(odinlog,errorLog) << "after builtinblock.parseblock(): for int " << int(testint) << "!=" << 46 << STD_endl;
      return false;
    }
    testint*=2;
    if(int(testint)!=92) {
      ODINLOG(odinlog,errorLog) << "JDXint *= " << int(testint) << "!=" << 92 << STD_endl;
      return false;
    }

    return true;
  }

};
void alloc_JDXintTest() {new JDXintTest();} // create test instance



class JDXcomplexTest : public UnitTest {

 public:
  JDXcomplexTest() : UnitTest("JDXcomplex") {}

 private:
  bool check() const {
    Log<UnitTest> odinlog(this,"check");

    // testing JDXcomplex
    JDXcomplex testcplx(STD_complex(1.2,3.4),"testcplx");
    STD_string expected="##$testcplx=1.20+3.40i\n";
    STD_string printed=testcplx.print();
    if(printed!=expected) {
      ODINLOG(odinlog,errorLog) << "JDXcomplex::print() failed: got >" << printed << "<, but expected >" << expected << "<" << STD_endl;
      return false;
    }
    JcampDxBlock cplxblock;
    cplxblock.append(testcplx);
    cplxblock.parseblock("##TITLE=cplxblock\n##testcplx=5.6+7.8i\n##END=");
    if(STD_complex(testcplx)!=STD_complex(5.6,7.8)) {
      ODINLOG(odinlog,errorLog) << "after cplxblock.parseblock(): for complex " << STD_complex(testcplx) << "!=" << STD_complex(5.6,7.8) << STD_endl;
      return false;
    }
    testcplx/=STD_complex(2.0);
    if(STD_complex(testcplx)!=STD_complex(2.8,3.9)) {
      ODINLOG(odinlog,errorLog) << "JDXcomplex /= " << STD_complex(testcplx) << "!=" << STD_complex(2.8,3.9) << STD_endl;
      return false;
    }

    return true;
  }

};
void alloc_JDXcomplexTest() {new JDXcomplexTest();} // create test instance


#endif
