import QtQuick 1.0
import QtMultimediaKit 1.1
import oif 1.0

Item {
    width: 500
    height: 500

    Camera {
        id: camera
        anchors.fill: parent

        property real angle: rotate.active ? rotate.angle.current*360 : angle
        transform: Rotation { origin.x: camera.width/2; origin.y: camera.height/2; axis { x: 0; y: 1; z: 0 } angle: camera.angle}
    }

    OIFRotateArea {
        id: rotate

        anchors.fill: parent

        subscription {
            touches.start: 2
        }
    }
}
