/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "device.h"

#include "attributes.h"

using geis_attributes::PopulateAttributeMap;

Device::Device(GeisDevice device, QDeclarativeItem *parent)
  : QDeclarativeItem(parent),
    device_(device) {
  geis_device_ref(device_);

  PopulateAttributeMap< GeisDevice >(device_, &attributes_);

  id_ = attributes_[GEIS_DEVICE_ATTRIBUTE_ID].toInt();

  bool direct = attributes_[GEIS_DEVICE_ATTRIBUTE_DIRECT_TOUCH].toBool();
  bool independent =
    attributes_[GEIS_DEVICE_ATTRIBUTE_INDEPENDENT_TOUCH].toBool();

  if (direct && !independent) {
    device_type_ = TouchScreen;
  } else if (!direct && !independent) {
    device_type_ = TouchPad;
  } else if (!direct) {
    device_type_ = Independent;
  } else {
    device_type_ = Unknown;
  }

  x_ = new AxisInfo(attributes_[GEIS_DEVICE_ATTRIBUTE_MIN_X].toFloat(),
                    attributes_[GEIS_DEVICE_ATTRIBUTE_MAX_X].toFloat(),
                    attributes_[GEIS_DEVICE_ATTRIBUTE_RES_X].toFloat(), this);
  y_ = new AxisInfo(attributes_[GEIS_DEVICE_ATTRIBUTE_MIN_Y].toFloat(),
                    attributes_[GEIS_DEVICE_ATTRIBUTE_MAX_Y].toFloat(),
                    attributes_[GEIS_DEVICE_ATTRIBUTE_RES_Y].toFloat(), this);
}

Device::~Device() {
  geis_device_unref(device_);
}
