/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "cmpiOpenDRIM_SSHCapabilities.h"

CMPIObjectPath* SSH_OpenDRIM_SSHCapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SSHCapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SSHCapabilities_classnames[0], OpenDRIM_SSHCapabilities_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* SSH_OpenDRIM_SSHCapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SSHCapabilities& instance) {
	_E_;
	Objectpath op(broker, SSH_OpenDRIM_SSHCapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.Generation_isNULL)
		ci.setProperty("Generation", instance.Generation);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.ElementNameEditSupported_isNULL)
		ci.setProperty("ElementNameEditSupported", instance.ElementNameEditSupported);

	if (!instance.MaxElementNameLen_isNULL)
		ci.setProperty("MaxElementNameLen", instance.MaxElementNameLen);

	if (!instance.RequestedStatesSupported_isNULL)
		ci.setProperty("RequestedStatesSupported", instance.RequestedStatesSupported);

	if (!instance.ElementNameMask_isNULL)
		ci.setProperty("ElementNameMask", instance.ElementNameMask);

	if (!instance.StateAwareness_isNULL)
		ci.setProperty("StateAwareness", instance.StateAwareness);

	if (!instance.MaxConnections_isNULL)
		ci.setProperty("MaxConnections", instance.MaxConnections);

	if (!instance.MaxListeningPorts_isNULL)
		ci.setProperty("MaxListeningPorts", instance.MaxListeningPorts);

	if (!instance.ListeningPortManagementSupported_isNULL)
		ci.setProperty("ListeningPortManagementSupported", instance.ListeningPortManagementSupported);

	if (!instance.SupportedSSHVersions_isNULL)
		ci.setProperty("SupportedSSHVersions", instance.SupportedSSHVersions);

	if (!instance.OtherSupportedSSHVersion_isNULL)
		ci.setProperty("OtherSupportedSSHVersion", instance.OtherSupportedSSHVersion);

	if (!instance.SupportedEncryptionAlgorithms_isNULL)
		ci.setProperty("SupportedEncryptionAlgorithms", instance.SupportedEncryptionAlgorithms);

	if (!instance.OtherSupportedEncryptionAlgorithm_isNULL)
		ci.setProperty("OtherSupportedEncryptionAlgorithm", instance.OtherSupportedEncryptionAlgorithm);

	_L_;
	return ci.getHdl();
}

void SSH_OpenDRIM_SSHCapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SSHCapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void SSH_OpenDRIM_SSHCapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SSHCapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("Generation", instance.Generation) == OK)
		instance.Generation_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("ElementNameEditSupported", instance.ElementNameEditSupported) == OK)
		instance.ElementNameEditSupported_isNULL = false;

	if (inst.getProperty("MaxElementNameLen", instance.MaxElementNameLen) == OK)
		instance.MaxElementNameLen_isNULL = false;

	if (inst.getProperty("RequestedStatesSupported", instance.RequestedStatesSupported) == OK)
		instance.RequestedStatesSupported_isNULL = false;

	if (inst.getProperty("ElementNameMask", instance.ElementNameMask) == OK)
		instance.ElementNameMask_isNULL = false;

	if (inst.getProperty("StateAwareness", instance.StateAwareness) == OK)
		instance.StateAwareness_isNULL = false;

	if (inst.getProperty("MaxConnections", instance.MaxConnections) == OK)
		instance.MaxConnections_isNULL = false;

	if (inst.getProperty("MaxListeningPorts", instance.MaxListeningPorts) == OK)
		instance.MaxListeningPorts_isNULL = false;

	if (inst.getProperty("ListeningPortManagementSupported", instance.ListeningPortManagementSupported) == OK)
		instance.ListeningPortManagementSupported_isNULL = false;

	if (inst.getProperty("SupportedSSHVersions", instance.SupportedSSHVersions) == OK)
		instance.SupportedSSHVersions_isNULL = false;

	if (inst.getProperty("OtherSupportedSSHVersion", instance.OtherSupportedSSHVersion) == OK)
		instance.OtherSupportedSSHVersion_isNULL = false;

	if (inst.getProperty("SupportedEncryptionAlgorithms", instance.SupportedEncryptionAlgorithms) == OK)
		instance.SupportedEncryptionAlgorithms_isNULL = false;

	if (inst.getProperty("OtherSupportedEncryptionAlgorithm", instance.OtherSupportedEncryptionAlgorithm) == OK)
		instance.OtherSupportedEncryptionAlgorithm_isNULL = false;

	_L_;
}

void SSH_OpenDRIM_SSHCapabilities_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_SSHCapabilities_CreateGoalSettings_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	vector<string> TemplateGoalSettings;
	data = in->ft->getArg(in, "TemplateGoalSettings", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, TemplateGoalSettings);	
		args.setTemplateGoalSettings(TemplateGoalSettings);
	}			

	vector<string> SupportedGoalSettings;
	data = in->ft->getArg(in, "SupportedGoalSettings", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, SupportedGoalSettings);	
		args.setSupportedGoalSettings(SupportedGoalSettings);
	}			

	_L_;
}

void SSH_OpenDRIM_SSHCapabilities_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_SSHCapabilities_CreateGoalSettings_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	vector<string> SupportedGoalSettings;
	errorMessage = args.getSupportedGoalSettings(SupportedGoalSettings);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, SupportedGoalSettings);
		out->ft->addArg(out, "SupportedGoalSettings", &value, CMPI_stringA);
	}

	_L_;
}
