##############################################i#################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_reader_dos_vuln_may09_lin.nasl 2116 2009-05-04 18:50:29Z may $
#
# Adobe Reader/Acrobat Denial of Service Vulnerability (May09) (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800706);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1492");
  script_bugtraq_id(34736);
  script_name("Adobe Reader/Acrobat Denial of Service Vulnerability (May09)");
  desc = "

  Overview: This host is installed with Adobe Reader/Acrobat and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  This flaw is due to memory corruption error in 'getAnnots' methods in the
  JavaScript API while processing malicious PDF files that calls this vulnerable
  method with crafted integer arguments.

  Impact:
  Successful exploitation will let the attacker cause memory corruption or
  denial of service.

  Impact level: System/Application.

  Affected Software/OS:
  Adobe Reader/Acrobat version 9.1 and prior on Windows.

  Fix:Upgrade to Adobe Reader/Acrobat version 9.3.2 or later,
  For further updates refer, http://www.adobe.com

  References:
  http://secunia.com/advisories/34924
  http://xforce.iss.net/xforce/xfdb/50145
  http://blogs.adobe.com/psirt/2009/04/update_on_adobe_reader_issue.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Adobe Reader/Acrobat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_adobe_prdts_detect_win.nasl");
  script_require_keys("Adobe/Reader/Win/Ver", "Adobe/Acrobat/Win/Ver");
  exit(0);
}


include("version_func.inc");

readerVer = get_kb_item("Adobe/Reader/Win/Ver");
acroVer = get_kb_item("Adobe/Acrobat/Win/Ver");

if(readerVer != NULL)
{
  # Grep for Adobe Reader version prior to 9.1
  if(version_is_less_equal(version:readerVer, test_version:"9.1")){
    security_hole(0);
  }
}

if(acroVer != NULL)
{
  # Grep for Adobe Acrobat version prior to 9.1
  if(version_is_less_equal(version:acroVer, test_version:"9.1")){
    security_hole(0);
  }
}
