###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ruby_rails_detect.nasl 3413 2009-07-16 17:21:24Z jul $
#
# Ruby On Rails Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800911);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Ruby On Rails Version Detection");
  desc = "

  Overview : This script detect the installed version of Ruby On Rails
  and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of Ruby On Rails");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

rorPaths = find_file(file_name:"rails", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach rorBin (rorPaths)
{
  rorVer = get_bin_version(full_prog_name:chomp(rorBin), sock:sock,
                             version_argv:"-v",
                             ver_pattern:"Rails ([0-9.]+)");
  if(rorVer[1] != NULL)
  {
    set_kb_item(name:"Ruby-Rails/Linux/Ver", value:rorVer[1]);
    security_note(data:"Ruby On Rails version " + rorVer[1] + 
                 " running at location " + rorBin + " was detected on the host");
  }
}
ssh_close_connection();
