###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_zenoss_serv_mult_vuln.nasl 7489 2010-03-02 16:50:35Z mar $
#
# Zenoss Server Multiple Vulnerabilities
#
# Authors:
# Rachana Shetty <srachan@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800990);
  script_version("$Revision: 7615 $: 1.0");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2010-0712, CVE-2010-0713");
  script_bugtraq_id(37802, 37843);
  script_name("Zenoss Server Multiple Vulnerabilities");
  desc = "
  Overview: The host is running Zenoss Server and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - Input passed via the 'severity', 'state', 'filter', 'offset', and 'count'
    parameters to /zport/dmd/Events/getJSONEventsInfo is not properly
    sanitised before being used in SQL queries.
  - The application allows administrative users to perform certain actions via
    HTTP requests without performing any validity checks to verify the
    requests. This can be exploited to e.g. change administrator passwords via
    zport/dmd/ZenUsers/admin or execute arbitrary shell commands via
    zport/dmd/userCommands/ by tricking an administrative user into visiting
    a malicious web site.

  Impact:
  Successful exploitation will allow remote attackers to view, add, modify or
  delete information in the back-end database or conduct cross site request
  forgery attacks.

  Impact Level: Application

  Affected Software/OS:
  Zenoss Server versions prior to 2.5

  Fix: Update to version 2.5 or later.
  For updates refer, http://www.zenoss.com/product/network-monitoring

  References:
  http://secunia.com/advisories/38195
  http://xforce.iss.net/xforce/xfdb/55670
  http://dev.zenoss.org/trac/changeset/15257
  http://www.ngenuity.org/wordpress/2010/01/14/ngenuity-2010-002-zenoss-multiple-admin-csrf/
  http://www.zenoss.com/news/SQL-Injection-and-Cross-Site-Forgery-in-Zenoss-Core-Corrected.html
  http://www.ngenuity.org/wordpress/2010/01/14/ngenuity-2010-001-zenoss-getjsoneventsinfo-sql-injection/

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.3
  Risk factor : High";

  script_description(desc);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_summary("Check through version of Zenoss Server");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_dependencies("gb_zenoss_serv_detect.nasl");
  script_require_ports("Services/www", 8080, 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

## Get http port
zenPort = get_http_port(default:8080);
if(!zenPort){
  exit(0);
}

## Get Zenoss Version from KB
zenVer = get_kb_item(string("www/",zenPort, "/Zenoss"));
if(isnull(zenVer)){
  exit(0);
}

## Check for version less than 2.5
if(version_is_less(version:zenVer, test_version:"2.5")){
   security_hole(zenPort);
}
