# Try to find the OpenVR library
#  OPENVR_FOUND - system has OpenVR lib
#  OpenVR_INCLUDE_DIRS - the include directories needed
#  OpenVR_LIBRARIES - libraries needed

FIND_PATH(OPENVR_INCLUDE_DIR NAMES openvr.h)
FIND_LIBRARY(OPENVR_LIBRARY NAMES openvr openvr_api)

SET(OpenVR_INCLUDE_DIRS ${OPENVR_INCLUDE_DIR})
SET(OpenVR_LIBRARIES ${OPENVR_LIBRARY})

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(OpenVR DEFAULT_MSG OPENVR_LIBRARY OPENVR_INCLUDE_DIR)

MARK_AS_ADVANCED(OPENVR_INCLUDE_DIR OPENVR_LIBRARY)
