#include "pgrp_dat.h"

     /**** TRIGONAL space groups  ****/
     /**** (TRIGONAL=HEXAGONAL, RHOMBOHEDRAL=triple hexagonal ***/
     /***  all groups in hexagonal axes ***/
int  lat_C3_sgrp[NC3_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL,     /*  2  */
   HEXAGONAL,     /*  3  */
   RHOMBOHEDRAL   /*  4  */
};
int  lat_C3i_sgrp[NC3i_sgrp]={
   HEXAGONAL,     /*  1  */
   RHOMBOHEDRAL   /*  2  */
};
int  lat_D3_sgrp[ND3_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL,     /*  2  */
   HEXAGONAL      /*  3  */
};
int  lat_D32_sgrp[ND32_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL,     /*  2  */
   HEXAGONAL,     /*  3  */
   RHOMBOHEDRAL   /*  4  */
};
int  lat_C3v_sgrp[NC3v_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL,     /*  2  */
   RHOMBOHEDRAL,  /*  3  */
   RHOMBOHEDRAL   /*  4  */
};
int  lat_C3v2_sgrp[NC3v2_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL      /*  2  */
};
int  lat_D3d_sgrp[ND3d_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL      /*  2  */
};
int  lat_D3d2_sgrp[ND3d2_sgrp]={
   HEXAGONAL,     /*  1  */
   HEXAGONAL,     /*  2  */
   RHOMBOHEDRAL,  /*  3  */
   RHOMBOHEDRAL   /*  4  */
};

char  *comnt_C3_sgrp[NC3_sgrp]={
  "143 (P 3)",
  "144 (P 31)",
  "145 (P 32)",
  "146 (R 3)"
};
char  *comnt_C3i_sgrp[NC3i_sgrp]={
  "147 (P -3)",
  "148 (R -3)",
};
char  *comnt_D3_sgrp[ND3_sgrp]={
  "149 (P 3 1 2)",
  "151 (P 31 1 2)",
  "153 (P 32 1 2)"
};
char  *comnt_D32_sgrp[ND32_sgrp]={
  "150 (P 3 2 1)",
  "152 (P 31 2 1)",
  "154 (P 32 2 1)",
  "155 (R 3 2)"
};
char  *comnt_C3v_sgrp[NC3v_sgrp]={
  "156 (P 3 m 1)",
  "158 (P 3 c 1)",
  "160 (R 3 m)",
  "161 (R 3 c)"
};
char  *comnt_C3v2_sgrp[NC3v2_sgrp]={
  "157 (P 3 1 m)",
  "159 (P 3 1 c)"
};
char  *comnt_D3d_sgrp[ND3d_sgrp]={
  "162 (P -3 1 m)",
  "163 (P -3 1 c)",
};
char  *comnt_D3d2_sgrp[ND3d2_sgrp]={
  "164 (P -3 m 1)",
  "165 (P -3 c 1)",
  "166 (R -3 m)",
  "167 (R -3 c)"
};

     /*** Partial translations for all trigonal space groups ***/
double rC3_sgrp[NC3_sgrp][3*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000  /*    3  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  1./3  , /*    2  */
     0.0000,  0.0000,  2./3    /*    3  */
  },
  { /*  3  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  2./3  , /*    2  */
     0.0000,  0.0000,  1./3    /*    3  */
  },
  { /*  4  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000  /*    3  */
  }
};
double rC3i_sgrp[NC3i_sgrp][6*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  }
};
double rD3_sgrp[ND3_sgrp][6*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  2  N151  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  1./3  , /*    2  */
     0.0000,  0.0000,  2./3  , /*    3  */
     0.0000,  0.0000,  2./3  , /*    4  */
     0.0000,  0.0000,  1./3  , /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  3 N153  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  2./3  , /*    2  */
     0.0000,  0.0000,  1./3  , /*    3  */
     0.0000,  0.0000,  1./3  , /*    4  */
     0.0000,  0.0000,  2./3  , /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  }
};
double rD32_sgrp[ND32_sgrp][6*3]={
  { /*  1 N150  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  2 N152  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  1./3  , /*    2  */
     0.0000,  0.0000,  2./3  , /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  2./3  , /*    5  */
     0.0000,  0.0000,  1./3    /*    6  */
  },
  { /*  3 N154  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  2./3  , /*    2  */
     0.0000,  0.0000,  1./3  , /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  1./3  , /*    5  */
     0.0000,  0.0000,  2./3    /*    6  */
  },
  { /*  4 N155  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  }
};
double rC3v_sgrp[NC3v_sgrp][6*3]={
  { /*  1 N156  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  2 N158  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000  /*    6  */
  },
  { /*  3 N160  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  4 N161  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000  /*    6  */
  }
};
   
double rC3v2_sgrp[NC3v2_sgrp][6*3]={
  { /*  1 N157  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000  /*    6  */
  },
  { /*  2 N159  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000  /*    6  */
  }
};
double rD3d_sgrp[ND3d_sgrp][12*3]={
  { /*  1 N162  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000  /*    12  */
  },
  { /*  2 163  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.5000, /*    10  */
     0.0000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.0000,  0.5000  /*    12  */
  }
};
double rD3d2_sgrp[ND3d2_sgrp][12*3]={
  { /*  1 N164  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000  /*    12  */
  },
  { /*  2 N165  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.5000, /*    10  */
     0.0000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.0000,  0.5000  /*    12  */
  },
  { /*  3 N166  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000  /*    12  */
  },
  { /*  4 N167  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.5000, /*    10  */
     0.0000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.0000,  0.5000  /*    12  */
  }
};




