# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementIpAllocationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_allocations_begin_delete(self, resource_group):
        response = await (
            await self.client.ip_allocations.begin_delete(
                resource_group_name=resource_group.name,
                ip_allocation_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_allocations_get(self, resource_group):
        response = await self.client.ip_allocations.get(
            resource_group_name=resource_group.name,
            ip_allocation_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_allocations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.ip_allocations.begin_create_or_update(
                resource_group_name=resource_group.name,
                ip_allocation_name="str",
                parameters={
                    "allocationTags": {"str": "str"},
                    "etag": "str",
                    "id": "str",
                    "ipamAllocationId": "str",
                    "location": "str",
                    "name": "str",
                    "prefix": "str",
                    "prefixLength": 0,
                    "prefixType": "str",
                    "subnet": {"id": "str"},
                    "tags": {"str": "str"},
                    "type": "str",
                    "virtualNetwork": {"id": "str"},
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_allocations_update_tags(self, resource_group):
        response = await self.client.ip_allocations.update_tags(
            resource_group_name=resource_group.name,
            ip_allocation_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_allocations_list(self, resource_group):
        response = self.client.ip_allocations.list(
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_allocations_list_by_resource_group(self, resource_group):
        response = self.client.ip_allocations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
