#ifndef SIGNAL_HPP
#define SIGNAL_HPP

/**
Singelton QCSignals emitting class

	@author Harald Krippel <harald@the-develop.net>
*/

#include <QObject>

class QCSignals : public QObject
{

  Q_OBJECT

public:
    enum {SIGNAL_SCRIPT_ERROR=0,
          SIGNAL_SOUND_ERROR=1,
          };

   static QCSignals *theInstance(QObject *parent=0);

   QCSignals (QObject *parent=0);
   ~QCSignals ();

   void signal(int, int arg=0);

signals:
    void unknownSignal();
    void scriptError();
    void soundError();

private:

   static QCSignals *theInstancePtr;
};

#endif
