/**************************************************************************
*   Copyright (C) 2000-2012 by Johan Maes                                 *
*   on4qz@telenet.be                                                      *
*   http://users.telenet.be/on4qz                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "mainwindow.h"
#include "qsstvglobal.h"
#include "ui_mainwindow.h"
#include "sound/soundio.h"
#include "configdialog.h"
#include "configparams.h"
#ifndef QT_NO_DEBUG
#include "scope/scopeview.h"
#endif

#include <QFont>
#include <QCloseEvent>
#include <QMessageBox>
#include "dispatcher.h"
#include "sound/calibration.h"
#include "dsp/filterparam.h"
#include "dsp/filter.h"
#include "utils/supportfunctions.h"
#include "utils/ftp.h"
#include "rig/rigcontrol.h"
#include "logbook/logbook.h"



/**
 * @brief
 *
 * @param parent
 */
mainWindow::mainWindow(QWidget *parent) :
  QMainWindow(parent),
  ui(new Ui::MainWindow)
{
  soundIOPtr=new soundIO;
  rigControllerR1=new rigControl(1);
//  rigControllerR2=new rigControl(2);
  rigController=rigControllerR1;
  confDiag=new configDialog();
#ifndef QT_NO_DEBUG
  scopeViewerData=new scopeView("Data Scope");
  scopeViewerSync=new scopeView("Sync Scope");
  scopeViewerData->setAlternativeScaleMultiplier(SUBSAMPLINGRATIO/rxClock);
  scopeViewerSync->setAlternativeScaleMultiplier(SUBSAMPLINGRATIO/rxClock);
#endif

//  drmProfileComboBox->addItem("FAX");
  wfTextPushButton=new QPushButton("WF Text",this);
  bsrPushButton=new QPushButton("BSR",this);
  idPushButton=new QPushButton("ID",this);

  greenPXM=new QPixmap(16,16);
  greenPXM->fill(Qt::green);
  redPXM=new QPixmap(16,16);
  redPXM->fill(Qt::red);
  pttText.setText("   PTT");
  pttIcon=new QLabel(this);
  pttIcon->setFixedSize(16,16);
  pttIcon->setPixmap(*greenPXM);
  pttIcon->setFrameShape(QFrame::Panel);
  pttIcon->setFrameShadow(QFrame::Raised);
  pttIcon->setLineWidth(2);
  dispatcherPtr=NULL;

  setWindowIcon(QPixmap(":/icons/qsstv.png"));
  readSettings();

  ui->setupUi(this);
  ui->maintabWidget->setCurrentIndex(0);
  ui->statusBar->addPermanentWidget(wfTextPushButton);
  ui->statusBar->addPermanentWidget(bsrPushButton);
  ui->statusBar->addPermanentWidget(idPushButton);
  ui->statusBar->addPermanentWidget(&pttText);
  ui->statusBar->addPermanentWidget(pttIcon);
  statusBarPtr=statusBar(); // must be after setup UI


  setWindowTitle(qsstvVersion);
  logBookPtr=new logBook;
}

/**
 * @brief
 *
 */
mainWindow::~mainWindow()
{
#ifndef QT_NO_DEBUG
  delete scopeViewerData;
  delete scopeViewerSync;
#endif
  delete ui;
}

/**
 * @brief initialize sound device and dispatcher
 *
 */
void mainWindow::init()
{
  QString ret;
  readSettings();
  rxWidgetPtr=ui->rxWindow;
  txWidgetPtr=ui->txWindow;
  galleryWidgetPtr=ui->galleryWindow;
   if(!dispatcherPtr) dispatcherPtr=new dispatcher();
   ret=dispatcherPtr->init();
   if(!ret.isEmpty())
   {
     splashStr+=ret.rightJustified(25,' ')+"\n";
     splashPtr->showMessage(splashStr ,Qt::AlignLeft,Qt::white);
   }


  confDiag->readSettings();
  connect(ui->actionExit,SIGNAL(triggered()),this, SLOT(slotExit()));
  connect(ui->actionConfigure,SIGNAL(triggered()),this, SLOT(slotConfigure()));
  connect(ui->actionCalibrate,SIGNAL(triggered()),this, SLOT(slotCalibrate()));
  connect(ui->actionAboutQSSTV, SIGNAL(triggered()),SLOT(slotAboutQSSTV()));
  connect(ui->actionAboutQt, SIGNAL(triggered()),SLOT(slotAboutQt()));
  connect(ui->actionUsersGuide, SIGNAL(triggered()),SLOT(slotDocumentation()));


  connect(idPushButton, SIGNAL(clicked()), this, SLOT(slotSendID()));
  connect(bsrPushButton, SIGNAL(clicked()), this, SLOT(slotSendBSR()));
//  connect(fixPushButton, SIGNAL(clicked()), this, SLOT(slotSendFIX()));
  connect(wfTextPushButton, SIGNAL(clicked()), this, SLOT(slotSendWfText()));


#ifndef QT_NO_DEBUG
//  connect(ui->actionTest,SIGNAL(triggered()),this, SLOT(slotTest()));
  connect(ui->actionLogSettings, SIGNAL(triggered()),SLOT(slotLogSettings()));
  connect(ui->actionResetLog, SIGNAL(triggered()),SLOT(slotResetLog()));
  connect(ui->actionShowDataScope, SIGNAL(triggered()),SLOT(slotShowDataScope()));
  connect(ui->actionShowSyncScope, SIGNAL(triggered()),SLOT(slotShowSyncScope()));
  connect(ui->actionScopeOffset,SIGNAL(triggered()),this, SLOT(slotScopeOffset()));
#else
  ui->menuOptions->removeAction(ui->actionTest);
  ui->menuOptions->removeAction(ui->actionLogSettings);
  ui->menuOptions->removeAction(ui->actionShowDataScope);
  ui->menuOptions->removeAction(ui->actionShowSyncScope);
  ui->menuOptions->removeAction(ui->actionLogSettings);
  ui->menuOptions->removeAction(ui->actionResetLog);
  ui->menuOptions->removeAction(ui->actionScopeOffset);

#endif


  if(!soundIOPtr->init())
  {
    splashStr+=QString("Soundcard error: %1").arg(*soundIOPtr->getLastError()).rightJustified(25,' ')+"\n";;
    splashPtr->showMessage(splashStr ,Qt::AlignLeft,Qt::white);
  }
  else
  {
    soundIOPtr->start();
  }

#ifndef QT_NO_DEBUG
 rxWidgetPtr->functionsPtr()->setOffset(dataScopeOffset,false);
#endif

}

void mainWindow::startReceiving()
{
  txWidgetPtr->setSettingsTab();
  rxWidgetPtr->setSettingsTab();
  rxWidgetPtr->start(true);
}

void mainWindow::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("MAIN");
  int windowWidth = qSettings.value("windowWidth", 460 ).toInt();
  int windowHeight = qSettings.value("windowHeight", 530 ).toInt();
  int windowX = qSettings.value( "windowX", -1 ).toInt();
  int windowY = qSettings.value( "windowY", -1 ).toInt();
  resize( windowWidth, windowHeight );
  if ( windowX != -1 || windowY != -1 ) 	move( windowX, windowY );
  transmissionModeIndex=(etransmissionMode)qSettings.value("transmissionModeIndex",0).toInt();
  dataScopeOffset=qSettings.value("dataScopeOffset",0).toUInt();
  logfile->readSettings(qSettings);
  qSettings.endGroup();
}

void mainWindow::writeSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("MAIN");
  qSettings.setValue( "windowWidth", width() );
  qSettings.setValue( "windowHeight", height() );
  qSettings.setValue( "windowX", x() );
  qSettings.setValue( "windowY", y() );
  qSettings.setValue("dataScopeOffset",dataScopeOffset);
  qSettings.setValue("transmissionModeIndex",(int)transmissionModeIndex);

  logfile->writeSettings(qSettings);
  galleryWidgetPtr->writeSettings(false);
  qSettings.endGroup();
}


/**
 *\todo fontselection
 */
void mainWindow::setNewFont()
{
//  QFont fnt;
//  fnt.fromString(fontString);
//  setFont(fnt);
//  galMW->setFont(fnt);
//  rxMW->setFont(fnt);
//  txMW->setFont(fnt);
}

void mainWindow::slotExit()
{
  int exit;
  exit=QMessageBox::information(this, tr("Quit..."),
                                tr("Do your really want to quit QSSTV?"),
                                QMessageBox::Ok, QMessageBox::Cancel);
    if(exit==QMessageBox::Ok)
        {

           dispatcherPtr->stopRXTX();
           deleteFiles(rxImagesPath,"*.rs*");
           deleteFiles(txImagesPath,"*.rs*");
           soundIOPtr->stopAndWait();
           QApplication::quit();
      }
   writeSettings();
}

void  mainWindow::closeEvent ( QCloseEvent *e )
{
  slotExit();
  e->ignore();
}

void mainWindow::slotConfigure()
{

  if(confDiag->exec()==QDialog::Accepted)
    {
      if(!soundIOPtr->init())
        {
          QMessageBox::critical(this, tr("Soundcard error"),*soundIOPtr->getLastError());
        }
      else
        {
           soundIOPtr->start();
        }
     dispatcherPtr->init();
     rxWidgetPtr->start(true);
    }
}

void mainWindow::slotLogSettings()
{
  logfile->maskSelect(this);
}

void mainWindow::slotResetLog()
{
 logfile->reset();
}


void mainWindow::slotCalibrate()
{
  calibration calib(this);
  if(calib.exec()==QDialog::Accepted)
    {
      rxClock=calib.getRXClock();
      txClock=calib.getTXClock();
    }
}

void mainWindow::slotAboutQSSTV()
{
  QString temp=tr("QSSTV\nVersion: ") + MAJORVERSION + MINORVERSION ;
  temp += QString("\n http://users.telenet.be/on4qz \n(c) 2014-%1 -- Johan Maes - ON4QZ\n%2").arg(QDate::currentDate().toString("yyyy")).arg(shortText);
//  temp += "\n http://users.telenet.be/on4qz \n(c) 2000-20135-- Johan Maes - ON4QZ\n HAMDRM Software based on RX/TXAMADRM\n from PA0MBO";


  QMessageBox::about(this,tr("About..."),temp);


//  QString temp=tr("QSSTV\nVersion: ") + MAJORVERSION + MINORVERSION;
//  temp += "\n http://users.telenet.be/on4qz \n(c) 2000-20135-- Johan Maes - ON4QZ\n HAMDRM Software based on RX/TXAMADRM\n from PA0MBO";
//  QMessageBox::about(this,tr("About..."),temp);

}

void mainWindow::slotAboutQt()
{
   QMessageBox::aboutQt(this,tr("About..."));

}





void mainWindow::setPTT(bool p)
{
  if(p) pttIcon->setPixmap(*redPXM);
  else pttIcon->setPixmap(*greenPXM);
}


void mainWindow::slotSendBSR()
{
  txWidgetPtr->sendBSR();
}


void mainWindow::slotSendID()
{
  txWidgetPtr->sendID();
}



void mainWindow::slotSendWfText()
{
 txWidgetPtr->sendWfText();
}

void mainWindow::slotDocumentation()
{
    QDesktopServices::openUrl(docURL);

}

void mainWindow::setBSRPushButton(bool b)
{
  bsrPushButton->setEnabled(b);
}

#ifndef QT_NO_DEBUG
void mainWindow::slotShowDataScope()
{
  scopeViewerData->show(true,true,true,true);
}
void mainWindow::slotShowSyncScope()
{
  scopeViewerSync->show(true,true,true,true);
}

void mainWindow::slotScopeOffset()
{
  dataScopeOffset=rxWidgetPtr->functionsPtr()->setOffset(dataScopeOffset,true);
}



#endif
