// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(unix)]
#[cfg_attr(docsrs, doc(cfg(unix)))]
use crate::UnixFDList;
use crate::{
    DBusCapabilityFlags, DBusMessageByteOrder, DBusMessageFlags, DBusMessageHeaderField,
    DBusMessageType,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GDBusMessage")]
    pub struct DBusMessage(Object<ffi::GDBusMessage>);

    match fn {
        type_ => || ffi::g_dbus_message_get_type(),
    }
}

impl DBusMessage {
    #[doc(alias = "g_dbus_message_new")]
    pub fn new() -> DBusMessage {
        unsafe { from_glib_full(ffi::g_dbus_message_new()) }
    }

    #[doc(alias = "g_dbus_message_new_from_blob")]
    #[doc(alias = "new_from_blob")]
    pub fn from_blob(
        blob: &[u8],
        capabilities: DBusCapabilityFlags,
    ) -> Result<DBusMessage, glib::Error> {
        let blob_len = blob.len() as _;
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_message_new_from_blob(
                blob.to_glib_none().0,
                blob_len,
                capabilities.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_message_new_method_call")]
    pub fn new_method_call(
        name: Option<&str>,
        path: &str,
        interface_: Option<&str>,
        method: &str,
    ) -> DBusMessage {
        unsafe {
            from_glib_full(ffi::g_dbus_message_new_method_call(
                name.to_glib_none().0,
                path.to_glib_none().0,
                interface_.to_glib_none().0,
                method.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_message_new_signal")]
    pub fn new_signal(path: &str, interface_: &str, signal: &str) -> DBusMessage {
        unsafe {
            from_glib_full(ffi::g_dbus_message_new_signal(
                path.to_glib_none().0,
                interface_.to_glib_none().0,
                signal.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_message_copy")]
    pub fn copy(&self) -> Result<DBusMessage, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_message_copy(self.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_message_get_arg0")]
    #[doc(alias = "get_arg0")]
    pub fn arg0(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_arg0(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_body")]
    #[doc(alias = "get_body")]
    pub fn body(&self) -> Option<glib::Variant> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_body(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_byte_order")]
    #[doc(alias = "get_byte_order")]
    pub fn byte_order(&self) -> DBusMessageByteOrder {
        unsafe { from_glib(ffi::g_dbus_message_get_byte_order(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_destination")]
    #[doc(alias = "get_destination")]
    pub fn destination(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_destination(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_error_name")]
    #[doc(alias = "get_error_name")]
    pub fn error_name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_error_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_flags")]
    #[doc(alias = "get_flags")]
    pub fn flags(&self) -> DBusMessageFlags {
        unsafe { from_glib(ffi::g_dbus_message_get_flags(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_header")]
    #[doc(alias = "get_header")]
    pub fn header(&self, header_field: DBusMessageHeaderField) -> Option<glib::Variant> {
        unsafe {
            from_glib_none(ffi::g_dbus_message_get_header(
                self.to_glib_none().0,
                header_field.into_glib(),
            ))
        }
    }

    #[doc(alias = "g_dbus_message_get_interface")]
    #[doc(alias = "get_interface")]
    pub fn interface(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_interface(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_locked")]
    #[doc(alias = "get_locked")]
    pub fn is_locked(&self) -> bool {
        unsafe { from_glib(ffi::g_dbus_message_get_locked(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_member")]
    #[doc(alias = "get_member")]
    pub fn member(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_member(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_message_type")]
    #[doc(alias = "get_message_type")]
    pub fn message_type(&self) -> DBusMessageType {
        unsafe { from_glib(ffi::g_dbus_message_get_message_type(self.to_glib_none().0)) }
    }

    #[cfg(unix)]
    #[cfg_attr(docsrs, doc(cfg(unix)))]
    #[doc(alias = "g_dbus_message_get_num_unix_fds")]
    #[doc(alias = "get_num_unix_fds")]
    pub fn num_unix_fds(&self) -> u32 {
        unsafe { ffi::g_dbus_message_get_num_unix_fds(self.to_glib_none().0) }
    }

    #[doc(alias = "g_dbus_message_get_path")]
    #[doc(alias = "get_path")]
    pub fn path(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_path(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_reply_serial")]
    #[doc(alias = "get_reply_serial")]
    pub fn reply_serial(&self) -> u32 {
        unsafe { ffi::g_dbus_message_get_reply_serial(self.to_glib_none().0) }
    }

    #[doc(alias = "g_dbus_message_get_sender")]
    #[doc(alias = "get_sender")]
    pub fn sender(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_sender(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_get_serial")]
    #[doc(alias = "get_serial")]
    pub fn serial(&self) -> u32 {
        unsafe { ffi::g_dbus_message_get_serial(self.to_glib_none().0) }
    }

    #[doc(alias = "g_dbus_message_get_signature")]
    #[doc(alias = "get_signature")]
    pub fn signature(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::g_dbus_message_get_signature(self.to_glib_none().0)) }
    }

    #[cfg(unix)]
    #[cfg_attr(docsrs, doc(cfg(unix)))]
    #[doc(alias = "g_dbus_message_get_unix_fd_list")]
    #[doc(alias = "get_unix_fd_list")]
    pub fn unix_fd_list(&self) -> Option<UnixFDList> {
        unsafe { from_glib_none(ffi::g_dbus_message_get_unix_fd_list(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_lock")]
    pub fn lock(&self) {
        unsafe {
            ffi::g_dbus_message_lock(self.to_glib_none().0);
        }
    }

    //#[doc(alias = "g_dbus_message_new_method_error")]
    //#[must_use]
    //pub fn new_method_error(&self, error_name: &str, error_message_format: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> DBusMessage {
    //    unsafe { TODO: call ffi:g_dbus_message_new_method_error() }
    //}

    #[doc(alias = "g_dbus_message_new_method_error_literal")]
    #[must_use]
    pub fn new_method_error_literal(&self, error_name: &str, error_message: &str) -> DBusMessage {
        unsafe {
            from_glib_full(ffi::g_dbus_message_new_method_error_literal(
                self.to_glib_none().0,
                error_name.to_glib_none().0,
                error_message.to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "g_dbus_message_new_method_error_valist")]
    //#[must_use]
    //pub fn new_method_error_valist(&self, error_name: &str, error_message_format: &str, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported) -> DBusMessage {
    //    unsafe { TODO: call ffi:g_dbus_message_new_method_error_valist() }
    //}

    #[doc(alias = "g_dbus_message_new_method_reply")]
    #[must_use]
    pub fn new_method_reply(&self) -> DBusMessage {
        unsafe { from_glib_full(ffi::g_dbus_message_new_method_reply(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_dbus_message_print")]
    pub fn print(&self, indent: u32) -> glib::GString {
        unsafe { from_glib_full(ffi::g_dbus_message_print(self.to_glib_none().0, indent)) }
    }

    #[doc(alias = "g_dbus_message_set_body")]
    pub fn set_body(&self, body: &glib::Variant) {
        unsafe {
            ffi::g_dbus_message_set_body(self.to_glib_none().0, body.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_byte_order")]
    pub fn set_byte_order(&self, byte_order: DBusMessageByteOrder) {
        unsafe {
            ffi::g_dbus_message_set_byte_order(self.to_glib_none().0, byte_order.into_glib());
        }
    }

    #[doc(alias = "g_dbus_message_set_destination")]
    pub fn set_destination(&self, value: Option<&str>) {
        unsafe {
            ffi::g_dbus_message_set_destination(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_error_name")]
    pub fn set_error_name(&self, value: &str) {
        unsafe {
            ffi::g_dbus_message_set_error_name(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_flags")]
    pub fn set_flags(&self, flags: DBusMessageFlags) {
        unsafe {
            ffi::g_dbus_message_set_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "g_dbus_message_set_header")]
    pub fn set_header(&self, header_field: DBusMessageHeaderField, value: Option<&glib::Variant>) {
        unsafe {
            ffi::g_dbus_message_set_header(
                self.to_glib_none().0,
                header_field.into_glib(),
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_message_set_interface")]
    pub fn set_interface(&self, value: Option<&str>) {
        unsafe {
            ffi::g_dbus_message_set_interface(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_member")]
    pub fn set_member(&self, value: Option<&str>) {
        unsafe {
            ffi::g_dbus_message_set_member(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_message_type")]
    pub fn set_message_type(&self, type_: DBusMessageType) {
        unsafe {
            ffi::g_dbus_message_set_message_type(self.to_glib_none().0, type_.into_glib());
        }
    }

    #[cfg(unix)]
    #[cfg_attr(docsrs, doc(cfg(unix)))]
    #[doc(alias = "g_dbus_message_set_num_unix_fds")]
    pub fn set_num_unix_fds(&self, value: u32) {
        unsafe {
            ffi::g_dbus_message_set_num_unix_fds(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "g_dbus_message_set_path")]
    pub fn set_path(&self, value: Option<&str>) {
        unsafe {
            ffi::g_dbus_message_set_path(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_reply_serial")]
    pub fn set_reply_serial(&self, value: u32) {
        unsafe {
            ffi::g_dbus_message_set_reply_serial(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "g_dbus_message_set_sender")]
    pub fn set_sender(&self, value: Option<&str>) {
        unsafe {
            ffi::g_dbus_message_set_sender(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_message_set_serial")]
    pub fn set_serial(&self, serial: u32) {
        unsafe {
            ffi::g_dbus_message_set_serial(self.to_glib_none().0, serial);
        }
    }

    #[doc(alias = "g_dbus_message_set_signature")]
    pub fn set_signature(&self, value: Option<&str>) {
        unsafe {
            ffi::g_dbus_message_set_signature(self.to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[cfg(unix)]
    #[cfg_attr(docsrs, doc(cfg(unix)))]
    #[doc(alias = "g_dbus_message_set_unix_fd_list")]
    pub fn set_unix_fd_list(&self, fd_list: Option<&impl IsA<UnixFDList>>) {
        unsafe {
            ffi::g_dbus_message_set_unix_fd_list(
                self.to_glib_none().0,
                fd_list.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_message_to_blob")]
    pub fn to_blob(&self, capabilities: DBusCapabilityFlags) -> Result<Vec<u8>, glib::Error> {
        unsafe {
            let mut out_size = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_message_to_blob(
                self.to_glib_none().0,
                out_size.as_mut_ptr(),
                capabilities.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibContainer::from_glib_full_num(
                    ret,
                    out_size.assume_init() as _,
                ))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_message_to_gerror")]
    pub fn to_gerror(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_dbus_message_to_gerror(self.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_message_bytes_needed")]
    pub fn bytes_needed(blob: &[u8]) -> Result<isize, glib::Error> {
        let blob_len = blob.len() as _;
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_dbus_message_bytes_needed(blob.to_glib_none().0, blob_len, &mut error);
            if error.is_null() {
                Ok(ret)
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "locked")]
    pub fn connect_locked_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_locked_trampoline<F: Fn(&DBusMessage) + 'static>(
            this: *mut ffi::GDBusMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::locked\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_locked_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for DBusMessage {
    fn default() -> Self {
        Self::new()
    }
}
