% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{extractVRegion}
\alias{extractVRegion}
\title{Extracts FWRs and CDRs from IMGT-gapped sequences}
\usage{
extractVRegion(sequences, region = c("fwr1", "cdr1", "fwr2", "cdr2", "fwr3"))
}
\arguments{
\item{sequences}{character vector of IMGT-gapped nucleotide sequences.}

\item{region}{string defining the region(s) of the V segment to extract. 
May be a single region or multiple regions (as a vector) from
\code{c("fwr1", "cdr1", "fwr2", "cdr2" ,"fwr3")}.  By default, all
regions will be returned.}
}
\value{
If only one region is specified in the \code{region} argument, a character 
           vector of the extracted sub-sequences will be returned. If multiple regions 
           are specified, then a character matrix will be returned with columns 
           corresponding to the specified regions and a row for each entry in 
           \code{sequences}.
}
\description{
\code{extractVRegion} extracts the framework and complementarity determining regions of 
the V segment for IMGT-gapped immunoglobulin (Ig) nucleotide sequences according to the 
IMGT numbering scheme.
}
\examples{
# Assign example clone
clone <- subset(ExampleDb, clone_id == 3138)

# Get all regions
extractVRegion(clone$sequence_alignment)

# Get single region
extractVRegion(clone$sequence_alignment, "fwr1")

# Get all CDRs
extractVRegion(clone$sequence_alignment, c("cdr1", "cdr2"))

# Get all FWRs
extractVRegion(clone$sequence_alignment, c("fwr1", "fwr2", "fwr3"))

}
\references{
\enumerate{
  \item  Lefranc M-P, et al. IMGT unique numbering for immunoglobulin and T cell 
           receptor variable domains and Ig superfamily V-like domains.
           Dev Comp Immunol. 2003 27(1):55-77.
}
}
\seealso{
IMGT-gapped region boundaries are defined in \link{IMGT_REGIONS}.
}
