% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.brmsfit}
\alias{update.brmsfit}
\title{Update \pkg{brms} models}
\usage{
\method{update}{brmsfit}(object, formula., newdata = NULL, recompile = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{formula.}{Changes to the formula; for details see 
\code{\link{update.formula}} and \code{\link{brmsformula}}.}

\item{newdata}{Optional \code{data.frame} 
to update the model with new data.}

\item{recompile}{Logical, indicating whether the Stan model should 
be recompiled. If \code{NULL} (the default), \code{update} tries
to figure out internally, if recompilation is necessary. 
Setting it to \code{FALSE} will cause all Stan code changing 
arguments to be ignored.}

\item{...}{Other arguments passed to \code{\link{brm}}.}
}
\description{
This method allows to update an existing \code{brmsfit} object.
}
\details{
Sometimes, when updating the model formula, 
 it may happen that \R complains about a mismatch
 between \code{model frame} and \code{formula}.
 This error can be avoided by supplying your original data
 again via argument \code{newdata}.
}
\examples{
\dontrun{
fit1 <- brm(time | cens(censored) ~ age * sex + disease + (1|patient), 
            data = kidney, family = gaussian("log"))
summary(fit1)

## remove effects of 'disease'
fit2 <- update(fit1, formula. = ~ . - disease)
summary(fit2)

## remove the group specific term of 'patient' and
## change the data (just take a subset in this example)
fit3 <- update(fit1, formula. = ~ . - (1|patient), 
               newdata = kidney[1:38, ])
summary(fit3)

## use another family and add population-level priors
fit4 <- update(fit1, family = weibull(), inits = "0",
               prior = set_prior("normal(0,5)"))
summary(fit4)
}

}
