% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-fetch.R
\docType{data}
\name{spec_result_fetch}
\alias{spec_result_fetch}
\title{spec_result_fetch}
\value{
\code{dbFetch()} always returns a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
An attempt to fetch from a closed result set raises an error.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbFetch()} with proper \code{n} argument succeeds.
Calling \code{dbFetch()} on a result set from a data manipulation query
created by \code{\link[=dbSendStatement]{dbSendStatement()}}
can be fetched and return an empty data frame, with a warning.
}
\description{
spec_result_fetch
}
\section{Specification}{

Fetching multi-row queries with one
or more columns by default returns the entire result.
Multi-row queries can also be fetched progressively
by passing a whole number (\link{integer}
or \link{numeric})
as the \code{n} argument.
A value of \link{Inf} for the \code{n} argument is supported
and also returns the full result.
If more rows than available are fetched, the result is returned in full
without warning.
If fewer rows than requested are returned, further fetches will
return a data frame with zero rows.
If zero rows are fetched, the columns of the data frame are still fully
typed.
Fetching fewer rows than available is permitted,
no warning is issued when clearing the result set.

A column named \code{row_names} is treated like any other column.
}

\keyword{internal}
