% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_rate_limit.R
\name{gh_rate_limit}
\alias{gh_rate_limit}
\alias{gh_rate_limits}
\title{Return GitHub user's current rate limits}
\usage{
gh_rate_limit(
  response = NULL,
  .token = NULL,
  .api_url = NULL,
  .send_headers = NULL
)

gh_rate_limits(.token = NULL, .api_url = NULL, .send_headers = NULL)
}
\arguments{
\item{response}{\code{gh_response} object from a previous \code{gh} call, rate
limit values are determined from values in the response header.
Optional argument, if missing a call to "GET /rate_limit" will be made.}

\item{.token}{Authentication token. Defaults to \code{GITHUB_PAT} or
\code{GITHUB_TOKEN} environment variables, in this order if any is set.
See \code{\link[=gh_token]{gh_token()}} if you need more flexibility, e.g. different tokens
for different GitHub Enterprise deployments.}

\item{.api_url}{Github API url (default: \url{https://api.github.com}). Used
if \code{endpoint} just contains a path. Defaults to \code{GITHUB_API_URL}
environment variable if set.}

\item{.send_headers}{Named character vector of header field values
(except \code{Authorization}, which is handled via \code{.token}). This can be
used to override or augment the default \code{User-Agent} header:
\code{"https://github.com/r-lib/gh"}.}
}
\value{
A \code{list} object containing the overall \code{limit}, \code{remaining} limit, and the
limit \code{reset} time.
}
\description{
\code{gh_rate_limits()} reports on all rate limits for the authenticated user.
\code{gh_rate_limit()} reports on rate limits for previous successful request.

Further details on GitHub's API rate limit policies are available at
\url{https://docs.github.com/v3/#rate-limiting}.
}
