% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentize.R
\name{percentize}
\alias{percentize}
\alias{percentize.default}
\alias{percentize.data.frame}
\alias{percentize.matrix}
\title{Empirical Percentile Transformation}
\usage{
percentize(x, ...)
}
\arguments{
\item{x}{a vector or a data.frame.}

\item{...}{Currently ignored.}
}
\value{
A vector (or data.frame) after \link{ecdf} was used on that vector.
If x is a \link{data.frame} then only the numeric variables are transformed.
}
\description{
An Empirical Percentile Transformation (percentize) is similar to taking the rank
of a variable. The difference is that it is simpler to compare and interpret
the transformed variables.

This is helpful for comparing several variables in a heatmap (e.g.: \link{heatmaply}).
}
\examples{
\dontrun{
x <- mtcars
x <- data.frame(x)
x$am <- factor(x$am)
x$vs <- factor(x$vs)
heatmaply(percentize(x))


x <- data.frame(a = 1:10, b = 11:20)
x[4:6, 1:2] <- NA
percentize(x)
percentize(x[,1])

}
}
\seealso{
\link{normalize}
}
