% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{include_graphics}
\alias{include_graphics}
\title{Embed external images in \pkg{knitr} documents}
\usage{
include_graphics(
  path,
  auto_pdf = getOption("knitr.graphics.auto_pdf", FALSE),
  dpi = NULL,
  error = TRUE
)
}
\arguments{
\item{path}{A character vector of image paths.}

\item{auto_pdf}{Whether to use PDF images automatically when the output
format is LaTeX. If \code{TRUE}, then e.g. \file{foo/bar.png} will be
replaced by \file{foo/bar.pdf} if the latter exists. This can be useful
since normally PDF images are of higher quality than raster images like
PNG, when the output is LaTeX/PDF.}

\item{dpi}{DPI (dots per inch) value. Used to calculate the output width (in
inches) of the images. This will be their actual width in pixels, divided
by \code{dpi}. If not provided, the chunk option \code{dpi} is used; if
\code{NA}, the output width will not be calculated.}

\item{error}{Whether to signal an error if any files specified in the
\code{path} argument do not exist and are not web resources.}
}
\value{
The same as the input character vector \code{path} but it is marked
  with special internal S3 classes so that \pkg{knitr} will convert the file
  paths to proper output code according to the output format.
}
\description{
When plots are not generated from R code, there is no way for \pkg{knitr} to
capture plots automatically. In this case, you may generate the images
manually and pass their file paths to this function to include them in the
output. The major advantage of using this function is that it is portable in
the sense that it works for all document formats that \pkg{knitr} supports,
so you do not need to think if you have to use, for example, LaTeX or
Markdown syntax, to embed an external image. Chunk options related to
graphics output that work for normal R plots also work for these images, such
as \code{out.width} and \code{out.height}.
}
\note{
This function is supposed to be used in R code chunks or inline R code
  expressions. You are recommended to use forward slashes (\verb{/}) as path
  separators instead of backslashes in the image paths.

  The automatic calculation of the output width requires the \pkg{png}
  package (for PNG images) or the \pkg{jpeg} package (for JPEG images). The
  width will not be calculated if the chunk option \code{out.width} is
  already provided or \code{dpi = NA}.
}
