% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_linter.R
\name{return_linter}
\alias{return_linter}
\title{Return linter}
\usage{
return_linter(
  return_style = c("implicit", "explicit"),
  allow_implicit_else = TRUE,
  return_functions = NULL,
  except = NULL,
  except_regex = NULL
)
}
\arguments{
\item{return_style}{Character string naming the return style. \code{"implicit"},
the default, enforces the Tidyverse guide recommendation to leave terminal
returns implicit. \code{"explicit"} style requires that \code{return()} always be
explicitly supplied.}

\item{allow_implicit_else}{Logical, default \code{TRUE}. If \code{FALSE}, functions with a terminal
\code{if} clause must always have an \verb{else} clause, making the \code{NULL} alternative explicit
if necessary. Similarly, functions with terminal \code{\link[=switch]{switch()}} statements must have an
explicit default case.}

\item{return_functions}{Character vector of functions that are accepted as terminal calls
when \code{return_style = "explicit"}. These are in addition to exit functions
from base that are always allowed: \code{\link[=stop]{stop()}}, \code{\link[=q]{q()}}, \code{\link[=quit]{quit()}}, \code{\link[=invokeRestart]{invokeRestart()}},
\code{tryInvokeRestart()}, \code{\link[=UseMethod]{UseMethod()}}, \code{\link[=NextMethod]{NextMethod()}}, \code{\link[=standardGeneric]{standardGeneric()}},
\code{\link[=callNextMethod]{callNextMethod()}}, \code{\link[=.C]{.C()}}, \code{\link[=.Call]{.Call()}}, \code{\link[=.External]{.External()}}, and \code{\link[=.Fortran]{.Fortran()}}.}

\item{except, except_regex}{Character vector of functions that are not checked when
\code{return_style = "explicit"}. These are in addition to namespace hook functions
that are never checked: \code{.onLoad()}, \code{.onUnload()}, \code{.onAttach()}, \code{.onDetach()},
\code{.Last.lib()}, \code{.First()} and \code{.Last()}. \code{except} matches function names exactly,
while \code{except_regex} does exclusion by pattern matching with \code{\link[rex:re_matches]{rex::re_matches()}}.}
}
\description{
This linter checks functions' \code{\link[=return]{return()}} expressions.
}
\examples{
# will produce lints
code <- "function(x) {\n  return(x + 1)\n}"
writeLines(code)
lint(
  text = code,
  linters = return_linter()
)

code <- "function(x) {\n  x + 1\n}"
writeLines(code)
lint(
  text = code,
  linters = return_linter(return_style = "explicit")
)

code <- "function(x) {\n  if (x > 0) 2\n}"
writeLines(code)
lint(
  text = code,
  linters = return_linter(allow_implicit_else = FALSE)
)

# okay
code <- "function(x) {\n  x + 1\n}"
writeLines(code)
lint(
  text = code,
  linters = return_linter()
)

code <- "function(x) {\n  return(x + 1)\n}"
writeLines(code)
lint(
  text = code,
  linters = return_linter(return_style = "explicit")
)

code <- "function(x) {\n  if (x > 0) 2 else NULL\n}"
writeLines(code)
lint(
  text = code,
  linters = return_linter(allow_implicit_else = FALSE)
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/functions.html?q=return#return}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=style_linters]{style}
}
