% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-plots.R
\name{gg_re}
\alias{gg_re}
\title{Plot Normal QQ plots for random effects}
\usage{
gg_re(x, ...)
}
\arguments{
\item{x}{ a fitted \code{gam} object as produced by \code{gam()}.}

\item{...}{Further arguments passed to \code{\link[mgcv]{plot.gam}}}
}
\description{
Plot Normal QQ plots for random effects
}
\examples{
library(pammtools)
data("patient")
ped <- patient \%>\%
 dplyr::slice(1:100) \%>\%
 as_ped(Surv(Survdays, PatientDied)~ ApacheIIScore + CombinedicuID, id="CombinedID")
pam <- mgcv::gam(ped_status ~ s(tend) + ApacheIIScore + s(CombinedicuID, bs="re"),
 data=ped, family=poisson(), offset=offset)
gg_re(pam)
plot(pam, select = 2)
}
\seealso{
\code{\link{tidy_re}}
}
