% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R, R/print_md.R
\name{display.performance_model}
\alias{display.performance_model}
\alias{print_md.performance_model}
\alias{print_md.compare_performance}
\title{Print tables in different output formats}
\usage{
\method{display}{performance_model}(object, format = "markdown", digits = 2, caption = NULL, ...)

\method{print_md}{performance_model}(
  x,
  digits = 2,
  caption = "Indices of model performance",
  layout = "horizontal",
  ...
)

\method{print_md}{compare_performance}(
  x,
  digits = 2,
  caption = "Comparison of Model Performance Indices",
  layout = "horizontal",
  ...
)
}
\arguments{
\item{object, x}{An object returned by \code{\link[=model_performance]{model_performance()}} or
or \code{\link[=compare_performance]{compare_performance()}}.
or its summary.}

\item{format}{String, indicating the output format. Currently, only
\code{"markdown"} is supported.}

\item{digits}{Number of decimal places.}

\item{caption}{Table caption as string. If \code{NULL}, no table caption is printed.}

\item{...}{Currently not used.}

\item{layout}{Table layout (can be either \code{"horizontal"} or \code{"vertical"}).}
}
\value{
A character vector. If \code{format = "markdown"}, the return value
will be a character vector in markdown-table format.
}
\description{
Prints tables (i.e. data frame) in different output formats.
\code{print_md()} is a alias for \code{display(format = "markdown")}.
}
\details{
\code{display()} is useful when the table-output from functions,
which is usually printed as formatted text-table to console, should
be formatted for pretty table-rendering in markdown documents, or if
knitted from rmarkdown to PDF or Word files. See
\href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{vignette}
for examples.
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
mp <- model_performance(model)
display(mp)
}
