% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartition.R
\name{bipartition}
\alias{bipartition}
\title{Bipartition a sample set}
\usage{
bipartition(
  A,
  tol = 1e-05,
  maxit = 100,
  nonneg = TRUE,
  samples = 1:ncol(A),
  seed = NULL,
  verbose = FALSE,
  calc_dist = FALSE,
  diag = TRUE
)
}
\arguments{
\item{A}{matrix of features-by-samples in dense or sparse format (preferred classes are "matrix" or "Matrix::dgCMatrix", respectively). Prefer sparse storage when more than half of all values are zero.}

\item{tol}{stopping criteria, the correlation distance between \eqn{w} across consecutive iterations, \eqn{1 - cor(w_i, w_{i-1})}}

\item{maxit}{stopping criteria, maximum number of alternating updates of \eqn{w} and \eqn{h}}

\item{nonneg}{enforce non-negativity}

\item{samples}{samples to include in bipartition, numbered from 1 to \code{ncol(A)}. Default is \code{NULL} for all samples.}

\item{seed}{random seed for model initialization}

\item{verbose}{print model tolerances between iterations}

\item{calc_dist}{calculate the relative cosine distance of samples within a cluster to either cluster centroid. If \code{TRUE}, centers for clusters will also be calculated.}

\item{diag}{scale factors in \eqn{w} and \eqn{h} to sum to 1 by introducing a diagonal, \eqn{d}. This should generally never be set to \code{FALSE}. Diagonalization enables symmetry of models in factorization of symmetric matrices, convex L1 regularization, and consistent factor scalings.}
}
\value{
A list giving the bipartition and useful statistics:
\itemize{
\item v       : vector giving difference between sample loadings between factors in a rank-2 factorization
\item dist    : relative cosine distance of samples within a cluster to centroids of assigned vs. not-assigned cluster
\item size1   : number of samples in first cluster (positive loadings in 'v')
\item size2   : number of samples in second cluster (negative loadings in 'v')
\item samples1: indices of samples in first cluster
\item samples2: indices of samples in second cluster
\item center1 : mean feature loadings across samples in first cluster
\item center2 : mean feature loadings across samples in second cluster
}
}
\description{
Spectral biparitioning by rank-2 matrix factorization
}
\details{
Spectral bipartitioning is a popular subroutine in divisive clustering. The sign of the difference between sample loadings in factors of a rank-2 matrix factorization
gives a bipartition that is nearly identical to an SVD.

Rank-2 matrix factorization by alternating least squares is faster than rank-2-truncated SVD (i.e. \emph{irlba}).

This function is a specialization of rank-2 \code{\link{nmf}} with support for factorization of only a subset of samples, and with additional calculations on the factorization model relevant to bipartitioning. See \code{\link{nmf}} for details regarding rank-2 factorization.
}
\examples{
\dontrun{
library(Matrix)
data(iris)
A <- as(as.matrix(iris[,1:4]), "dgCMatrix")
bipartition(A, calc_dist = TRUE)
}
}
\references{
Kuang, D, Park, H. (2013). "Fast rank-2 nonnegative matrix factorization for hierarchical document clustering." Proc. 19th ACM SIGKDD intl. conf. on Knowledge discovery and data mining.
}
\seealso{
\code{\link{nmf}}, \code{\link{dclust}}
}
\author{
Zach DeBruine
}
