// Copyright (c) 2012 Leonhard Gruenschloss (leonhard@gruenschloss.org)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
// of the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// This file is automatically generated.

#ifndef HALTON_SAMPLER_H
#define HALTON_SAMPLER_H

#include <algorithm>
#include <vector>

namespace spacefillr {
// Compute points of the Halton sequence with with digit-permutations for different bases.
class Halton_sampler
{
public:
    // Init the permutation arrays using Faure-permutations. Alternatively, init_random can be
    // called before the sampling functionality can be used.
    void init_faure();

    // Init the permutation arrays using randomized permutations. Alternatively, init_faure can be
    // called before the sampling functionality can be used. The client needs to specify a random
    // number generator function object that can be used to generate a random sequence of integers.
    // That is: if f is a random number generator and N is a positive integer, then f(N) will
    // return an integer less than N and greater than or equal to 0.
    template <typename Random_number_generator>
    void init_random(Random_number_generator& rand);

    // Return the number of supported dimensions.
    static unsigned get_num_dimensions() { return 256u; }

    // Return the Halton sample for the given dimension (component) and index.
    // The client must have called init_random or init_faure at least once before.
    // dimension must be smaller than the value returned by get_num_dimensions().
    float sample(unsigned dimension, unsigned index) const;

private:
    static unsigned short invert(unsigned short base, unsigned short digits,
        unsigned short index, const std::vector<unsigned short>& perm);

    void init_tables(const std::vector<std::vector<unsigned short> >& perms);

    float halton2(unsigned index) const;
    float halton3(unsigned index) const;
    float halton5(unsigned index) const;
    float halton7(unsigned index) const;
    float halton11(unsigned index) const;
    float halton13(unsigned index) const;
    float halton17(unsigned index) const;
    float halton19(unsigned index) const;
    float halton23(unsigned index) const;
    float halton29(unsigned index) const;
    float halton31(unsigned index) const;
    float halton37(unsigned index) const;
    float halton41(unsigned index) const;
    float halton43(unsigned index) const;
    float halton47(unsigned index) const;
    float halton53(unsigned index) const;
    float halton59(unsigned index) const;
    float halton61(unsigned index) const;
    float halton67(unsigned index) const;
    float halton71(unsigned index) const;
    float halton73(unsigned index) const;
    float halton79(unsigned index) const;
    float halton83(unsigned index) const;
    float halton89(unsigned index) const;
    float halton97(unsigned index) const;
    float halton101(unsigned index) const;
    float halton103(unsigned index) const;
    float halton107(unsigned index) const;
    float halton109(unsigned index) const;
    float halton113(unsigned index) const;
    float halton127(unsigned index) const;
    float halton131(unsigned index) const;
    float halton137(unsigned index) const;
    float halton139(unsigned index) const;
    float halton149(unsigned index) const;
    float halton151(unsigned index) const;
    float halton157(unsigned index) const;
    float halton163(unsigned index) const;
    float halton167(unsigned index) const;
    float halton173(unsigned index) const;
    float halton179(unsigned index) const;
    float halton181(unsigned index) const;
    float halton191(unsigned index) const;
    float halton193(unsigned index) const;
    float halton197(unsigned index) const;
    float halton199(unsigned index) const;
    float halton211(unsigned index) const;
    float halton223(unsigned index) const;
    float halton227(unsigned index) const;
    float halton229(unsigned index) const;
    float halton233(unsigned index) const;
    float halton239(unsigned index) const;
    float halton241(unsigned index) const;
    float halton251(unsigned index) const;
    float halton257(unsigned index) const;
    float halton263(unsigned index) const;
    float halton269(unsigned index) const;
    float halton271(unsigned index) const;
    float halton277(unsigned index) const;
    float halton281(unsigned index) const;
    float halton283(unsigned index) const;
    float halton293(unsigned index) const;
    float halton307(unsigned index) const;
    float halton311(unsigned index) const;
    float halton313(unsigned index) const;
    float halton317(unsigned index) const;
    float halton331(unsigned index) const;
    float halton337(unsigned index) const;
    float halton347(unsigned index) const;
    float halton349(unsigned index) const;
    float halton353(unsigned index) const;
    float halton359(unsigned index) const;
    float halton367(unsigned index) const;
    float halton373(unsigned index) const;
    float halton379(unsigned index) const;
    float halton383(unsigned index) const;
    float halton389(unsigned index) const;
    float halton397(unsigned index) const;
    float halton401(unsigned index) const;
    float halton409(unsigned index) const;
    float halton419(unsigned index) const;
    float halton421(unsigned index) const;
    float halton431(unsigned index) const;
    float halton433(unsigned index) const;
    float halton439(unsigned index) const;
    float halton443(unsigned index) const;
    float halton449(unsigned index) const;
    float halton457(unsigned index) const;
    float halton461(unsigned index) const;
    float halton463(unsigned index) const;
    float halton467(unsigned index) const;
    float halton479(unsigned index) const;
    float halton487(unsigned index) const;
    float halton491(unsigned index) const;
    float halton499(unsigned index) const;
    float halton503(unsigned index) const;
    float halton509(unsigned index) const;
    float halton521(unsigned index) const;
    float halton523(unsigned index) const;
    float halton541(unsigned index) const;
    float halton547(unsigned index) const;
    float halton557(unsigned index) const;
    float halton563(unsigned index) const;
    float halton569(unsigned index) const;
    float halton571(unsigned index) const;
    float halton577(unsigned index) const;
    float halton587(unsigned index) const;
    float halton593(unsigned index) const;
    float halton599(unsigned index) const;
    float halton601(unsigned index) const;
    float halton607(unsigned index) const;
    float halton613(unsigned index) const;
    float halton617(unsigned index) const;
    float halton619(unsigned index) const;
    float halton631(unsigned index) const;
    float halton641(unsigned index) const;
    float halton643(unsigned index) const;
    float halton647(unsigned index) const;
    float halton653(unsigned index) const;
    float halton659(unsigned index) const;
    float halton661(unsigned index) const;
    float halton673(unsigned index) const;
    float halton677(unsigned index) const;
    float halton683(unsigned index) const;
    float halton691(unsigned index) const;
    float halton701(unsigned index) const;
    float halton709(unsigned index) const;
    float halton719(unsigned index) const;
    float halton727(unsigned index) const;
    float halton733(unsigned index) const;
    float halton739(unsigned index) const;
    float halton743(unsigned index) const;
    float halton751(unsigned index) const;
    float halton757(unsigned index) const;
    float halton761(unsigned index) const;
    float halton769(unsigned index) const;
    float halton773(unsigned index) const;
    float halton787(unsigned index) const;
    float halton797(unsigned index) const;
    float halton809(unsigned index) const;
    float halton811(unsigned index) const;
    float halton821(unsigned index) const;
    float halton823(unsigned index) const;
    float halton827(unsigned index) const;
    float halton829(unsigned index) const;
    float halton839(unsigned index) const;
    float halton853(unsigned index) const;
    float halton857(unsigned index) const;
    float halton859(unsigned index) const;
    float halton863(unsigned index) const;
    float halton877(unsigned index) const;
    float halton881(unsigned index) const;
    float halton883(unsigned index) const;
    float halton887(unsigned index) const;
    float halton907(unsigned index) const;
    float halton911(unsigned index) const;
    float halton919(unsigned index) const;
    float halton929(unsigned index) const;
    float halton937(unsigned index) const;
    float halton941(unsigned index) const;
    float halton947(unsigned index) const;
    float halton953(unsigned index) const;
    float halton967(unsigned index) const;
    float halton971(unsigned index) const;
    float halton977(unsigned index) const;
    float halton983(unsigned index) const;
    float halton991(unsigned index) const;
    float halton997(unsigned index) const;
    float halton1009(unsigned index) const;
    float halton1013(unsigned index) const;
    float halton1019(unsigned index) const;
    float halton1021(unsigned index) const;
    float halton1031(unsigned index) const;
    float halton1033(unsigned index) const;
    float halton1039(unsigned index) const;
    float halton1049(unsigned index) const;
    float halton1051(unsigned index) const;
    float halton1061(unsigned index) const;
    float halton1063(unsigned index) const;
    float halton1069(unsigned index) const;
    float halton1087(unsigned index) const;
    float halton1091(unsigned index) const;
    float halton1093(unsigned index) const;
    float halton1097(unsigned index) const;
    float halton1103(unsigned index) const;
    float halton1109(unsigned index) const;
    float halton1117(unsigned index) const;
    float halton1123(unsigned index) const;
    float halton1129(unsigned index) const;
    float halton1151(unsigned index) const;
    float halton1153(unsigned index) const;
    float halton1163(unsigned index) const;
    float halton1171(unsigned index) const;
    float halton1181(unsigned index) const;
    float halton1187(unsigned index) const;
    float halton1193(unsigned index) const;
    float halton1201(unsigned index) const;
    float halton1213(unsigned index) const;
    float halton1217(unsigned index) const;
    float halton1223(unsigned index) const;
    float halton1229(unsigned index) const;
    float halton1231(unsigned index) const;
    float halton1237(unsigned index) const;
    float halton1249(unsigned index) const;
    float halton1259(unsigned index) const;
    float halton1277(unsigned index) const;
    float halton1279(unsigned index) const;
    float halton1283(unsigned index) const;
    float halton1289(unsigned index) const;
    float halton1291(unsigned index) const;
    float halton1297(unsigned index) const;
    float halton1301(unsigned index) const;
    float halton1303(unsigned index) const;
    float halton1307(unsigned index) const;
    float halton1319(unsigned index) const;
    float halton1321(unsigned index) const;
    float halton1327(unsigned index) const;
    float halton1361(unsigned index) const;
    float halton1367(unsigned index) const;
    float halton1373(unsigned index) const;
    float halton1381(unsigned index) const;
    float halton1399(unsigned index) const;
    float halton1409(unsigned index) const;
    float halton1423(unsigned index) const;
    float halton1427(unsigned index) const;
    float halton1429(unsigned index) const;
    float halton1433(unsigned index) const;
    float halton1439(unsigned index) const;
    float halton1447(unsigned index) const;
    float halton1451(unsigned index) const;
    float halton1453(unsigned index) const;
    float halton1459(unsigned index) const;
    float halton1471(unsigned index) const;
    float halton1481(unsigned index) const;
    float halton1483(unsigned index) const;
    float halton1487(unsigned index) const;
    float halton1489(unsigned index) const;
    float halton1493(unsigned index) const;
    float halton1499(unsigned index) const;
    float halton1511(unsigned index) const;
    float halton1523(unsigned index) const;
    float halton1531(unsigned index) const;
    float halton1543(unsigned index) const;
    float halton1549(unsigned index) const;
    float halton1553(unsigned index) const;
    float halton1559(unsigned index) const;
    float halton1567(unsigned index) const;
    float halton1571(unsigned index) const;
    float halton1579(unsigned index) const;
    float halton1583(unsigned index) const;
    float halton1597(unsigned index) const;
    float halton1601(unsigned index) const;
    float halton1607(unsigned index) const;
    float halton1609(unsigned index) const;
    float halton1613(unsigned index) const;
    float halton1619(unsigned index) const;

    unsigned short m_perm3[243];
    unsigned short m_perm5[125];
    unsigned short m_perm7[343];
    unsigned short m_perm11[121];
    unsigned short m_perm13[169];
    unsigned short m_perm17[289];
    unsigned short m_perm19[361];
    unsigned short m_perm23[23];
    unsigned short m_perm29[29];
    unsigned short m_perm31[31];
    unsigned short m_perm37[37];
    unsigned short m_perm41[41];
    unsigned short m_perm43[43];
    unsigned short m_perm47[47];
    unsigned short m_perm53[53];
    unsigned short m_perm59[59];
    unsigned short m_perm61[61];
    unsigned short m_perm67[67];
    unsigned short m_perm71[71];
    unsigned short m_perm73[73];
    unsigned short m_perm79[79];
    unsigned short m_perm83[83];
    unsigned short m_perm89[89];
    unsigned short m_perm97[97];
    unsigned short m_perm101[101];
    unsigned short m_perm103[103];
    unsigned short m_perm107[107];
    unsigned short m_perm109[109];
    unsigned short m_perm113[113];
    unsigned short m_perm127[127];
    unsigned short m_perm131[131];
    unsigned short m_perm137[137];
    unsigned short m_perm139[139];
    unsigned short m_perm149[149];
    unsigned short m_perm151[151];
    unsigned short m_perm157[157];
    unsigned short m_perm163[163];
    unsigned short m_perm167[167];
    unsigned short m_perm173[173];
    unsigned short m_perm179[179];
    unsigned short m_perm181[181];
    unsigned short m_perm191[191];
    unsigned short m_perm193[193];
    unsigned short m_perm197[197];
    unsigned short m_perm199[199];
    unsigned short m_perm211[211];
    unsigned short m_perm223[223];
    unsigned short m_perm227[227];
    unsigned short m_perm229[229];
    unsigned short m_perm233[233];
    unsigned short m_perm239[239];
    unsigned short m_perm241[241];
    unsigned short m_perm251[251];
    unsigned short m_perm257[257];
    unsigned short m_perm263[263];
    unsigned short m_perm269[269];
    unsigned short m_perm271[271];
    unsigned short m_perm277[277];
    unsigned short m_perm281[281];
    unsigned short m_perm283[283];
    unsigned short m_perm293[293];
    unsigned short m_perm307[307];
    unsigned short m_perm311[311];
    unsigned short m_perm313[313];
    unsigned short m_perm317[317];
    unsigned short m_perm331[331];
    unsigned short m_perm337[337];
    unsigned short m_perm347[347];
    unsigned short m_perm349[349];
    unsigned short m_perm353[353];
    unsigned short m_perm359[359];
    unsigned short m_perm367[367];
    unsigned short m_perm373[373];
    unsigned short m_perm379[379];
    unsigned short m_perm383[383];
    unsigned short m_perm389[389];
    unsigned short m_perm397[397];
    unsigned short m_perm401[401];
    unsigned short m_perm409[409];
    unsigned short m_perm419[419];
    unsigned short m_perm421[421];
    unsigned short m_perm431[431];
    unsigned short m_perm433[433];
    unsigned short m_perm439[439];
    unsigned short m_perm443[443];
    unsigned short m_perm449[449];
    unsigned short m_perm457[457];
    unsigned short m_perm461[461];
    unsigned short m_perm463[463];
    unsigned short m_perm467[467];
    unsigned short m_perm479[479];
    unsigned short m_perm487[487];
    unsigned short m_perm491[491];
    unsigned short m_perm499[499];
    unsigned short m_perm503[503];
    unsigned short m_perm509[509];
    unsigned short m_perm521[521];
    unsigned short m_perm523[523];
    unsigned short m_perm541[541];
    unsigned short m_perm547[547];
    unsigned short m_perm557[557];
    unsigned short m_perm563[563];
    unsigned short m_perm569[569];
    unsigned short m_perm571[571];
    unsigned short m_perm577[577];
    unsigned short m_perm587[587];
    unsigned short m_perm593[593];
    unsigned short m_perm599[599];
    unsigned short m_perm601[601];
    unsigned short m_perm607[607];
    unsigned short m_perm613[613];
    unsigned short m_perm617[617];
    unsigned short m_perm619[619];
    unsigned short m_perm631[631];
    unsigned short m_perm641[641];
    unsigned short m_perm643[643];
    unsigned short m_perm647[647];
    unsigned short m_perm653[653];
    unsigned short m_perm659[659];
    unsigned short m_perm661[661];
    unsigned short m_perm673[673];
    unsigned short m_perm677[677];
    unsigned short m_perm683[683];
    unsigned short m_perm691[691];
    unsigned short m_perm701[701];
    unsigned short m_perm709[709];
    unsigned short m_perm719[719];
    unsigned short m_perm727[727];
    unsigned short m_perm733[733];
    unsigned short m_perm739[739];
    unsigned short m_perm743[743];
    unsigned short m_perm751[751];
    unsigned short m_perm757[757];
    unsigned short m_perm761[761];
    unsigned short m_perm769[769];
    unsigned short m_perm773[773];
    unsigned short m_perm787[787];
    unsigned short m_perm797[797];
    unsigned short m_perm809[809];
    unsigned short m_perm811[811];
    unsigned short m_perm821[821];
    unsigned short m_perm823[823];
    unsigned short m_perm827[827];
    unsigned short m_perm829[829];
    unsigned short m_perm839[839];
    unsigned short m_perm853[853];
    unsigned short m_perm857[857];
    unsigned short m_perm859[859];
    unsigned short m_perm863[863];
    unsigned short m_perm877[877];
    unsigned short m_perm881[881];
    unsigned short m_perm883[883];
    unsigned short m_perm887[887];
    unsigned short m_perm907[907];
    unsigned short m_perm911[911];
    unsigned short m_perm919[919];
    unsigned short m_perm929[929];
    unsigned short m_perm937[937];
    unsigned short m_perm941[941];
    unsigned short m_perm947[947];
    unsigned short m_perm953[953];
    unsigned short m_perm967[967];
    unsigned short m_perm971[971];
    unsigned short m_perm977[977];
    unsigned short m_perm983[983];
    unsigned short m_perm991[991];
    unsigned short m_perm997[997];
    unsigned short m_perm1009[1009];
    unsigned short m_perm1013[1013];
    unsigned short m_perm1019[1019];
    unsigned short m_perm1021[1021];
    unsigned short m_perm1031[1031];
    unsigned short m_perm1033[1033];
    unsigned short m_perm1039[1039];
    unsigned short m_perm1049[1049];
    unsigned short m_perm1051[1051];
    unsigned short m_perm1061[1061];
    unsigned short m_perm1063[1063];
    unsigned short m_perm1069[1069];
    unsigned short m_perm1087[1087];
    unsigned short m_perm1091[1091];
    unsigned short m_perm1093[1093];
    unsigned short m_perm1097[1097];
    unsigned short m_perm1103[1103];
    unsigned short m_perm1109[1109];
    unsigned short m_perm1117[1117];
    unsigned short m_perm1123[1123];
    unsigned short m_perm1129[1129];
    unsigned short m_perm1151[1151];
    unsigned short m_perm1153[1153];
    unsigned short m_perm1163[1163];
    unsigned short m_perm1171[1171];
    unsigned short m_perm1181[1181];
    unsigned short m_perm1187[1187];
    unsigned short m_perm1193[1193];
    unsigned short m_perm1201[1201];
    unsigned short m_perm1213[1213];
    unsigned short m_perm1217[1217];
    unsigned short m_perm1223[1223];
    unsigned short m_perm1229[1229];
    unsigned short m_perm1231[1231];
    unsigned short m_perm1237[1237];
    unsigned short m_perm1249[1249];
    unsigned short m_perm1259[1259];
    unsigned short m_perm1277[1277];
    unsigned short m_perm1279[1279];
    unsigned short m_perm1283[1283];
    unsigned short m_perm1289[1289];
    unsigned short m_perm1291[1291];
    unsigned short m_perm1297[1297];
    unsigned short m_perm1301[1301];
    unsigned short m_perm1303[1303];
    unsigned short m_perm1307[1307];
    unsigned short m_perm1319[1319];
    unsigned short m_perm1321[1321];
    unsigned short m_perm1327[1327];
    unsigned short m_perm1361[1361];
    unsigned short m_perm1367[1367];
    unsigned short m_perm1373[1373];
    unsigned short m_perm1381[1381];
    unsigned short m_perm1399[1399];
    unsigned short m_perm1409[1409];
    unsigned short m_perm1423[1423];
    unsigned short m_perm1427[1427];
    unsigned short m_perm1429[1429];
    unsigned short m_perm1433[1433];
    unsigned short m_perm1439[1439];
    unsigned short m_perm1447[1447];
    unsigned short m_perm1451[1451];
    unsigned short m_perm1453[1453];
    unsigned short m_perm1459[1459];
    unsigned short m_perm1471[1471];
    unsigned short m_perm1481[1481];
    unsigned short m_perm1483[1483];
    unsigned short m_perm1487[1487];
    unsigned short m_perm1489[1489];
    unsigned short m_perm1493[1493];
    unsigned short m_perm1499[1499];
    unsigned short m_perm1511[1511];
    unsigned short m_perm1523[1523];
    unsigned short m_perm1531[1531];
    unsigned short m_perm1543[1543];
    unsigned short m_perm1549[1549];
    unsigned short m_perm1553[1553];
    unsigned short m_perm1559[1559];
    unsigned short m_perm1567[1567];
    unsigned short m_perm1571[1571];
    unsigned short m_perm1579[1579];
    unsigned short m_perm1583[1583];
    unsigned short m_perm1597[1597];
    unsigned short m_perm1601[1601];
    unsigned short m_perm1607[1607];
    unsigned short m_perm1609[1609];
    unsigned short m_perm1613[1613];
    unsigned short m_perm1619[1619];
};

inline void Halton_sampler::init_faure()
{
    const unsigned max_base = 1619u;
    std::vector<std::vector<unsigned short> > perms(max_base + 1);
    for (unsigned k = 1; k <= 3; ++k) // Keep identity permutations for base 1, 2, 3.
    {
        perms[k].resize(k);
        for (unsigned i = 0; i < k; ++i)
            perms[k][i] = i;
    }
    for (unsigned base = 4; base <= max_base; ++base)
    {
        perms[base].resize(base);
        const unsigned b = base / 2;
        if (base & 1) // odd
        {
            for (unsigned i = 0; i < base - 1; ++i)
                perms[base][i + (i >= b)] = perms[base - 1][i] + (perms[base - 1][i] >= b);
            perms[base][b] = b;
        }
        else // even
        {
            for (unsigned i = 0; i < b; ++i)
            {
                perms[base][i] = 2 * perms[b][i];
                perms[base][b + i] = 2 * perms[b][i] + 1;
            }
        }
    }
    init_tables(perms);
}

template <typename Random_number_generator>
void Halton_sampler::init_random(Random_number_generator& rand)
{
    const unsigned max_base = 1619u;
    std::vector<std::vector<unsigned short> > perms(max_base + 1);
    for (unsigned k = 1; k <= 3; ++k) // Keep identity permutations for base 1, 2, 3.
    {
        perms[k].resize(k);
        for (unsigned i = 0; i < k; ++i)
            perms[k][i] = i;
    }
    for (unsigned base = 4; base <= max_base; ++base)
    {
        perms[base].resize(base);
        for (unsigned i = 0; i < base; ++i)
            perms[base][i] = i;
        std::shuffle(perms[base].begin(), perms[base].end(), rand);
    }
    init_tables(perms);
}

inline float Halton_sampler::sample(const unsigned dimension, const unsigned index) const
{
    switch (dimension)
    {
        case 0: return halton2(index);
        case 1: return halton3(index);
        case 2: return halton5(index);
        case 3: return halton7(index);
        case 4: return halton11(index);
        case 5: return halton13(index);
        case 6: return halton17(index);
        case 7: return halton19(index);
        case 8: return halton23(index);
        case 9: return halton29(index);
        case 10: return halton31(index);
        case 11: return halton37(index);
        case 12: return halton41(index);
        case 13: return halton43(index);
        case 14: return halton47(index);
        case 15: return halton53(index);
        case 16: return halton59(index);
        case 17: return halton61(index);
        case 18: return halton67(index);
        case 19: return halton71(index);
        case 20: return halton73(index);
        case 21: return halton79(index);
        case 22: return halton83(index);
        case 23: return halton89(index);
        case 24: return halton97(index);
        case 25: return halton101(index);
        case 26: return halton103(index);
        case 27: return halton107(index);
        case 28: return halton109(index);
        case 29: return halton113(index);
        case 30: return halton127(index);
        case 31: return halton131(index);
        case 32: return halton137(index);
        case 33: return halton139(index);
        case 34: return halton149(index);
        case 35: return halton151(index);
        case 36: return halton157(index);
        case 37: return halton163(index);
        case 38: return halton167(index);
        case 39: return halton173(index);
        case 40: return halton179(index);
        case 41: return halton181(index);
        case 42: return halton191(index);
        case 43: return halton193(index);
        case 44: return halton197(index);
        case 45: return halton199(index);
        case 46: return halton211(index);
        case 47: return halton223(index);
        case 48: return halton227(index);
        case 49: return halton229(index);
        case 50: return halton233(index);
        case 51: return halton239(index);
        case 52: return halton241(index);
        case 53: return halton251(index);
        case 54: return halton257(index);
        case 55: return halton263(index);
        case 56: return halton269(index);
        case 57: return halton271(index);
        case 58: return halton277(index);
        case 59: return halton281(index);
        case 60: return halton283(index);
        case 61: return halton293(index);
        case 62: return halton307(index);
        case 63: return halton311(index);
        case 64: return halton313(index);
        case 65: return halton317(index);
        case 66: return halton331(index);
        case 67: return halton337(index);
        case 68: return halton347(index);
        case 69: return halton349(index);
        case 70: return halton353(index);
        case 71: return halton359(index);
        case 72: return halton367(index);
        case 73: return halton373(index);
        case 74: return halton379(index);
        case 75: return halton383(index);
        case 76: return halton389(index);
        case 77: return halton397(index);
        case 78: return halton401(index);
        case 79: return halton409(index);
        case 80: return halton419(index);
        case 81: return halton421(index);
        case 82: return halton431(index);
        case 83: return halton433(index);
        case 84: return halton439(index);
        case 85: return halton443(index);
        case 86: return halton449(index);
        case 87: return halton457(index);
        case 88: return halton461(index);
        case 89: return halton463(index);
        case 90: return halton467(index);
        case 91: return halton479(index);
        case 92: return halton487(index);
        case 93: return halton491(index);
        case 94: return halton499(index);
        case 95: return halton503(index);
        case 96: return halton509(index);
        case 97: return halton521(index);
        case 98: return halton523(index);
        case 99: return halton541(index);
        case 100: return halton547(index);
        case 101: return halton557(index);
        case 102: return halton563(index);
        case 103: return halton569(index);
        case 104: return halton571(index);
        case 105: return halton577(index);
        case 106: return halton587(index);
        case 107: return halton593(index);
        case 108: return halton599(index);
        case 109: return halton601(index);
        case 110: return halton607(index);
        case 111: return halton613(index);
        case 112: return halton617(index);
        case 113: return halton619(index);
        case 114: return halton631(index);
        case 115: return halton641(index);
        case 116: return halton643(index);
        case 117: return halton647(index);
        case 118: return halton653(index);
        case 119: return halton659(index);
        case 120: return halton661(index);
        case 121: return halton673(index);
        case 122: return halton677(index);
        case 123: return halton683(index);
        case 124: return halton691(index);
        case 125: return halton701(index);
        case 126: return halton709(index);
        case 127: return halton719(index);
        case 128: return halton727(index);
        case 129: return halton733(index);
        case 130: return halton739(index);
        case 131: return halton743(index);
        case 132: return halton751(index);
        case 133: return halton757(index);
        case 134: return halton761(index);
        case 135: return halton769(index);
        case 136: return halton773(index);
        case 137: return halton787(index);
        case 138: return halton797(index);
        case 139: return halton809(index);
        case 140: return halton811(index);
        case 141: return halton821(index);
        case 142: return halton823(index);
        case 143: return halton827(index);
        case 144: return halton829(index);
        case 145: return halton839(index);
        case 146: return halton853(index);
        case 147: return halton857(index);
        case 148: return halton859(index);
        case 149: return halton863(index);
        case 150: return halton877(index);
        case 151: return halton881(index);
        case 152: return halton883(index);
        case 153: return halton887(index);
        case 154: return halton907(index);
        case 155: return halton911(index);
        case 156: return halton919(index);
        case 157: return halton929(index);
        case 158: return halton937(index);
        case 159: return halton941(index);
        case 160: return halton947(index);
        case 161: return halton953(index);
        case 162: return halton967(index);
        case 163: return halton971(index);
        case 164: return halton977(index);
        case 165: return halton983(index);
        case 166: return halton991(index);
        case 167: return halton997(index);
        case 168: return halton1009(index);
        case 169: return halton1013(index);
        case 170: return halton1019(index);
        case 171: return halton1021(index);
        case 172: return halton1031(index);
        case 173: return halton1033(index);
        case 174: return halton1039(index);
        case 175: return halton1049(index);
        case 176: return halton1051(index);
        case 177: return halton1061(index);
        case 178: return halton1063(index);
        case 179: return halton1069(index);
        case 180: return halton1087(index);
        case 181: return halton1091(index);
        case 182: return halton1093(index);
        case 183: return halton1097(index);
        case 184: return halton1103(index);
        case 185: return halton1109(index);
        case 186: return halton1117(index);
        case 187: return halton1123(index);
        case 188: return halton1129(index);
        case 189: return halton1151(index);
        case 190: return halton1153(index);
        case 191: return halton1163(index);
        case 192: return halton1171(index);
        case 193: return halton1181(index);
        case 194: return halton1187(index);
        case 195: return halton1193(index);
        case 196: return halton1201(index);
        case 197: return halton1213(index);
        case 198: return halton1217(index);
        case 199: return halton1223(index);
        case 200: return halton1229(index);
        case 201: return halton1231(index);
        case 202: return halton1237(index);
        case 203: return halton1249(index);
        case 204: return halton1259(index);
        case 205: return halton1277(index);
        case 206: return halton1279(index);
        case 207: return halton1283(index);
        case 208: return halton1289(index);
        case 209: return halton1291(index);
        case 210: return halton1297(index);
        case 211: return halton1301(index);
        case 212: return halton1303(index);
        case 213: return halton1307(index);
        case 214: return halton1319(index);
        case 215: return halton1321(index);
        case 216: return halton1327(index);
        case 217: return halton1361(index);
        case 218: return halton1367(index);
        case 219: return halton1373(index);
        case 220: return halton1381(index);
        case 221: return halton1399(index);
        case 222: return halton1409(index);
        case 223: return halton1423(index);
        case 224: return halton1427(index);
        case 225: return halton1429(index);
        case 226: return halton1433(index);
        case 227: return halton1439(index);
        case 228: return halton1447(index);
        case 229: return halton1451(index);
        case 230: return halton1453(index);
        case 231: return halton1459(index);
        case 232: return halton1471(index);
        case 233: return halton1481(index);
        case 234: return halton1483(index);
        case 235: return halton1487(index);
        case 236: return halton1489(index);
        case 237: return halton1493(index);
        case 238: return halton1499(index);
        case 239: return halton1511(index);
        case 240: return halton1523(index);
        case 241: return halton1531(index);
        case 242: return halton1543(index);
        case 243: return halton1549(index);
        case 244: return halton1553(index);
        case 245: return halton1559(index);
        case 246: return halton1567(index);
        case 247: return halton1571(index);
        case 248: return halton1579(index);
        case 249: return halton1583(index);
        case 250: return halton1597(index);
        case 251: return halton1601(index);
        case 252: return halton1607(index);
        case 253: return halton1609(index);
        case 254: return halton1613(index);
        case 255: return halton1619(index);
    }
    return 0.f;
}

inline unsigned short Halton_sampler::invert(const unsigned short base, const unsigned short digits,
    unsigned short index, const std::vector<unsigned short>& perm)
{
    unsigned short result = 0;
    for (unsigned short i = 0; i < digits; ++i)
    {
        result = result * base + perm[index % base];
        index /= base;
    }
    return result;
}

inline void Halton_sampler::init_tables(const std::vector<std::vector<unsigned short> >& perms)
{
    for (unsigned short i = 0; i < 243; ++i)
        m_perm3[i] = invert(3, 5, i, perms[3]);
    for (unsigned short i = 0; i < 125; ++i)
        m_perm5[i] = invert(5, 3, i, perms[5]);
    for (unsigned short i = 0; i < 343; ++i)
        m_perm7[i] = invert(7, 3, i, perms[7]);
    for (unsigned short i = 0; i < 121; ++i)
        m_perm11[i] = invert(11, 2, i, perms[11]);
    for (unsigned short i = 0; i < 169; ++i)
        m_perm13[i] = invert(13, 2, i, perms[13]);
    for (unsigned short i = 0; i < 289; ++i)
        m_perm17[i] = invert(17, 2, i, perms[17]);
    for (unsigned short i = 0; i < 361; ++i)
        m_perm19[i] = invert(19, 2, i, perms[19]);
    for (unsigned short i = 0; i < 23; ++i)
        m_perm23[i] = invert(23, 1, i, perms[23]);
    for (unsigned short i = 0; i < 29; ++i)
        m_perm29[i] = invert(29, 1, i, perms[29]);
    for (unsigned short i = 0; i < 31; ++i)
        m_perm31[i] = invert(31, 1, i, perms[31]);
    for (unsigned short i = 0; i < 37; ++i)
        m_perm37[i] = invert(37, 1, i, perms[37]);
    for (unsigned short i = 0; i < 41; ++i)
        m_perm41[i] = invert(41, 1, i, perms[41]);
    for (unsigned short i = 0; i < 43; ++i)
        m_perm43[i] = invert(43, 1, i, perms[43]);
    for (unsigned short i = 0; i < 47; ++i)
        m_perm47[i] = invert(47, 1, i, perms[47]);
    for (unsigned short i = 0; i < 53; ++i)
        m_perm53[i] = invert(53, 1, i, perms[53]);
    for (unsigned short i = 0; i < 59; ++i)
        m_perm59[i] = invert(59, 1, i, perms[59]);
    for (unsigned short i = 0; i < 61; ++i)
        m_perm61[i] = invert(61, 1, i, perms[61]);
    for (unsigned short i = 0; i < 67; ++i)
        m_perm67[i] = invert(67, 1, i, perms[67]);
    for (unsigned short i = 0; i < 71; ++i)
        m_perm71[i] = invert(71, 1, i, perms[71]);
    for (unsigned short i = 0; i < 73; ++i)
        m_perm73[i] = invert(73, 1, i, perms[73]);
    for (unsigned short i = 0; i < 79; ++i)
        m_perm79[i] = invert(79, 1, i, perms[79]);
    for (unsigned short i = 0; i < 83; ++i)
        m_perm83[i] = invert(83, 1, i, perms[83]);
    for (unsigned short i = 0; i < 89; ++i)
        m_perm89[i] = invert(89, 1, i, perms[89]);
    for (unsigned short i = 0; i < 97; ++i)
        m_perm97[i] = invert(97, 1, i, perms[97]);
    for (unsigned short i = 0; i < 101; ++i)
        m_perm101[i] = invert(101, 1, i, perms[101]);
    for (unsigned short i = 0; i < 103; ++i)
        m_perm103[i] = invert(103, 1, i, perms[103]);
    for (unsigned short i = 0; i < 107; ++i)
        m_perm107[i] = invert(107, 1, i, perms[107]);
    for (unsigned short i = 0; i < 109; ++i)
        m_perm109[i] = invert(109, 1, i, perms[109]);
    for (unsigned short i = 0; i < 113; ++i)
        m_perm113[i] = invert(113, 1, i, perms[113]);
    for (unsigned short i = 0; i < 127; ++i)
        m_perm127[i] = invert(127, 1, i, perms[127]);
    for (unsigned short i = 0; i < 131; ++i)
        m_perm131[i] = invert(131, 1, i, perms[131]);
    for (unsigned short i = 0; i < 137; ++i)
        m_perm137[i] = invert(137, 1, i, perms[137]);
    for (unsigned short i = 0; i < 139; ++i)
        m_perm139[i] = invert(139, 1, i, perms[139]);
    for (unsigned short i = 0; i < 149; ++i)
        m_perm149[i] = invert(149, 1, i, perms[149]);
    for (unsigned short i = 0; i < 151; ++i)
        m_perm151[i] = invert(151, 1, i, perms[151]);
    for (unsigned short i = 0; i < 157; ++i)
        m_perm157[i] = invert(157, 1, i, perms[157]);
    for (unsigned short i = 0; i < 163; ++i)
        m_perm163[i] = invert(163, 1, i, perms[163]);
    for (unsigned short i = 0; i < 167; ++i)
        m_perm167[i] = invert(167, 1, i, perms[167]);
    for (unsigned short i = 0; i < 173; ++i)
        m_perm173[i] = invert(173, 1, i, perms[173]);
    for (unsigned short i = 0; i < 179; ++i)
        m_perm179[i] = invert(179, 1, i, perms[179]);
    for (unsigned short i = 0; i < 181; ++i)
        m_perm181[i] = invert(181, 1, i, perms[181]);
    for (unsigned short i = 0; i < 191; ++i)
        m_perm191[i] = invert(191, 1, i, perms[191]);
    for (unsigned short i = 0; i < 193; ++i)
        m_perm193[i] = invert(193, 1, i, perms[193]);
    for (unsigned short i = 0; i < 197; ++i)
        m_perm197[i] = invert(197, 1, i, perms[197]);
    for (unsigned short i = 0; i < 199; ++i)
        m_perm199[i] = invert(199, 1, i, perms[199]);
    for (unsigned short i = 0; i < 211; ++i)
        m_perm211[i] = invert(211, 1, i, perms[211]);
    for (unsigned short i = 0; i < 223; ++i)
        m_perm223[i] = invert(223, 1, i, perms[223]);
    for (unsigned short i = 0; i < 227; ++i)
        m_perm227[i] = invert(227, 1, i, perms[227]);
    for (unsigned short i = 0; i < 229; ++i)
        m_perm229[i] = invert(229, 1, i, perms[229]);
    for (unsigned short i = 0; i < 233; ++i)
        m_perm233[i] = invert(233, 1, i, perms[233]);
    for (unsigned short i = 0; i < 239; ++i)
        m_perm239[i] = invert(239, 1, i, perms[239]);
    for (unsigned short i = 0; i < 241; ++i)
        m_perm241[i] = invert(241, 1, i, perms[241]);
    for (unsigned short i = 0; i < 251; ++i)
        m_perm251[i] = invert(251, 1, i, perms[251]);
    for (unsigned short i = 0; i < 257; ++i)
        m_perm257[i] = invert(257, 1, i, perms[257]);
    for (unsigned short i = 0; i < 263; ++i)
        m_perm263[i] = invert(263, 1, i, perms[263]);
    for (unsigned short i = 0; i < 269; ++i)
        m_perm269[i] = invert(269, 1, i, perms[269]);
    for (unsigned short i = 0; i < 271; ++i)
        m_perm271[i] = invert(271, 1, i, perms[271]);
    for (unsigned short i = 0; i < 277; ++i)
        m_perm277[i] = invert(277, 1, i, perms[277]);
    for (unsigned short i = 0; i < 281; ++i)
        m_perm281[i] = invert(281, 1, i, perms[281]);
    for (unsigned short i = 0; i < 283; ++i)
        m_perm283[i] = invert(283, 1, i, perms[283]);
    for (unsigned short i = 0; i < 293; ++i)
        m_perm293[i] = invert(293, 1, i, perms[293]);
    for (unsigned short i = 0; i < 307; ++i)
        m_perm307[i] = invert(307, 1, i, perms[307]);
    for (unsigned short i = 0; i < 311; ++i)
        m_perm311[i] = invert(311, 1, i, perms[311]);
    for (unsigned short i = 0; i < 313; ++i)
        m_perm313[i] = invert(313, 1, i, perms[313]);
    for (unsigned short i = 0; i < 317; ++i)
        m_perm317[i] = invert(317, 1, i, perms[317]);
    for (unsigned short i = 0; i < 331; ++i)
        m_perm331[i] = invert(331, 1, i, perms[331]);
    for (unsigned short i = 0; i < 337; ++i)
        m_perm337[i] = invert(337, 1, i, perms[337]);
    for (unsigned short i = 0; i < 347; ++i)
        m_perm347[i] = invert(347, 1, i, perms[347]);
    for (unsigned short i = 0; i < 349; ++i)
        m_perm349[i] = invert(349, 1, i, perms[349]);
    for (unsigned short i = 0; i < 353; ++i)
        m_perm353[i] = invert(353, 1, i, perms[353]);
    for (unsigned short i = 0; i < 359; ++i)
        m_perm359[i] = invert(359, 1, i, perms[359]);
    for (unsigned short i = 0; i < 367; ++i)
        m_perm367[i] = invert(367, 1, i, perms[367]);
    for (unsigned short i = 0; i < 373; ++i)
        m_perm373[i] = invert(373, 1, i, perms[373]);
    for (unsigned short i = 0; i < 379; ++i)
        m_perm379[i] = invert(379, 1, i, perms[379]);
    for (unsigned short i = 0; i < 383; ++i)
        m_perm383[i] = invert(383, 1, i, perms[383]);
    for (unsigned short i = 0; i < 389; ++i)
        m_perm389[i] = invert(389, 1, i, perms[389]);
    for (unsigned short i = 0; i < 397; ++i)
        m_perm397[i] = invert(397, 1, i, perms[397]);
    for (unsigned short i = 0; i < 401; ++i)
        m_perm401[i] = invert(401, 1, i, perms[401]);
    for (unsigned short i = 0; i < 409; ++i)
        m_perm409[i] = invert(409, 1, i, perms[409]);
    for (unsigned short i = 0; i < 419; ++i)
        m_perm419[i] = invert(419, 1, i, perms[419]);
    for (unsigned short i = 0; i < 421; ++i)
        m_perm421[i] = invert(421, 1, i, perms[421]);
    for (unsigned short i = 0; i < 431; ++i)
        m_perm431[i] = invert(431, 1, i, perms[431]);
    for (unsigned short i = 0; i < 433; ++i)
        m_perm433[i] = invert(433, 1, i, perms[433]);
    for (unsigned short i = 0; i < 439; ++i)
        m_perm439[i] = invert(439, 1, i, perms[439]);
    for (unsigned short i = 0; i < 443; ++i)
        m_perm443[i] = invert(443, 1, i, perms[443]);
    for (unsigned short i = 0; i < 449; ++i)
        m_perm449[i] = invert(449, 1, i, perms[449]);
    for (unsigned short i = 0; i < 457; ++i)
        m_perm457[i] = invert(457, 1, i, perms[457]);
    for (unsigned short i = 0; i < 461; ++i)
        m_perm461[i] = invert(461, 1, i, perms[461]);
    for (unsigned short i = 0; i < 463; ++i)
        m_perm463[i] = invert(463, 1, i, perms[463]);
    for (unsigned short i = 0; i < 467; ++i)
        m_perm467[i] = invert(467, 1, i, perms[467]);
    for (unsigned short i = 0; i < 479; ++i)
        m_perm479[i] = invert(479, 1, i, perms[479]);
    for (unsigned short i = 0; i < 487; ++i)
        m_perm487[i] = invert(487, 1, i, perms[487]);
    for (unsigned short i = 0; i < 491; ++i)
        m_perm491[i] = invert(491, 1, i, perms[491]);
    for (unsigned short i = 0; i < 499; ++i)
        m_perm499[i] = invert(499, 1, i, perms[499]);
    for (unsigned short i = 0; i < 503; ++i)
        m_perm503[i] = invert(503, 1, i, perms[503]);
    for (unsigned short i = 0; i < 509; ++i)
        m_perm509[i] = invert(509, 1, i, perms[509]);
    for (unsigned short i = 0; i < 521; ++i)
        m_perm521[i] = invert(521, 1, i, perms[521]);
    for (unsigned short i = 0; i < 523; ++i)
        m_perm523[i] = invert(523, 1, i, perms[523]);
    for (unsigned short i = 0; i < 541; ++i)
        m_perm541[i] = invert(541, 1, i, perms[541]);
    for (unsigned short i = 0; i < 547; ++i)
        m_perm547[i] = invert(547, 1, i, perms[547]);
    for (unsigned short i = 0; i < 557; ++i)
        m_perm557[i] = invert(557, 1, i, perms[557]);
    for (unsigned short i = 0; i < 563; ++i)
        m_perm563[i] = invert(563, 1, i, perms[563]);
    for (unsigned short i = 0; i < 569; ++i)
        m_perm569[i] = invert(569, 1, i, perms[569]);
    for (unsigned short i = 0; i < 571; ++i)
        m_perm571[i] = invert(571, 1, i, perms[571]);
    for (unsigned short i = 0; i < 577; ++i)
        m_perm577[i] = invert(577, 1, i, perms[577]);
    for (unsigned short i = 0; i < 587; ++i)
        m_perm587[i] = invert(587, 1, i, perms[587]);
    for (unsigned short i = 0; i < 593; ++i)
        m_perm593[i] = invert(593, 1, i, perms[593]);
    for (unsigned short i = 0; i < 599; ++i)
        m_perm599[i] = invert(599, 1, i, perms[599]);
    for (unsigned short i = 0; i < 601; ++i)
        m_perm601[i] = invert(601, 1, i, perms[601]);
    for (unsigned short i = 0; i < 607; ++i)
        m_perm607[i] = invert(607, 1, i, perms[607]);
    for (unsigned short i = 0; i < 613; ++i)
        m_perm613[i] = invert(613, 1, i, perms[613]);
    for (unsigned short i = 0; i < 617; ++i)
        m_perm617[i] = invert(617, 1, i, perms[617]);
    for (unsigned short i = 0; i < 619; ++i)
        m_perm619[i] = invert(619, 1, i, perms[619]);
    for (unsigned short i = 0; i < 631; ++i)
        m_perm631[i] = invert(631, 1, i, perms[631]);
    for (unsigned short i = 0; i < 641; ++i)
        m_perm641[i] = invert(641, 1, i, perms[641]);
    for (unsigned short i = 0; i < 643; ++i)
        m_perm643[i] = invert(643, 1, i, perms[643]);
    for (unsigned short i = 0; i < 647; ++i)
        m_perm647[i] = invert(647, 1, i, perms[647]);
    for (unsigned short i = 0; i < 653; ++i)
        m_perm653[i] = invert(653, 1, i, perms[653]);
    for (unsigned short i = 0; i < 659; ++i)
        m_perm659[i] = invert(659, 1, i, perms[659]);
    for (unsigned short i = 0; i < 661; ++i)
        m_perm661[i] = invert(661, 1, i, perms[661]);
    for (unsigned short i = 0; i < 673; ++i)
        m_perm673[i] = invert(673, 1, i, perms[673]);
    for (unsigned short i = 0; i < 677; ++i)
        m_perm677[i] = invert(677, 1, i, perms[677]);
    for (unsigned short i = 0; i < 683; ++i)
        m_perm683[i] = invert(683, 1, i, perms[683]);
    for (unsigned short i = 0; i < 691; ++i)
        m_perm691[i] = invert(691, 1, i, perms[691]);
    for (unsigned short i = 0; i < 701; ++i)
        m_perm701[i] = invert(701, 1, i, perms[701]);
    for (unsigned short i = 0; i < 709; ++i)
        m_perm709[i] = invert(709, 1, i, perms[709]);
    for (unsigned short i = 0; i < 719; ++i)
        m_perm719[i] = invert(719, 1, i, perms[719]);
    for (unsigned short i = 0; i < 727; ++i)
        m_perm727[i] = invert(727, 1, i, perms[727]);
    for (unsigned short i = 0; i < 733; ++i)
        m_perm733[i] = invert(733, 1, i, perms[733]);
    for (unsigned short i = 0; i < 739; ++i)
        m_perm739[i] = invert(739, 1, i, perms[739]);
    for (unsigned short i = 0; i < 743; ++i)
        m_perm743[i] = invert(743, 1, i, perms[743]);
    for (unsigned short i = 0; i < 751; ++i)
        m_perm751[i] = invert(751, 1, i, perms[751]);
    for (unsigned short i = 0; i < 757; ++i)
        m_perm757[i] = invert(757, 1, i, perms[757]);
    for (unsigned short i = 0; i < 761; ++i)
        m_perm761[i] = invert(761, 1, i, perms[761]);
    for (unsigned short i = 0; i < 769; ++i)
        m_perm769[i] = invert(769, 1, i, perms[769]);
    for (unsigned short i = 0; i < 773; ++i)
        m_perm773[i] = invert(773, 1, i, perms[773]);
    for (unsigned short i = 0; i < 787; ++i)
        m_perm787[i] = invert(787, 1, i, perms[787]);
    for (unsigned short i = 0; i < 797; ++i)
        m_perm797[i] = invert(797, 1, i, perms[797]);
    for (unsigned short i = 0; i < 809; ++i)
        m_perm809[i] = invert(809, 1, i, perms[809]);
    for (unsigned short i = 0; i < 811; ++i)
        m_perm811[i] = invert(811, 1, i, perms[811]);
    for (unsigned short i = 0; i < 821; ++i)
        m_perm821[i] = invert(821, 1, i, perms[821]);
    for (unsigned short i = 0; i < 823; ++i)
        m_perm823[i] = invert(823, 1, i, perms[823]);
    for (unsigned short i = 0; i < 827; ++i)
        m_perm827[i] = invert(827, 1, i, perms[827]);
    for (unsigned short i = 0; i < 829; ++i)
        m_perm829[i] = invert(829, 1, i, perms[829]);
    for (unsigned short i = 0; i < 839; ++i)
        m_perm839[i] = invert(839, 1, i, perms[839]);
    for (unsigned short i = 0; i < 853; ++i)
        m_perm853[i] = invert(853, 1, i, perms[853]);
    for (unsigned short i = 0; i < 857; ++i)
        m_perm857[i] = invert(857, 1, i, perms[857]);
    for (unsigned short i = 0; i < 859; ++i)
        m_perm859[i] = invert(859, 1, i, perms[859]);
    for (unsigned short i = 0; i < 863; ++i)
        m_perm863[i] = invert(863, 1, i, perms[863]);
    for (unsigned short i = 0; i < 877; ++i)
        m_perm877[i] = invert(877, 1, i, perms[877]);
    for (unsigned short i = 0; i < 881; ++i)
        m_perm881[i] = invert(881, 1, i, perms[881]);
    for (unsigned short i = 0; i < 883; ++i)
        m_perm883[i] = invert(883, 1, i, perms[883]);
    for (unsigned short i = 0; i < 887; ++i)
        m_perm887[i] = invert(887, 1, i, perms[887]);
    for (unsigned short i = 0; i < 907; ++i)
        m_perm907[i] = invert(907, 1, i, perms[907]);
    for (unsigned short i = 0; i < 911; ++i)
        m_perm911[i] = invert(911, 1, i, perms[911]);
    for (unsigned short i = 0; i < 919; ++i)
        m_perm919[i] = invert(919, 1, i, perms[919]);
    for (unsigned short i = 0; i < 929; ++i)
        m_perm929[i] = invert(929, 1, i, perms[929]);
    for (unsigned short i = 0; i < 937; ++i)
        m_perm937[i] = invert(937, 1, i, perms[937]);
    for (unsigned short i = 0; i < 941; ++i)
        m_perm941[i] = invert(941, 1, i, perms[941]);
    for (unsigned short i = 0; i < 947; ++i)
        m_perm947[i] = invert(947, 1, i, perms[947]);
    for (unsigned short i = 0; i < 953; ++i)
        m_perm953[i] = invert(953, 1, i, perms[953]);
    for (unsigned short i = 0; i < 967; ++i)
        m_perm967[i] = invert(967, 1, i, perms[967]);
    for (unsigned short i = 0; i < 971; ++i)
        m_perm971[i] = invert(971, 1, i, perms[971]);
    for (unsigned short i = 0; i < 977; ++i)
        m_perm977[i] = invert(977, 1, i, perms[977]);
    for (unsigned short i = 0; i < 983; ++i)
        m_perm983[i] = invert(983, 1, i, perms[983]);
    for (unsigned short i = 0; i < 991; ++i)
        m_perm991[i] = invert(991, 1, i, perms[991]);
    for (unsigned short i = 0; i < 997; ++i)
        m_perm997[i] = invert(997, 1, i, perms[997]);
    for (unsigned short i = 0; i < 1009; ++i)
        m_perm1009[i] = invert(1009, 1, i, perms[1009]);
    for (unsigned short i = 0; i < 1013; ++i)
        m_perm1013[i] = invert(1013, 1, i, perms[1013]);
    for (unsigned short i = 0; i < 1019; ++i)
        m_perm1019[i] = invert(1019, 1, i, perms[1019]);
    for (unsigned short i = 0; i < 1021; ++i)
        m_perm1021[i] = invert(1021, 1, i, perms[1021]);
    for (unsigned short i = 0; i < 1031; ++i)
        m_perm1031[i] = invert(1031, 1, i, perms[1031]);
    for (unsigned short i = 0; i < 1033; ++i)
        m_perm1033[i] = invert(1033, 1, i, perms[1033]);
    for (unsigned short i = 0; i < 1039; ++i)
        m_perm1039[i] = invert(1039, 1, i, perms[1039]);
    for (unsigned short i = 0; i < 1049; ++i)
        m_perm1049[i] = invert(1049, 1, i, perms[1049]);
    for (unsigned short i = 0; i < 1051; ++i)
        m_perm1051[i] = invert(1051, 1, i, perms[1051]);
    for (unsigned short i = 0; i < 1061; ++i)
        m_perm1061[i] = invert(1061, 1, i, perms[1061]);
    for (unsigned short i = 0; i < 1063; ++i)
        m_perm1063[i] = invert(1063, 1, i, perms[1063]);
    for (unsigned short i = 0; i < 1069; ++i)
        m_perm1069[i] = invert(1069, 1, i, perms[1069]);
    for (unsigned short i = 0; i < 1087; ++i)
        m_perm1087[i] = invert(1087, 1, i, perms[1087]);
    for (unsigned short i = 0; i < 1091; ++i)
        m_perm1091[i] = invert(1091, 1, i, perms[1091]);
    for (unsigned short i = 0; i < 1093; ++i)
        m_perm1093[i] = invert(1093, 1, i, perms[1093]);
    for (unsigned short i = 0; i < 1097; ++i)
        m_perm1097[i] = invert(1097, 1, i, perms[1097]);
    for (unsigned short i = 0; i < 1103; ++i)
        m_perm1103[i] = invert(1103, 1, i, perms[1103]);
    for (unsigned short i = 0; i < 1109; ++i)
        m_perm1109[i] = invert(1109, 1, i, perms[1109]);
    for (unsigned short i = 0; i < 1117; ++i)
        m_perm1117[i] = invert(1117, 1, i, perms[1117]);
    for (unsigned short i = 0; i < 1123; ++i)
        m_perm1123[i] = invert(1123, 1, i, perms[1123]);
    for (unsigned short i = 0; i < 1129; ++i)
        m_perm1129[i] = invert(1129, 1, i, perms[1129]);
    for (unsigned short i = 0; i < 1151; ++i)
        m_perm1151[i] = invert(1151, 1, i, perms[1151]);
    for (unsigned short i = 0; i < 1153; ++i)
        m_perm1153[i] = invert(1153, 1, i, perms[1153]);
    for (unsigned short i = 0; i < 1163; ++i)
        m_perm1163[i] = invert(1163, 1, i, perms[1163]);
    for (unsigned short i = 0; i < 1171; ++i)
        m_perm1171[i] = invert(1171, 1, i, perms[1171]);
    for (unsigned short i = 0; i < 1181; ++i)
        m_perm1181[i] = invert(1181, 1, i, perms[1181]);
    for (unsigned short i = 0; i < 1187; ++i)
        m_perm1187[i] = invert(1187, 1, i, perms[1187]);
    for (unsigned short i = 0; i < 1193; ++i)
        m_perm1193[i] = invert(1193, 1, i, perms[1193]);
    for (unsigned short i = 0; i < 1201; ++i)
        m_perm1201[i] = invert(1201, 1, i, perms[1201]);
    for (unsigned short i = 0; i < 1213; ++i)
        m_perm1213[i] = invert(1213, 1, i, perms[1213]);
    for (unsigned short i = 0; i < 1217; ++i)
        m_perm1217[i] = invert(1217, 1, i, perms[1217]);
    for (unsigned short i = 0; i < 1223; ++i)
        m_perm1223[i] = invert(1223, 1, i, perms[1223]);
    for (unsigned short i = 0; i < 1229; ++i)
        m_perm1229[i] = invert(1229, 1, i, perms[1229]);
    for (unsigned short i = 0; i < 1231; ++i)
        m_perm1231[i] = invert(1231, 1, i, perms[1231]);
    for (unsigned short i = 0; i < 1237; ++i)
        m_perm1237[i] = invert(1237, 1, i, perms[1237]);
    for (unsigned short i = 0; i < 1249; ++i)
        m_perm1249[i] = invert(1249, 1, i, perms[1249]);
    for (unsigned short i = 0; i < 1259; ++i)
        m_perm1259[i] = invert(1259, 1, i, perms[1259]);
    for (unsigned short i = 0; i < 1277; ++i)
        m_perm1277[i] = invert(1277, 1, i, perms[1277]);
    for (unsigned short i = 0; i < 1279; ++i)
        m_perm1279[i] = invert(1279, 1, i, perms[1279]);
    for (unsigned short i = 0; i < 1283; ++i)
        m_perm1283[i] = invert(1283, 1, i, perms[1283]);
    for (unsigned short i = 0; i < 1289; ++i)
        m_perm1289[i] = invert(1289, 1, i, perms[1289]);
    for (unsigned short i = 0; i < 1291; ++i)
        m_perm1291[i] = invert(1291, 1, i, perms[1291]);
    for (unsigned short i = 0; i < 1297; ++i)
        m_perm1297[i] = invert(1297, 1, i, perms[1297]);
    for (unsigned short i = 0; i < 1301; ++i)
        m_perm1301[i] = invert(1301, 1, i, perms[1301]);
    for (unsigned short i = 0; i < 1303; ++i)
        m_perm1303[i] = invert(1303, 1, i, perms[1303]);
    for (unsigned short i = 0; i < 1307; ++i)
        m_perm1307[i] = invert(1307, 1, i, perms[1307]);
    for (unsigned short i = 0; i < 1319; ++i)
        m_perm1319[i] = invert(1319, 1, i, perms[1319]);
    for (unsigned short i = 0; i < 1321; ++i)
        m_perm1321[i] = invert(1321, 1, i, perms[1321]);
    for (unsigned short i = 0; i < 1327; ++i)
        m_perm1327[i] = invert(1327, 1, i, perms[1327]);
    for (unsigned short i = 0; i < 1361; ++i)
        m_perm1361[i] = invert(1361, 1, i, perms[1361]);
    for (unsigned short i = 0; i < 1367; ++i)
        m_perm1367[i] = invert(1367, 1, i, perms[1367]);
    for (unsigned short i = 0; i < 1373; ++i)
        m_perm1373[i] = invert(1373, 1, i, perms[1373]);
    for (unsigned short i = 0; i < 1381; ++i)
        m_perm1381[i] = invert(1381, 1, i, perms[1381]);
    for (unsigned short i = 0; i < 1399; ++i)
        m_perm1399[i] = invert(1399, 1, i, perms[1399]);
    for (unsigned short i = 0; i < 1409; ++i)
        m_perm1409[i] = invert(1409, 1, i, perms[1409]);
    for (unsigned short i = 0; i < 1423; ++i)
        m_perm1423[i] = invert(1423, 1, i, perms[1423]);
    for (unsigned short i = 0; i < 1427; ++i)
        m_perm1427[i] = invert(1427, 1, i, perms[1427]);
    for (unsigned short i = 0; i < 1429; ++i)
        m_perm1429[i] = invert(1429, 1, i, perms[1429]);
    for (unsigned short i = 0; i < 1433; ++i)
        m_perm1433[i] = invert(1433, 1, i, perms[1433]);
    for (unsigned short i = 0; i < 1439; ++i)
        m_perm1439[i] = invert(1439, 1, i, perms[1439]);
    for (unsigned short i = 0; i < 1447; ++i)
        m_perm1447[i] = invert(1447, 1, i, perms[1447]);
    for (unsigned short i = 0; i < 1451; ++i)
        m_perm1451[i] = invert(1451, 1, i, perms[1451]);
    for (unsigned short i = 0; i < 1453; ++i)
        m_perm1453[i] = invert(1453, 1, i, perms[1453]);
    for (unsigned short i = 0; i < 1459; ++i)
        m_perm1459[i] = invert(1459, 1, i, perms[1459]);
    for (unsigned short i = 0; i < 1471; ++i)
        m_perm1471[i] = invert(1471, 1, i, perms[1471]);
    for (unsigned short i = 0; i < 1481; ++i)
        m_perm1481[i] = invert(1481, 1, i, perms[1481]);
    for (unsigned short i = 0; i < 1483; ++i)
        m_perm1483[i] = invert(1483, 1, i, perms[1483]);
    for (unsigned short i = 0; i < 1487; ++i)
        m_perm1487[i] = invert(1487, 1, i, perms[1487]);
    for (unsigned short i = 0; i < 1489; ++i)
        m_perm1489[i] = invert(1489, 1, i, perms[1489]);
    for (unsigned short i = 0; i < 1493; ++i)
        m_perm1493[i] = invert(1493, 1, i, perms[1493]);
    for (unsigned short i = 0; i < 1499; ++i)
        m_perm1499[i] = invert(1499, 1, i, perms[1499]);
    for (unsigned short i = 0; i < 1511; ++i)
        m_perm1511[i] = invert(1511, 1, i, perms[1511]);
    for (unsigned short i = 0; i < 1523; ++i)
        m_perm1523[i] = invert(1523, 1, i, perms[1523]);
    for (unsigned short i = 0; i < 1531; ++i)
        m_perm1531[i] = invert(1531, 1, i, perms[1531]);
    for (unsigned short i = 0; i < 1543; ++i)
        m_perm1543[i] = invert(1543, 1, i, perms[1543]);
    for (unsigned short i = 0; i < 1549; ++i)
        m_perm1549[i] = invert(1549, 1, i, perms[1549]);
    for (unsigned short i = 0; i < 1553; ++i)
        m_perm1553[i] = invert(1553, 1, i, perms[1553]);
    for (unsigned short i = 0; i < 1559; ++i)
        m_perm1559[i] = invert(1559, 1, i, perms[1559]);
    for (unsigned short i = 0; i < 1567; ++i)
        m_perm1567[i] = invert(1567, 1, i, perms[1567]);
    for (unsigned short i = 0; i < 1571; ++i)
        m_perm1571[i] = invert(1571, 1, i, perms[1571]);
    for (unsigned short i = 0; i < 1579; ++i)
        m_perm1579[i] = invert(1579, 1, i, perms[1579]);
    for (unsigned short i = 0; i < 1583; ++i)
        m_perm1583[i] = invert(1583, 1, i, perms[1583]);
    for (unsigned short i = 0; i < 1597; ++i)
        m_perm1597[i] = invert(1597, 1, i, perms[1597]);
    for (unsigned short i = 0; i < 1601; ++i)
        m_perm1601[i] = invert(1601, 1, i, perms[1601]);
    for (unsigned short i = 0; i < 1607; ++i)
        m_perm1607[i] = invert(1607, 1, i, perms[1607]);
    for (unsigned short i = 0; i < 1609; ++i)
        m_perm1609[i] = invert(1609, 1, i, perms[1609]);
    for (unsigned short i = 0; i < 1613; ++i)
        m_perm1613[i] = invert(1613, 1, i, perms[1613]);
    for (unsigned short i = 0; i < 1619; ++i)
        m_perm1619[i] = invert(1619, 1, i, perms[1619]);
}

// Special case: radical inverse in base 2, with direct bit reversal.
inline float Halton_sampler::halton2(unsigned index) const
{
    index = (index << 16) | (index >> 16);
    index = ((index & 0x00ff00ff) << 8) | ((index & 0xff00ff00) >> 8);
    index = ((index & 0x0f0f0f0f) << 4) | ((index & 0xf0f0f0f0) >> 4);
    index = ((index & 0x33333333) << 2) | ((index & 0xcccccccc) >> 2);
    index = ((index & 0x55555555) << 1) | ((index & 0xaaaaaaaa) >> 1);
    union Result
    {
        unsigned u;
        float f;
    } result; // Write reversed bits directly into floating-point mantissa.
    result.u = 0x3f800000u | (index >> 9);
    return result.f - 1.f;
}

inline float Halton_sampler::halton3(const unsigned index) const
{
    return (m_perm3[index % 243u] * 14348907u +
            m_perm3[(index / 243u) % 243u] * 59049u +
            m_perm3[(index / 59049u) % 243u] * 243u +
            m_perm3[(index / 14348907u) % 243u]) * float(0x1.fffffcp-1 / 3486784401u); // Results in [0,1).
}

inline float Halton_sampler::halton5(const unsigned index) const
{
    return (m_perm5[index % 125u] * 1953125u +
            m_perm5[(index / 125u) % 125u] * 15625u +
            m_perm5[(index / 15625u) % 125u] * 125u +
            m_perm5[(index / 1953125u) % 125u]) * float(0x1.fffffcp-1 / 244140625u); // Results in [0,1).
}

inline float Halton_sampler::halton7(const unsigned index) const
{
    return (m_perm7[index % 343u] * 117649u +
            m_perm7[(index / 343u) % 343u] * 343u +
            m_perm7[(index / 117649u) % 343u]) * float(0x1.fffffcp-1 / 40353607u); // Results in [0,1).
}

inline float Halton_sampler::halton11(const unsigned index) const
{
    return (m_perm11[index % 121u] * 1771561u +
            m_perm11[(index / 121u) % 121u] * 14641u +
            m_perm11[(index / 14641u) % 121u] * 121u +
            m_perm11[(index / 1771561u) % 121u]) * float(0x1.fffffcp-1 / 214358881u); // Results in [0,1).
}

inline float Halton_sampler::halton13(const unsigned index) const
{
    return (m_perm13[index % 169u] * 4826809u +
            m_perm13[(index / 169u) % 169u] * 28561u +
            m_perm13[(index / 28561u) % 169u] * 169u +
            m_perm13[(index / 4826809u) % 169u]) * float(0x1.fffffcp-1 / 815730721u); // Results in [0,1).
}

inline float Halton_sampler::halton17(const unsigned index) const
{
    return (m_perm17[index % 289u] * 83521u +
            m_perm17[(index / 289u) % 289u] * 289u +
            m_perm17[(index / 83521u) % 289u]) * float(0x1.fffffcp-1 / 24137569u); // Results in [0,1).
}

inline float Halton_sampler::halton19(const unsigned index) const
{
    return (m_perm19[index % 361u] * 130321u +
            m_perm19[(index / 361u) % 361u] * 361u +
            m_perm19[(index / 130321u) % 361u]) * float(0x1.fffffcp-1 / 47045881u); // Results in [0,1).
}

inline float Halton_sampler::halton23(const unsigned index) const
{
    return (m_perm23[index % 23u] * 148035889u +
            m_perm23[(index / 23u) % 23u] * 6436343u +
            m_perm23[(index / 529u) % 23u] * 279841u +
            m_perm23[(index / 12167u) % 23u] * 12167u +
            m_perm23[(index / 279841u) % 23u] * 529u +
            m_perm23[(index / 6436343u) % 23u] * 23u +
            m_perm23[(index / 148035889u) % 23u]) * float(0x1.fffffcp-1 / 3404825447u); // Results in [0,1).
}

inline float Halton_sampler::halton29(const unsigned index) const
{
    return (m_perm29[index % 29u] * 20511149u +
            m_perm29[(index / 29u) % 29u] * 707281u +
            m_perm29[(index / 841u) % 29u] * 24389u +
            m_perm29[(index / 24389u) % 29u] * 841u +
            m_perm29[(index / 707281u) % 29u] * 29u +
            m_perm29[(index / 20511149u) % 29u]) * float(0x1.fffffcp-1 / 594823321u); // Results in [0,1).
}

inline float Halton_sampler::halton31(const unsigned index) const
{
    return (m_perm31[index % 31u] * 28629151u +
            m_perm31[(index / 31u) % 31u] * 923521u +
            m_perm31[(index / 961u) % 31u] * 29791u +
            m_perm31[(index / 29791u) % 31u] * 961u +
            m_perm31[(index / 923521u) % 31u] * 31u +
            m_perm31[(index / 28629151u) % 31u]) * float(0x1.fffffcp-1 / 887503681u); // Results in [0,1).
}

inline float Halton_sampler::halton37(const unsigned index) const
{
    return (m_perm37[index % 37u] * 69343957u +
            m_perm37[(index / 37u) % 37u] * 1874161u +
            m_perm37[(index / 1369u) % 37u] * 50653u +
            m_perm37[(index / 50653u) % 37u] * 1369u +
            m_perm37[(index / 1874161u) % 37u] * 37u +
            m_perm37[(index / 69343957u) % 37u]) * float(0x1.fffffcp-1 / 2565726409u); // Results in [0,1).
}

inline float Halton_sampler::halton41(const unsigned index) const
{
    return (m_perm41[index % 41u] * 2825761u +
            m_perm41[(index / 41u) % 41u] * 68921u +
            m_perm41[(index / 1681u) % 41u] * 1681u +
            m_perm41[(index / 68921u) % 41u] * 41u +
            m_perm41[(index / 2825761u) % 41u]) * float(0x1.fffffcp-1 / 115856201u); // Results in [0,1).
}

inline float Halton_sampler::halton43(const unsigned index) const
{
    return (m_perm43[index % 43u] * 3418801u +
            m_perm43[(index / 43u) % 43u] * 79507u +
            m_perm43[(index / 1849u) % 43u] * 1849u +
            m_perm43[(index / 79507u) % 43u] * 43u +
            m_perm43[(index / 3418801u) % 43u]) * float(0x1.fffffcp-1 / 147008443u); // Results in [0,1).
}

inline float Halton_sampler::halton47(const unsigned index) const
{
    return (m_perm47[index % 47u] * 4879681u +
            m_perm47[(index / 47u) % 47u] * 103823u +
            m_perm47[(index / 2209u) % 47u] * 2209u +
            m_perm47[(index / 103823u) % 47u] * 47u +
            m_perm47[(index / 4879681u) % 47u]) * float(0x1.fffffcp-1 / 229345007u); // Results in [0,1).
}

inline float Halton_sampler::halton53(const unsigned index) const
{
    return (m_perm53[index % 53u] * 7890481u +
            m_perm53[(index / 53u) % 53u] * 148877u +
            m_perm53[(index / 2809u) % 53u] * 2809u +
            m_perm53[(index / 148877u) % 53u] * 53u +
            m_perm53[(index / 7890481u) % 53u]) * float(0x1.fffffcp-1 / 418195493u); // Results in [0,1).
}

inline float Halton_sampler::halton59(const unsigned index) const
{
    return (m_perm59[index % 59u] * 12117361u +
            m_perm59[(index / 59u) % 59u] * 205379u +
            m_perm59[(index / 3481u) % 59u] * 3481u +
            m_perm59[(index / 205379u) % 59u] * 59u +
            m_perm59[(index / 12117361u) % 59u]) * float(0x1.fffffcp-1 / 714924299u); // Results in [0,1).
}

inline float Halton_sampler::halton61(const unsigned index) const
{
    return (m_perm61[index % 61u] * 13845841u +
            m_perm61[(index / 61u) % 61u] * 226981u +
            m_perm61[(index / 3721u) % 61u] * 3721u +
            m_perm61[(index / 226981u) % 61u] * 61u +
            m_perm61[(index / 13845841u) % 61u]) * float(0x1.fffffcp-1 / 844596301u); // Results in [0,1).
}

inline float Halton_sampler::halton67(const unsigned index) const
{
    return (m_perm67[index % 67u] * 20151121u +
            m_perm67[(index / 67u) % 67u] * 300763u +
            m_perm67[(index / 4489u) % 67u] * 4489u +
            m_perm67[(index / 300763u) % 67u] * 67u +
            m_perm67[(index / 20151121u) % 67u]) * float(0x1.fffffcp-1 / 1350125107u); // Results in [0,1).
}

inline float Halton_sampler::halton71(const unsigned index) const
{
    return (m_perm71[index % 71u] * 25411681u +
            m_perm71[(index / 71u) % 71u] * 357911u +
            m_perm71[(index / 5041u) % 71u] * 5041u +
            m_perm71[(index / 357911u) % 71u] * 71u +
            m_perm71[(index / 25411681u) % 71u]) * float(0x1.fffffcp-1 / 1804229351u); // Results in [0,1).
}

inline float Halton_sampler::halton73(const unsigned index) const
{
    return (m_perm73[index % 73u] * 28398241u +
            m_perm73[(index / 73u) % 73u] * 389017u +
            m_perm73[(index / 5329u) % 73u] * 5329u +
            m_perm73[(index / 389017u) % 73u] * 73u +
            m_perm73[(index / 28398241u) % 73u]) * float(0x1.fffffcp-1 / 2073071593u); // Results in [0,1).
}

inline float Halton_sampler::halton79(const unsigned index) const
{
    return (m_perm79[index % 79u] * 38950081u +
            m_perm79[(index / 79u) % 79u] * 493039u +
            m_perm79[(index / 6241u) % 79u] * 6241u +
            m_perm79[(index / 493039u) % 79u] * 79u +
            m_perm79[(index / 38950081u) % 79u]) * float(0x1.fffffcp-1 / 3077056399u); // Results in [0,1).
}

inline float Halton_sampler::halton83(const unsigned index) const
{
    return (m_perm83[index % 83u] * 47458321u +
            m_perm83[(index / 83u) % 83u] * 571787u +
            m_perm83[(index / 6889u) % 83u] * 6889u +
            m_perm83[(index / 571787u) % 83u] * 83u +
            m_perm83[(index / 47458321u) % 83u]) * float(0x1.fffffcp-1 / 3939040643u); // Results in [0,1).
}

inline float Halton_sampler::halton89(const unsigned index) const
{
    return (m_perm89[index % 89u] * 704969u +
            m_perm89[(index / 89u) % 89u] * 7921u +
            m_perm89[(index / 7921u) % 89u] * 89u +
            m_perm89[(index / 704969u) % 89u]) * float(0x1.fffffcp-1 / 62742241u); // Results in [0,1).
}

inline float Halton_sampler::halton97(const unsigned index) const
{
    return (m_perm97[index % 97u] * 912673u +
            m_perm97[(index / 97u) % 97u] * 9409u +
            m_perm97[(index / 9409u) % 97u] * 97u +
            m_perm97[(index / 912673u) % 97u]) * float(0x1.fffffcp-1 / 88529281u); // Results in [0,1).
}

inline float Halton_sampler::halton101(const unsigned index) const
{
    return (m_perm101[index % 101u] * 1030301u +
            m_perm101[(index / 101u) % 101u] * 10201u +
            m_perm101[(index / 10201u) % 101u] * 101u +
            m_perm101[(index / 1030301u) % 101u]) * float(0x1.fffffcp-1 / 104060401u); // Results in [0,1).
}

inline float Halton_sampler::halton103(const unsigned index) const
{
    return (m_perm103[index % 103u] * 1092727u +
            m_perm103[(index / 103u) % 103u] * 10609u +
            m_perm103[(index / 10609u) % 103u] * 103u +
            m_perm103[(index / 1092727u) % 103u]) * float(0x1.fffffcp-1 / 112550881u); // Results in [0,1).
}

inline float Halton_sampler::halton107(const unsigned index) const
{
    return (m_perm107[index % 107u] * 1225043u +
            m_perm107[(index / 107u) % 107u] * 11449u +
            m_perm107[(index / 11449u) % 107u] * 107u +
            m_perm107[(index / 1225043u) % 107u]) * float(0x1.fffffcp-1 / 131079601u); // Results in [0,1).
}

inline float Halton_sampler::halton109(const unsigned index) const
{
    return (m_perm109[index % 109u] * 1295029u +
            m_perm109[(index / 109u) % 109u] * 11881u +
            m_perm109[(index / 11881u) % 109u] * 109u +
            m_perm109[(index / 1295029u) % 109u]) * float(0x1.fffffcp-1 / 141158161u); // Results in [0,1).
}

inline float Halton_sampler::halton113(const unsigned index) const
{
    return (m_perm113[index % 113u] * 1442897u +
            m_perm113[(index / 113u) % 113u] * 12769u +
            m_perm113[(index / 12769u) % 113u] * 113u +
            m_perm113[(index / 1442897u) % 113u]) * float(0x1.fffffcp-1 / 163047361u); // Results in [0,1).
}

inline float Halton_sampler::halton127(const unsigned index) const
{
    return (m_perm127[index % 127u] * 2048383u +
            m_perm127[(index / 127u) % 127u] * 16129u +
            m_perm127[(index / 16129u) % 127u] * 127u +
            m_perm127[(index / 2048383u) % 127u]) * float(0x1.fffffcp-1 / 260144641u); // Results in [0,1).
}

inline float Halton_sampler::halton131(const unsigned index) const
{
    return (m_perm131[index % 131u] * 2248091u +
            m_perm131[(index / 131u) % 131u] * 17161u +
            m_perm131[(index / 17161u) % 131u] * 131u +
            m_perm131[(index / 2248091u) % 131u]) * float(0x1.fffffcp-1 / 294499921u); // Results in [0,1).
}

inline float Halton_sampler::halton137(const unsigned index) const
{
    return (m_perm137[index % 137u] * 2571353u +
            m_perm137[(index / 137u) % 137u] * 18769u +
            m_perm137[(index / 18769u) % 137u] * 137u +
            m_perm137[(index / 2571353u) % 137u]) * float(0x1.fffffcp-1 / 352275361u); // Results in [0,1).
}

inline float Halton_sampler::halton139(const unsigned index) const
{
    return (m_perm139[index % 139u] * 2685619u +
            m_perm139[(index / 139u) % 139u] * 19321u +
            m_perm139[(index / 19321u) % 139u] * 139u +
            m_perm139[(index / 2685619u) % 139u]) * float(0x1.fffffcp-1 / 373301041u); // Results in [0,1).
}

inline float Halton_sampler::halton149(const unsigned index) const
{
    return (m_perm149[index % 149u] * 3307949u +
            m_perm149[(index / 149u) % 149u] * 22201u +
            m_perm149[(index / 22201u) % 149u] * 149u +
            m_perm149[(index / 3307949u) % 149u]) * float(0x1.fffffcp-1 / 492884401u); // Results in [0,1).
}

inline float Halton_sampler::halton151(const unsigned index) const
{
    return (m_perm151[index % 151u] * 3442951u +
            m_perm151[(index / 151u) % 151u] * 22801u +
            m_perm151[(index / 22801u) % 151u] * 151u +
            m_perm151[(index / 3442951u) % 151u]) * float(0x1.fffffcp-1 / 519885601u); // Results in [0,1).
}

inline float Halton_sampler::halton157(const unsigned index) const
{
    return (m_perm157[index % 157u] * 3869893u +
            m_perm157[(index / 157u) % 157u] * 24649u +
            m_perm157[(index / 24649u) % 157u] * 157u +
            m_perm157[(index / 3869893u) % 157u]) * float(0x1.fffffcp-1 / 607573201u); // Results in [0,1).
}

inline float Halton_sampler::halton163(const unsigned index) const
{
    return (m_perm163[index % 163u] * 4330747u +
            m_perm163[(index / 163u) % 163u] * 26569u +
            m_perm163[(index / 26569u) % 163u] * 163u +
            m_perm163[(index / 4330747u) % 163u]) * float(0x1.fffffcp-1 / 705911761u); // Results in [0,1).
}

inline float Halton_sampler::halton167(const unsigned index) const
{
    return (m_perm167[index % 167u] * 4657463u +
            m_perm167[(index / 167u) % 167u] * 27889u +
            m_perm167[(index / 27889u) % 167u] * 167u +
            m_perm167[(index / 4657463u) % 167u]) * float(0x1.fffffcp-1 / 777796321u); // Results in [0,1).
}

inline float Halton_sampler::halton173(const unsigned index) const
{
    return (m_perm173[index % 173u] * 5177717u +
            m_perm173[(index / 173u) % 173u] * 29929u +
            m_perm173[(index / 29929u) % 173u] * 173u +
            m_perm173[(index / 5177717u) % 173u]) * float(0x1.fffffcp-1 / 895745041u); // Results in [0,1).
}

inline float Halton_sampler::halton179(const unsigned index) const
{
    return (m_perm179[index % 179u] * 5735339u +
            m_perm179[(index / 179u) % 179u] * 32041u +
            m_perm179[(index / 32041u) % 179u] * 179u +
            m_perm179[(index / 5735339u) % 179u]) * float(0x1.fffffcp-1 / 1026625681u); // Results in [0,1).
}

inline float Halton_sampler::halton181(const unsigned index) const
{
    return (m_perm181[index % 181u] * 5929741u +
            m_perm181[(index / 181u) % 181u] * 32761u +
            m_perm181[(index / 32761u) % 181u] * 181u +
            m_perm181[(index / 5929741u) % 181u]) * float(0x1.fffffcp-1 / 1073283121u); // Results in [0,1).
}

inline float Halton_sampler::halton191(const unsigned index) const
{
    return (m_perm191[index % 191u] * 6967871u +
            m_perm191[(index / 191u) % 191u] * 36481u +
            m_perm191[(index / 36481u) % 191u] * 191u +
            m_perm191[(index / 6967871u) % 191u]) * float(0x1.fffffcp-1 / 1330863361u); // Results in [0,1).
}

inline float Halton_sampler::halton193(const unsigned index) const
{
    return (m_perm193[index % 193u] * 7189057u +
            m_perm193[(index / 193u) % 193u] * 37249u +
            m_perm193[(index / 37249u) % 193u] * 193u +
            m_perm193[(index / 7189057u) % 193u]) * float(0x1.fffffcp-1 / 1387488001u); // Results in [0,1).
}

inline float Halton_sampler::halton197(const unsigned index) const
{
    return (m_perm197[index % 197u] * 7645373u +
            m_perm197[(index / 197u) % 197u] * 38809u +
            m_perm197[(index / 38809u) % 197u] * 197u +
            m_perm197[(index / 7645373u) % 197u]) * float(0x1.fffffcp-1 / 1506138481u); // Results in [0,1).
}

inline float Halton_sampler::halton199(const unsigned index) const
{
    return (m_perm199[index % 199u] * 7880599u +
            m_perm199[(index / 199u) % 199u] * 39601u +
            m_perm199[(index / 39601u) % 199u] * 199u +
            m_perm199[(index / 7880599u) % 199u]) * float(0x1.fffffcp-1 / 1568239201u); // Results in [0,1).
}

inline float Halton_sampler::halton211(const unsigned index) const
{
    return (m_perm211[index % 211u] * 9393931u +
            m_perm211[(index / 211u) % 211u] * 44521u +
            m_perm211[(index / 44521u) % 211u] * 211u +
            m_perm211[(index / 9393931u) % 211u]) * float(0x1.fffffcp-1 / 1982119441u); // Results in [0,1).
}

inline float Halton_sampler::halton223(const unsigned index) const
{
    return (m_perm223[index % 223u] * 11089567u +
            m_perm223[(index / 223u) % 223u] * 49729u +
            m_perm223[(index / 49729u) % 223u] * 223u +
            m_perm223[(index / 11089567u) % 223u]) * float(0x1.fffffcp-1 / 2472973441u); // Results in [0,1).
}

inline float Halton_sampler::halton227(const unsigned index) const
{
    return (m_perm227[index % 227u] * 11697083u +
            m_perm227[(index / 227u) % 227u] * 51529u +
            m_perm227[(index / 51529u) % 227u] * 227u +
            m_perm227[(index / 11697083u) % 227u]) * float(0x1.fffffcp-1 / 2655237841u); // Results in [0,1).
}

inline float Halton_sampler::halton229(const unsigned index) const
{
    return (m_perm229[index % 229u] * 12008989u +
            m_perm229[(index / 229u) % 229u] * 52441u +
            m_perm229[(index / 52441u) % 229u] * 229u +
            m_perm229[(index / 12008989u) % 229u]) * float(0x1.fffffcp-1 / 2750058481u); // Results in [0,1).
}

inline float Halton_sampler::halton233(const unsigned index) const
{
    return (m_perm233[index % 233u] * 12649337u +
            m_perm233[(index / 233u) % 233u] * 54289u +
            m_perm233[(index / 54289u) % 233u] * 233u +
            m_perm233[(index / 12649337u) % 233u]) * float(0x1.fffffcp-1 / 2947295521u); // Results in [0,1).
}

inline float Halton_sampler::halton239(const unsigned index) const
{
    return (m_perm239[index % 239u] * 13651919u +
            m_perm239[(index / 239u) % 239u] * 57121u +
            m_perm239[(index / 57121u) % 239u] * 239u +
            m_perm239[(index / 13651919u) % 239u]) * float(0x1.fffffcp-1 / 3262808641u); // Results in [0,1).
}

inline float Halton_sampler::halton241(const unsigned index) const
{
    return (m_perm241[index % 241u] * 13997521u +
            m_perm241[(index / 241u) % 241u] * 58081u +
            m_perm241[(index / 58081u) % 241u] * 241u +
            m_perm241[(index / 13997521u) % 241u]) * float(0x1.fffffcp-1 / 3373402561u); // Results in [0,1).
}

inline float Halton_sampler::halton251(const unsigned index) const
{
    return (m_perm251[index % 251u] * 15813251u +
            m_perm251[(index / 251u) % 251u] * 63001u +
            m_perm251[(index / 63001u) % 251u] * 251u +
            m_perm251[(index / 15813251u) % 251u]) * float(0x1.fffffcp-1 / 3969126001u); // Results in [0,1).
}

inline float Halton_sampler::halton257(const unsigned index) const
{
    return (m_perm257[index % 257u] * 66049u +
            m_perm257[(index / 257u) % 257u] * 257u +
            m_perm257[(index / 66049u) % 257u]) * float(0x1.fffffcp-1 / 16974593u); // Results in [0,1).
}

inline float Halton_sampler::halton263(const unsigned index) const
{
    return (m_perm263[index % 263u] * 69169u +
            m_perm263[(index / 263u) % 263u] * 263u +
            m_perm263[(index / 69169u) % 263u]) * float(0x1.fffffcp-1 / 18191447u); // Results in [0,1).
}

inline float Halton_sampler::halton269(const unsigned index) const
{
    return (m_perm269[index % 269u] * 72361u +
            m_perm269[(index / 269u) % 269u] * 269u +
            m_perm269[(index / 72361u) % 269u]) * float(0x1.fffffcp-1 / 19465109u); // Results in [0,1).
}

inline float Halton_sampler::halton271(const unsigned index) const
{
    return (m_perm271[index % 271u] * 73441u +
            m_perm271[(index / 271u) % 271u] * 271u +
            m_perm271[(index / 73441u) % 271u]) * float(0x1.fffffcp-1 / 19902511u); // Results in [0,1).
}

inline float Halton_sampler::halton277(const unsigned index) const
{
    return (m_perm277[index % 277u] * 76729u +
            m_perm277[(index / 277u) % 277u] * 277u +
            m_perm277[(index / 76729u) % 277u]) * float(0x1.fffffcp-1 / 21253933u); // Results in [0,1).
}

inline float Halton_sampler::halton281(const unsigned index) const
{
    return (m_perm281[index % 281u] * 78961u +
            m_perm281[(index / 281u) % 281u] * 281u +
            m_perm281[(index / 78961u) % 281u]) * float(0x1.fffffcp-1 / 22188041u); // Results in [0,1).
}

inline float Halton_sampler::halton283(const unsigned index) const
{
    return (m_perm283[index % 283u] * 80089u +
            m_perm283[(index / 283u) % 283u] * 283u +
            m_perm283[(index / 80089u) % 283u]) * float(0x1.fffffcp-1 / 22665187u); // Results in [0,1).
}

inline float Halton_sampler::halton293(const unsigned index) const
{
    return (m_perm293[index % 293u] * 85849u +
            m_perm293[(index / 293u) % 293u] * 293u +
            m_perm293[(index / 85849u) % 293u]) * float(0x1.fffffcp-1 / 25153757u); // Results in [0,1).
}

inline float Halton_sampler::halton307(const unsigned index) const
{
    return (m_perm307[index % 307u] * 94249u +
            m_perm307[(index / 307u) % 307u] * 307u +
            m_perm307[(index / 94249u) % 307u]) * float(0x1.fffffcp-1 / 28934443u); // Results in [0,1).
}

inline float Halton_sampler::halton311(const unsigned index) const
{
    return (m_perm311[index % 311u] * 96721u +
            m_perm311[(index / 311u) % 311u] * 311u +
            m_perm311[(index / 96721u) % 311u]) * float(0x1.fffffcp-1 / 30080231u); // Results in [0,1).
}

inline float Halton_sampler::halton313(const unsigned index) const
{
    return (m_perm313[index % 313u] * 97969u +
            m_perm313[(index / 313u) % 313u] * 313u +
            m_perm313[(index / 97969u) % 313u]) * float(0x1.fffffcp-1 / 30664297u); // Results in [0,1).
}

inline float Halton_sampler::halton317(const unsigned index) const
{
    return (m_perm317[index % 317u] * 100489u +
            m_perm317[(index / 317u) % 317u] * 317u +
            m_perm317[(index / 100489u) % 317u]) * float(0x1.fffffcp-1 / 31855013u); // Results in [0,1).
}

inline float Halton_sampler::halton331(const unsigned index) const
{
    return (m_perm331[index % 331u] * 109561u +
            m_perm331[(index / 331u) % 331u] * 331u +
            m_perm331[(index / 109561u) % 331u]) * float(0x1.fffffcp-1 / 36264691u); // Results in [0,1).
}

inline float Halton_sampler::halton337(const unsigned index) const
{
    return (m_perm337[index % 337u] * 113569u +
            m_perm337[(index / 337u) % 337u] * 337u +
            m_perm337[(index / 113569u) % 337u]) * float(0x1.fffffcp-1 / 38272753u); // Results in [0,1).
}

inline float Halton_sampler::halton347(const unsigned index) const
{
    return (m_perm347[index % 347u] * 120409u +
            m_perm347[(index / 347u) % 347u] * 347u +
            m_perm347[(index / 120409u) % 347u]) * float(0x1.fffffcp-1 / 41781923u); // Results in [0,1).
}

inline float Halton_sampler::halton349(const unsigned index) const
{
    return (m_perm349[index % 349u] * 121801u +
            m_perm349[(index / 349u) % 349u] * 349u +
            m_perm349[(index / 121801u) % 349u]) * float(0x1.fffffcp-1 / 42508549u); // Results in [0,1).
}

inline float Halton_sampler::halton353(const unsigned index) const
{
    return (m_perm353[index % 353u] * 124609u +
            m_perm353[(index / 353u) % 353u] * 353u +
            m_perm353[(index / 124609u) % 353u]) * float(0x1.fffffcp-1 / 43986977u); // Results in [0,1).
}

inline float Halton_sampler::halton359(const unsigned index) const
{
    return (m_perm359[index % 359u] * 128881u +
            m_perm359[(index / 359u) % 359u] * 359u +
            m_perm359[(index / 128881u) % 359u]) * float(0x1.fffffcp-1 / 46268279u); // Results in [0,1).
}

inline float Halton_sampler::halton367(const unsigned index) const
{
    return (m_perm367[index % 367u] * 134689u +
            m_perm367[(index / 367u) % 367u] * 367u +
            m_perm367[(index / 134689u) % 367u]) * float(0x1.fffffcp-1 / 49430863u); // Results in [0,1).
}

inline float Halton_sampler::halton373(const unsigned index) const
{
    return (m_perm373[index % 373u] * 139129u +
            m_perm373[(index / 373u) % 373u] * 373u +
            m_perm373[(index / 139129u) % 373u]) * float(0x1.fffffcp-1 / 51895117u); // Results in [0,1).
}

inline float Halton_sampler::halton379(const unsigned index) const
{
    return (m_perm379[index % 379u] * 143641u +
            m_perm379[(index / 379u) % 379u] * 379u +
            m_perm379[(index / 143641u) % 379u]) * float(0x1.fffffcp-1 / 54439939u); // Results in [0,1).
}

inline float Halton_sampler::halton383(const unsigned index) const
{
    return (m_perm383[index % 383u] * 146689u +
            m_perm383[(index / 383u) % 383u] * 383u +
            m_perm383[(index / 146689u) % 383u]) * float(0x1.fffffcp-1 / 56181887u); // Results in [0,1).
}

inline float Halton_sampler::halton389(const unsigned index) const
{
    return (m_perm389[index % 389u] * 151321u +
            m_perm389[(index / 389u) % 389u] * 389u +
            m_perm389[(index / 151321u) % 389u]) * float(0x1.fffffcp-1 / 58863869u); // Results in [0,1).
}

inline float Halton_sampler::halton397(const unsigned index) const
{
    return (m_perm397[index % 397u] * 157609u +
            m_perm397[(index / 397u) % 397u] * 397u +
            m_perm397[(index / 157609u) % 397u]) * float(0x1.fffffcp-1 / 62570773u); // Results in [0,1).
}

inline float Halton_sampler::halton401(const unsigned index) const
{
    return (m_perm401[index % 401u] * 160801u +
            m_perm401[(index / 401u) % 401u] * 401u +
            m_perm401[(index / 160801u) % 401u]) * float(0x1.fffffcp-1 / 64481201u); // Results in [0,1).
}

inline float Halton_sampler::halton409(const unsigned index) const
{
    return (m_perm409[index % 409u] * 167281u +
            m_perm409[(index / 409u) % 409u] * 409u +
            m_perm409[(index / 167281u) % 409u]) * float(0x1.fffffcp-1 / 68417929u); // Results in [0,1).
}

inline float Halton_sampler::halton419(const unsigned index) const
{
    return (m_perm419[index % 419u] * 175561u +
            m_perm419[(index / 419u) % 419u] * 419u +
            m_perm419[(index / 175561u) % 419u]) * float(0x1.fffffcp-1 / 73560059u); // Results in [0,1).
}

inline float Halton_sampler::halton421(const unsigned index) const
{
    return (m_perm421[index % 421u] * 177241u +
            m_perm421[(index / 421u) % 421u] * 421u +
            m_perm421[(index / 177241u) % 421u]) * float(0x1.fffffcp-1 / 74618461u); // Results in [0,1).
}

inline float Halton_sampler::halton431(const unsigned index) const
{
    return (m_perm431[index % 431u] * 185761u +
            m_perm431[(index / 431u) % 431u] * 431u +
            m_perm431[(index / 185761u) % 431u]) * float(0x1.fffffcp-1 / 80062991u); // Results in [0,1).
}

inline float Halton_sampler::halton433(const unsigned index) const
{
    return (m_perm433[index % 433u] * 187489u +
            m_perm433[(index / 433u) % 433u] * 433u +
            m_perm433[(index / 187489u) % 433u]) * float(0x1.fffffcp-1 / 81182737u); // Results in [0,1).
}

inline float Halton_sampler::halton439(const unsigned index) const
{
    return (m_perm439[index % 439u] * 192721u +
            m_perm439[(index / 439u) % 439u] * 439u +
            m_perm439[(index / 192721u) % 439u]) * float(0x1.fffffcp-1 / 84604519u); // Results in [0,1).
}

inline float Halton_sampler::halton443(const unsigned index) const
{
    return (m_perm443[index % 443u] * 196249u +
            m_perm443[(index / 443u) % 443u] * 443u +
            m_perm443[(index / 196249u) % 443u]) * float(0x1.fffffcp-1 / 86938307u); // Results in [0,1).
}

inline float Halton_sampler::halton449(const unsigned index) const
{
    return (m_perm449[index % 449u] * 201601u +
            m_perm449[(index / 449u) % 449u] * 449u +
            m_perm449[(index / 201601u) % 449u]) * float(0x1.fffffcp-1 / 90518849u); // Results in [0,1).
}

inline float Halton_sampler::halton457(const unsigned index) const
{
    return (m_perm457[index % 457u] * 208849u +
            m_perm457[(index / 457u) % 457u] * 457u +
            m_perm457[(index / 208849u) % 457u]) * float(0x1.fffffcp-1 / 95443993u); // Results in [0,1).
}

inline float Halton_sampler::halton461(const unsigned index) const
{
    return (m_perm461[index % 461u] * 212521u +
            m_perm461[(index / 461u) % 461u] * 461u +
            m_perm461[(index / 212521u) % 461u]) * float(0x1.fffffcp-1 / 97972181u); // Results in [0,1).
}

inline float Halton_sampler::halton463(const unsigned index) const
{
    return (m_perm463[index % 463u] * 214369u +
            m_perm463[(index / 463u) % 463u] * 463u +
            m_perm463[(index / 214369u) % 463u]) * float(0x1.fffffcp-1 / 99252847u); // Results in [0,1).
}

inline float Halton_sampler::halton467(const unsigned index) const
{
    return (m_perm467[index % 467u] * 218089u +
            m_perm467[(index / 467u) % 467u] * 467u +
            m_perm467[(index / 218089u) % 467u]) * float(0x1.fffffcp-1 / 101847563u); // Results in [0,1).
}

inline float Halton_sampler::halton479(const unsigned index) const
{
    return (m_perm479[index % 479u] * 229441u +
            m_perm479[(index / 479u) % 479u] * 479u +
            m_perm479[(index / 229441u) % 479u]) * float(0x1.fffffcp-1 / 109902239u); // Results in [0,1).
}

inline float Halton_sampler::halton487(const unsigned index) const
{
    return (m_perm487[index % 487u] * 237169u +
            m_perm487[(index / 487u) % 487u] * 487u +
            m_perm487[(index / 237169u) % 487u]) * float(0x1.fffffcp-1 / 115501303u); // Results in [0,1).
}

inline float Halton_sampler::halton491(const unsigned index) const
{
    return (m_perm491[index % 491u] * 241081u +
            m_perm491[(index / 491u) % 491u] * 491u +
            m_perm491[(index / 241081u) % 491u]) * float(0x1.fffffcp-1 / 118370771u); // Results in [0,1).
}

inline float Halton_sampler::halton499(const unsigned index) const
{
    return (m_perm499[index % 499u] * 249001u +
            m_perm499[(index / 499u) % 499u] * 499u +
            m_perm499[(index / 249001u) % 499u]) * float(0x1.fffffcp-1 / 124251499u); // Results in [0,1).
}

inline float Halton_sampler::halton503(const unsigned index) const
{
    return (m_perm503[index % 503u] * 253009u +
            m_perm503[(index / 503u) % 503u] * 503u +
            m_perm503[(index / 253009u) % 503u]) * float(0x1.fffffcp-1 / 127263527u); // Results in [0,1).
}

inline float Halton_sampler::halton509(const unsigned index) const
{
    return (m_perm509[index % 509u] * 259081u +
            m_perm509[(index / 509u) % 509u] * 509u +
            m_perm509[(index / 259081u) % 509u]) * float(0x1.fffffcp-1 / 131872229u); // Results in [0,1).
}

inline float Halton_sampler::halton521(const unsigned index) const
{
    return (m_perm521[index % 521u] * 271441u +
            m_perm521[(index / 521u) % 521u] * 521u +
            m_perm521[(index / 271441u) % 521u]) * float(0x1.fffffcp-1 / 141420761u); // Results in [0,1).
}

inline float Halton_sampler::halton523(const unsigned index) const
{
    return (m_perm523[index % 523u] * 273529u +
            m_perm523[(index / 523u) % 523u] * 523u +
            m_perm523[(index / 273529u) % 523u]) * float(0x1.fffffcp-1 / 143055667u); // Results in [0,1).
}

inline float Halton_sampler::halton541(const unsigned index) const
{
    return (m_perm541[index % 541u] * 292681u +
            m_perm541[(index / 541u) % 541u] * 541u +
            m_perm541[(index / 292681u) % 541u]) * float(0x1.fffffcp-1 / 158340421u); // Results in [0,1).
}

inline float Halton_sampler::halton547(const unsigned index) const
{
    return (m_perm547[index % 547u] * 299209u +
            m_perm547[(index / 547u) % 547u] * 547u +
            m_perm547[(index / 299209u) % 547u]) * float(0x1.fffffcp-1 / 163667323u); // Results in [0,1).
}

inline float Halton_sampler::halton557(const unsigned index) const
{
    return (m_perm557[index % 557u] * 310249u +
            m_perm557[(index / 557u) % 557u] * 557u +
            m_perm557[(index / 310249u) % 557u]) * float(0x1.fffffcp-1 / 172808693u); // Results in [0,1).
}

inline float Halton_sampler::halton563(const unsigned index) const
{
    return (m_perm563[index % 563u] * 316969u +
            m_perm563[(index / 563u) % 563u] * 563u +
            m_perm563[(index / 316969u) % 563u]) * float(0x1.fffffcp-1 / 178453547u); // Results in [0,1).
}

inline float Halton_sampler::halton569(const unsigned index) const
{
    return (m_perm569[index % 569u] * 323761u +
            m_perm569[(index / 569u) % 569u] * 569u +
            m_perm569[(index / 323761u) % 569u]) * float(0x1.fffffcp-1 / 184220009u); // Results in [0,1).
}

inline float Halton_sampler::halton571(const unsigned index) const
{
    return (m_perm571[index % 571u] * 326041u +
            m_perm571[(index / 571u) % 571u] * 571u +
            m_perm571[(index / 326041u) % 571u]) * float(0x1.fffffcp-1 / 186169411u); // Results in [0,1).
}

inline float Halton_sampler::halton577(const unsigned index) const
{
    return (m_perm577[index % 577u] * 332929u +
            m_perm577[(index / 577u) % 577u] * 577u +
            m_perm577[(index / 332929u) % 577u]) * float(0x1.fffffcp-1 / 192100033u); // Results in [0,1).
}

inline float Halton_sampler::halton587(const unsigned index) const
{
    return (m_perm587[index % 587u] * 344569u +
            m_perm587[(index / 587u) % 587u] * 587u +
            m_perm587[(index / 344569u) % 587u]) * float(0x1.fffffcp-1 / 202262003u); // Results in [0,1).
}

inline float Halton_sampler::halton593(const unsigned index) const
{
    return (m_perm593[index % 593u] * 351649u +
            m_perm593[(index / 593u) % 593u] * 593u +
            m_perm593[(index / 351649u) % 593u]) * float(0x1.fffffcp-1 / 208527857u); // Results in [0,1).
}

inline float Halton_sampler::halton599(const unsigned index) const
{
    return (m_perm599[index % 599u] * 358801u +
            m_perm599[(index / 599u) % 599u] * 599u +
            m_perm599[(index / 358801u) % 599u]) * float(0x1.fffffcp-1 / 214921799u); // Results in [0,1).
}

inline float Halton_sampler::halton601(const unsigned index) const
{
    return (m_perm601[index % 601u] * 361201u +
            m_perm601[(index / 601u) % 601u] * 601u +
            m_perm601[(index / 361201u) % 601u]) * float(0x1.fffffcp-1 / 217081801u); // Results in [0,1).
}

inline float Halton_sampler::halton607(const unsigned index) const
{
    return (m_perm607[index % 607u] * 368449u +
            m_perm607[(index / 607u) % 607u] * 607u +
            m_perm607[(index / 368449u) % 607u]) * float(0x1.fffffcp-1 / 223648543u); // Results in [0,1).
}

inline float Halton_sampler::halton613(const unsigned index) const
{
    return (m_perm613[index % 613u] * 375769u +
            m_perm613[(index / 613u) % 613u] * 613u +
            m_perm613[(index / 375769u) % 613u]) * float(0x1.fffffcp-1 / 230346397u); // Results in [0,1).
}

inline float Halton_sampler::halton617(const unsigned index) const
{
    return (m_perm617[index % 617u] * 380689u +
            m_perm617[(index / 617u) % 617u] * 617u +
            m_perm617[(index / 380689u) % 617u]) * float(0x1.fffffcp-1 / 234885113u); // Results in [0,1).
}

inline float Halton_sampler::halton619(const unsigned index) const
{
    return (m_perm619[index % 619u] * 383161u +
            m_perm619[(index / 619u) % 619u] * 619u +
            m_perm619[(index / 383161u) % 619u]) * float(0x1.fffffcp-1 / 237176659u); // Results in [0,1).
}

inline float Halton_sampler::halton631(const unsigned index) const
{
    return (m_perm631[index % 631u] * 398161u +
            m_perm631[(index / 631u) % 631u] * 631u +
            m_perm631[(index / 398161u) % 631u]) * float(0x1.fffffcp-1 / 251239591u); // Results in [0,1).
}

inline float Halton_sampler::halton641(const unsigned index) const
{
    return (m_perm641[index % 641u] * 410881u +
            m_perm641[(index / 641u) % 641u] * 641u +
            m_perm641[(index / 410881u) % 641u]) * float(0x1.fffffcp-1 / 263374721u); // Results in [0,1).
}

inline float Halton_sampler::halton643(const unsigned index) const
{
    return (m_perm643[index % 643u] * 413449u +
            m_perm643[(index / 643u) % 643u] * 643u +
            m_perm643[(index / 413449u) % 643u]) * float(0x1.fffffcp-1 / 265847707u); // Results in [0,1).
}

inline float Halton_sampler::halton647(const unsigned index) const
{
    return (m_perm647[index % 647u] * 418609u +
            m_perm647[(index / 647u) % 647u] * 647u +
            m_perm647[(index / 418609u) % 647u]) * float(0x1.fffffcp-1 / 270840023u); // Results in [0,1).
}

inline float Halton_sampler::halton653(const unsigned index) const
{
    return (m_perm653[index % 653u] * 426409u +
            m_perm653[(index / 653u) % 653u] * 653u +
            m_perm653[(index / 426409u) % 653u]) * float(0x1.fffffcp-1 / 278445077u); // Results in [0,1).
}

inline float Halton_sampler::halton659(const unsigned index) const
{
    return (m_perm659[index % 659u] * 434281u +
            m_perm659[(index / 659u) % 659u] * 659u +
            m_perm659[(index / 434281u) % 659u]) * float(0x1.fffffcp-1 / 286191179u); // Results in [0,1).
}

inline float Halton_sampler::halton661(const unsigned index) const
{
    return (m_perm661[index % 661u] * 436921u +
            m_perm661[(index / 661u) % 661u] * 661u +
            m_perm661[(index / 436921u) % 661u]) * float(0x1.fffffcp-1 / 288804781u); // Results in [0,1).
}

inline float Halton_sampler::halton673(const unsigned index) const
{
    return (m_perm673[index % 673u] * 452929u +
            m_perm673[(index / 673u) % 673u] * 673u +
            m_perm673[(index / 452929u) % 673u]) * float(0x1.fffffcp-1 / 304821217u); // Results in [0,1).
}

inline float Halton_sampler::halton677(const unsigned index) const
{
    return (m_perm677[index % 677u] * 458329u +
            m_perm677[(index / 677u) % 677u] * 677u +
            m_perm677[(index / 458329u) % 677u]) * float(0x1.fffffcp-1 / 310288733u); // Results in [0,1).
}

inline float Halton_sampler::halton683(const unsigned index) const
{
    return (m_perm683[index % 683u] * 466489u +
            m_perm683[(index / 683u) % 683u] * 683u +
            m_perm683[(index / 466489u) % 683u]) * float(0x1.fffffcp-1 / 318611987u); // Results in [0,1).
}

inline float Halton_sampler::halton691(const unsigned index) const
{
    return (m_perm691[index % 691u] * 477481u +
            m_perm691[(index / 691u) % 691u] * 691u +
            m_perm691[(index / 477481u) % 691u]) * float(0x1.fffffcp-1 / 329939371u); // Results in [0,1).
}

inline float Halton_sampler::halton701(const unsigned index) const
{
    return (m_perm701[index % 701u] * 491401u +
            m_perm701[(index / 701u) % 701u] * 701u +
            m_perm701[(index / 491401u) % 701u]) * float(0x1.fffffcp-1 / 344472101u); // Results in [0,1).
}

inline float Halton_sampler::halton709(const unsigned index) const
{
    return (m_perm709[index % 709u] * 502681u +
            m_perm709[(index / 709u) % 709u] * 709u +
            m_perm709[(index / 502681u) % 709u]) * float(0x1.fffffcp-1 / 356400829u); // Results in [0,1).
}

inline float Halton_sampler::halton719(const unsigned index) const
{
    return (m_perm719[index % 719u] * 516961u +
            m_perm719[(index / 719u) % 719u] * 719u +
            m_perm719[(index / 516961u) % 719u]) * float(0x1.fffffcp-1 / 371694959u); // Results in [0,1).
}

inline float Halton_sampler::halton727(const unsigned index) const
{
    return (m_perm727[index % 727u] * 528529u +
            m_perm727[(index / 727u) % 727u] * 727u +
            m_perm727[(index / 528529u) % 727u]) * float(0x1.fffffcp-1 / 384240583u); // Results in [0,1).
}

inline float Halton_sampler::halton733(const unsigned index) const
{
    return (m_perm733[index % 733u] * 537289u +
            m_perm733[(index / 733u) % 733u] * 733u +
            m_perm733[(index / 537289u) % 733u]) * float(0x1.fffffcp-1 / 393832837u); // Results in [0,1).
}

inline float Halton_sampler::halton739(const unsigned index) const
{
    return (m_perm739[index % 739u] * 546121u +
            m_perm739[(index / 739u) % 739u] * 739u +
            m_perm739[(index / 546121u) % 739u]) * float(0x1.fffffcp-1 / 403583419u); // Results in [0,1).
}

inline float Halton_sampler::halton743(const unsigned index) const
{
    return (m_perm743[index % 743u] * 552049u +
            m_perm743[(index / 743u) % 743u] * 743u +
            m_perm743[(index / 552049u) % 743u]) * float(0x1.fffffcp-1 / 410172407u); // Results in [0,1).
}

inline float Halton_sampler::halton751(const unsigned index) const
{
    return (m_perm751[index % 751u] * 564001u +
            m_perm751[(index / 751u) % 751u] * 751u +
            m_perm751[(index / 564001u) % 751u]) * float(0x1.fffffcp-1 / 423564751u); // Results in [0,1).
}

inline float Halton_sampler::halton757(const unsigned index) const
{
    return (m_perm757[index % 757u] * 573049u +
            m_perm757[(index / 757u) % 757u] * 757u +
            m_perm757[(index / 573049u) % 757u]) * float(0x1.fffffcp-1 / 433798093u); // Results in [0,1).
}

inline float Halton_sampler::halton761(const unsigned index) const
{
    return (m_perm761[index % 761u] * 579121u +
            m_perm761[(index / 761u) % 761u] * 761u +
            m_perm761[(index / 579121u) % 761u]) * float(0x1.fffffcp-1 / 440711081u); // Results in [0,1).
}

inline float Halton_sampler::halton769(const unsigned index) const
{
    return (m_perm769[index % 769u] * 591361u +
            m_perm769[(index / 769u) % 769u] * 769u +
            m_perm769[(index / 591361u) % 769u]) * float(0x1.fffffcp-1 / 454756609u); // Results in [0,1).
}

inline float Halton_sampler::halton773(const unsigned index) const
{
    return (m_perm773[index % 773u] * 597529u +
            m_perm773[(index / 773u) % 773u] * 773u +
            m_perm773[(index / 597529u) % 773u]) * float(0x1.fffffcp-1 / 461889917u); // Results in [0,1).
}

inline float Halton_sampler::halton787(const unsigned index) const
{
    return (m_perm787[index % 787u] * 619369u +
            m_perm787[(index / 787u) % 787u] * 787u +
            m_perm787[(index / 619369u) % 787u]) * float(0x1.fffffcp-1 / 487443403u); // Results in [0,1).
}

inline float Halton_sampler::halton797(const unsigned index) const
{
    return (m_perm797[index % 797u] * 635209u +
            m_perm797[(index / 797u) % 797u] * 797u +
            m_perm797[(index / 635209u) % 797u]) * float(0x1.fffffcp-1 / 506261573u); // Results in [0,1).
}

inline float Halton_sampler::halton809(const unsigned index) const
{
    return (m_perm809[index % 809u] * 654481u +
            m_perm809[(index / 809u) % 809u] * 809u +
            m_perm809[(index / 654481u) % 809u]) * float(0x1.fffffcp-1 / 529475129u); // Results in [0,1).
}

inline float Halton_sampler::halton811(const unsigned index) const
{
    return (m_perm811[index % 811u] * 657721u +
            m_perm811[(index / 811u) % 811u] * 811u +
            m_perm811[(index / 657721u) % 811u]) * float(0x1.fffffcp-1 / 533411731u); // Results in [0,1).
}

inline float Halton_sampler::halton821(const unsigned index) const
{
    return (m_perm821[index % 821u] * 674041u +
            m_perm821[(index / 821u) % 821u] * 821u +
            m_perm821[(index / 674041u) % 821u]) * float(0x1.fffffcp-1 / 553387661u); // Results in [0,1).
}

inline float Halton_sampler::halton823(const unsigned index) const
{
    return (m_perm823[index % 823u] * 677329u +
            m_perm823[(index / 823u) % 823u] * 823u +
            m_perm823[(index / 677329u) % 823u]) * float(0x1.fffffcp-1 / 557441767u); // Results in [0,1).
}

inline float Halton_sampler::halton827(const unsigned index) const
{
    return (m_perm827[index % 827u] * 683929u +
            m_perm827[(index / 827u) % 827u] * 827u +
            m_perm827[(index / 683929u) % 827u]) * float(0x1.fffffcp-1 / 565609283u); // Results in [0,1).
}

inline float Halton_sampler::halton829(const unsigned index) const
{
    return (m_perm829[index % 829u] * 687241u +
            m_perm829[(index / 829u) % 829u] * 829u +
            m_perm829[(index / 687241u) % 829u]) * float(0x1.fffffcp-1 / 569722789u); // Results in [0,1).
}

inline float Halton_sampler::halton839(const unsigned index) const
{
    return (m_perm839[index % 839u] * 703921u +
            m_perm839[(index / 839u) % 839u] * 839u +
            m_perm839[(index / 703921u) % 839u]) * float(0x1.fffffcp-1 / 590589719u); // Results in [0,1).
}

inline float Halton_sampler::halton853(const unsigned index) const
{
    return (m_perm853[index % 853u] * 727609u +
            m_perm853[(index / 853u) % 853u] * 853u +
            m_perm853[(index / 727609u) % 853u]) * float(0x1.fffffcp-1 / 620650477u); // Results in [0,1).
}

inline float Halton_sampler::halton857(const unsigned index) const
{
    return (m_perm857[index % 857u] * 734449u +
            m_perm857[(index / 857u) % 857u] * 857u +
            m_perm857[(index / 734449u) % 857u]) * float(0x1.fffffcp-1 / 629422793u); // Results in [0,1).
}

inline float Halton_sampler::halton859(const unsigned index) const
{
    return (m_perm859[index % 859u] * 737881u +
            m_perm859[(index / 859u) % 859u] * 859u +
            m_perm859[(index / 737881u) % 859u]) * float(0x1.fffffcp-1 / 633839779u); // Results in [0,1).
}

inline float Halton_sampler::halton863(const unsigned index) const
{
    return (m_perm863[index % 863u] * 744769u +
            m_perm863[(index / 863u) % 863u] * 863u +
            m_perm863[(index / 744769u) % 863u]) * float(0x1.fffffcp-1 / 642735647u); // Results in [0,1).
}

inline float Halton_sampler::halton877(const unsigned index) const
{
    return (m_perm877[index % 877u] * 769129u +
            m_perm877[(index / 877u) % 877u] * 877u +
            m_perm877[(index / 769129u) % 877u]) * float(0x1.fffffcp-1 / 674526133u); // Results in [0,1).
}

inline float Halton_sampler::halton881(const unsigned index) const
{
    return (m_perm881[index % 881u] * 776161u +
            m_perm881[(index / 881u) % 881u] * 881u +
            m_perm881[(index / 776161u) % 881u]) * float(0x1.fffffcp-1 / 683797841u); // Results in [0,1).
}

inline float Halton_sampler::halton883(const unsigned index) const
{
    return (m_perm883[index % 883u] * 779689u +
            m_perm883[(index / 883u) % 883u] * 883u +
            m_perm883[(index / 779689u) % 883u]) * float(0x1.fffffcp-1 / 688465387u); // Results in [0,1).
}

inline float Halton_sampler::halton887(const unsigned index) const
{
    return (m_perm887[index % 887u] * 786769u +
            m_perm887[(index / 887u) % 887u] * 887u +
            m_perm887[(index / 786769u) % 887u]) * float(0x1.fffffcp-1 / 697864103u); // Results in [0,1).
}

inline float Halton_sampler::halton907(const unsigned index) const
{
    return (m_perm907[index % 907u] * 822649u +
            m_perm907[(index / 907u) % 907u] * 907u +
            m_perm907[(index / 822649u) % 907u]) * float(0x1.fffffcp-1 / 746142643u); // Results in [0,1).
}

inline float Halton_sampler::halton911(const unsigned index) const
{
    return (m_perm911[index % 911u] * 829921u +
            m_perm911[(index / 911u) % 911u] * 911u +
            m_perm911[(index / 829921u) % 911u]) * float(0x1.fffffcp-1 / 756058031u); // Results in [0,1).
}

inline float Halton_sampler::halton919(const unsigned index) const
{
    return (m_perm919[index % 919u] * 844561u +
            m_perm919[(index / 919u) % 919u] * 919u +
            m_perm919[(index / 844561u) % 919u]) * float(0x1.fffffcp-1 / 776151559u); // Results in [0,1).
}

inline float Halton_sampler::halton929(const unsigned index) const
{
    return (m_perm929[index % 929u] * 863041u +
            m_perm929[(index / 929u) % 929u] * 929u +
            m_perm929[(index / 863041u) % 929u]) * float(0x1.fffffcp-1 / 801765089u); // Results in [0,1).
}

inline float Halton_sampler::halton937(const unsigned index) const
{
    return (m_perm937[index % 937u] * 877969u +
            m_perm937[(index / 937u) % 937u] * 937u +
            m_perm937[(index / 877969u) % 937u]) * float(0x1.fffffcp-1 / 822656953u); // Results in [0,1).
}

inline float Halton_sampler::halton941(const unsigned index) const
{
    return (m_perm941[index % 941u] * 885481u +
            m_perm941[(index / 941u) % 941u] * 941u +
            m_perm941[(index / 885481u) % 941u]) * float(0x1.fffffcp-1 / 833237621u); // Results in [0,1).
}

inline float Halton_sampler::halton947(const unsigned index) const
{
    return (m_perm947[index % 947u] * 896809u +
            m_perm947[(index / 947u) % 947u] * 947u +
            m_perm947[(index / 896809u) % 947u]) * float(0x1.fffffcp-1 / 849278123u); // Results in [0,1).
}

inline float Halton_sampler::halton953(const unsigned index) const
{
    return (m_perm953[index % 953u] * 908209u +
            m_perm953[(index / 953u) % 953u] * 953u +
            m_perm953[(index / 908209u) % 953u]) * float(0x1.fffffcp-1 / 865523177u); // Results in [0,1).
}

inline float Halton_sampler::halton967(const unsigned index) const
{
    return (m_perm967[index % 967u] * 935089u +
            m_perm967[(index / 967u) % 967u] * 967u +
            m_perm967[(index / 935089u) % 967u]) * float(0x1.fffffcp-1 / 904231063u); // Results in [0,1).
}

inline float Halton_sampler::halton971(const unsigned index) const
{
    return (m_perm971[index % 971u] * 942841u +
            m_perm971[(index / 971u) % 971u] * 971u +
            m_perm971[(index / 942841u) % 971u]) * float(0x1.fffffcp-1 / 915498611u); // Results in [0,1).
}

inline float Halton_sampler::halton977(const unsigned index) const
{
    return (m_perm977[index % 977u] * 954529u +
            m_perm977[(index / 977u) % 977u] * 977u +
            m_perm977[(index / 954529u) % 977u]) * float(0x1.fffffcp-1 / 932574833u); // Results in [0,1).
}

inline float Halton_sampler::halton983(const unsigned index) const
{
    return (m_perm983[index % 983u] * 966289u +
            m_perm983[(index / 983u) % 983u] * 983u +
            m_perm983[(index / 966289u) % 983u]) * float(0x1.fffffcp-1 / 949862087u); // Results in [0,1).
}

inline float Halton_sampler::halton991(const unsigned index) const
{
    return (m_perm991[index % 991u] * 982081u +
            m_perm991[(index / 991u) % 991u] * 991u +
            m_perm991[(index / 982081u) % 991u]) * float(0x1.fffffcp-1 / 973242271u); // Results in [0,1).
}

inline float Halton_sampler::halton997(const unsigned index) const
{
    return (m_perm997[index % 997u] * 994009u +
            m_perm997[(index / 997u) % 997u] * 997u +
            m_perm997[(index / 994009u) % 997u]) * float(0x1.fffffcp-1 / 991026973u); // Results in [0,1).
}

inline float Halton_sampler::halton1009(const unsigned index) const
{
    return (m_perm1009[index % 1009u] * 1018081u +
            m_perm1009[(index / 1009u) % 1009u] * 1009u +
            m_perm1009[(index / 1018081u) % 1009u]) * float(0x1.fffffcp-1 / 1027243729u); // Results in [0,1).
}

inline float Halton_sampler::halton1013(const unsigned index) const
{
    return (m_perm1013[index % 1013u] * 1026169u +
            m_perm1013[(index / 1013u) % 1013u] * 1013u +
            m_perm1013[(index / 1026169u) % 1013u]) * float(0x1.fffffcp-1 / 1039509197u); // Results in [0,1).
}

inline float Halton_sampler::halton1019(const unsigned index) const
{
    return (m_perm1019[index % 1019u] * 1038361u +
            m_perm1019[(index / 1019u) % 1019u] * 1019u +
            m_perm1019[(index / 1038361u) % 1019u]) * float(0x1.fffffcp-1 / 1058089859u); // Results in [0,1).
}

inline float Halton_sampler::halton1021(const unsigned index) const
{
    return (m_perm1021[index % 1021u] * 1042441u +
            m_perm1021[(index / 1021u) % 1021u] * 1021u +
            m_perm1021[(index / 1042441u) % 1021u]) * float(0x1.fffffcp-1 / 1064332261u); // Results in [0,1).
}

inline float Halton_sampler::halton1031(const unsigned index) const
{
    return (m_perm1031[index % 1031u] * 1062961u +
            m_perm1031[(index / 1031u) % 1031u] * 1031u +
            m_perm1031[(index / 1062961u) % 1031u]) * float(0x1.fffffcp-1 / 1095912791u); // Results in [0,1).
}

inline float Halton_sampler::halton1033(const unsigned index) const
{
    return (m_perm1033[index % 1033u] * 1067089u +
            m_perm1033[(index / 1033u) % 1033u] * 1033u +
            m_perm1033[(index / 1067089u) % 1033u]) * float(0x1.fffffcp-1 / 1102302937u); // Results in [0,1).
}

inline float Halton_sampler::halton1039(const unsigned index) const
{
    return (m_perm1039[index % 1039u] * 1079521u +
            m_perm1039[(index / 1039u) % 1039u] * 1039u +
            m_perm1039[(index / 1079521u) % 1039u]) * float(0x1.fffffcp-1 / 1121622319u); // Results in [0,1).
}

inline float Halton_sampler::halton1049(const unsigned index) const
{
    return (m_perm1049[index % 1049u] * 1100401u +
            m_perm1049[(index / 1049u) % 1049u] * 1049u +
            m_perm1049[(index / 1100401u) % 1049u]) * float(0x1.fffffcp-1 / 1154320649u); // Results in [0,1).
}

inline float Halton_sampler::halton1051(const unsigned index) const
{
    return (m_perm1051[index % 1051u] * 1104601u +
            m_perm1051[(index / 1051u) % 1051u] * 1051u +
            m_perm1051[(index / 1104601u) % 1051u]) * float(0x1.fffffcp-1 / 1160935651u); // Results in [0,1).
}

inline float Halton_sampler::halton1061(const unsigned index) const
{
    return (m_perm1061[index % 1061u] * 1125721u +
            m_perm1061[(index / 1061u) % 1061u] * 1061u +
            m_perm1061[(index / 1125721u) % 1061u]) * float(0x1.fffffcp-1 / 1194389981u); // Results in [0,1).
}

inline float Halton_sampler::halton1063(const unsigned index) const
{
    return (m_perm1063[index % 1063u] * 1129969u +
            m_perm1063[(index / 1063u) % 1063u] * 1063u +
            m_perm1063[(index / 1129969u) % 1063u]) * float(0x1.fffffcp-1 / 1201157047u); // Results in [0,1).
}

inline float Halton_sampler::halton1069(const unsigned index) const
{
    return (m_perm1069[index % 1069u] * 1142761u +
            m_perm1069[(index / 1069u) % 1069u] * 1069u +
            m_perm1069[(index / 1142761u) % 1069u]) * float(0x1.fffffcp-1 / 1221611509u); // Results in [0,1).
}

inline float Halton_sampler::halton1087(const unsigned index) const
{
    return (m_perm1087[index % 1087u] * 1181569u +
            m_perm1087[(index / 1087u) % 1087u] * 1087u +
            m_perm1087[(index / 1181569u) % 1087u]) * float(0x1.fffffcp-1 / 1284365503u); // Results in [0,1).
}

inline float Halton_sampler::halton1091(const unsigned index) const
{
    return (m_perm1091[index % 1091u] * 1190281u +
            m_perm1091[(index / 1091u) % 1091u] * 1091u +
            m_perm1091[(index / 1190281u) % 1091u]) * float(0x1.fffffcp-1 / 1298596571u); // Results in [0,1).
}

inline float Halton_sampler::halton1093(const unsigned index) const
{
    return (m_perm1093[index % 1093u] * 1194649u +
            m_perm1093[(index / 1093u) % 1093u] * 1093u +
            m_perm1093[(index / 1194649u) % 1093u]) * float(0x1.fffffcp-1 / 1305751357u); // Results in [0,1).
}

inline float Halton_sampler::halton1097(const unsigned index) const
{
    return (m_perm1097[index % 1097u] * 1203409u +
            m_perm1097[(index / 1097u) % 1097u] * 1097u +
            m_perm1097[(index / 1203409u) % 1097u]) * float(0x1.fffffcp-1 / 1320139673u); // Results in [0,1).
}

inline float Halton_sampler::halton1103(const unsigned index) const
{
    return (m_perm1103[index % 1103u] * 1216609u +
            m_perm1103[(index / 1103u) % 1103u] * 1103u +
            m_perm1103[(index / 1216609u) % 1103u]) * float(0x1.fffffcp-1 / 1341919727u); // Results in [0,1).
}

inline float Halton_sampler::halton1109(const unsigned index) const
{
    return (m_perm1109[index % 1109u] * 1229881u +
            m_perm1109[(index / 1109u) % 1109u] * 1109u +
            m_perm1109[(index / 1229881u) % 1109u]) * float(0x1.fffffcp-1 / 1363938029u); // Results in [0,1).
}

inline float Halton_sampler::halton1117(const unsigned index) const
{
    return (m_perm1117[index % 1117u] * 1247689u +
            m_perm1117[(index / 1117u) % 1117u] * 1117u +
            m_perm1117[(index / 1247689u) % 1117u]) * float(0x1.fffffcp-1 / 1393668613u); // Results in [0,1).
}

inline float Halton_sampler::halton1123(const unsigned index) const
{
    return (m_perm1123[index % 1123u] * 1261129u +
            m_perm1123[(index / 1123u) % 1123u] * 1123u +
            m_perm1123[(index / 1261129u) % 1123u]) * float(0x1.fffffcp-1 / 1416247867u); // Results in [0,1).
}

inline float Halton_sampler::halton1129(const unsigned index) const
{
    return (m_perm1129[index % 1129u] * 1274641u +
            m_perm1129[(index / 1129u) % 1129u] * 1129u +
            m_perm1129[(index / 1274641u) % 1129u]) * float(0x1.fffffcp-1 / 1439069689u); // Results in [0,1).
}

inline float Halton_sampler::halton1151(const unsigned index) const
{
    return (m_perm1151[index % 1151u] * 1324801u +
            m_perm1151[(index / 1151u) % 1151u] * 1151u +
            m_perm1151[(index / 1324801u) % 1151u]) * float(0x1.fffffcp-1 / 1524845951u); // Results in [0,1).
}

inline float Halton_sampler::halton1153(const unsigned index) const
{
    return (m_perm1153[index % 1153u] * 1329409u +
            m_perm1153[(index / 1153u) % 1153u] * 1153u +
            m_perm1153[(index / 1329409u) % 1153u]) * float(0x1.fffffcp-1 / 1532808577u); // Results in [0,1).
}

inline float Halton_sampler::halton1163(const unsigned index) const
{
    return (m_perm1163[index % 1163u] * 1352569u +
            m_perm1163[(index / 1163u) % 1163u] * 1163u +
            m_perm1163[(index / 1352569u) % 1163u]) * float(0x1.fffffcp-1 / 1573037747u); // Results in [0,1).
}

inline float Halton_sampler::halton1171(const unsigned index) const
{
    return (m_perm1171[index % 1171u] * 1371241u +
            m_perm1171[(index / 1171u) % 1171u] * 1171u +
            m_perm1171[(index / 1371241u) % 1171u]) * float(0x1.fffffcp-1 / 1605723211u); // Results in [0,1).
}

inline float Halton_sampler::halton1181(const unsigned index) const
{
    return (m_perm1181[index % 1181u] * 1394761u +
            m_perm1181[(index / 1181u) % 1181u] * 1181u +
            m_perm1181[(index / 1394761u) % 1181u]) * float(0x1.fffffcp-1 / 1647212741u); // Results in [0,1).
}

inline float Halton_sampler::halton1187(const unsigned index) const
{
    return (m_perm1187[index % 1187u] * 1408969u +
            m_perm1187[(index / 1187u) % 1187u] * 1187u +
            m_perm1187[(index / 1408969u) % 1187u]) * float(0x1.fffffcp-1 / 1672446203u); // Results in [0,1).
}

inline float Halton_sampler::halton1193(const unsigned index) const
{
    return (m_perm1193[index % 1193u] * 1423249u +
            m_perm1193[(index / 1193u) % 1193u] * 1193u +
            m_perm1193[(index / 1423249u) % 1193u]) * float(0x1.fffffcp-1 / 1697936057u); // Results in [0,1).
}

inline float Halton_sampler::halton1201(const unsigned index) const
{
    return (m_perm1201[index % 1201u] * 1442401u +
            m_perm1201[(index / 1201u) % 1201u] * 1201u +
            m_perm1201[(index / 1442401u) % 1201u]) * float(0x1.fffffcp-1 / 1732323601u); // Results in [0,1).
}

inline float Halton_sampler::halton1213(const unsigned index) const
{
    return (m_perm1213[index % 1213u] * 1471369u +
            m_perm1213[(index / 1213u) % 1213u] * 1213u +
            m_perm1213[(index / 1471369u) % 1213u]) * float(0x1.fffffcp-1 / 1784770597u); // Results in [0,1).
}

inline float Halton_sampler::halton1217(const unsigned index) const
{
    return (m_perm1217[index % 1217u] * 1481089u +
            m_perm1217[(index / 1217u) % 1217u] * 1217u +
            m_perm1217[(index / 1481089u) % 1217u]) * float(0x1.fffffcp-1 / 1802485313u); // Results in [0,1).
}

inline float Halton_sampler::halton1223(const unsigned index) const
{
    return (m_perm1223[index % 1223u] * 1495729u +
            m_perm1223[(index / 1223u) % 1223u] * 1223u +
            m_perm1223[(index / 1495729u) % 1223u]) * float(0x1.fffffcp-1 / 1829276567u); // Results in [0,1).
}

inline float Halton_sampler::halton1229(const unsigned index) const
{
    return (m_perm1229[index % 1229u] * 1510441u +
            m_perm1229[(index / 1229u) % 1229u] * 1229u +
            m_perm1229[(index / 1510441u) % 1229u]) * float(0x1.fffffcp-1 / 1856331989u); // Results in [0,1).
}

inline float Halton_sampler::halton1231(const unsigned index) const
{
    return (m_perm1231[index % 1231u] * 1515361u +
            m_perm1231[(index / 1231u) % 1231u] * 1231u +
            m_perm1231[(index / 1515361u) % 1231u]) * float(0x1.fffffcp-1 / 1865409391u); // Results in [0,1).
}

inline float Halton_sampler::halton1237(const unsigned index) const
{
    return (m_perm1237[index % 1237u] * 1530169u +
            m_perm1237[(index / 1237u) % 1237u] * 1237u +
            m_perm1237[(index / 1530169u) % 1237u]) * float(0x1.fffffcp-1 / 1892819053u); // Results in [0,1).
}

inline float Halton_sampler::halton1249(const unsigned index) const
{
    return (m_perm1249[index % 1249u] * 1560001u +
            m_perm1249[(index / 1249u) % 1249u] * 1249u +
            m_perm1249[(index / 1560001u) % 1249u]) * float(0x1.fffffcp-1 / 1948441249u); // Results in [0,1).
}

inline float Halton_sampler::halton1259(const unsigned index) const
{
    return (m_perm1259[index % 1259u] * 1585081u +
            m_perm1259[(index / 1259u) % 1259u] * 1259u +
            m_perm1259[(index / 1585081u) % 1259u]) * float(0x1.fffffcp-1 / 1995616979u); // Results in [0,1).
}

inline float Halton_sampler::halton1277(const unsigned index) const
{
    return (m_perm1277[index % 1277u] * 1630729u +
            m_perm1277[(index / 1277u) % 1277u] * 1277u +
            m_perm1277[(index / 1630729u) % 1277u]) * float(0x1.fffffcp-1 / 2082440933u); // Results in [0,1).
}

inline float Halton_sampler::halton1279(const unsigned index) const
{
    return (m_perm1279[index % 1279u] * 1635841u +
            m_perm1279[(index / 1279u) % 1279u] * 1279u +
            m_perm1279[(index / 1635841u) % 1279u]) * float(0x1.fffffcp-1 / 2092240639u); // Results in [0,1).
}

inline float Halton_sampler::halton1283(const unsigned index) const
{
    return (m_perm1283[index % 1283u] * 1646089u +
            m_perm1283[(index / 1283u) % 1283u] * 1283u +
            m_perm1283[(index / 1646089u) % 1283u]) * float(0x1.fffffcp-1 / 2111932187u); // Results in [0,1).
}

inline float Halton_sampler::halton1289(const unsigned index) const
{
    return (m_perm1289[index % 1289u] * 1661521u +
            m_perm1289[(index / 1289u) % 1289u] * 1289u +
            m_perm1289[(index / 1661521u) % 1289u]) * float(0x1.fffffcp-1 / 2141700569u); // Results in [0,1).
}

inline float Halton_sampler::halton1291(const unsigned index) const
{
    return (m_perm1291[index % 1291u] * 1666681u +
            m_perm1291[(index / 1291u) % 1291u] * 1291u +
            m_perm1291[(index / 1666681u) % 1291u]) * float(0x1.fffffcp-1 / 2151685171u); // Results in [0,1).
}

inline float Halton_sampler::halton1297(const unsigned index) const
{
    return (m_perm1297[index % 1297u] * 1682209u +
            m_perm1297[(index / 1297u) % 1297u] * 1297u +
            m_perm1297[(index / 1682209u) % 1297u]) * float(0x1.fffffcp-1 / 2181825073u); // Results in [0,1).
}

inline float Halton_sampler::halton1301(const unsigned index) const
{
    return (m_perm1301[index % 1301u] * 1692601u +
            m_perm1301[(index / 1301u) % 1301u] * 1301u +
            m_perm1301[(index / 1692601u) % 1301u]) * float(0x1.fffffcp-1 / 2202073901u); // Results in [0,1).
}

inline float Halton_sampler::halton1303(const unsigned index) const
{
    return (m_perm1303[index % 1303u] * 1697809u +
            m_perm1303[(index / 1303u) % 1303u] * 1303u +
            m_perm1303[(index / 1697809u) % 1303u]) * float(0x1.fffffcp-1 / 2212245127u); // Results in [0,1).
}

inline float Halton_sampler::halton1307(const unsigned index) const
{
    return (m_perm1307[index % 1307u] * 1708249u +
            m_perm1307[(index / 1307u) % 1307u] * 1307u +
            m_perm1307[(index / 1708249u) % 1307u]) * float(0x1.fffffcp-1 / 2232681443u); // Results in [0,1).
}

inline float Halton_sampler::halton1319(const unsigned index) const
{
    return (m_perm1319[index % 1319u] * 1739761u +
            m_perm1319[(index / 1319u) % 1319u] * 1319u +
            m_perm1319[(index / 1739761u) % 1319u]) * float(0x1.fffffcp-1 / 2294744759u); // Results in [0,1).
}

inline float Halton_sampler::halton1321(const unsigned index) const
{
    return (m_perm1321[index % 1321u] * 1745041u +
            m_perm1321[(index / 1321u) % 1321u] * 1321u +
            m_perm1321[(index / 1745041u) % 1321u]) * float(0x1.fffffcp-1 / 2305199161u); // Results in [0,1).
}

inline float Halton_sampler::halton1327(const unsigned index) const
{
    return (m_perm1327[index % 1327u] * 1760929u +
            m_perm1327[(index / 1327u) % 1327u] * 1327u +
            m_perm1327[(index / 1760929u) % 1327u]) * float(0x1.fffffcp-1 / 2336752783u); // Results in [0,1).
}

inline float Halton_sampler::halton1361(const unsigned index) const
{
    return (m_perm1361[index % 1361u] * 1852321u +
            m_perm1361[(index / 1361u) % 1361u] * 1361u +
            m_perm1361[(index / 1852321u) % 1361u]) * float(0x1.fffffcp-1 / 2521008881u); // Results in [0,1).
}

inline float Halton_sampler::halton1367(const unsigned index) const
{
    return (m_perm1367[index % 1367u] * 1868689u +
            m_perm1367[(index / 1367u) % 1367u] * 1367u +
            m_perm1367[(index / 1868689u) % 1367u]) * float(0x1.fffffcp-1 / 2554497863u); // Results in [0,1).
}

inline float Halton_sampler::halton1373(const unsigned index) const
{
    return (m_perm1373[index % 1373u] * 1885129u +
            m_perm1373[(index / 1373u) % 1373u] * 1373u +
            m_perm1373[(index / 1885129u) % 1373u]) * float(0x1.fffffcp-1 / 2588282117u); // Results in [0,1).
}

inline float Halton_sampler::halton1381(const unsigned index) const
{
    return (m_perm1381[index % 1381u] * 1907161u +
            m_perm1381[(index / 1381u) % 1381u] * 1381u +
            m_perm1381[(index / 1907161u) % 1381u]) * float(0x1.fffffcp-1 / 2633789341u); // Results in [0,1).
}

inline float Halton_sampler::halton1399(const unsigned index) const
{
    return (m_perm1399[index % 1399u] * 1957201u +
            m_perm1399[(index / 1399u) % 1399u] * 1399u +
            m_perm1399[(index / 1957201u) % 1399u]) * float(0x1.fffffcp-1 / 2738124199u); // Results in [0,1).
}

inline float Halton_sampler::halton1409(const unsigned index) const
{
    return (m_perm1409[index % 1409u] * 1985281u +
            m_perm1409[(index / 1409u) % 1409u] * 1409u +
            m_perm1409[(index / 1985281u) % 1409u]) * float(0x1.fffffcp-1 / 2797260929u); // Results in [0,1).
}

inline float Halton_sampler::halton1423(const unsigned index) const
{
    return (m_perm1423[index % 1423u] * 2024929u +
            m_perm1423[(index / 1423u) % 1423u] * 1423u +
            m_perm1423[(index / 2024929u) % 1423u]) * float(0x1.fffffcp-1 / 2881473967u); // Results in [0,1).
}

inline float Halton_sampler::halton1427(const unsigned index) const
{
    return (m_perm1427[index % 1427u] * 2036329u +
            m_perm1427[(index / 1427u) % 1427u] * 1427u +
            m_perm1427[(index / 2036329u) % 1427u]) * float(0x1.fffffcp-1 / 2905841483u); // Results in [0,1).
}

inline float Halton_sampler::halton1429(const unsigned index) const
{
    return (m_perm1429[index % 1429u] * 2042041u +
            m_perm1429[(index / 1429u) % 1429u] * 1429u +
            m_perm1429[(index / 2042041u) % 1429u]) * float(0x1.fffffcp-1 / 2918076589u); // Results in [0,1).
}

inline float Halton_sampler::halton1433(const unsigned index) const
{
    return (m_perm1433[index % 1433u] * 2053489u +
            m_perm1433[(index / 1433u) % 1433u] * 1433u +
            m_perm1433[(index / 2053489u) % 1433u]) * float(0x1.fffffcp-1 / 2942649737u); // Results in [0,1).
}

inline float Halton_sampler::halton1439(const unsigned index) const
{
    return (m_perm1439[index % 1439u] * 2070721u +
            m_perm1439[(index / 1439u) % 1439u] * 1439u +
            m_perm1439[(index / 2070721u) % 1439u]) * float(0x1.fffffcp-1 / 2979767519u); // Results in [0,1).
}

inline float Halton_sampler::halton1447(const unsigned index) const
{
    return (m_perm1447[index % 1447u] * 2093809u +
            m_perm1447[(index / 1447u) % 1447u] * 1447u +
            m_perm1447[(index / 2093809u) % 1447u]) * float(0x1.fffffcp-1 / 3029741623u); // Results in [0,1).
}

inline float Halton_sampler::halton1451(const unsigned index) const
{
    return (m_perm1451[index % 1451u] * 2105401u +
            m_perm1451[(index / 1451u) % 1451u] * 1451u +
            m_perm1451[(index / 2105401u) % 1451u]) * float(0x1.fffffcp-1 / 3054936851u); // Results in [0,1).
}

inline float Halton_sampler::halton1453(const unsigned index) const
{
    return (m_perm1453[index % 1453u] * 2111209u +
            m_perm1453[(index / 1453u) % 1453u] * 1453u +
            m_perm1453[(index / 2111209u) % 1453u]) * float(0x1.fffffcp-1 / 3067586677u); // Results in [0,1).
}

inline float Halton_sampler::halton1459(const unsigned index) const
{
    return (m_perm1459[index % 1459u] * 2128681u +
            m_perm1459[(index / 1459u) % 1459u] * 1459u +
            m_perm1459[(index / 2128681u) % 1459u]) * float(0x1.fffffcp-1 / 3105745579u); // Results in [0,1).
}

inline float Halton_sampler::halton1471(const unsigned index) const
{
    return (m_perm1471[index % 1471u] * 2163841u +
            m_perm1471[(index / 1471u) % 1471u] * 1471u +
            m_perm1471[(index / 2163841u) % 1471u]) * float(0x1.fffffcp-1 / 3183010111u); // Results in [0,1).
}

inline float Halton_sampler::halton1481(const unsigned index) const
{
    return (m_perm1481[index % 1481u] * 2193361u +
            m_perm1481[(index / 1481u) % 1481u] * 1481u +
            m_perm1481[(index / 2193361u) % 1481u]) * float(0x1.fffffcp-1 / 3248367641u); // Results in [0,1).
}

inline float Halton_sampler::halton1483(const unsigned index) const
{
    return (m_perm1483[index % 1483u] * 2199289u +
            m_perm1483[(index / 1483u) % 1483u] * 1483u +
            m_perm1483[(index / 2199289u) % 1483u]) * float(0x1.fffffcp-1 / 3261545587u); // Results in [0,1).
}

inline float Halton_sampler::halton1487(const unsigned index) const
{
    return (m_perm1487[index % 1487u] * 2211169u +
            m_perm1487[(index / 1487u) % 1487u] * 1487u +
            m_perm1487[(index / 2211169u) % 1487u]) * float(0x1.fffffcp-1 / 3288008303u); // Results in [0,1).
}

inline float Halton_sampler::halton1489(const unsigned index) const
{
    return (m_perm1489[index % 1489u] * 2217121u +
            m_perm1489[(index / 1489u) % 1489u] * 1489u +
            m_perm1489[(index / 2217121u) % 1489u]) * float(0x1.fffffcp-1 / 3301293169u); // Results in [0,1).
}

inline float Halton_sampler::halton1493(const unsigned index) const
{
    return (m_perm1493[index % 1493u] * 2229049u +
            m_perm1493[(index / 1493u) % 1493u] * 1493u +
            m_perm1493[(index / 2229049u) % 1493u]) * float(0x1.fffffcp-1 / 3327970157u); // Results in [0,1).
}

inline float Halton_sampler::halton1499(const unsigned index) const
{
    return (m_perm1499[index % 1499u] * 2247001u +
            m_perm1499[(index / 1499u) % 1499u] * 1499u +
            m_perm1499[(index / 2247001u) % 1499u]) * float(0x1.fffffcp-1 / 3368254499u); // Results in [0,1).
}

inline float Halton_sampler::halton1511(const unsigned index) const
{
    return (m_perm1511[index % 1511u] * 2283121u +
            m_perm1511[(index / 1511u) % 1511u] * 1511u +
            m_perm1511[(index / 2283121u) % 1511u]) * float(0x1.fffffcp-1 / 3449795831u); // Results in [0,1).
}

inline float Halton_sampler::halton1523(const unsigned index) const
{
    return (m_perm1523[index % 1523u] * 2319529u +
            m_perm1523[(index / 1523u) % 1523u] * 1523u +
            m_perm1523[(index / 2319529u) % 1523u]) * float(0x1.fffffcp-1 / 3532642667u); // Results in [0,1).
}

inline float Halton_sampler::halton1531(const unsigned index) const
{
    return (m_perm1531[index % 1531u] * 2343961u +
            m_perm1531[(index / 1531u) % 1531u] * 1531u +
            m_perm1531[(index / 2343961u) % 1531u]) * float(0x1.fffffcp-1 / 3588604291u); // Results in [0,1).
}

inline float Halton_sampler::halton1543(const unsigned index) const
{
    return (m_perm1543[index % 1543u] * 2380849u +
            m_perm1543[(index / 1543u) % 1543u] * 1543u +
            m_perm1543[(index / 2380849u) % 1543u]) * float(0x1.fffffcp-1 / 3673650007u); // Results in [0,1).
}

inline float Halton_sampler::halton1549(const unsigned index) const
{
    return (m_perm1549[index % 1549u] * 2399401u +
            m_perm1549[(index / 1549u) % 1549u] * 1549u +
            m_perm1549[(index / 2399401u) % 1549u]) * float(0x1.fffffcp-1 / 3716672149u); // Results in [0,1).
}

inline float Halton_sampler::halton1553(const unsigned index) const
{
    return (m_perm1553[index % 1553u] * 2411809u +
            m_perm1553[(index / 1553u) % 1553u] * 1553u +
            m_perm1553[(index / 2411809u) % 1553u]) * float(0x1.fffffcp-1 / 3745539377u); // Results in [0,1).
}

inline float Halton_sampler::halton1559(const unsigned index) const
{
    return (m_perm1559[index % 1559u] * 2430481u +
            m_perm1559[(index / 1559u) % 1559u] * 1559u +
            m_perm1559[(index / 2430481u) % 1559u]) * float(0x1.fffffcp-1 / 3789119879u); // Results in [0,1).
}

inline float Halton_sampler::halton1567(const unsigned index) const
{
    return (m_perm1567[index % 1567u] * 2455489u +
            m_perm1567[(index / 1567u) % 1567u] * 1567u +
            m_perm1567[(index / 2455489u) % 1567u]) * float(0x1.fffffcp-1 / 3847751263u); // Results in [0,1).
}

inline float Halton_sampler::halton1571(const unsigned index) const
{
    return (m_perm1571[index % 1571u] * 2468041u +
            m_perm1571[(index / 1571u) % 1571u] * 1571u +
            m_perm1571[(index / 2468041u) % 1571u]) * float(0x1.fffffcp-1 / 3877292411u); // Results in [0,1).
}

inline float Halton_sampler::halton1579(const unsigned index) const
{
    return (m_perm1579[index % 1579u] * 2493241u +
            m_perm1579[(index / 1579u) % 1579u] * 1579u +
            m_perm1579[(index / 2493241u) % 1579u]) * float(0x1.fffffcp-1 / 3936827539u); // Results in [0,1).
}

inline float Halton_sampler::halton1583(const unsigned index) const
{
    return (m_perm1583[index % 1583u] * 2505889u +
            m_perm1583[(index / 1583u) % 1583u] * 1583u +
            m_perm1583[(index / 2505889u) % 1583u]) * float(0x1.fffffcp-1 / 3966822287u); // Results in [0,1).
}

inline float Halton_sampler::halton1597(const unsigned index) const
{
    return (m_perm1597[index % 1597u] * 2550409u +
            m_perm1597[(index / 1597u) % 1597u] * 1597u +
            m_perm1597[(index / 2550409u) % 1597u]) * float(0x1.fffffcp-1 / 4073003173u); // Results in [0,1).
}

inline float Halton_sampler::halton1601(const unsigned index) const
{
    return (m_perm1601[index % 1601u] * 2563201u +
            m_perm1601[(index / 1601u) % 1601u] * 1601u +
            m_perm1601[(index / 2563201u) % 1601u]) * float(0x1.fffffcp-1 / 4103684801u); // Results in [0,1).
}

inline float Halton_sampler::halton1607(const unsigned index) const
{
    return (m_perm1607[index % 1607u] * 2582449u +
            m_perm1607[(index / 1607u) % 1607u] * 1607u +
            m_perm1607[(index / 2582449u) % 1607u]) * float(0x1.fffffcp-1 / 4149995543u); // Results in [0,1).
}

inline float Halton_sampler::halton1609(const unsigned index) const
{
    return (m_perm1609[index % 1609u] * 2588881u +
            m_perm1609[(index / 1609u) % 1609u] * 1609u +
            m_perm1609[(index / 2588881u) % 1609u]) * float(0x1.fffffcp-1 / 4165509529u); // Results in [0,1).
}

inline float Halton_sampler::halton1613(const unsigned index) const
{
    return (m_perm1613[index % 1613u] * 2601769u +
            m_perm1613[(index / 1613u) % 1613u] * 1613u +
            m_perm1613[(index / 2601769u) % 1613u]) * float(0x1.fffffcp-1 / 4196653397u); // Results in [0,1).
}

inline float Halton_sampler::halton1619(const unsigned index) const
{
    return (m_perm1619[index % 1619u] * 2621161u +
            m_perm1619[(index / 1619u) % 1619u] * 1619u +
            m_perm1619[(index / 2621161u) % 1619u]) * float(0x1.fffffcp-1 / 4243659659u); // Results in [0,1).
}

static inline double generate_halton_faure_single(uint64_t  i, unsigned int dim) {
    Halton_sampler hs;
    hs.init_faure();
    return(hs.sample(i,dim));
}

static inline double generate_halton_random_single(uint64_t  i, unsigned int dim, unsigned int seed) {
    random_gen rng(seed);
    Halton_sampler hs;
    hs.init_random(rng.rng);
    return(hs.sample(i,dim));
}

} //namespace spacefillr

#endif // HALTON_SAMPLER_H

