% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock.R
\name{with_mock}
\alias{with_mock}
\alias{local_mock}
\title{Mock functions in a package.}
\usage{
with_mock(..., .env = topenv())

local_mock(..., .env = topenv(), .local_envir = parent.frame())
}
\arguments{
\item{...}{named parameters redefine mocked functions, unnamed parameters
will be evaluated after mocking the functions}

\item{.env}{the environment in which to patch the functions,
defaults to the top-level environment.  A character is interpreted as
package name.}

\item{.local_env}{Environment in which to add exit hander.
For expert use only.}
}
\value{
The result of the last unnamed parameter
}
\description{
Executes code after temporarily substituting implementations of package
functions.  This is useful for testing code that relies on functions that are
slow, have unintended side effects or access resources that may not be
available when testing.
}
\details{
This works by using some C code to temporarily modify the mocked function \emph{in place}.
On exit (regular or error), all functions are restored to their previous state.
This is somewhat abusive of R's internals, and is still experimental, so use with care.

Functions in base packages cannot be mocked, but this can be
worked around easily by defining a wrapper function.
}
\examples{
add_one <- function(x) x + 1
expect_equal(add_one(2), 3)
with_mock(
  add_one = function(x) x - 1,
  expect_equal(add_one(2), 1)
)
square_add_one <- function(x) add_one(x)^2
expect_equal(square_add_one(2), 9)
expect_equal(
  with_mock(
    add_one = function(x) x - 1,
    square_add_one(2)
  ),
  1
)

# local_mock() -------------------------------
plus <- function(x, y) x + y
test_that("plus(1, 1) == 2", {
  expect_equal(plus(1, 1), 2)
})

test_that("plus(1, 1) == 3", {
  local_mock(plus = function(x, y) 3)
  expect_equal(plus(1, 1), 3)
})
}
\references{
Suraj Gupta (2012): \href{http://obeautifulcode.com/R/How-R-Searches-And-Finds-Stuff}{How R Searches And Finds Stuff}
}
\keyword{internal}
