% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-that.R
\name{test_that}
\alias{test_that}
\title{Run a test}
\usage{
test_that(desc, code)
}
\arguments{
\item{desc}{Test name. Names should be brief, but evocative. They are
only used by humans, so do you}

\item{code}{Test code containing expectations. Braces (\code{{}}) should always
be used in order to get accurate location data for test failures.}
}
\value{
When run interactively, returns \code{invisible(TRUE)} if all tests
pass, otherwise throws an error.
}
\description{
A test encapsulates a series of expectations about a small, self-contained
set of functionality. Each test lives in a file and contains multiple
expectations, like \code{\link[=expect_equal]{expect_equal()}} or \code{\link[=expect_error]{expect_error()}}.

Tests are evaluated in their own environments, and should not affect
global state.
}
\examples{
test_that("trigonometric functions match identities", {
  expect_equal(sin(pi / 4), 1 / sqrt(2))
  expect_equal(cos(pi / 4), 1 / sqrt(2))
  expect_equal(tan(pi / 4), 1)
})

\dontrun{
test_that("trigonometric functions match identities", {
  expect_equal(sin(pi / 4), 1)
})
}
}
