// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Bcm.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Bcm : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Bcm:1.0.0", null);

    public Bcm(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Bcm(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Bcm StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Bcm(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum LineConfig {
      UNCONNECTED,
      L1_N,
      L2_N,
      L3_N,
    }

    public enum TransformerType {
      VOLTAGE,
      TURNSRATIO,
    }

    public class PhaseConfig : ICloneable {
      public object Clone() {
        PhaseConfig copy = new PhaseConfig();
        copy.lineConfig = this.lineConfig;
        copy.ctType = this.ctType;
        copy.fsCurrent = this.fsCurrent;
        copy.fsVoltage = this.fsVoltage;
        copy.turnsRatio = this.turnsRatio;
        copy.burdenResistor = this.burdenResistor;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["lineConfig"] = (int)this.lineConfig;
        json["ctType"] = (int)this.ctType;
        json["fsCurrent"] = this.fsCurrent;
        json["fsVoltage"] = this.fsVoltage;
        json["turnsRatio"] = this.turnsRatio;
        json["burdenResistor"] = this.burdenResistor;
        return json;
      }

      public static PhaseConfig Decode(LightJson.JsonObject json, Agent agent) {
        PhaseConfig inst = new PhaseConfig();
        inst.lineConfig = (Com.Raritan.Idl.pdumodel.Bcm.LineConfig)(int)json["lineConfig"];
        inst.ctType = (Com.Raritan.Idl.pdumodel.Bcm.TransformerType)(int)json["ctType"];
        inst.fsCurrent = (int)json["fsCurrent"];
        inst.fsVoltage = (int)json["fsVoltage"];
        inst.turnsRatio = (int)json["turnsRatio"];
        inst.burdenResistor = (int)json["burdenResistor"];
        return inst;
      }

      public Com.Raritan.Idl.pdumodel.Bcm.LineConfig lineConfig = Com.Raritan.Idl.pdumodel.Bcm.LineConfig.UNCONNECTED;
      public Com.Raritan.Idl.pdumodel.Bcm.TransformerType ctType = Com.Raritan.Idl.pdumodel.Bcm.TransformerType.VOLTAGE;
      public int fsCurrent = 0;
      public int fsVoltage = 0;
      public int turnsRatio = 0;
      public int burdenResistor = 0;
    }

    public class ChannelConfig : ICloneable {
      public object Clone() {
        ChannelConfig copy = new ChannelConfig();
        copy.channel = this.channel;
        copy.label = this.label;
        copy.is3Phase = this.is3Phase;
        copy.lineA = this.lineA;
        copy.lineB = this.lineB;
        copy.lineC = this.lineC;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["channel"] = this.channel;
        json["label"] = this.label;
        json["is3Phase"] = this.is3Phase;
        json["lineA"] = this.lineA.Encode();
        json["lineB"] = this.lineB.Encode();
        json["lineC"] = this.lineC.Encode();
        return json;
      }

      public static ChannelConfig Decode(LightJson.JsonObject json, Agent agent) {
        ChannelConfig inst = new ChannelConfig();
        inst.channel = (int)json["channel"];
        inst.label = (string)json["label"];
        inst.is3Phase = (bool)json["is3Phase"];
        inst.lineA = Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig.Decode(json["lineA"], agent);
        inst.lineB = Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig.Decode(json["lineB"], agent);
        inst.lineC = Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig.Decode(json["lineC"], agent);
        return inst;
      }

      public int channel = 0;
      public string label = "";
      public bool is3Phase = false;
      public Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig lineA = new Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig();
      public Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig lineB = new Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig();
      public Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig lineC = new Com.Raritan.Idl.pdumodel.Bcm.PhaseConfig();
    }

    public class GetChannelCountResult {
      public int _ret_;
    }

    public GetChannelCountResult getChannelCount() {
      JsonObject _parameters = null;
      var _result = RpcCall("getChannelCount", _parameters);
      var _ret = new GetChannelCountResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getChannelCount(AsyncRpcResponse<GetChannelCountResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getChannelCount(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getChannelCount(AsyncRpcResponse<GetChannelCountResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getChannelCount", _parameters,
        _result => {
          try {
            var _ret = new GetChannelCountResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetChannelConfigsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig> _ret_;
    }

    public GetChannelConfigsResult getChannelConfigs() {
      JsonObject _parameters = null;
      var _result = RpcCall("getChannelConfigs", _parameters);
      var _ret = new GetChannelConfigsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getChannelConfigs(AsyncRpcResponse<GetChannelConfigsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getChannelConfigs(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getChannelConfigs(AsyncRpcResponse<GetChannelConfigsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getChannelConfigs", _parameters,
        _result => {
          try {
            var _ret = new GetChannelConfigsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetChannelConfigResult {
      public int _ret_;
    }

    public SetChannelConfigResult setChannelConfig(int channel, Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig config) {
      var _parameters = new LightJson.JsonObject();
      _parameters["channel"] = channel;
      _parameters["config"] = config.Encode();

      var _result = RpcCall("setChannelConfig", _parameters);
      var _ret = new SetChannelConfigResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setChannelConfig(int channel, Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig config, AsyncRpcResponse<SetChannelConfigResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setChannelConfig(channel, config, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setChannelConfig(int channel, Com.Raritan.Idl.pdumodel.Bcm.ChannelConfig config, AsyncRpcResponse<SetChannelConfigResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["channel"] = channel;
        _parameters["config"] = config.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setChannelConfig", _parameters,
        _result => {
          try {
            var _ret = new SetChannelConfigResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
