# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DsamDevice.idl.

use strict;

package Raritan::RPC::dsam::DsamDevice;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "dsam.DsamDevice:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::dsam::DsamDevice::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use Raritan::RPC::dsam::DsamDevice::Info;

sub getInfo($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInfo', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::dsam::DsamDevice::Info::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}


sub getPorts($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPorts', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'}, 'dsam.DsamPort');
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

sub startFirmwareUpdate($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'startFirmwareUpdate', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('dsam.DsamDevice', 1, 0, 0, 'Raritan::RPC::dsam::DsamDevice');
1;
