# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Fitness.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.fitness


# interface
class Fitness(Interface):
    idlType = "fitness.Fitness:1.0.0"

    FLAG_VALUE_INVALID = 0x1

    FLAG_VALUE_OLD = 0x2

    FLAG_ENTRY_CRITICAL = 0x4

    # structure
    class DataEntry(Structure):
        idlType = "fitness.Fitness.DataEntry:1.0.0"
        elements = ["id", "value", "maxValue", "worstValue", "thresholdValue", "rawValue", "flags"]

        def __init__(self, id="", value=0, maxValue=0, worstValue=0, thresholdValue=0, rawValue=0, flags=0):
            typecheck.is_string(id, AssertionError)
            typecheck.is_int(value, AssertionError)
            typecheck.is_int(maxValue, AssertionError)
            typecheck.is_int(worstValue, AssertionError)
            typecheck.is_int(thresholdValue, AssertionError)
            typecheck.is_long(rawValue, AssertionError)
            typecheck.is_int(flags, AssertionError)

            self.id = id
            self.value = value
            self.maxValue = maxValue
            self.worstValue = worstValue
            self.thresholdValue = thresholdValue
            self.rawValue = rawValue
            self.flags = flags

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                value = json['value'],
                maxValue = json['maxValue'],
                worstValue = json['worstValue'],
                thresholdValue = json['thresholdValue'],
                rawValue = int(json['rawValue']),
                flags = json['flags'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['value'] = self.value
            json['maxValue'] = self.maxValue
            json['worstValue'] = self.worstValue
            json['thresholdValue'] = self.thresholdValue
            json['rawValue'] = self.rawValue
            json['flags'] = self.flags
            return json

    # structure
    class ErrorLogEntry(Structure):
        idlType = "fitness.Fitness.ErrorLogEntry:1.0.0"
        elements = ["id", "value", "thresholdValue", "rawValue", "powerOnHours", "timeStampUTC"]

        def __init__(self, id="", value=0, thresholdValue=0, rawValue=0, powerOnHours=0, timeStampUTC=None):
            typecheck.is_string(id, AssertionError)
            typecheck.is_int(value, AssertionError)
            typecheck.is_int(thresholdValue, AssertionError)
            typecheck.is_long(rawValue, AssertionError)
            typecheck.is_int(powerOnHours, AssertionError)
            typecheck.is_time(timeStampUTC, AssertionError)

            self.id = id
            self.value = value
            self.thresholdValue = thresholdValue
            self.rawValue = rawValue
            self.powerOnHours = powerOnHours
            self.timeStampUTC = timeStampUTC

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                value = json['value'],
                thresholdValue = json['thresholdValue'],
                rawValue = int(json['rawValue']),
                powerOnHours = json['powerOnHours'],
                timeStampUTC = raritan.rpc.Time.decode(json['timeStampUTC']),
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['value'] = self.value
            json['thresholdValue'] = self.thresholdValue
            json['rawValue'] = self.rawValue
            json['powerOnHours'] = self.powerOnHours
            json['timeStampUTC'] = raritan.rpc.Time.encode(self.timeStampUTC)
            return json

    class _getDataEntries(Interface.Method):
        name = 'getDataEntries'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.fitness.Fitness.DataEntry.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.fitness.Fitness.DataEntry, DecodeException)
            return _ret_

    class _getErrorLogIndexRange(Interface.Method):
        name = 'getErrorLogIndexRange'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            firstIndex = rsp['firstIndex']
            entryCount = rsp['entryCount']
            typecheck.is_int(firstIndex, DecodeException)
            typecheck.is_int(entryCount, DecodeException)
            return (firstIndex, entryCount)

    class _getErrorLogEntries(Interface.Method):
        name = 'getErrorLogEntries'

        @staticmethod
        def encode(startIndex, count):
            typecheck.is_int(startIndex, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['startIndex'] = startIndex
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.fitness.Fitness.ErrorLogEntry.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.fitness.Fitness.ErrorLogEntry, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Fitness, self).__init__(target, agent)
        self.getDataEntries = Fitness._getDataEntries(self)
        self.getErrorLogIndexRange = Fitness._getErrorLogIndexRange(self)
        self.getErrorLogEntries = Fitness._getErrorLogEntries(self)

#
# Section generated by IdlC from "HardwareHealth.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.fitness

import raritan.rpc.idl


# interface
class HardwareHealth(Interface):
    idlType = "fitness.HardwareHealth:1.0.3"

    FAILURE_TYPE_NETWORK_DEVICE_NOT_DETECTED = 1

    FAILURE_TYPE_I2C_BUS_STUCK = 2

    FAILURE_TYPE_SUB_CTRL_NOT_REACHABLE = 3

    FAILURE_TYPE_SUB_CTRL_MALFUNCTION = 4

    FAILURE_TYPE_OUTLET_POWER_STATE_INCONSISTENT = 5

    FAILURE_TYPE_SUB_CTRL_INCOMPATIBLE = 6

    # structure
    class Failure(Structure):
        idlType = "fitness.HardwareHealth_1_0_3.Failure:1.0.0"
        elements = ["creationOrderId", "componentId", "type", "description", "isAsserted", "lastAssertTimeStamp", "lastDeassertTimeStamp", "assertCount"]

        def __init__(self, creationOrderId=0, componentId="", type=0, description="", isAsserted=False, lastAssertTimeStamp=None, lastDeassertTimeStamp=None, assertCount=0):
            typecheck.is_int(creationOrderId, AssertionError)
            typecheck.is_string(componentId, AssertionError)
            typecheck.is_int(type, AssertionError)
            typecheck.is_string(description, AssertionError)
            typecheck.is_bool(isAsserted, AssertionError)
            typecheck.is_time(lastAssertTimeStamp, AssertionError)
            typecheck.is_time(lastDeassertTimeStamp, AssertionError)
            typecheck.is_int(assertCount, AssertionError)

            self.creationOrderId = creationOrderId
            self.componentId = componentId
            self.type = type
            self.description = description
            self.isAsserted = isAsserted
            self.lastAssertTimeStamp = lastAssertTimeStamp
            self.lastDeassertTimeStamp = lastDeassertTimeStamp
            self.assertCount = assertCount

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                creationOrderId = json['creationOrderId'],
                componentId = json['componentId'],
                type = json['type'],
                description = json['description'],
                isAsserted = json['isAsserted'],
                lastAssertTimeStamp = raritan.rpc.Time.decode(json['lastAssertTimeStamp']),
                lastDeassertTimeStamp = raritan.rpc.Time.decode(json['lastDeassertTimeStamp']),
                assertCount = json['assertCount'],
            )
            return obj

        def encode(self):
            json = {}
            json['creationOrderId'] = self.creationOrderId
            json['componentId'] = self.componentId
            json['type'] = self.type
            json['description'] = self.description
            json['isAsserted'] = self.isAsserted
            json['lastAssertTimeStamp'] = raritan.rpc.Time.encode(self.lastAssertTimeStamp)
            json['lastDeassertTimeStamp'] = raritan.rpc.Time.encode(self.lastDeassertTimeStamp)
            json['assertCount'] = self.assertCount
            return json

    # value object
    class FailureStatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "fitness.HardwareHealth_1_0_3.FailureStatusChangedEvent:1.0.0"

        def __init__(self, componentId="", failureType=0, isAsserted=False, source=None):
            super(raritan.rpc.fitness.HardwareHealth.FailureStatusChangedEvent, self).__init__(source)
            typecheck.is_string(componentId, AssertionError)
            typecheck.is_int(failureType, AssertionError)
            typecheck.is_bool(isAsserted, AssertionError)

            self.componentId = componentId
            self.failureType = failureType
            self.isAsserted = isAsserted

        def encode(self):
            json = super(raritan.rpc.fitness.HardwareHealth.FailureStatusChangedEvent, self).encode()
            json['componentId'] = self.componentId
            json['failureType'] = self.failureType
            json['isAsserted'] = self.isAsserted
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                componentId = json['componentId'],
                failureType = json['failureType'],
                isAsserted = json['isAsserted'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["componentId", "failureType", "isAsserted"]
            elements = elements + super(raritan.rpc.fitness.HardwareHealth.FailureStatusChangedEvent, self).listElements()
            return elements

    class _getFailures(Interface.Method):
        name = 'getFailures'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.fitness.HardwareHealth.Failure.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.fitness.HardwareHealth.Failure, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(HardwareHealth, self).__init__(target, agent)
        self.getFailures = HardwareHealth._getFailures(self)
