---
title: "rclone config update"
description: "Update options in an existing remote."
slug: rclone_config_update
url: /commands/rclone_config_update/
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/config/update/ and as part of making a release run "make commanddocs"
---
# rclone config update

Update options in an existing remote.

## Synopsis


Update an existing remote's options. The options should be passed in
in pairs of `key` `value`.

For example to update the env_auth field of a remote of name myremote
you would do:

    rclone config update myremote swift env_auth true

If any of the parameters passed is a password field, then rclone will
automatically obscure them if they aren't already obscured before
putting them in the config file.

**NB** If the password parameter is 22 characters or longer and
consists only of base64 characters then rclone can get confused about
whether the password is already obscured or not and put unobscured
passwords into the config file. If you want to be 100% certain that
the passwords get obscured then use the "--obscure" flag, or if you
are 100% certain you are already passing obscured passwords then use
"--no-obscure".  You can also set osbscured passwords using the
"rclone config password" command.

If the remote uses OAuth the token will be updated, if you don't
require this add an extra parameter thus:

    rclone config update myremote swift env_auth true config_refresh_token false


```
rclone config update `name` [`key` `value`]+ [flags]
```

## Options

```
  -h, --help         help for update
      --no-obscure   Force any passwords not to be obscured.
      --obscure      Force any passwords to be obscured.
```

See the [global flags page](/flags/) for global options not listed here.

## SEE ALSO

* [rclone config](/commands/rclone_config/)	 - Enter an interactive configuration session.

