#ifndef _RHEOLEF_FIELD_LOCAL_NORM_H
#define _RHEOLEF_FIELD_LOCAL_NORM_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/field.h"
namespace rheolef { 

// compute the local L2 norm:
//  I_K = (int_K |vh(x)|^2 dx )^{1/2}
// -> return a P0 scalar field
// extension: accepts some vector-valued input
field norm2_L2_local (const field& vh);

// vh & wh are Pkd-scalar
// returns the P0-scalar field of int_K vh*wh dx
field norm2_L2_local_scalar (const field& vh, const field& wh);

// vh is a Pkd-vector
// returns the P0-vector field of |vh[i]|_l2(K), i=0..n_comp-1
field norm2_L2_local_vector (const field& vh);

}// namespace rheolef
#endif // _RHEOLEF_FIELD_LOCAL_NORM_H
