#include "rheolef.h"
#include "rheolef/cg_abtbc.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  Float inv_lambda = (argc > 2 ? atof(argv[2]) : 0);
  space Vh (omega, "P2", "vector");
  space Qh (omega, "P1");
  Vh.block("bottom");
  Vh.block("left");
  if (omega.dimension() == 3)
    { Vh.block("right");  Vh.block("back"); }
  field uh (Vh,0.), fh (Vh, 0.);
  if (omega.dimension() == 3) {
    uh["right"] = uh["back"] = 0;
    fh[2] = -1;
  } else {
    fh[1] = -1;
  }
  field ph (Qh, 0.);
  form a (Vh, Vh, "2D_D");
  form m (Vh, Vh, "mass");
  form b (Vh, Qh, "div"); b = -b;
  form c = - inv_lambda*form(Qh, Qh, "mass");
  int   max_iter  = 500;
  Float tol       = 1e-8;
  Float r         = 1e+7;
  field mfh  = m*fh;
  vec<Float> f = mfh.u-(a.ub*uh.b);
  vec<Float> g = -(b.ub*uh.b);
  form ar = a + r*trans(b)*b;
  form br = b + r*trans(c)*b;
  form cr = c + r*trans(c)*c;
  vec<Float> fr = f + r*trans(b.uu)*g;
  vec<Float> gr = g + r*trans(c.uu)*g;
  ssk<Float> fact = ldlt(ar.uu);
  cg_abtbc (ar.uu, fact, br.uu, cr.uu, uh.u, ph.u, fr, gr, max_iter, tol);
  cout << catchmark("inv_lambda")  << inv_lambda << endl
       << catchmark("u")  << uh
       << catchmark("p")  << ph;
  return 0;
}
