namespace rheolef {
  template <class T>
  csr<T>
  band_assembly (const form& a, const field& phi_h) {
    const space& Bh = a.get_first_space();
    check_macro (Bh == phi_h.get_space(), "incompatible spaces");
    const geo& band = Bh.get_geo();
    size_t n = a.uu.nrow();
    size_t m = band.n_domain() - 2; // n_connected components: skip zero & isolated
    asr<T> A (n+m, n+m);
    Array<size_t>::const_iterator ia = a.uu.ia().begin();
    Array<size_t>::const_iterator ja = a.uu.ja().begin();
    typename Array<T>::const_iterator va = a.uu.a().begin();
    for (size_t i = 0; i < n; i++) {
      for (size_t p = ia[i]; p < ia[i+1]; p++) {
        A.entry(i,ja[p]) = va[p];
      }
    }
    typename Array<T>::const_iterator vb = phi_h.u.begin();
    for (size_t i = 0; i < m; i++) {
      const domain& ci = band["connected_component_"+itos(i)];
      for (size_t p = 0; p < ci.size(); p++) {
        const geo_element& P = ci.at(p);
        size_t jdx = P[0];
        size_t j = Bh.index(jdx);
        A.entry(n+i, j) = vb[j];
        A.entry(j, n+i) = vb[j];
      }
    }
    return csr<T>(A);
  }
} // namespace rheolef
