///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
///
// COLOR: Define a color table
//        output in Postscript format
// 
// author: Pierre.Saramito@imag.fr
//
// date: 30 january 1997
//
# include "rheolef/color.h"
# include "rheolef/array.h" /* for max(), min() */
using namespace rheolef;
using namespace std;

void palette::postscript_print_color_def (ostream& s)
{
    	for (int i = first; i <= last; i++) {

	    color c = rgb(i);
	    s << "/c" << i << " { " 
	      << c.r << " " << c.g << " " << c.b 
	      << " setrgbcolor} def\n";
        }
}
palette::palette (Float min1, Float max1, int n, Float percent_green_default) {
            
        min_ = min1;
        max_ = max1;
        if (max_ - min_ == Float(0)) {
	    max_ = 1;
	    min_ = -1;
	}
	first = 0;
        last = n-1;
        medium = (last+first)/2;
	    
        percent_green = percent_green_default;
        green_size = int(0.01*percent_green*(last-first+1) + 0.5);
        fist_green = medium - green_size/2;
        last_green = medium + green_size/2;
}
// index -> intensity per color
Float palette::red(int i) {

        if (i >= last_green) return 1;
        if (i > medium)      return Float(i - medium)/Float(last_green - medium);
        		     return 0;
}
Float palette::green(int i) {

	if (i < fist_green) 	return Float(i - first)/Float(fist_green - first);
	if (i > last_green) 	return Float(last  - i)/Float(last  - last_green);
	                        return 1;
}
Float palette::blue(int i) {

    	if (i <= fist_green) return 1;
    	if (i < medium)      return 1.0*(medium - i)/(medium - fist_green);
    			     return 0;
}
color palette::rgb(int i) {
	color c;
    	c.r = red(i);
    	c.g = green(i);
    	c.b = blue(i);
	return c;
}
int palette::color_index(Float x) {
	return int(Float(last - first)*(x - min_)/(max_ - min_) + first + 0.5);
}
color palette::rgb(Float x) {
	return rgb(color_index(x));
}
