//! Precalculated large powers for 64-bit limbs.

/// Large powers (&[u64]) for base5 operations.
const POW5_1: [u64; 1] = [5];
const POW5_2: [u64; 1] = [25];
const POW5_3: [u64; 1] = [625];
const POW5_4: [u64; 1] = [390625];
const POW5_5: [u64; 1] = [152587890625];
const POW5_6: [u64; 2] = [3273344365508751233, 1262];
const POW5_7: [u64; 3] = [7942358959831785217, 16807427164405733357, 1593091];
const POW5_8: [u64; 5] = [279109966635548161, 2554917779393558781, 14124656261812188652, 11976055582626787546, 2537941837315];
const POW5_9: [u64; 10] = [13750482914757213185, 1302999927698857842, 14936872543252795590, 2788415840139466767, 2095640732773017264, 7205570348933370714, 7348167152523113408, 9285516396840364274, 6907659600622710236, 349175];
const POW5_10: [u64; 19] = [8643096425819600897, 6743743997439985372, 14059704609098336919, 10729359125898331411, 4933048501514368705, 12258131603170554683, 2172371001088594721, 13569903330219142946, 13809142207969578845, 16716360519037769646, 9631256923806107285, 12866941232305103710, 1397931361048440292, 7619627737732970332, 12725409486282665900, 11703051443360963910, 9947078370803086083, 13966287901448440471, 121923442132];
const POW5_11: [u64; 38] = [17679772531488845825, 2216509366347768155, 1568689219195129479, 5511594616325588277, 1067709417009240089, 9070650952098657518, 11515285870634858015, 2539561553659505564, 17604889300961091799, 14511540856854204724, 12099083339557485471, 7115240299237943815, 313979240050606788, 10004784664717172195, 15570268847930131473, 10359715202835930803, 17685054012115162812, 13183273382855797757, 7743260039872919062, 9284593436392572926, 11105921222066415013, 18198799323400703846, 16314988383739458320, 4387527177871570570, 8476708682254672590, 4925096874831034057, 14075687868072027455, 112866656203221926, 9852830467773230418, 25755239915196746, 2201493076310172510, 8342165458688466438, 13954006576066379050, 15193819059903295636, 12565616718911389531, 3815854855847885129, 15696762163583540628, 805];
const POW5_12: [u64; 75] = [16359721904723189761, 5323973632697650495, 17187956456762001185, 3930387638628283780, 3374723710406992273, 16884225088663222131, 10967440051041439154, 9686916182456720060, 10554548046311730194, 7390739362393647554, 6316162333127736719, 18122464886584070891, 4044404959645932768, 3801320885861987401, 12080950653257274590, 16414324262488991299, 16395687498836410113, 12173633940896186260, 10843185433142632150, 11048169832730399808, 12674828934734683716, 17370808310130582550, 10500926985433408692, 10252725158410704555, 14170108270502067523, 3698946465517688080, 989984870770509463, 10965601426733943069, 11389898658438335655, 6901098232861256586, 1921335291173932590, 7662788640922083388, 9775023833308395430, 4640401278902814207, 14532050972198413359, 8378549018693130223, 11672322628395371653, 8930704142764178555, 6275193859483102017, 15782593304269205087, 8673060659034172558, 8018354414354334043, 1824896661540749038, 11345563346725559868, 14959216444480821949, 970189517688324683, 3338835207603007873, 17684964260791738489, 1436466329061721851, 4554134986752476101, 6398757850768963907, 4709779218751158342, 10033277748582410264, 17932125878679265063, 10004750887749091440, 256584531835386932, 14396282740722731628, 3086085133731396950, 17831272085689600064, 10573926491412564693, 14888061047859191737, 4570995450261499817, 10410165022312935266, 5691078631447480790, 8632710455805418155, 790672778942823293, 16505464105756800547, 2092171438149740401, 17505030673829275878, 1291290830058928444, 14856191690683232796, 8916773426496500052, 10152003807578858265, 13104441193763861714, 649395];
const POW5_13: [u64; 149] = [15308384451594534913, 17913664074042735335, 6115977719198531863, 5794980608663993169, 16544350702855106930, 9253787637781258566, 4977988951675168190, 9087837664087448770, 2098480401110016986, 15474332540882100712, 14042133997396540944, 1090855284423485362, 12639956485351058381, 1454115676006639319, 3180465001342538023, 14649076551958697729, 9801292446545910916, 13552201410826594004, 6101141927469189381, 1881431857880609316, 4907847477899433595, 8714572486973123228, 3514969632331374520, 11667642286891470094, 2391499697425323350, 17486585679659076043, 18267223761882105642, 2886610765822313148, 9302834862968900288, 15246507846733637044, 15924227519624562840, 9743741243284697760, 3159780987244964246, 7304816812369628428, 17584602612559717809, 4146812420657846766, 14525415362681041515, 8477630142371600195, 4380695748062263745, 12119915994367943173, 16970630866565485122, 4332724980155264503, 8079943140620527639, 1687908087554405626, 17051081099834002166, 12638146269730763230, 11883749876933445771, 4662462156371383785, 4796962238316531176, 3325504751659868927, 6469595803187862550, 5852556621152583005, 9229334792448387881, 17979733373938620709, 13951623534175792756, 17075879371091039277, 14212246479457938037, 4008999959804158260, 2414266395366403722, 3252733766253918247, 6382678985007829216, 2245927470982310841, 13790724502051307301, 13116936866733148041, 9718402891306794538, 13516274400356104875, 17859223875778049403, 4396895129099725471, 3563053650368467915, 12176845952536972668, 3492050964335269015, 2740656767075170753, 4409704077614761919, 10237775279597492710, 3314206875098230827, 16437361028114095448, 12361736225407656572, 16792510651790145480, 11449053143229929935, 18336641737580333136, 6558939822118891088, 4606255756908155300, 2360792578991605004, 160428430149144538, 11644861220729221511, 10785178451159739786, 14923560618031934681, 1902620814992781610, 14064076995338910412, 11547019064112212657, 16847481479966225734, 8331994491163145469, 11739712981738851885, 8008309968651120619, 10266969595459035264, 15175153381217702033, 12208659352573720245, 7714061140750342961, 2892831567213510541, 15453714249045017319, 71020323573871677, 15431137995750602633, 5659146884637671933, 5998809010488554503, 16552192379299157850, 1192197967194298797, 16157555793424861524, 10929371590994640255, 3194469143425738352, 6651586784672005225, 11062427140788057791, 6834443579468668318, 16421563197797455922, 6251046422506172884, 13952303462156793860, 16632486601871393224, 11313454360291325172, 5587835232504462834, 3105197524618514637, 18268568531031972989, 2397205535804309313, 59413027864729597, 11869878125348715710, 12592801707270523266, 8070632061321113656, 18403647807860650811, 267109013517069093, 6537214311028855260, 5220826919973709902, 3448740582779163661, 16822239213112884941, 5975299384311048185, 10294433804430712138, 4739856055412448774, 12057273038326387897, 13119002941950056609, 3354445304051737058, 13592813067499314594, 3890182464434078629, 17820384357466425060, 9785228118969879380, 1778431746734556271, 10075313876350055029, 13994048489400919028, 17948287074199726448, 2815088342305858722, 2676626035777198370, 1174257960026283968, 421714788677];
const POW5_14: [u64; 298] = [11471884475673051137, 8902860357476377573, 13350296775839230505, 10609191786344608888, 7261211985859587338, 11439672689354862964, 16789708072300570627, 4607056528866348430, 3202978990421512997, 2024899620433984146, 17666950207239811774, 4233228489390288200, 9137580478688460738, 4060411066587388546, 11119949806060600124, 867715462473090103, 14382394941384869610, 4856042377419278489, 8265605599571137921, 538981667666252469, 4270263388700786523, 3281140600308898503, 4121392524544394174, 2077884106245940229, 9773041957329767574, 7550623316597646685, 8611033926449791714, 18137922955420802793, 2796546741236224013, 15477096484628446761, 9517540128113714010, 9471917970500821378, 15938570248662483124, 5228016831978462619, 15720991252586974501, 7662829825220776698, 17328310068068434348, 3371736428170309730, 3803724952191098855, 13115926536504376719, 16752571196153442257, 16540185467776259880, 3432518182450051120, 5880364967211798870, 12355748840305392783, 14196090758536469575, 7370123524686686319, 6819740424617592686, 13037938013537368753, 15029273671291927100, 3671312928327205696, 7473228676544792780, 17234079691312938123, 14164740848093544419, 13169904779481875902, 7179036968465894054, 8244653688947194445, 17179797746073799490, 5591970751047577674, 17530550506268329742, 5965746721852312330, 1604149463243472865, 7734199791463116918, 11305790396015856714, 4441196105025505137, 13046431581185664762, 124776524294606713, 1134521334706523966, 11671728093344476434, 14103440020972933148, 3966727403013869059, 9828094508409132821, 4355682486381147287, 10261407143988481234, 3800455155249557199, 12700901937937547500, 18184475466894579360, 13267691151779895412, 4714157123477697445, 10770360171308585263, 9083344917597998040, 12078649873810212155, 18218989082046199377, 4454285072780637351, 5287307245618354742, 16042289702059031730, 4131926574212754010, 217692071448455473, 3624845916216282093, 2901203491797614218, 6679177724033967080, 44561358851332790, 9094639944041587162, 13690915012276084311, 1408896670826320686, 5359130319612337580, 6148412925099835601, 5211368532286409612, 11386360825549027374, 16895182466965795071, 3392940493846427241, 438089879085393580, 4783928372776399972, 6278117363595909959, 12569481049412674733, 15648622492570893902, 1966316336235305115, 1603775390515993547, 13576113010204316709, 10821754650102840474, 18198222517222903152, 6966163076615302988, 1373932372410129684, 3285839581819684990, 30177575069719475, 16447047871247307061, 11618654126674833808, 990072222556306872, 1260682336135768017, 13862055046689532489, 15668483092844698432, 1879572630092764264, 13912027797058626108, 6231679788219816920, 13857858054844167403, 18101470072534728857, 4144579812461609229, 7048589655616599284, 9946956499532694630, 9771303850109874038, 6477823708780339765, 17526247621747041971, 13525995675852669549, 3928768291901239810, 8094153383078124544, 11214278667728965552, 11251547162596832610, 5964946855123292381, 3622548288590237903, 13469765967150053587, 17798986288523466082, 14684592818807932259, 16724077276802963921, 7119877993753121290, 1864571304902781632, 12871984921385213812, 9065447042604670298, 3987130777300360550, 6890545752116901685, 17275341711601865750, 6296474927799264658, 1257436973037243463, 13854281781965301421, 1657132483318662716, 17309399540017292849, 12808111630089217242, 1098489625264462071, 14010458905686364135, 16134414519481621220, 14288255900328821475, 3469093466388187882, 15982710881468295872, 4056765540058056052, 15945176389096104089, 8625339365793505375, 12316179968863788913, 15334123773538054321, 9536238824220581765, 16080825720106203271, 6235695225418121745, 12035192956458019349, 3235835166714703698, 5348960676912581218, 15315062772709464647, 17335089708021308662, 16855855317958414409, 2369751139431140406, 3693542588628609043, 7350405893393987577, 17402072586341663801, 7007897690013647122, 15671767872059304758, 9259490518292347915, 14836045474406130394, 4654005815464502513, 6487825998330548401, 7013356660323385022, 7136200343936679946, 15341236858676437716, 3657357368867197449, 12621075530054608378, 5603868621997066972, 7683447656788439942, 450883379216880060, 14291494350184945047, 5466258454997635048, 14206933098432772126, 4775870327277641692, 1864430798867181939, 13748978265070608793, 12250822864261576589, 12561896977498605296, 16060949594257359328, 17775189113543311529, 11835965177892927035, 4218664174878121437, 3499000902478111683, 15169853304359126294, 7076121963053575143, 832652347668916805, 1292148207755194737, 7556838978364207852, 5904021986723518500, 4610244652288570024, 4526508363195533871, 746120481022614726, 737965197247830486, 4006266184415762653, 9272188239892688050, 15346235246415709678, 11850675997347533184, 11181059668610842701, 6687857983250662774, 2908718488661492818, 4828337780126983225, 18071738646453002184, 12790187227727197880, 17602483480871623153, 12523532189621855977, 10598805712727696716, 2179787555896149376, 2242193929457337594, 14908923241136742532, 8369182018012550027, 13385381554043022324, 3332327430110633913, 16138090784046208492, 16172324607469047339, 8279089815915615244, 12872906602736235247, 10894545290539475621, 15428756545851905023, 4155747980686992922, 4074479178894544043, 66083965608603584, 13873786284662268377, 8861183628277687555, 12119497911296021430, 2154012318305274287, 15490706314503067312, 13643145488710608367, 672340241093017103, 6039493278284091973, 9679797700977436461, 18070795828318171174, 2188146431134935377, 5247392385741514952, 1852539214842869734, 12235621681634112739, 8812930319623534062, 5585597406294108629, 11312989214475901864, 1547377291787797995, 8641748937186208205, 12518148659168623694, 6611379197521520985, 18096591571068008576, 15087021227100112139, 13058454842015958418, 1473584652966833794, 4387660670140018168, 8452836916843525402, 14376083294443363955, 13998026203969090659, 611968444648172645, 990232438801273845, 18001186324715561929, 13470591857250177501, 14881554140239420091, 16696367836720124495, 6328076032778459673, 17027497695968504616, 10192245646262428833, 8282482589527318647, 4319014353374321425, 14134087271041670980, 5060230880114618599, 13179509240430058600, 3903514232614801894, 17774749744702165255, 15448635507030969726, 15983775238358480209, 14542832143965487887, 9385618098039514666, 14431419612662304843, 730863073501675978, 16750118380379734815, 9640];

pub(super) const POW5: [&'static [u64]; 14] = [
    &POW5_1,
    &POW5_2,
    &POW5_3,
    &POW5_4,
    &POW5_5,
    &POW5_6,
    &POW5_7,
    &POW5_8,
    &POW5_9,
    &POW5_10,
    &POW5_11,
    &POW5_12,
    &POW5_13,
    &POW5_14,
];

cfg_if! {
if #[cfg(feature = "radix")] {

/// Large powers (&[u64]) for base3 operations.
const POW3_1: [u64; 1] = [3];
const POW3_2: [u64; 1] = [9];
const POW3_3: [u64; 1] = [81];
const POW3_4: [u64; 1] = [6561];
const POW3_5: [u64; 1] = [43046721];
const POW3_6: [u64; 1] = [1853020188851841];
const POW3_7: [u64; 2] = [8733086111712066817, 186140372879];
const POW3_8: [u64; 4] = [9241971931925084673, 16454059005556024164, 5253045282866540271, 1878];
const POW3_9: [u64; 7] = [15136703003180987393, 8476343899828878673, 18361811754143825027, 14388418858783342465, 5401376488135036380, 12364567666609403030, 3527953];
const POW3_10: [u64; 13] = [2118395047680534529, 8537117469025143052, 3872259360504933309, 10701526949532696147, 17998776526579280936, 6666182382162752224, 2298937609138591600, 10431735398056406321, 16375030035869515722, 3789847405179292381, 16253248952895454123, 5013447294207740028, 12446457099674];
const POW3_11: [u64; 26] = [11359380750133874689, 5276606518746106582, 8074516225493162415, 44091562328298894, 3624566612640262530, 1648712055576603746, 570015793462054116, 4997922052233515184, 11461456262225743338, 3703749129909374618, 1032298853854876563, 5055703740018389007, 12165799951080916707, 7876242724076368176, 11382490680713659023, 8012668037354425323, 6455631446982530500, 11518146109761638553, 14211686304453726670, 14638327231082858575, 212706140070406144, 18114182620365251442, 16255881380360420802, 17396653870711483704, 13342545167648199825, 8397920];
const POW3_12: [u64; 51] = [6615629770586038273, 14589289854081549156, 16033283353414803848, 4072670504909965136, 9285202060411609801, 3844375208352343783, 14457341458236460110, 11113571593891798513, 6897806051678254736, 13754726319538359186, 6705168383790534776, 18424255276769215806, 9125568036581672334, 17950439800261239652, 3360019889600789048, 8736970908230253200, 5862837180794632907, 4685996133977145346, 7012924617285143305, 6946857363647229985, 17278143000252629097, 8632720555983218073, 448178319842208351, 13359710428804700555, 13363983887301643254, 13693315286110143380, 3073162922650220325, 14844710205972612777, 10236141098283186080, 15546300905171289287, 14991733718586000242, 12916696994748984595, 1335788671178492970, 8288858105892413588, 531597803005806362, 1424346394172629150, 8721143616286912970, 14331896312442271549, 3043145014208270918, 8340447499879054696, 11359259714499294398, 8644862996062775644, 9484939289239162819, 13589880770603801564, 15411917558929121981, 4327480870720673885, 1325470906085940108, 1949446308450023420, 15707488697789413385, 7670729805623044772, 70525072474845];
const POW3_13: [u64; 102] = [17686697579142660097, 6835527964327392632, 519141719648339438, 10915724132684181418, 10525094883897927730, 12931691278819523731, 13609994346461817211, 7792013918408689767, 12616283906737735258, 6152585453049961975, 18093218868158061242, 4597585598518975727, 4540690555621276154, 5146752950888563072, 17078008680493976306, 4940054416148051507, 13292642740797593673, 11433236470183933650, 1893271136554408208, 5395175136028342217, 3377431049116564971, 16414233592433497551, 660190863912874689, 10191500464313104710, 5296767785184324219, 7017570247774576725, 11906963227774686324, 11523256495834484144, 17718039332649552444, 18203074682319783749, 13063547705319384019, 2689214593055349782, 8872984591015716038, 13295405780899799222, 17955349892186737306, 18377333322072047388, 10009321763381733263, 10740619310679053173, 3678366978495582488, 5386006412549914107, 2939999530005680313, 864350463957430877, 7134876155463612350, 12859539885231597000, 14622204113412710377, 8487354967518133412, 16893752681799589394, 1861455355759609366, 2215078177635153677, 12328081781789258814, 13512115210914444970, 12467125683110614132, 10809819066795130489, 10302065192562501784, 6333142106738947567, 12227363843828271581, 4911642960325424181, 4922686570288394259, 2904259931365432466, 15017412742290626787, 18050457076260269306, 7789034218973547683, 10100531119715750776, 6151136088165477097, 13496448062567072853, 11179514145292123821, 6834256416281897152, 6315963086107973635, 7916218311420134351, 4058636906137698771, 612677900085674499, 740390706776619056, 15913061541915060609, 5625318012611030298, 5492469315252333142, 1787499506659871564, 13130972346797301907, 17139036276093329309, 3129806882433428008, 11801555561087648421, 1337437552933432854, 14393715939936689772, 5075982616701483039, 14146728107994341104, 2009717676181581254, 6499370409273010652, 1614287946020752558, 543465737531163540, 9981569900494582018, 14819783240964814582, 3413474580476079436, 10254490513920293241, 15716828194058191719, 4496048105227602492, 9117771791529929093, 8598172845056620230, 10788533399188821370, 6549281897122335588, 13437155476602347060, 2738314500086357436, 1315507096324862908, 269629471];
const POW3_14: [u64; 203] = [3014151301029068801, 3368717210500941014, 16526655043858351280, 1570922329624414208, 1659387501763276584, 14746156693680335077, 12991990277270429286, 819557268048782528, 13315632618164850296, 13715274206880838717, 17320008985571678455, 5772178420050611091, 2836253575397763676, 7717380670411115663, 2099659576414294503, 15238056155431820065, 12367761437621511661, 10877305759783841876, 1225050232812614950, 4132971589311606454, 3487827946854483167, 8858594377116303592, 13014169932326731571, 6586799248091633642, 2908467343916459689, 17130644458472461229, 11990926378323331396, 7443957075454662896, 11344079546287445306, 6894950762728195350, 1686251346332844224, 6646110915587688968, 6238314137953262194, 4464909969120699941, 14286719114913530972, 2734304957036558979, 773565632958560255, 14242527207621083408, 14447328157991647975, 4816462262218287249, 14117383283175832350, 14908821434818589176, 6568674307664296350, 678284794617743431, 8334193628813726431, 9581059312036536760, 3383333089665701405, 2303925959357643449, 9136900775437373797, 11516055338615503912, 13559451120619030647, 17025355858086313952, 1910167349182142859, 16525896153568708881, 17714211194627560821, 10810197653235829756, 7452461128358501030, 17844611896374050395, 333578009178998475, 4628333967402862148, 10057732281097955560, 15569406586116356914, 4118001685045222295, 6935172110078815123, 12967793877761791179, 8817769094107007808, 1747043335436027338, 15653102610442392714, 4502857681038835401, 6487866587498327385, 18379297231463588590, 11533941842543278284, 13172688588106291155, 8469492863154015196, 6805786336069511037, 9261430062346425502, 9474322044812704055, 6999972495444113671, 7013474345268902220, 714098888039517700, 9579110838306604082, 18056640044808390108, 1403980188111742434, 17430545075496543804, 3391229225121147510, 11581960744638707540, 5557076712965167319, 14374646898589421993, 3074971570627478236, 7522848267109877585, 4851002149225660252, 1149011036220677837, 10860077460801552088, 10030117995774642746, 9800251505364265802, 12263726642788040500, 8880913180594270442, 15211874648317416291, 7160134456849478774, 11477475544166228321, 257207889078646990, 3305183774411918594, 13048234133003633760, 18097110596628986519, 12591826257500422975, 15148251536720461410, 16843770751005933355, 11253961878990923156, 593780973732575744, 10457383791702173304, 11986258352615194256, 11413384508803902693, 12753714256533469971, 18436679404309801714, 726019101611306918, 7258345777840499664, 5032958293947934815, 12227080935754030974, 13887924239651958077, 1400265616991034855, 7085864794210057777, 1240279560360509664, 14067798200534308237, 9797298435194605689, 7723185714118383600, 4745023082819817852, 8367408728769205959, 14068664393588123867, 7743596177843306725, 13881494215404370022, 5857917740184736707, 11774638389823353270, 13335039482811683472, 5448496090214748403, 8169443631504709398, 8923963461059690757, 1420236601460646338, 17175265161397714, 9419779367266532198, 13740545339430881939, 149551661811372044, 2134178529555318188, 11862173939403040776, 134962647208871982, 15812412501213249693, 15500965737260495409, 9091597338111703767, 1402601351158315376, 9678477204323131251, 7123714578778314639, 13419443329419867216, 1626139390311403400, 10670527174588355677, 15613942385335190283, 14866028981683790327, 2875412637795392250, 5545700603057473186, 3901369409833122233, 5041841700261093720, 10236452968877155790, 3361723130076326542, 14087286044445658952, 4897068441082356069, 2618207670852915413, 2604225553110898515, 14226665567951584750, 12441492392956774230, 11464430628227911604, 9999109980159956095, 7322975638809513305, 13948967581531822327, 16002355077850659557, 8999432336483894258, 8650590966026907421, 9182164374843588426, 13872899150185224091, 2685796546452147997, 14968944803847985245, 1671197773218265345, 17072901215829183054, 11825035869843291884, 7589981082857893534, 1366317217152210935, 18341163110247053099, 17449546387829746903, 11088612001571320736, 13674344207423319935, 2545851539157564305, 454005134127827820, 11490672491862242506, 17374998876632719106, 728817640684130820, 7986346026335789287, 18271071587538933317, 17636118140819937104, 18108284073799426945, 8364244323095764194, 13281114514187980951, 10491295715437014665, 1310444496377544831, 13888191830922343152, 17586897146784604748, 72700051670196435];
const POW3_15: [u64; 406] = [2857149036689686529, 14175379900903675190, 1401520348671872501, 16234776120238177371, 2962701845019208792, 10297908473583313655, 18066235025537403509, 1985963752685589805, 15624639389973621271, 9833928866606755125, 17745402233238635630, 78130099366186161, 12083669796004842145, 15173692294343262744, 9518028755097555228, 10655057306492369587, 10897270467574297527, 11548904126095768962, 16262733627336844205, 18151767593952348763, 950464694189644815, 6291554747973611516, 412611759298967463, 5131078896100319781, 11813629186150778579, 4930929854592610956, 9762646238078359535, 14151100457737951354, 9708371858765635341, 6206831854096772214, 11595187312349610475, 6063894554553047360, 5433806591902421653, 15615131202940708890, 5805566002014644475, 4620768948367927720, 9055048231872307321, 14794281338878642100, 14491705029677010203, 7725284928432884786, 5045913831328676711, 15521729565232894446, 3262592488400695957, 5860761651758622952, 15030937622342206574, 7453984232973937363, 6285625393700329290, 2465144476302674710, 8540406565562185120, 2124606755425251207, 15813845962394172633, 2477333097123117589, 8683731013287375651, 15551597013896998911, 13605714123740057270, 14643891956139000479, 16971916378338524615, 15119653078633321114, 7493370147962291677, 2678804130241001593, 13413059027227613678, 6036771203292121206, 216244970876952160, 17611436704967980222, 3304742578256495637, 6927085775538733664, 13315658962419865452, 16461637478880332520, 9159263971826645462, 3913462873965369515, 17857254079665575825, 3797276440638589676, 9647428625542802123, 5854328892645482296, 2742441761432302421, 11225733082991098542, 4731412809753060685, 17545245222905168693, 15240998744534217754, 17088932600994765882, 10442808830797594267, 11981042725675971866, 644023621331554282, 2253594321603903465, 13252024675441680346, 1124873775965929306, 3874314155656849983, 13892797440651273602, 9163903989027282919, 5017350417091981181, 11170456011312851663, 2813559808584014328, 4116812115518818307, 13702742319649213141, 9775591519475943926, 17735958355304760612, 3093666990666573256, 8423586328399094843, 14152162489874533060, 17134035917593418065, 11958464969389092154, 18193330560469652293, 15521397355562956835, 10283106949839764045, 18334295958623800517, 14145932412602810213, 1816204165436187296, 16755091554444271862, 13461743902646297942, 17785198157821483501, 999714903368483550, 4677242625481985221, 9910022434578132564, 12025413185432583859, 16127703755272276818, 7453627110909065543, 15703566422987747137, 7272822243903333886, 1972484455033885611, 5509585683682809340, 12514075252383283443, 11015910612262455107, 8794620302298645693, 15766428415367493519, 1711834399970520693, 15301284329794636575, 15049625973964155655, 15900259345481470201, 14664694545501816077, 3248323624137027632, 16327026424974928165, 17676983136848424128, 17594845293034422036, 3598462360111237297, 6164837332473491363, 12557690121307106283, 10109939069437709652, 12800775096878587589, 2264928308272583125, 13933925261096421472, 12872763176208350745, 17787668368194830187, 8570604642865953441, 7048709692658599440, 6754336151043341637, 2767582648225916208, 17089211422130615505, 7566542657417605506, 554454622829143337, 13636006234823920274, 10978927532226055445, 13620824993125744831, 15598312988352584692, 11333363185755496030, 10691411377887685123, 9093362498010697430, 7394222032753075205, 12497667692881492128, 17276437181405535039, 1967499791420895192, 13091300736258632381, 1931999432125026959, 18101845663395832750, 10737028481523317251, 12073559789498238872, 11600927278876301021, 15394915644183372245, 43690149765302700, 14536830506341517937, 16343918510091159741, 8885672906893606987, 13181764654802828998, 10684690211700734804, 11732832770256274611, 8091692846200747000, 11734231950782980792, 11641113657779633319, 6987987564428180688, 6088231683739768666, 16987580781422859898, 16746734300109643009, 17453062775533821932, 17841203839200805944, 12973269137781883020, 6739230905854879202, 4867603677078590158, 17071942355573399551, 16746958632169604933, 8042500730691203793, 1396863806740074599, 6353513291046703412, 17389378324433898655, 15224528156400861908, 14940329842914752037, 8087738209487611514, 9396976871403877261, 14675994089300772146, 8819403867934322505, 13266609157024508919, 587689721215471106, 1703005196134536966, 2562787762183549728, 2313037854415173833, 7657340139746646222, 11564317508629152862, 5177906634388746083, 13192072273283457007, 2386777937402525559, 5375420682092016494, 9601947856602884550, 12680741746175106873, 2647294323878177901, 16035270017585634300, 12640401596289815949, 914437713487483877, 5090403726355275456, 15014595474028671514, 2867550296812809867, 2226773502982296943, 11459138565640924262, 8011532628562544869, 10500265492658359708, 15678123494779554117, 8506283525418128192, 11555992027763787680, 16095828519246415965, 1780456502835650762, 14603503648175969311, 1023585434351191123, 7484428532864560132, 18418291991478309713, 15357998610942194121, 3327605184344835340, 10435521103325521382, 1462713553537928150, 17423946492822110088, 145809024559853829, 6485054502148338297, 17099341458460775434, 965188172493604392, 5942702139314563916, 18106401177866486041, 14227718483166825836, 16035001229177166090, 15848711243740451176, 8774453998296083694, 11450427090259705369, 15573232951905096870, 6377903469683679142, 4261188984466607964, 11623123875989409090, 14415088741163804951, 1599813716942485968, 10604599897062500857, 2841830536040670623, 17828418933022515783, 6008046665831459714, 1978729563784647133, 5039099535650143903, 1599933062843895915, 737781630230469889, 11776024369682400535, 959346849988973980, 1671320449241372282, 9374282794778072195, 5383646033852945261, 4082887125286827160, 7536093557609062578, 3037527067803905260, 17427494077634156108, 12901475821374563281, 12032057534999621592, 7153754414806200017, 11521738428893480789, 16840132959828552310, 4951031368936021383, 10312972927109338281, 12434164894986795920, 16556791237464647839, 16220041076205579133, 18066959170754826181, 16064639237569846742, 1869073155250041058, 2420881339938507528, 4916480328379338711, 7578061351847790663, 13718055631926778314, 8732707385537350434, 17405133998566250365, 10371421237885974483, 6574583501129588316, 11300582933137231603, 282635628756722916, 10023070438431334382, 14272941146175213443, 16447365197670601414, 16041672552242935265, 17831407565973892034, 4182576405085205587, 11489328974408614647, 5035552335907170388, 3828974546045291137, 391913277838204438, 2817165455206460849, 11037533297049178580, 17170762779897421063, 2017484446390904666, 9021271920363221672, 11472693518105623921, 9501309554691385430, 16285283824493093188, 1703905920124801556, 11903037454242217696, 15395241027612287187, 307954930251028486, 11285734998298085507, 4846482603857718635, 2932055447754077719, 8481968243191684346, 11872001756632486481, 15833458741916767589, 5344561634374332691, 11307041361145532568, 18098034837345724832, 9473471699261927345, 12738480131881003004, 9318308383069160161, 14437880034370135329, 13965001776697565794, 17220068391430406293, 9769002565592045026, 14598113333382548931, 54463427733913003, 9653310437927051461, 18160027269831575495, 18079344490948425895, 15649431771668008954, 7638725635058075543, 360487819896943426, 18025371643700939561, 131193844645282412, 665347044270411237, 6051870096576101338, 2265594749826975374, 8499902357104734534, 11652571364819076154, 14239292171532033618, 13665821847127328442, 8018875021737294176, 4362889439394542905, 4780760689801532038, 685326272505554135, 852503507998133134, 237435172021779198, 5647410246788877101, 14902909516438526300, 11561729043595838984, 6580075114648231917, 3157148098482255540, 6292052703844876456, 4748907769001459290, 2759798991985961249, 15886889339845481809, 14517196801294293542, 15634118355276978734, 7602021282687142333, 16412875441962451500, 859131100574205952, 13679947396837903063, 18007510132633611780, 10281782328503563318, 16806051588047700661, 1764784474925535298, 5132268748786976403, 14007269090915984241, 16228556843064665646, 6786619220176084699, 8781872344617115798, 14818695140861444492, 3803689984658392692, 8867348272163989449, 4445582801996948090, 1814340225932887761, 7442302284644936579, 8934573719166517466, 16663117729942253798, 1945493944851571756, 6242849097309870753, 3003858696070588705, 5554724178452783697, 5784523079423192636, 16351163808549131589, 13851169259806597257, 10400584659272711720, 13517990180283491305, 5411389055160485541, 16458469570767121525, 13029575019242449083, 3390421090671316916, 11145730665637945625, 12769842855787723120, 856643283237865802, 3377708198364687594, 11148540603251120001, 9392475753388252485, 286516552283168];

pub(super) const POW3: [&'static [u64]; 15] = [
    &POW3_1,
    &POW3_2,
    &POW3_3,
    &POW3_4,
    &POW3_5,
    &POW3_6,
    &POW3_7,
    &POW3_8,
    &POW3_9,
    &POW3_10,
    &POW3_11,
    &POW3_12,
    &POW3_13,
    &POW3_14,
    &POW3_15,
];

/// Large powers (&[u64]) for base7 operations.
const POW7_1: [u64; 1] = [7];
const POW7_2: [u64; 1] = [49];
const POW7_3: [u64; 1] = [2401];
const POW7_4: [u64; 1] = [5764801];
const POW7_5: [u64; 1] = [33232930569601];
const POW7_6: [u64; 2] = [3475709467328330497, 59871144];
const POW7_7: [u64; 3] = [1843124298495784449, 15437065083437528094, 3584553906430408];
const POW7_8: [u64; 6] = [603000588348353537, 6625227153381996056, 14457317603578335302, 17567483729823316726, 11305168499310630393, 696547133562];
const POW7_9: [u64; 12] = [582341683539466241, 935252957464965720, 7598000487062652093, 4625010431675930147, 9224048018587399532, 13680868751916767356, 8922574898880355762, 10713662064272255971, 7311846544833571521, 7849590305058879299, 10093391657513723873, 26301];
const POW7_10: [u64; 23] = [17388776497041092609, 16457160058211406920, 2033260851521277314, 388183302058992872, 11702388862916293188, 15587415680696876522, 17031101678673454097, 13546772628478348863, 1318818236829654072, 13546125121584063508, 15808600474458000559, 12340053761285050049, 11573725793723298554, 6718505878150856626, 13954243453614827806, 16457462685960267285, 4074042241940842542, 2459465861860456148, 11372976075770768963, 12438879223211243738, 10907291956159364375, 3922778149643709348, 691771383];
const POW7_11: [u64; 45] = [17893919801682124801, 3206805966542412074, 991339494089278143, 13206340436150790646, 18033625394386074124, 16458343404181418861, 17068682823623086914, 17404038974574216090, 962547594831857602, 3798503919189056778, 10868579965491865695, 16037596885066557690, 15650701519890368734, 5316858967346585573, 1294049556640001754, 4351899201987763235, 17272889925200789554, 11628357220856409746, 8183184337517765892, 5628381843664522578, 7035887794254973747, 14841513942105928626, 14335113033987904456, 4216971858414870684, 10046451271544515515, 13714559003201406195, 5538475528829426789, 13395992984114831599, 5775212483408605146, 476243820514366277, 7043979434395428305, 1123299295821096769, 13048743086067956097, 17408198213811270998, 14736127160480877037, 9928220036139807386, 16675345951754369649, 18412518348195034899, 6406425587547789027, 4882575999668915206, 578900299059747925, 13250083076538589099, 2094116887459461474, 1275645183894667687, 478547646631948910];
const POW7_12: [u64; 90] = [14704542522817822721, 1908239702443586382, 611332695634661034, 16935085395232124524, 17736127977087465434, 11574241301399055267, 5823027105340961300, 17867009488740981351, 16348656808471078139, 16998423839097420228, 10609591466688569109, 9321504974414050525, 5278480101560703961, 14020203188500303776, 11864162492233692889, 17199512118478259021, 11362092576628354485, 3847370898204590091, 17126288518479724521, 10795558634415719516, 18062350854860133613, 17815499380630351463, 2397880943408320835, 11957809306317262075, 4223055476074955396, 16895069142623741217, 1458414023731884738, 14478520812823555327, 4291320715420414322, 8514090496211945321, 17901716023666967076, 14778482251275665363, 14165811673627054156, 9738219091708628549, 17670530737779529126, 18441890196349229021, 1430517926851965919, 4257604772280009255, 18025184073054564469, 9432558672249582826, 9643577683709596315, 10555481450221114804, 13124478177775831576, 11646845666206872949, 14548406571586152881, 141151896422981225, 11467171836679354650, 17545012642488291046, 14398743913477952771, 2888950879284581693, 13666904399237409328, 621695337355461794, 14166552457800910289, 10954834507641183898, 9677730810104475487, 14676264575249719435, 13008246759944130819, 2030706501610114848, 4897055351795194734, 3524240815322299211, 15993729733810538377, 8348875806346627098, 3621970447188199522, 1936527222884678993, 11992365621207994256, 8378409427045537486, 8371521441088447597, 6461957056912354693, 7577499642046353006, 17758468389980924503, 3665053575154184649, 17632504112159264165, 10287638585991044463, 13453018864877752149, 4986048915235721371, 8010577477677231093, 2566753874256716720, 13671175792596478465, 17399823534959146233, 657911218850639068, 18403822336734148495, 12555610471455063660, 14201739888607579522, 17742516903898228154, 6520371116357715524, 8544760306369341395, 1180972524889679931, 11918607129691019839, 12571893800880669715, 12414540429568840];
const POW7_13: [u64; 180] = [12366296415387615233, 11730370143930056766, 13967732971866448579, 2925064822323435284, 2785615026663960457, 9074767406787476511, 3387713669152756978, 16330772840749905029, 5004347987740918145, 1315322498776660068, 7136573792949781095, 6596511490066652934, 15328400376800820701, 4151285918184437031, 2722109124645525931, 12584201001210098571, 4801451632388026870, 1248764704649326431, 12119364074365100011, 5640226822887893893, 2466082534073732294, 9376326909146947249, 12674214251527350139, 16419525458752860311, 13141399977808101994, 16781245260594999187, 4673558965977830587, 1543269790139155142, 655848619610515825, 4380368131434905185, 17202266790808975771, 9897556520474296144, 186158812369995444, 10839347090923799085, 12422346061322264189, 12643626675592297011, 8939459572447991756, 16206167192025569135, 10652787480640468501, 6293507708854356553, 10008288180717595541, 16701596280546434665, 2182825862847259332, 2628366503764667985, 15959170117175880303, 15836457939481202981, 11143212174727211038, 11639730631195478348, 8604656216563733850, 290257727157156575, 10867525394732332731, 1400886510665911332, 6854704422327140956, 3741927266393244853, 12592994994270249287, 439863710787067670, 16239578794168605549, 9640756285361877479, 9561104718740555478, 10986531952367003721, 5612089266456309932, 5109766922818154132, 520998779395183753, 4810560545866637631, 7274850324832478242, 17740465167031001500, 13265097944367707437, 5648511910982105361, 1926944453539713356, 12405754124125155830, 8383831105158128438, 13034264539550437049, 6918089257970591536, 8857928391173216388, 12676875348889552368, 13731113671766870607, 6771449918166076052, 8756654551140551959, 13379197087459041336, 6347547918949812401, 3387083920238887242, 14306112307048422287, 11912069810554218385, 14551104752625294311, 13417676994193582072, 14897938903565105236, 17289003445441078886, 15935491860024724266, 10923257555407950154, 5770216580172492402, 6250010055206710577, 7113183740182564188, 16387949281660169088, 17091421695475875959, 2131077906426403330, 13839116851521344304, 8864920085113370983, 6149852328935262932, 15032054729326966345, 4079272632542779879, 18150912544137753996, 492094719586834357, 17582232315280964994, 17578774863963670026, 12416216660796818289, 302631016537865551, 7277572050364799567, 18318206792198604499, 8336737834969626066, 11235435284257084219, 13892783786080704129, 7289453266695394602, 6929315969304750655, 12953596354343027301, 14472672948577913927, 15139745008459803490, 1690846238072387883, 4955216932099385961, 16619071707385308450, 9480481535671607273, 12515534283932537347, 10261619361996609982, 5697090213210413990, 16942391088215900432, 3390999434243588207, 10353114664674932485, 12517229326878383040, 9850781917386990418, 14517298494686528889, 7573739014936709067, 9491858137805457174, 8611651487447140948, 3780787470485496576, 1469333660036523473, 15295174784873008984, 12194577480964034719, 15876198610592501565, 18166331529585637952, 14741475852802803613, 12569037466157958916, 3196162541872941938, 7948233786967345628, 8512552754069301546, 15113573103827111254, 11941684798565771194, 18265093358547574369, 4518669510372598251, 6791752066809298136, 16474333814242830926, 13472661237575196439, 16203356457439450423, 9015295329483684690, 7515397403580994501, 9717515703166204916, 12803427964745774746, 9813636653104481782, 12164929818934127602, 6797386733521120119, 7357244105545916498, 6517689230155891753, 4494756087209765099, 12574450216721428114, 18229699776525499919, 16540416958523241979, 16954357825433621959, 4441764790640151967, 7692257063480708500, 14819052434666854628, 16539482058519341923, 2489420457360669726, 10401109589692597340, 6501853965608688459, 6084336442276895198, 7104159518497231396, 5906434163082579893, 6565487219660143921, 12514992069438829377, 8382345892383208722, 9989560017558404363, 8354906072397];
const POW7_14: [u64; 360] = [16097952260272357377, 13130180796874004926, 6337999946274631917, 7806454005154593237, 3964779689212281839, 12067020790687221530, 993348543337434128, 456722304578047521, 6384489518616540919, 13656542509554516712, 7615813412761653167, 1522890313695650550, 6769281955844232350, 9000627954716615290, 17654875012081329198, 15585242463663518376, 2540047272071862908, 18010502217122882397, 2469241273316584143, 14522992147677403371, 3181323347248219209, 7412171862387734501, 15605977390940193644, 13732110206561584648, 6841310912708667139, 16772078603097906642, 3932701771162534294, 935552481945584886, 8928472931851695208, 439487408254902253, 3742108558531046361, 7467399779969413506, 6927800424520470433, 12319531680218572262, 2207523306292819613, 9058935655454630050, 8955262245124164257, 1695674628383954123, 12816266506087942372, 7642227795136877890, 5713091426437903432, 12455780974352151992, 9028911734769248426, 2629919507522055962, 6568953920878807825, 6441922329987167714, 1380860427454155323, 5162485348867390068, 18120478809550583585, 3557167691094160707, 9585556561423086347, 11140377260415831834, 17643371617081948346, 8803088719882987190, 15962382442107137458, 17063152676566552748, 10725484034242195865, 15709290609547120918, 9776802977956060171, 9641939324093396328, 8372300427360498714, 16896521492553339514, 1605503625113386766, 6596970146048364117, 5436155145821996359, 6773372136735004873, 2628016400388274989, 6462447048395462393, 15868096675813489674, 12969626573711253525, 12950483435176918975, 2262901692170033777, 7884963415598533440, 11514901661896874795, 5535814518946402213, 16351010394775660849, 4484876175662512236, 12156236651679611400, 15913616290364867544, 6253994434725726243, 1772728943040970532, 804279014012107613, 10394176623936067837, 17767737320216335381, 13651623913537429051, 2760832717800206867, 353270184060837729, 7447587540669411115, 11497513406571887865, 13223393344293563948, 2247898226096490615, 9953276799822295558, 12096075571540599291, 1817771230343237672, 18102535593989929269, 6414926188696218205, 10016339272007016725, 16879061665801594136, 10460900921895064914, 11085671488685598859, 7889552591773559932, 3021854743891978983, 4085994113907715761, 10466379589806669773, 16349849026994454109, 17352762078141175596, 601419915748930655, 6447353073228970401, 17995486874886165147, 6929880376298793509, 3669860551090646591, 3398341264769132809, 2301312788782735293, 14326873820728993112, 6519275883693387909, 5473548873407647590, 3920167345898264370, 10811801410884101002, 52970438849003295, 18128409130392095377, 10129863895205347314, 8320617748635348408, 15230404138270709575, 10425352779147164501, 8552070433977403941, 519705666637954232, 8524877583558787805, 8793834798035604499, 16167575759687524270, 547353747635705358, 2262756621184939719, 5991353929532280027, 10912415421229507949, 16483292131039576327, 9884619350958591014, 10734315355375469644, 11800424964188469136, 12058456212947390452, 7155400162305206791, 16135411518688007462, 6634167420807032090, 18063622714683533688, 2507242405996740310, 8259021275432108422, 12945670728782439874, 7172905444644909244, 15489103791052285055, 10418690523421072793, 9204769224238674854, 2878886988929159927, 14478321813784184602, 6580438489841406930, 17945679376420501907, 16001168065175441422, 10474823731535765832, 6505883723032583832, 7017424349503470247, 10427343442585095117, 7439465121266744247, 16183858348895227045, 6358193713503525814, 12702498643321358765, 7249764850445241116, 5299649406322709021, 481501828002012261, 16048956593771133686, 18238268908149352689, 2277566368866221405, 2801572749363642207, 15845862264899617200, 9806493542549254185, 13171331383548694257, 17811024629638326500, 237728575869603137, 1584918033186942575, 3458405115991025486, 14927829336143853235, 12029979567201885941, 11399400825819059492, 358387370090724492, 14249854791490390116, 14532916569974861129, 1093408639155183134, 6783598018720378728, 14819699618307406559, 6367909722180635812, 14209671311977258244, 9896579481722863617, 2097705012534014475, 17121704697625244445, 3622230343497336042, 17774622213911132212, 6645830483858889425, 15059793628035953495, 14525066567216672413, 7768417859699468843, 9442783756696131154, 10120202076259726556, 7383621149031122703, 6307316201761002780, 7381462566569701037, 12682904768029991916, 10325096036426052320, 12053931381819278360, 16852137193270511631, 17828141154092460989, 15472958372898633112, 10685946623044136176, 7058161217185270446, 15506112215314992523, 2603405286327598150, 14984285679998610515, 13308782686743905479, 13572243438993310066, 496660177568319435, 11998217866928295752, 15399372022516591533, 7172311566126579964, 4293481005014510635, 12973099906887367644, 14248415487123492423, 932891384243788852, 3467436302278130377, 1247673930042538006, 15377855697395121362, 3784510218690412199, 8104799035987075210, 12519062381270051133, 5495005024645947637, 2351932853904283156, 6703998543967833340, 3216210641055977203, 13199727672684370757, 10456834212923237043, 1800869797916367448, 9936934404567432636, 7024904587990317101, 17661047131642535339, 9058291675122015538, 667783409113178925, 5083781129445930221, 3556923738989951503, 10613572322633589647, 4350359409101468309, 1457548242871789739, 8885342167524640344, 10316845847952729828, 3477511179397303409, 16925069634451263094, 15834976524338260586, 15659523818281901996, 7434857577782550946, 12147746899654987715, 5668413592721689665, 8032830936493279200, 13617876313652185522, 5055982689745543607, 2058351167232943793, 2384018411882861673, 18393412178309349217, 3595687859588011938, 4724338838262503762, 88487996285581379, 12419469004964354847, 15029405122247879091, 10453100248404664303, 11815875067107019163, 13318783922657172641, 17063328775103766210, 15995177957727858631, 3337113625236935402, 12011245583154484308, 5612520138869104301, 14552133026880633198, 1836785609036632505, 1675725092902144711, 6557967504238413980, 18157671856133242743, 13015066162180778194, 4821635839614725011, 14901336225477334385, 18051437442300357744, 4018581868209046319, 11380431028641919395, 15494488453762803593, 2234206949114687498, 10814654735415792321, 11032514027152029919, 12840164818300226149, 12632990531852126959, 14542578197457741239, 5574572814530813269, 9039317489618929225, 6638367824881589965, 15204500812328294053, 8449286298854092036, 5629551307743247026, 14315632672578784243, 9863340608758860590, 14498396372357538980, 17230627093216409991, 2126190059759121396, 7282436405282076555, 16334215958199140859, 9821866104444108236, 14166990661167317903, 17954587786171925389, 8053187639906305959, 5818126477269297937, 16703671127253274435, 3325631217918823977, 11257142347483193312, 8493323319788741582, 6769867770236249770, 8075904957237992496, 18333240141647668885, 9489810858494556395, 1268788742819741070, 8183052026303658119, 1119184389843976056, 15756092335594419499, 7294561540061076746, 11472189890655343279, 17991578536803490058, 11257374986136473726, 15978035697189493595, 16754225317773630993, 13330871253108412337, 11006252491451403411, 7818512327252827085, 7606858841874053276, 7072722004561541599, 7738478710728317399, 9037822280667238374, 3681607021635297595, 12842201535468213346, 11539966054165267631, 10371391190118416727, 13484800967140291487, 11638839644475346673, 17502514434053797501, 16599166471406440654, 11166751072013296017, 12143045417492076966, 17258176312463112896, 16619606322400939605, 6748801852988009064, 7995536363981500580, 16541527472806327001, 5174785509933619616, 12207954298427456142, 8409687532898307371, 12212456215883038873, 9096953697076456401, 10927914225841440029, 10425878390961569497, 17598390738945121969, 2285822102408734494, 2102052483318711971, 3784107];

pub(super) const POW7: [&'static [u64]; 14] = [
    &POW7_1,
    &POW7_2,
    &POW7_3,
    &POW7_4,
    &POW7_5,
    &POW7_6,
    &POW7_7,
    &POW7_8,
    &POW7_9,
    &POW7_10,
    &POW7_11,
    &POW7_12,
    &POW7_13,
    &POW7_14,
];

/// Large powers (&[u64]) for base11 operations.
const POW11_1: [u64; 1] = [11];
const POW11_2: [u64; 1] = [121];
const POW11_3: [u64; 1] = [14641];
const POW11_4: [u64; 1] = [214358881];
const POW11_5: [u64; 1] = [45949729863572161];
const POW11_6: [u64; 2] = [14844108096902645121, 114458013083425];
const POW11_7: [u64; 4] = [8905530187360357121, 14477147077736378572, 13888007700250411872, 710186941];
const POW11_8: [u64; 7] = [4224151863064040961, 6237037915502622116, 15440260407910408871, 16124569072210476883, 12861392671514593715, 14527596912204933308, 504365492236294942];
const POW11_9: [u64; 14] = [14683225950600899585, 11312468005203390341, 9315594959014972904, 10842970136224308225, 1914369411386100363, 2491852204082726000, 12175660300580967766, 9414158174000630540, 12609863281556590504, 6489400440241531664, 117114288086471509, 1456781387136959649, 15696568929021680207, 13790214074759729];
const POW11_10: [u64; 28] = [17600486957711513601, 8022606290278406200, 8640958398179583395, 17727316401753491127, 9575607270622255189, 2072190441612624931, 14325854535236213783, 497551600749624034, 17635779223843169228, 11641721939423750382, 4105266644234922105, 801313456423024184, 16053736676906551679, 11243631360283463029, 7169921231119155227, 6535002338168290033, 1778184524698444140, 12167119020684722171, 6902101552327136471, 6183212344232315579, 16617944419037185325, 10187537814409491043, 3362267959182336422, 9478890853856662177, 9803115284869262977, 16725423551793776493, 10485792092922498104, 10309136586262];
const POW11_11: [u64; 56] = [8731580401360089089, 7641087749022849047, 7459296236447692961, 9800873921581906937, 6192826691154354975, 9444147789066284785, 14210506877018498301, 3094172356842321099, 668845366480580725, 3492266118122964796, 96529364629869745, 9893346702623899520, 6456488582816735915, 8976637586268446582, 4302897655204158962, 12526727947551740113, 17609142381680809349, 15544966799867548700, 1677652516887693103, 7438076216237633450, 8863297770664404100, 733574942719088888, 6432836854270260969, 18134376405202473969, 10804596744936031921, 17290005223842274743, 10127841390384582073, 13369091202704950404, 6045733069692757935, 5722147506200683549, 13713918444041994071, 9823962477355305112, 2537590973225324990, 17042268964188673424, 16176615291475221624, 16581342866083396318, 14707859061892150060, 14591066112765904256, 7871331706807351047, 5347059669077259657, 4619379623562433285, 3503843082012409561, 10443929285777752234, 397701103738382164, 3313093769655934608, 17836661706065908393, 1889144565928840696, 13914569287880052538, 14298154024944976168, 12924825459066648959, 948817799025216192, 8692209791762933875, 13408375962285646739, 8887158042233942949, 611198328255130303, 5761358];
const POW11_12: [u64; 111] = [12258111188078518273, 8688564386083985456, 2156380122306077916, 17836377793484015006, 18361442090419275253, 7263790696386055570, 1670049922837400519, 5718650195652683092, 8163040196717364521, 11363341172428738431, 4064482683668480453, 11565560735215538501, 2528171839334464225, 15361436207937868827, 7465080434366412227, 7717867788307812880, 2823048072521719884, 13528041730992648969, 9430876728602908162, 3885208255168570863, 6535820119850281185, 4461599089176575727, 18041982256587994410, 7471905082286866712, 17020017326155742614, 4938075662850608137, 4035468853066340626, 13821921610284215834, 13862027701123527138, 9154509599241848282, 16850885539955883538, 12575377137436317217, 8571268533459053559, 13898318040337272130, 810664620423602705, 7969335010597002616, 4286298881463138912, 14997259924918624976, 8264946895082660957, 15789931679311731657, 1185140025365085931, 16660324801169803431, 2556207960654942928, 8388838178441726101, 17971511442791836722, 1518280446620680356, 14933763998487830416, 15420564015868786103, 15035815882331303650, 3724518200777626298, 16798103199834126210, 8974893138557648076, 730818289427918383, 8722780918440509067, 17929755918867537992, 1146683209954232014, 17785212432311993598, 16613266046652518135, 9037649691952539401, 6627873182884077622, 333349853771469713, 15362796262717486532, 13172781257678513446, 15673083917296920826, 9067497080000291947, 1713297178691202910, 17708109588198440330, 3651774645063594416, 10886905812677462691, 2482233135585461860, 12616350414084702971, 1579459710720933490, 14708964334113467430, 51472236753600047, 1907397188939632778, 276838364253098806, 18166561361752499284, 9673362683923931093, 7282286593732476230, 11482488857388653014, 110116388352099354, 11985755127714364622, 11919464636612160213, 4471064793063388034, 9010412767207345704, 16783755977228655765, 16705665948206142403, 11178584287994817796, 8461284996706700993, 12105618960209776400, 16759015816474315541, 14855883815494135571, 11403006415320021080, 17030720119736277607, 7322697049602247758, 8785621568590627019, 1275438746651414403, 2735203210542683179, 6038898933195588170, 1829254170735016380, 4959340518011265405, 12942229586997440418, 14265112482871021343, 16789129922601896684, 5932357378257598349, 7466966399014766989, 11895041829419269547, 336661255594001888, 6380615258116690617, 11483716500585653909, 33193246385947];
const POW11_13: [u64; 222] = [3808821441094402049, 13950047456451507757, 9798258156629946174, 15394771717186026371, 8402385358364424036, 10643620587084864841, 770025935782707926, 12646401765719380359, 12902529371099697499, 4713071912651158781, 12808907975759538373, 3611787448482999847, 10792949668135085247, 9819656912719149606, 10402648732215573615, 3099634234087648418, 1303996289514071597, 17202252306428860401, 11799438143501747880, 5290182064440021858, 6787598363645614998, 15524626330776708844, 17793027940762140310, 17004880507537385137, 12841080511592520550, 17802074978586652087, 8690205948794188170, 17021225369825206887, 12214371232481703209, 1944672684319471300, 12379112297018720671, 7908417186977849250, 2987701410501237081, 2038965172598895439, 6761749950944809115, 8931536425641523590, 7739113602339379737, 10276676859270825864, 4439920731860331975, 13587872298826297188, 10580582791203023976, 3378600784962670077, 11537395749888529099, 16813363578673814635, 7891172225344211285, 9350831321289342668, 5510229781758539814, 11084856245604590009, 12529226724027785473, 2772826409583854511, 11608215440244732894, 10561403027736810526, 9440496731290372475, 11187592866459075264, 18112121354970375753, 9439832470996749136, 12469261181704230522, 14584009432264737017, 192113371429651489, 6754460669087876465, 4530800811863053914, 463470628453220004, 6297950986641494811, 125594562797689320, 11035677947788700700, 17623708510179728580, 15775324055817623665, 14674109028438731929, 1209923272414374235, 15577884694090340636, 12570728211257605898, 11561061063357213891, 4651057686655763411, 7322712693448232647, 11809200609224415423, 2420420028580938070, 17006922394396159292, 9184515882701633204, 5031231983598943171, 3111072846816492517, 13024060130177495813, 8355932088208869510, 3321002394274404753, 6300461667657000714, 17747131805136614222, 2747653135256732076, 3505709525949287103, 3538610109129548423, 5420162045976326785, 15554801802738338250, 14489399518018827597, 4850011043856499047, 14310910444184822761, 9292252647602881874, 11707256297859066238, 11303830017912707039, 9094658840273999067, 10586581944556291517, 17960495918206643218, 8670610157246630259, 8653439255149520818, 7568788909374460033, 13873931190982173941, 15819535526777069096, 15029981376872693308, 13847545477117570871, 18220433945128351138, 8622564884841603318, 10831197658512299419, 3482858466220293205, 7738391096419399681, 2388165370073725310, 4358050862883070385, 7507790034085095805, 89269209394697250, 13562217700279342344, 16454409421097177328, 16005524809376482876, 15667251180569804396, 5575611494182542501, 10430834717129143495, 11659407253092098863, 4895499822409996600, 6091211079131464965, 17808419333800129021, 9570998286801415179, 5887752729029264648, 4894808089110649255, 264445405266933451, 12074768974351470228, 5985747285239971975, 8930452312045511767, 581799560152189317, 17941120742042728911, 15817196956092701708, 2343261090808633691, 408906981660082567, 4350888852889124580, 16977906164174597996, 3989397226896384133, 11797852548640146128, 2578312619770412510, 7917095819269751495, 4230379070581724230, 13126041898733797169, 16968484606411437981, 11317889594303192129, 12648840019394002233, 3111186006688328723, 10706649976093419159, 14466617554838031936, 17470352306889372501, 18411469382383403573, 3153962946118390326, 1014317017884139082, 9067463626083157937, 9196385543164920811, 18341966026070632878, 2053546991595525844, 15511571668352276553, 12964932464667812226, 4608057668984183759, 17979015922850588491, 15888006382316848065, 6191253953762183056, 17159783485185120772, 17513047285830409019, 10417270127383690995, 18067596632167697078, 6209418964215319558, 6733592007390738336, 4568126052283103779, 11355338046799267184, 15425201093814830598, 16990348514482983138, 9671568810535511308, 13106810235011387032, 10809291324792942232, 2571942032983045376, 12245280439867659807, 16489897181110719710, 411658004810086058, 1868460854412176896, 11032950235885186844, 6344640398962141871, 760808458165149881, 3306488977670562423, 6839411434812535694, 16468028338001386174, 2112092371815785823, 12646741262445324147, 9993358993287357353, 15017076939767283590, 1499021541653222206, 12262422680303055865, 1052978976587305768, 2525637906577367832, 9375682883492818340, 2656458953615313602, 5575528468780549633, 2205334098316854237, 4036086244823022446, 15332220321466312298, 15262584590254458024, 12408741965943962, 2169913035744765570, 5194058381386770850, 18399971040889575890, 146441422052474806, 5815392231184153485, 16047228440717103626, 17392719586815490099, 14470688503267233324, 3774976851959202265, 17522274784675477951, 1352849022052684252, 12432653384097243620, 5555774420231729718, 140146492729849120, 5751821307726361580, 11491634968064100927, 59728242];
const POW11_14: [u64; 443] = [4861448979329941505, 14234964374014750949, 12324565570828414774, 1324814589202696928, 607244302112676228, 1468893317251208529, 11822532846329079123, 1772747872098596721, 4408320304397308991, 179895444459060586, 17377293528146141760, 1714298375615180651, 13727398619163416501, 15410259826864896954, 7039628146162027211, 13698063942247679856, 9196351222540173809, 4207522375895023624, 7653694298972214729, 7081904518120937303, 18126762283091340173, 1302148257619410361, 2278020359663609313, 17275960804927763932, 17646698674846864050, 1061665203398398749, 6021343083513264083, 10292895744609000652, 13506325232783503285, 824481431162821605, 7919324098292802678, 1985884143083030766, 6027199192564773665, 5488984059843063194, 6401554277696298326, 16250265188100062086, 15461151778850686767, 2152095348062875365, 8568875091076248658, 11535118345773079746, 5457225141428596749, 18105156839686949851, 1446204699134367047, 5940200217327425024, 4723404657175721957, 11332495094309303050, 11210916865656261972, 16263615410279778249, 6583355182287363108, 3474139183894197613, 1175721547224620583, 10014270463271451313, 482451149736938829, 12654754310346753670, 12060907194253820784, 16371222874844907434, 13724874157976399003, 9122955285147480236, 2424368639689405019, 7087904929142059907, 14595747643997040906, 15968581825605881645, 17256763206331601495, 17481768017051479863, 4084534300439740145, 17098776779575199687, 8515782993518578340, 2288291991277446116, 16299830825136238124, 8561362796615308257, 11274137098972488891, 7192165600378860146, 8978728286869674427, 13923828547777691987, 5832039018973580482, 9837821197135420015, 18051373213910634026, 4637098454786810426, 6240800240028283280, 7380213381432486022, 10638615442398485648, 9542889592286395713, 533439917619070920, 15976474426279470150, 13617284272561781679, 10276288751212140441, 15218655173862339787, 6727164750656390926, 2230801314483879028, 10021252070973934913, 1612778788739111084, 7041336484812664137, 5291567855310821299, 10626676180760950806, 3659645323342341666, 1545507752301941771, 14519585472656231099, 1280387026359760607, 16199734190462799358, 8572516678011533267, 17081096972675348465, 18297685214062940363, 14723211966654587245, 8767349579514427244, 12568842691268661877, 10504581466359364874, 17983973018406970412, 328705068174436706, 2174559131771944018, 2855491391269045818, 9009166862880166991, 10878402612077551096, 17264107070611546538, 223351840959114071, 5747868541617443987, 16012440336833037029, 4274888826175210215, 5698113987508239659, 2810339290159470120, 2010651586206732346, 9076087548247923863, 17009418387669523776, 16557728273782932974, 18384489959436541655, 15752294227131384690, 6195553920678090298, 13838306873320407029, 3997543181277782696, 13632792040016317818, 10571440041344215283, 14876573291975049851, 3879865230527161572, 18236798115142797478, 13052196600916404619, 9251700438782427988, 10407452028375711369, 4538634364832492797, 8910999848840304863, 10343596653804926032, 15132844029119797390, 7864786558078627424, 4854202622679318856, 14490496116897594330, 1922939018516173744, 12791865105402661392, 4920230059241940123, 2446522703407379623, 2719058737904468525, 9999578869275587172, 4836000489857180559, 5994605752061867846, 15083412007297361974, 17908574010793699948, 8603146064853266860, 13282523391143325229, 7479701421185277336, 2826652990638591311, 9442860486471380906, 13694763927822677330, 4070864902063801545, 13509688881300716966, 3995509851884739921, 15500907961429706360, 9795626114514347062, 1571980437087492045, 13142893915917944686, 9646309683012187316, 8777629042773692026, 9881264653716081071, 8508104196538675869, 15117475129918140690, 16475891468886709943, 9503794508304165687, 14161558219184310438, 10022403343962581244, 774772164966805214, 362976409323838940, 2715006944996371750, 17694596407445297762, 1213888929410517115, 12040552348230620694, 10058036256970099697, 2256146506417247640, 18164569340587724858, 12721263982171681707, 15380531655246048023, 9194447864364357124, 1395189177546037021, 8859131669854344798, 7692997617889865194, 17678217856577248805, 5051283006520813772, 11882900795697794617, 5447764509551475534, 3261307948022048285, 7015933502359776047, 12399112476339008598, 16628161813791920281, 4466609504385759042, 11527239354824549320, 14896865012286473085, 7446357960840887736, 615295693915679010, 15420865078772261891, 15914776189073358434, 10427386017406062370, 443797358218834337, 5596975675103798631, 6338038437211252377, 13233769772475152622, 17775197412637834205, 9102894931534069061, 13353703773597231356, 944019229681291505, 8977246688627596603, 3748124351709709960, 3298771011254639, 8435566979418350674, 11851644920285863541, 16324834267757928361, 6016362057210517043, 11654330633207158652, 1370135402791183063, 14777157798210096039, 10776086879308252035, 4433322625034727973, 14836526024633985271, 4685352809016622820, 7408166577780936829, 15199466109466461354, 2211473805549433243, 10171842521951063980, 12827586232103031433, 10952407668210671654, 4933370584920750452, 7319841716061281131, 17603020551770387193, 4427023795533149004, 5760431258666948947, 2628001461433152159, 14147963620160221164, 16099616627752170074, 3327193394265296968, 5368283717218509624, 9241571475776324157, 15640746428336985715, 9487035580372452084, 17632705763587892565, 12736713781685959613, 9971589274082832845, 17168262626685135304, 414500848950060554, 5827338905593107639, 8612815215356362343, 668474300455630914, 4491005903555927409, 18378927420991026827, 10011565531712440040, 14065786654535912965, 15958324543393833014, 12112865839706180370, 1348635633866503714, 18426905119685767107, 594668133275684728, 9061562651652632498, 16967293170698280657, 7468586466608959052, 457321426013996781, 14671934119177120539, 1665947187370340545, 17062037043693347693, 1454458100651286104, 9177597526745466448, 2182055382421138739, 12758433655523518006, 11620001244104019106, 9036694130892191599, 13166526811205530424, 7969601211618561908, 10556629472960027668, 3038682221177727183, 11625506627928375388, 506754098530257881, 10840704320944236093, 14587935551799268659, 388433678147809197, 3043986931365819006, 9795384084862995819, 8687753689379869237, 10535103462454142818, 8396429594174113569, 18119088061758192698, 16481009488626485359, 12663196266720378655, 6119147888683342287, 2161357170291219501, 10311153247653876270, 14620598843548926965, 9239718912375357587, 12103480311318159322, 11635590630179821901, 6497644388597848233, 14536941038281688274, 17370698524274983270, 4054446082565130877, 12359766469096244508, 3084254287251620162, 11510691519238341312, 14048480973982759344, 3550446225178059644, 7086785931913740434, 11677224635326405715, 6131139509691824952, 3681904041476043764, 14346955711384546565, 17310238062338563531, 9260860885029083495, 16623084050272570307, 10937240502080722425, 15439315697216607631, 13475090244496674402, 18190235497085877663, 5274480102891558646, 4983822368450167335, 7000097594073865571, 2483077929630858635, 2813775331710572682, 816911581587374000, 1732149738726002827, 16039777340190112897, 139765720276307849, 17733651201482295497, 4609725426879943425, 13913572179659651504, 3059450630507556352, 14807014575446128996, 5569394288100667931, 14375498051354007605, 7807598407780865484, 569701784442343756, 51797670586037983, 9504686786967003450, 9217951525504177336, 10879341428667564507, 8843201496576441510, 6249217303036338976, 2464461876712416813, 10963802434450345807, 5156833682864126006, 5467966583136449663, 2176539270699150252, 7008785551069887799, 6632700210090622936, 18144174610076905244, 8104595025195641764, 8971441915667154511, 6011391662547105818, 3983263972883013952, 3886620564818691950, 16925909445790200563, 16003748304083263684, 1453919995355324282, 4260654273475685913, 18138606151029898826, 16699456612278458717, 7446480364777014672, 10958728156983022753, 5139828146590601075, 17653479006349068371, 7536076115681831906, 7607716607870617503, 14560876409314381480, 13158870719256372693, 12393118114934470163, 7771763481698298794, 6134690783315422671, 4024072529465038927, 13806427607287721571, 11252219171378906111, 6594350577506956860, 14743085644471785042, 2975981301153091444, 11808661777650285210, 17608508176248613454, 6115964025237033355, 17110450100769106313, 1462488821698087209, 3710454816741289037, 11109359605802440170, 9388771030799246581, 6092804038621777855, 14553243641565391062, 2571790254273754999, 13291052400737486800, 10642591906992584111, 1039612743225989315, 2516005090382757510, 5308033042682329050, 5364406318072353263, 9571296697887995083, 4342141404806216855, 13824528048124185762, 13124734456838244282, 6543442858705932039, 15653401468778309577, 1274442923177363099, 5127571593148750493, 14406107908112660827, 13330511805319483230, 10395540962184514938, 6947918551182283208, 8459432705439102169, 14124047457577169823, 8592300886547817212, 17271922302251148279, 10015402479770037483, 18049226981662995844, 14922839348994532248, 16771406244013390849, 12917722840054563317, 18368817445375692029, 16168933425046355196, 2047740251628425144, 1315137751888759163, 14138764838763486325, 825695092163721671, 3055436360940615263, 1492572876028562170, 17854804685161712323, 13963312285969121334, 1022428655137937057, 17304775861198439126, 14488691714775008885, 3559022074931400028, 9803967563486540149, 5840733631497687280, 17464660925899346648, 760781807011823055, 11138978771366153564, 4500147140213882775, 16894960700949132870, 13586419147412383825, 3567462966827507];

pub(super) const POW11: [&'static [u64]; 14] = [
    &POW11_1,
    &POW11_2,
    &POW11_3,
    &POW11_4,
    &POW11_5,
    &POW11_6,
    &POW11_7,
    &POW11_8,
    &POW11_9,
    &POW11_10,
    &POW11_11,
    &POW11_12,
    &POW11_13,
    &POW11_14,
];

/// Large powers (&[u64]) for base13 operations.
const POW13_1: [u64; 1] = [13];
const POW13_2: [u64; 1] = [169];
const POW13_3: [u64; 1] = [28561];
const POW13_4: [u64; 1] = [815730721];
const POW13_5: [u64; 1] = [665416609183179841];
const POW13_6: [u64; 2] = [3919697708568696961, 24003111985919145];
const POW13_7: [u64; 4] = [10962733054231376129, 4577472700600565796, 4329209982584479332, 31233120745124];
const POW13_8: [u64; 8] = [7163256066462638593, 7700051585458762681, 9519551227927472482, 7477692841487206870, 584696450287827424, 4658499684880148153, 9377132942246373073, 52882385];
const POW13_9: [u64; 15] = [5365041021046080513, 8568544766453320380, 7748416443152478440, 5769290248959972646, 10008377727041243801, 13198018498029413189, 18212266078933409250, 11009380506711076718, 5042359334083314982, 16169575357398556542, 5013820542687223037, 13258554444064024165, 10433479404760757721, 8005776949133303266, 2796546697052201];
const POW13_10: [u64; 30] = [15836836905661728769, 5552771274265787082, 8658814385343096072, 17318436243571826118, 3795751027676562654, 5758095269786646185, 2230268814104946217, 5649141262329647785, 9634371443283913081, 8399134031292750081, 16632839205091735321, 12189472608495961105, 16123638117585320649, 13018883090882067163, 13128986057192585034, 6769301628408492628, 474275071893529293, 8353132743960307191, 9424925663763685936, 5941010392587702928, 16609754696905747741, 469146692787701129, 14215249896965005555, 3399572096990812063, 17120890880503935024, 12388356583333619404, 15914200145625827530, 16104732014018090148, 16284305993513564551, 423959556089];
const POW13_11: [u64; 60] = [10825245909596966913, 5227565081833453221, 5437827865970514660, 2634626693930470638, 7791313698235985478, 9849032823460265468, 8279658923777232819, 2060596865702984494, 10239800468899970474, 12389871316412402834, 12015992134249231999, 15591767937777349731, 8968525305486241990, 15957056669959365974, 17622202978596432688, 2850992533279334848, 13911194238700387305, 7313624275157161214, 7248853985706563409, 6592847550342527558, 14803786781037723221, 15705891050791155715, 8133622017774493950, 3696503260788519228, 11404213207295227541, 7921238562279668647, 6561067286176262477, 12116294961236065547, 2266430190702116676, 4730219264323966605, 16311559478903934441, 15455930101545448941, 3852886984154041603, 1776228360455975018, 10515676917103608918, 769509830092784164, 169766357296013836, 9287163347439286595, 15898564984627198140, 8447546082614091560, 13343187541130294681, 13239159875550645207, 5342398021613563965, 11665491069175159155, 1225305497339060403, 13879701978218296081, 15305333355503561197, 8456975261344400641, 7180678784195069454, 5067906964941909849, 566505528766750768, 13475675598626116704, 14181860841192586270, 18312773713633166526, 10688355960935327997, 13023469697192509680, 11097116550631752656, 13159483348597556730, 15077689778296524836, 9743];
const POW13_12: [u64; 119] = [11058438542103289857, 9247248103457281029, 17336009740870029295, 10323468375289993187, 1504781354816836272, 9554730237366408854, 8587566550324569666, 5183476223015141948, 3643122171939706098, 18400384628963318263, 3572669864495390762, 4229421147935839893, 3552241799096742830, 1854807433957978561, 14028317535707552152, 14877222599659598821, 10945729493178143222, 1448781112948823933, 7767106363490107135, 16804445247893060870, 226424419111212600, 15283830687743071085, 1487797500753650062, 10333864616775077672, 2737584982632672862, 12625267193455441790, 12281734660947652817, 17217123806808760645, 10929681892618839227, 10865969385290900850, 3332334426668184000, 4883636421309900493, 17621565163257567649, 888697704683033409, 6000007989952325470, 8694648489794675891, 6439324098338385100, 5055535558537034701, 17439774471630192755, 1890751051615471174, 8519817437827345306, 12812135280042016222, 11756388140614318382, 12847173998629383540, 3195426038228239005, 5408495899086602028, 6922648616092793742, 5190932152595381165, 13719540325198346554, 10629959409267319255, 8884268677394635427, 6247623128442836769, 3486276745613410200, 9922470857167696268, 14050590494518967213, 8995719668655130556, 14390840361596141419, 8805291080328413490, 1566519057385031214, 14936709980149037189, 7843407261302448200, 7362780728948899723, 8946431151602397981, 12379705824411818733, 10625136469958786891, 14809497030327428493, 9600038407435655136, 9837775683877496167, 8314234294629785773, 7534662661788740755, 17545591642159119367, 5386108291396711743, 10314959419729647004, 9921350920794026186, 5258567043271810200, 16619824962820676808, 13220627530497654811, 16290250367911457974, 8006465541051436115, 5091829719940545572, 10072085677397640377, 14112092657396804275, 330584062778878076, 15840181077086384365, 9433048095385237868, 17547222939187629580, 9003900423094679394, 13034539377777557986, 15200986616921766375, 5647363409336713681, 13477915035055474650, 10108372618673363661, 9646104442597003613, 15344302009281875206, 7483449034533484580, 8795188594332056720, 17885112742810008270, 6548243381935151424, 6302172644111584420, 12757561721076687245, 13247607995431226792, 2189822730261058939, 11438243578619214144, 14096253582179708483, 8235642739441819693, 17931433398519450539, 9927801953719909330, 9995825800685970424, 9124542719873359665, 17993527059507412774, 9728704891460674569, 17044025698547768405, 17484244453920345875, 6521328358485104519, 12029066764909652028, 8464592765225463263, 12597892885514076315, 14894106690171984976, 94941976];
const POW13_13: [u64; 237] = [1203553390770798593, 1609911557065216166, 1088829841559431321, 16845364770249289016, 13845306940320367243, 11279257715767435083, 4184517647422671463, 13618233420395390883, 11087029362168150996, 12824044226510429646, 15049709674611256955, 9950066500331292447, 14590365862096941747, 8420372193425272733, 13105392963450672485, 2225554786167414869, 13130811412339158477, 14373309974282704312, 1363934382124367093, 3493249700550808246, 198113603689650440, 17724195032260904529, 15510671998166755903, 9412112796161208987, 13107146209093962052, 14325694777197506385, 17290985315933150591, 12912300155233688889, 11888988617301666335, 16824020535296757095, 6656469285892451070, 10712076583117571968, 13585126715300435862, 5505357760921272323, 932014371801169344, 17265099438162165715, 9217420426919580929, 7386758858448837773, 15881425290995742661, 8589320880104585762, 12250041853446393684, 14402642887289062137, 15186226884070560626, 13685794765897176244, 17149732232508516893, 16958080657013900036, 446281904813871080, 487180674618228103, 11297619110741084464, 6872665199954788963, 8212455334907092516, 3332955197913213157, 6913996779383831253, 9143487460784907028, 16797670345194284720, 323102373846704555, 13352688140753214724, 12806526486837460652, 18268241912985161776, 4382411597157882469, 847659914389185987, 921514402521550321, 3413578678807403563, 5299255870322462778, 16593630186495530209, 681978374293965158, 17224675749288852530, 13657040160381442415, 15934597417946057970, 5968355591754377009, 10937621785845023795, 16336645948308360494, 12405912972336456603, 10056632425406120927, 9545350830397964915, 6230724639162649640, 1723225072254664691, 3264119010427044824, 12061938998424201052, 15793623536384650589, 2770434678443391736, 8742840120100988883, 12550260951863227963, 5656722295253371501, 15088774378750634990, 10962679145980624525, 10979536132202984393, 13795001474202318651, 4448006730336918867, 38671531538996222, 6160062839598287682, 1257541840742917296, 3178541894065862841, 12893034833167956877, 1545292770228628058, 14868485339772606169, 12433131052169805902, 1047624445068450958, 12830444186848242028, 16967079682316239583, 15300022305344409644, 2748688994970373146, 14437881100213368756, 5136001432521644414, 11557874420159275359, 9951604686169636949, 9105441558159706958, 12641802768889824602, 14749264964144337284, 7817863904982045617, 3274708901909362741, 9216091375878036934, 2785095739303537655, 7946462064155218917, 9880642893921977390, 7312919982913531673, 6798900350867994681, 5200771958630779037, 5461481497323024249, 6667251605971833578, 10862966560696237413, 4981305851286696344, 18405303816635774252, 2626422208612979467, 2524010639745371494, 9424627984561097090, 9388677451104336995, 2582058352296334392, 3461496597965765778, 6903709418194893235, 14168445877626931980, 11962515729592987925, 18225813165060703921, 12244528200070559824, 17676522228037342234, 15700092181859214166, 3977481182383385443, 17776841864312704000, 14166018271826904702, 12649693585479702092, 14565403646859767953, 18322287800489296404, 10322559522303048577, 17758462006476576260, 5032958958915733924, 12927847438191977469, 5419434607677467828, 10527444260142380542, 3401503835092434125, 17614130616565316930, 4810516414309631958, 3507848254831682488, 15634605763662377822, 9388453154499759721, 18065763110862168232, 15388918126425569691, 461692384970678664, 15850564788257762644, 14111430541734206603, 4994954389344485847, 10805375757737593723, 3961054096977611587, 10318887131642571288, 5743184960545772523, 10189117180961746330, 5622362617669878188, 15746304441183604634, 14078139847955519633, 1794138234269283797, 16546868410017152004, 4720044912811418814, 11715077310973639211, 15826706810046401131, 7575219333327213432, 3565823395965375601, 12590663819287174106, 484808767868101781, 15408998376957354637, 6415573641749871077, 17152492909023801467, 7980131495021249563, 10327931235324087527, 12249230950224323531, 10416259948363286175, 17501767217562082331, 10989307086053754589, 5241272896345779004, 2465467701083299706, 10074938103029299899, 17129430888733603970, 10855614832124598988, 14919221415520823623, 15256533446239181458, 9174981353474693807, 2174936122263534850, 3154260097308379950, 10106874050564863329, 1505468923052395092, 13425512187246481099, 14284746803028228819, 8441005310956645818, 5073973329263230999, 6010673567795215036, 8524322481505644754, 13229211917795335472, 3650375234546436406, 6742299890377516527, 17241811097427073487, 13687187275544022283, 1106925317233923510, 17938270309567737480, 919882561984985194, 10318700069693997193, 15867660097971050053, 7928187184457814201, 8746125163467766185, 8766735466984942365, 4349224684163839110, 9117893002779338032, 8425226445855708951, 12570045176103670012, 14523052880893323756, 16571364823704058491, 11810450155391964648, 220457475584251241, 11466805777400920749, 7189923430699012936, 10523264242029311260, 1942629354778206703, 14287715025778465138, 17271531035582072914, 9257960542134080107, 15668680892476791439, 3220052894238631189, 11648831345971031687, 1762690671166907766, 9013978960098995];
const POW13_14: [u64; 474] = [11001221296112041985, 13826034922266770651, 13489083541915362882, 9373283467586653811, 1574296081529153194, 8207827534493453592, 16099869660317043525, 8401454024036860842, 5202873459370842377, 6508035404547889168, 10590408588648330578, 13599124082937212823, 9434321195352883064, 10155515984415152651, 4051416326546982, 6681481629395179557, 14231271695377702163, 12307270831191947198, 14256025792262662724, 7001983270372916679, 17105157001211452178, 17527560855128134638, 14998745783366241801, 17190927521760669498, 5007035647203439458, 8853466165539928102, 16983632653169162652, 2037074113710105517, 30417155902682448, 8035056124599177390, 6042168278089742406, 15878770400820717005, 9722934369610784553, 15287047448505517637, 2820968948861209497, 9975818641012472740, 7182985748273685520, 1364562377225132628, 18296360144709817, 576848656767306379, 5955230672257124560, 7379015716094514221, 5718216123111898794, 15142142519635291591, 11106867854158898911, 16790919704601646679, 257926260294187969, 12448066541968444986, 1415233908419532352, 17902761823566127020, 2731664248199999171, 6237029798739583092, 6467722435243876522, 1299039604882059493, 398976867616281671, 7553870406036065786, 16934670912782359126, 1289086765772745842, 2613897624044659519, 12849575202457487093, 330113016788704466, 5757502493281968984, 7559306778079978960, 5542934425745706224, 1533151162646650219, 7421850702646697978, 16594798993445426776, 17897324178914914957, 9087172952624010028, 9066556304319215325, 7840945401977096023, 16922738906269128645, 4861129228358429263, 3295150432511268970, 10997859628130123416, 15343396175772034760, 1317816914573838479, 14759039390472615987, 1281922616905457063, 5162401323428780856, 9758372827512559901, 13619943009676615370, 4902989325629769882, 14949250806229852955, 2137627133258871847, 3709905021608383901, 1154230757852321644, 2959555194364826825, 2897568030266647527, 10875744904860113415, 11966155686055175906, 3702953058348919818, 2073451823964344281, 16085408681594082929, 10552977438191271711, 12514675473966984872, 15762256019488987366, 9071568391198829544, 10510779715864700534, 17587637550002829721, 15995901679724167395, 649433175885093709, 3126365131652797316, 3745803722635257275, 2740293817418522285, 2463647550353539666, 13911370545147095490, 10947209519617321806, 10026214067430552082, 3740391652626600960, 14726472218128771969, 7810795638644566032, 15550857298608943406, 3607017316420688105, 18121379695941633959, 16641977675136006855, 1049371298479392969, 6328311637329283350, 15114018247966121758, 14757563084213719233, 17935953705758344969, 13945851098450867085, 3301120041836373770, 3726731014553693929, 16919795808353174542, 15191793168421742042, 10179892033259062458, 14032663474246125256, 6962785128823785316, 5423606119058457628, 6691408130986499730, 9794856483701825466, 13304871226024279347, 6480974202663029808, 6184600061405054561, 15442528502365176705, 12005067980263272267, 5371579747120466179, 18232208518232842609, 16444904199311614000, 9190740480149943570, 5314651193942028542, 13629915964829916970, 10094255490430702491, 4315579360341753242, 7687187928622058395, 16633182809672350619, 15201840602062472548, 815169498973750913, 11465779781025816541, 13846214078933346557, 8203008060395181666, 13072818940317752720, 2094326092261982095, 1606992515386423987, 834319476160655119, 15826955984133679204, 17864292461931537762, 16315617099703841285, 10994678332850258678, 8182109064250625378, 5733101953484631105, 1701622557818523975, 8678005748388319746, 12559138384279305724, 2149920055961087342, 4679156372840331208, 4890945313952747490, 12341079351983382907, 16996522479932293853, 7167693384214142369, 64564806202024973, 13018947479033271512, 807572127061928419, 13169707104144669064, 1301780138563365402, 11171679016440668017, 10930338792860354388, 7503827134764867545, 3710148376837961313, 7346453468431038544, 17746186879842678411, 5420383338443940395, 4546493977089636385, 7541571235635047232, 5923299374354259028, 7467965462087563843, 8695020258660585006, 11830360506652846144, 8050617092956085340, 4951161648616577377, 7462209926343763823, 10469006123121960375, 6148873142691968891, 9391262262729762674, 11872107003184134291, 5508694767999789443, 18143120487909803859, 15524922245663613461, 4833182803128976775, 8244678688694015487, 5057226443534091947, 3030120199463773862, 13784827470316886596, 18238937241437302856, 13368902651824757590, 13315981508335635710, 15966818832176274537, 3085539072629787937, 9363905682672589140, 16157039694340711928, 9559531996628716787, 3150261223189782519, 8856439592903901949, 3091470400550228612, 9040155639517394379, 1371353811560573927, 12889247891890590187, 17049235564690384092, 16757584821310313034, 11758625002648909337, 7759573695080814361, 10097096795860409844, 16589854659233622964, 11934746433485305957, 12333524935205720205, 3955817633335153034, 4125327313510146580, 4568297301310197968, 18119174710384717893, 5345869971982942857, 494470270414093801, 7997948628033282961, 942666202323743512, 16437958288915398268, 1283200097456786113, 15332211832576291157, 17410164318065492694, 11928883664083256784, 9850658024400890166, 1733793683783473816, 12344212916256620557, 2819203097851441342, 7982443306230804850, 4160454682175014431, 13842251928901083007, 7808640267378970699, 13600668417738025882, 2594746220954726072, 15816048106874640762, 2987812975317503152, 12543491042227346886, 3826802535651268272, 15850960931252961241, 10017176066894286196, 6762101883533445749, 5307989341262880556, 4157978587800144642, 6777863180208783660, 17022038493314532091, 7273401959974654348, 2004648355965154788, 6047272893593882362, 1913493044036973221, 978875274625428970, 17120070580062738323, 7209978581865436701, 7221034171459879768, 8855079812911202908, 8138230977246452031, 15129746512467684403, 18239795630873686579, 14218049206967094751, 1741356195072171132, 1250348196747565897, 4844413968011903569, 3243911763561264075, 2270507046888594328, 1745972380732774692, 11611949605661118884, 16815810824338229786, 13149366465235705917, 12772769592611338268, 18127644775168346314, 11627350941001380640, 13085395823307950354, 8163261920636206817, 6668735979905409851, 8786125210795383444, 11923422846774113428, 9155009889104890040, 5305284880382256866, 14316398359199834891, 10541498030296982923, 14943515792680830022, 7917825939785758284, 15631466534941108133, 12920335454558214696, 10959813717540086952, 15729862033964173328, 13286222593245553847, 13004657081351788118, 2626602932514888710, 3065039904467636347, 12026579291253778633, 10563241431200478218, 2349397445393051973, 18038315903885496324, 14629828402248920882, 16509748883247899556, 17448613528315110931, 6572809837694703460, 18259089056305221691, 7345479003112781147, 3670992425516768002, 7394406571262240786, 1282899707141302414, 10361574807864457268, 8432084522712399019, 9712523964169320490, 3222983355808575244, 1532899133358693843, 17095626576899797785, 4716860293526059400, 6063867918555490264, 8746071046293822259, 1152651058829808534, 11648519557365373839, 15418969224994841052, 6940179054540262900, 8364720200192476037, 11673043597161346328, 8686616599861651722, 13356248813490536770, 11819966142617113834, 12603069758178319602, 1815243887937208353, 12760687437624258217, 12561294096896395018, 8012967678291210914, 8176121075751724519, 9435407884199829361, 16805827493862195416, 5129173037979284942, 7293708894884142616, 9864549789479883882, 7637483112799067924, 10579080446112035552, 9543557324069537796, 16314213310017096676, 10031098292690718712, 10164031712634739722, 3267823673232592820, 3136193050632781907, 3706101864669700413, 9460086010135946756, 10916100565297338071, 7173053772854990367, 2503009763637123653, 8217140079509149715, 2810622735802506167, 14280999559109874227, 1650648906925277119, 11045199590068177714, 10728518634165757251, 202850395640093662, 191152309499110130, 7571404669107300800, 3575303671359809366, 16004841872492895335, 2622669442037194783, 9163035080063833785, 964368337670138517, 13390118242819651871, 10448930796967671907, 17974688233878842982, 8159271893993050695, 7677697874118781395, 6794934973509989802, 2613774578300155016, 292694226148776518, 699325260027102137, 6009081017233518841, 4808972936998712736, 2623499327102215274, 14910930447682807849, 5154480565623165511, 4596781419765526739, 9164821477431395490, 12128029734657776850, 13627460724662533268, 11708733599451343812, 75964617081117142, 7751072208351631823, 1810436372569480281, 10593526490340800088, 2928831967240972121, 11430913332203388860, 3457200823898512150, 10207567760803673904, 1653252314220274777, 7888064959285737145, 4661569017137482286, 4419268922763370533, 9193738542267727654, 643779550123355219, 7526113752480014803, 17180488012839069744, 2271943469414029100, 9454167928806399491, 17263275688221850543, 3618575948507292930, 16875459308840290795, 919514450176394764, 16881770684872090106, 6500076494866963562, 8152684853826958593, 14423244243871580034, 10078630153364349209, 1657197671101659193, 16159257563350574568, 11738586755435346341, 12002324055030490736, 8776944205051025557, 16688420418636467722, 18149554999083539289, 13691303795704853731, 6963984469531699303, 8037230931167529001, 585854776801936318, 13296836435828448841, 9587336969956966916, 16672576742326658947, 1561024513249204507, 8757421682897192967, 12562341706736520009, 2676213381522479443, 16551135642207408305, 1381302543289772132, 13052332861289439793, 8931178299453276459, 17413406719003837278, 8660924170765933191, 5102370430756705633, 7670466310574234812, 4270146355458001205, 11500515934090134119, 364081632367892515, 1424227298276949770, 8173368021493932022, 4804288675503958208, 18124903500673088296, 5083514154075546120, 17409090338743953366, 14715725901254457899, 11902426688450673479, 10555493577098859529, 6930497058318651918, 16042130515736346985, 1716882303854684150, 11660820427629564676, 9737372309838229215, 13568955813836938774, 304757648521303857, 7833621986519686371, 3508169234872570781, 4668927750426144566, 6798315679163870904, 10649911868726982934, 2582989167030406133, 17973120471981440931, 15781752425946823773, 899757886429656950, 4404669808853];

pub(super) const POW13: [&'static [u64]; 14] = [
    &POW13_1,
    &POW13_2,
    &POW13_3,
    &POW13_4,
    &POW13_5,
    &POW13_6,
    &POW13_7,
    &POW13_8,
    &POW13_9,
    &POW13_10,
    &POW13_11,
    &POW13_12,
    &POW13_13,
    &POW13_14,
];

/// Large powers (&[u64]) for base17 operations.
const POW17_1: [u64; 1] = [17];
const POW17_2: [u64; 1] = [289];
const POW17_3: [u64; 1] = [83521];
const POW17_4: [u64; 1] = [6975757441];
const POW17_5: [u64; 2] = [11767703728247765249, 2];
const POW17_6: [u64; 3] = [11901479856962007553, 17684280322388389617, 6];
const POW17_7: [u64; 5] = [14949628490430014465, 4334809184308303144, 17832375909946066926, 7803766654558500058, 48];
const POW17_8: [u64; 9] = [8009457700659775489, 5864744823687262438, 11288212946149035610, 15666403803208012848, 545151480090474179, 4471958383658311826, 6377793695101289317, 14593165042794031210, 2344];
const POW17_9: [u64; 17] = [6230562379196764161, 3405124145050529442, 6672549857659104409, 8045576461241663187, 12485001784417160192, 11038644820189654219, 429283131511802281, 17946514039288555881, 16665292417367021928, 8217113687992683468, 9233390645811130670, 6282302448753559949, 10686294792075548010, 8286724651875629291, 705476786323852570, 5328561222396733028, 5498045];
const POW17_10: [u64; 33] = [4227612726968393729, 4761126626777682748, 11568710771682007766, 5571113179633199579, 5851565854403606477, 10308635839098688885, 16798960391526040672, 7869857980563782065, 18423256546778402415, 14203547828869553692, 12791369416689782508, 12876291981408895064, 15307555864783909491, 9137356882703048504, 3517233437621529783, 15111927952764162774, 16961664718059510463, 14099718551820868393, 16099826150732442218, 11196000002599581151, 3989192399412465526, 3152094919306852295, 8526189504144703959, 16230267771132803500, 14683900195084541313, 6568030588913947551, 16721463581699432323, 17147904814754118545, 16686796696251874433, 2966231010345418546, 2819956962494148691, 6325931310759637711, 30228501998376];
const POW17_11: [u64; 66] = [15846384477333766145, 17721259160332568959, 15268217993063608275, 3369257428568507113, 6849076422060632174, 1559939278665064961, 15149163351107375334, 14454902370960405567, 6797223075258887305, 1909847963587451314, 14199165546850971259, 15511683067408627876, 5805409519841271969, 7815958194823638455, 14713740033966179139, 719153356046425635, 15139191507293081965, 16203450164456674122, 4081196284567714938, 14758364217129439883, 9702794971545023221, 12711153795347319, 1201936732137814958, 3257934889304808719, 12342561217742503707, 2516924444893373492, 16911910252687000253, 17642443087981298450, 6171037733903123784, 8711207953117949856, 9491615688477157367, 6888778246783500957, 3846072893649681856, 11581388360545359451, 6615391846425574639, 8307688205333072650, 5082992663755394103, 10006915555520507839, 13748929870033738122, 13822220226590713782, 16155676614061297595, 14591432047590794740, 16180155903817834722, 1768962406949444296, 12415132256614504782, 8001327676754234197, 16938389339776157999, 13933254066233238025, 622533281476191193, 3284230806252073576, 7582164516679533000, 6954285079702638317, 2137851930352740555, 3838440653317478891, 17588564846903944152, 7450046277947452385, 17486325056255996844, 7770323824051307195, 12761289505732553996, 14760668822500286956, 864042941828465833, 7063455544966285626, 10470935038940623311, 4298754747365446251, 6129308493713104401, 49535155];
const POW17_12: [u64; 131] = [8959163060392329217, 191675492520161846, 9861768627217535660, 15373541761327164473, 4711124327161180762, 9148574511009427361, 6256124510954776780, 16092166725978353288, 18302892885771588550, 5554041675132576311, 6701058617620120256, 17741092924367331446, 17591967636758680126, 4424715011316294039, 13880932752311819576, 7314018719979239563, 2116064787992819024, 16117403803089837852, 4655954531271169387, 6834141459358892299, 3655460684868413951, 11462338205905151735, 10077406444200357956, 13130230130748888616, 5889899626778796386, 6132699084648918276, 9726807360252753060, 5247171256046325894, 8536133978436943399, 748382039249661328, 868011800140048627, 2772320414349939948, 15362211012728597267, 3382951323352826994, 8125886995900784397, 4017158398871576676, 7893480193554175008, 5573935412896544204, 8123912607352453095, 15714075234884286912, 16469474643299192237, 9241777800732816496, 6176630977917232021, 10797511347607665837, 15022344948172738195, 14428212684778821630, 6734324888653914439, 10575506900324831475, 16553245213985120509, 1257284041236233123, 3908192413356462543, 4564527608827375259, 12151764111397135943, 458175833548946244, 4096151054727360058, 7402916187011778388, 3229234406745339345, 4132007059461908897, 9663290448559559546, 9234229907084195896, 3986539845594665168, 8583252218130488663, 16269932014543485379, 5582927709185863709, 4156224254070092169, 10228700068637145318, 15289134047528690598, 12947151334886938785, 6341666219823015281, 15251353559696302105, 11243855513904347971, 911152298063356736, 5591652336349208176, 5924560756866900721, 16140991744705182053, 125421795282426929, 1732882485300281289, 566444319590466275, 13799487113002678358, 702306079806215844, 12074151907789264562, 3318353663331306078, 12354859459090774515, 17620576393983662297, 1780495445327301352, 13281235673007693735, 4616082378180806908, 17901748227341567272, 2255419658270086281, 5124911507572099852, 11178096695446382543, 10870988045866950024, 13317277910799673260, 1643374315321976420, 9604922605134795741, 8774236625624226892, 3140444146600578725, 13538194915004718302, 6829493612567060204, 18311602663646564982, 17830822296778723208, 6865079510397734800, 11402190682638191329, 4572060998450752551, 6421143019301485022, 1918017823683976379, 3115348749764798203, 11961373941157925564, 13683530668200002252, 4550096309857206893, 749653413096125507, 7130884266445741772, 6909992711640903849, 3823563730409373012, 15296311858043646555, 2274049411665268452, 6013473541626923118, 6919079438080853997, 7448520711576428686, 17407348002788668254, 5722106574277061894, 2073438185679237707, 5960334185761856144, 15386035660141607389, 14462253340111213632, 4103115605173323406, 7271379120963975286, 4817823530239772404, 9462154710072633015, 9078581308959962399, 2453731613792164];
const POW17_13: [u64; 262] = [3453493696249004033, 14526017207175330164, 5273243693336234366, 14341733444399718434, 11415496706593102501, 13876706249671608639, 321363226988254866, 308962417931214708, 15911336303095720984, 996824685256301228, 15677982801565030214, 6203109012714328248, 3577016848774547852, 13751276889057797017, 2249578892878439932, 11649554284292177446, 10765186448076743818, 5028446022824535899, 13333281916584181132, 10600832506166696241, 374609586480556231, 8837817030667441504, 12522209874183140446, 14887407680095266206, 7878449496481078588, 9979151851659884035, 3944321834529564998, 13033175757373656028, 17034680569138281182, 15337183806926405103, 14234796339765425125, 3659046019752366622, 12319550462837266669, 17372995233808427154, 3220981660259398548, 13600683337207885152, 1240229990393705526, 2464512451689236607, 6090545387749947476, 4759164737740380158, 13567236852469529802, 2223785365877143535, 7731405295463554874, 13327676158848262579, 9927763461166706695, 16371137271828264195, 9390760318458771698, 13825879733085872998, 6108142823395892079, 15000480047604873784, 8138808737293537674, 795303861000927288, 3431326080676545410, 4094275192551237205, 13807846055260267478, 11022809290223582560, 560783138310981946, 13540845070229582961, 5857694737960376790, 327355669609233992, 4238227645838412351, 7646313024116194751, 7285406168992098213, 3897249497123239660, 1073602066689072866, 10857882633873024923, 3362934076454294000, 5212916866602033072, 1725307266225281544, 11955500225774178853, 9633806680133782119, 9861276272964407887, 10436361308193547820, 13840240434718659608, 414167629521649992, 11345570322302018903, 5390463353510226820, 12795318804701548501, 16202145356757001200, 2812273960567726268, 655049091438802107, 17231723169691259728, 11082101123986442539, 18443629319620178059, 8309590386389515990, 1939372487602583775, 2669920229543028106, 9556943150854048846, 3800461242298202654, 11832491830257986646, 15816312406128203594, 10153636748224629883, 5594191127080816557, 10269374132501948068, 3794848301519526269, 10057158154152845822, 12748032332747561749, 10647428812306673632, 12741110773301132710, 9155522279676869496, 5313772790584689660, 7936007289057905531, 12052079759835667301, 4632728627205541802, 17383578792221334953, 10038814202371690444, 9003685037805387593, 12038898373841603014, 13499198510584174522, 12140117105448917631, 16941108449964135680, 483272408134465939, 12464071335974555547, 2020642769228549477, 2264497751077711576, 448403399328266180, 12744589264497159584, 6370660673588569542, 14314471902760634029, 15996423551881056631, 1036073191813529138, 11230341400851904256, 13774244195239257712, 17877112685551479552, 2141857429346143824, 13804636919441295933, 7714753020686541958, 5541153521060002318, 13696369674662283266, 15986267858624178941, 5770580672437871734, 5544198272223268859, 3166932195878070274, 18244824934193415238, 8263359853692574304, 9896504794358422619, 3154076072347406873, 13356341923311833639, 4311531226105996129, 15827733439051006549, 5628573781578495108, 17183082566167736388, 9020640082123933088, 10068398142802300110, 4211884241116479941, 17530527679573489043, 11376944817997087233, 9255151802627062249, 8057850084867608822, 6983268662492669940, 11504853929838981371, 15678682304000836697, 14442617427776347788, 9688392016774030261, 13586354197343885967, 12909584926447299726, 14603220715827301809, 283206376923126647, 10296102240185384275, 4944543490257020180, 7146538787918427487, 15164292249373632032, 6431532434800671082, 2449416194845629415, 4432030625828233840, 6139962560278119501, 5250431025208417075, 5548467511879587586, 10715590260985086579, 3338041801736609361, 17438055901318356005, 6853670436702292494, 16372824264222855267, 14686430409410397439, 6868381658089998765, 18292642808321975035, 7274352449373431955, 14983250044603241917, 1635779988451042236, 2678323226758805561, 351774090608032895, 6392639507683575772, 8324642828346497619, 9320673411977431015, 6260021926778537127, 6348556698199682350, 9195546093760306927, 16769138414957877603, 961827998071396233, 9156524616979475039, 15673386381176476794, 5442214397100570582, 8876830942353946570, 7311172727612586526, 8234482784752016105, 15306778849167016468, 7502009653802519812, 4712059500290642977, 14423360925915259766, 1448744954666221572, 6078860174888560856, 2720672009072674462, 10318145048288136827, 18113229674157472565, 6404256905911555919, 9257257400021527557, 17686983671329440628, 10106377461913198073, 7618967566971511927, 3760397855961663847, 16813439320983284451, 11493293337594424887, 13179725129734599832, 13849366199944841585, 15065993544969198538, 3120683522238678144, 13763881560037094390, 2829296345720252421, 10712566716559778109, 9875922995273184600, 17632913709150245841, 1202466900984995006, 8056344660482507190, 3674707261944432957, 17295864791525018378, 14560273084621476982, 13048445087642742990, 16218257899308673711, 5655471326288357633, 7328683466588010193, 13941334933370497582, 552563626146860996, 12709870039432658426, 1239512640748675355, 17778787651186157106, 5866197565252347000, 6122417430865487137, 15964656896633902952, 7128470856815954433, 1848204601345607694, 4778259156713161407, 11116574780375752896, 9849797082728023937, 5763971865884449624, 4801386319788717349, 9057809257185363799, 13940990906848311768, 6808284956768501841, 12321634604151815934, 16051364341293277744, 6531003425874712870, 12157585571810326251, 4608359961445944066, 17636826458037430263, 13336478188061285051, 12567967923923968803, 18226023352920088899, 10910669443286149977, 8614888343058296948, 5237316467097514822, 18201092146435758479, 326388158715];

pub(super) const POW17: [&'static [u64]; 13] = [
    &POW17_1,
    &POW17_2,
    &POW17_3,
    &POW17_4,
    &POW17_5,
    &POW17_6,
    &POW17_7,
    &POW17_8,
    &POW17_9,
    &POW17_10,
    &POW17_11,
    &POW17_12,
    &POW17_13,
];

/// Large powers (&[u64]) for base19 operations.
const POW19_1: [u64; 1] = [19];
const POW19_2: [u64; 1] = [361];
const POW19_3: [u64; 1] = [130321];
const POW19_4: [u64; 1] = [16983563041];
const POW19_5: [u64; 2] = [11740252461977893441, 15];
const POW19_6: [u64; 3] = [9107004542504076417, 9191406976808105505, 244];
const POW19_7: [u64; 5] = [4093619427583084801, 13957234897430346681, 1664550439794844065, 7427571119310257990, 59779];
const POW19_8: [u64; 9] = [817529151526638081, 11061274887526630745, 13854936344412371742, 2590959186039059915, 15775445760697030947, 16331670318820695493, 2071048169989844021, 2278881448906328646, 3573576981];
const POW19_9: [u64; 17] = [18416236736923247617, 2843296379787837318, 6729620708251823400, 12798876267615021754, 2660717132428076544, 10628885389055499043, 11044503519330130687, 7985224598569237787, 1457616077719484039, 4253722459635196846, 15778909568102640, 9133037468603004244, 10607875013481456916, 10405573357077323564, 16201176834369868626, 15603744466688166633, 12770452440016022403];
const POW19_10: [u64; 34] = [5633069569090144257, 15290206512922886739, 9707218376940875875, 1709039808364038994, 14035865001343459164, 14752003658582921822, 5082969893951651856, 16272852641206412796, 730258252848516821, 5788390706397880364, 7242425681721975223, 6952174348889624452, 6454810008803646456, 13619454667360554822, 658364721192818459, 13614738124954350725, 7590796877500647051, 15054213496588806398, 18128202672247203937, 1539858474300290951, 6852435336274526825, 13905822336907188274, 13057368655456895800, 4908899325321147633, 701112620434091845, 13513741133915280885, 4125718765320579123, 1751062884599762549, 14570551700183118526, 12097441747169335093, 13483771739387388768, 657201670406363667, 14630950795039046978, 8840826048816954163];
const POW19_11: [u64; 68] = [3868274050427817985, 9609965785064554795, 6362446737853125643, 6140304471677215738, 5944960630607158193, 14401685563426760224, 4560905396542113511, 2548913289596743873, 2195836196340464609, 584474905622497817, 9585394224313248505, 11836011876247902363, 15213425438825380920, 3815573032503586985, 9803347371716257639, 9461035088993310619, 5300156522097191451, 5918635114962373973, 12218486070363149403, 6449965452583488968, 15408535376151636739, 12466181625097255803, 10825828646380741420, 4121435683046602366, 2741973219018491560, 10715518326862115396, 15231389696256960893, 8350402888314404759, 11938803783207849103, 7726173741642165137, 9772085543297372800, 17846120431012455121, 15969961948968637780, 3682485160058388355, 10414744953778694019, 11287979426725105581, 301389775852099638, 8153105316773946755, 13425390638242950873, 6732727068684316942, 6570701204518578902, 1033209613870478974, 12613463344053582811, 9498960377609318279, 9420473608029820334, 8904730387087749961, 15951318581146735401, 5998702251292236994, 14539934067862285112, 9259413545972995298, 15565615665290070497, 11891825817077140304, 5906020157881929016, 2164104905828351276, 356616233133185022, 17409004541213955531, 5307453371472689621, 15573363977388344584, 4191162759449342083, 11493628618944877076, 17119550843961342139, 4803917594058321191, 8997719434483579480, 13271118517769149072, 17284093494109674951, 9909172166325359010, 2022791723112558206, 4237073215366767747];
const POW19_12: [u64; 136] = [1960352136792973313, 12915306719042846755, 9549721850741165947, 1794818986843879764, 10215019418910247731, 4426669725966792242, 5383828992808606577, 2001777283720954158, 15250541989612595041, 15876462925156345934, 4444313350329650360, 7926624381155763340, 14296416638539564181, 404793363532558309, 1200481957272550884, 15907747927139955519, 14671662520317250615, 1507208032879759849, 6851799916100325063, 8565727275049804590, 4689600023823228041, 756029801721980048, 15329091841300896412, 10566542626694407745, 13533481494481050317, 12874804700045844122, 1991448365425740129, 17353422221748742514, 13313092773583902835, 11497473115430563823, 13702285198855437096, 247010935149247943, 12549987517324888135, 17375207470734806265, 15821763063034448617, 12536204144939836520, 2357214310561288419, 647449256512126995, 3325003721186089419, 17452175399978474856, 5524709823518690895, 10175805100915607438, 12164264439256393019, 1182031409207463077, 11482720052668503858, 5809954311598707966, 1458642029465885496, 6652359116980107346, 17309444824431055511, 12050041769952339412, 16720975861473443227, 957554924186800091, 859228806681068266, 10225722239085408727, 10959642869928201712, 1447446427562697235, 16607278679201454416, 17474996716956937081, 6539898828930260607, 8647993941424130124, 11076258879161498058, 510342348592251553, 16269428316411042956, 8555392314223380320, 11535418644057428613, 12051908495099828664, 2776204980897946502, 13126542370903926866, 15738254011086029526, 18379785119021048064, 11739425220439312073, 2854925554475372758, 17669770314744446061, 1437039477200178015, 18392564141500484039, 11145666968277950017, 8796226633411283692, 16023130302112197966, 10686203817595327958, 7557808848364814361, 14885152611388665789, 9900024034053821768, 1824284327392229733, 4209142342116784665, 13654828572915005029, 15907904975061311313, 8737388517806224363, 11363958266183929021, 10498302627208387178, 2754551711826034827, 2124138861016386537, 4335915466825829320, 18352003110361531619, 5269970246625732076, 12023298798400671021, 18385236477689900799, 8722836570358853256, 11267513616534803384, 6679741229755568887, 503544455235210957, 2391128621808331307, 3448315061963389445, 17136462553840291457, 1740673100858724456, 4392582926876629883, 12394647519023928247, 13865729469863724620, 416651680067900905, 10330898263527971675, 10645324120294157721, 6793220771642939284, 11760621930141429944, 5546468040327333541, 5022544873554114077, 16574061157558710524, 15088079029515873596, 2472930629014111443, 13728522472745411853, 814942555029735474, 9921434599477829181, 16710970458645597244, 9705337344771396803, 12085441819327374209, 16935579946984688668, 14477999081276262966, 9663727961641594069, 18361964884341760000, 2155295036902588563, 1243782721433810458, 9716419136897822080, 15251463038903931903, 14357519492630616122, 1719450790954065508, 15226663363792079469, 17581785284757192445, 973222665237977690];
const POW19_13: [u64; 272] = [10087636017330929665, 117629036420060348, 2257288031963526354, 2697080650104114613, 7317222843606800402, 17233645136066997926, 15215182557830513151, 4409679207039632416, 5551303152772086392, 10445654504756146421, 15631589513374389381, 16740210980841856961, 12206455894870582408, 10514915510066191703, 9798591746919096135, 9113014456766034048, 1915311464989266308, 5175862425342707440, 1127360680493692391, 10057398955950352231, 6891411935195458871, 12832839332288736446, 17524506411926026100, 14080098086345178452, 3038109464521314257, 10013456124587865885, 13142012752886403448, 4060193906554278791, 11170398590472031536, 9410248415261768441, 3755575703495444750, 1087894592984391669, 4751912188462049770, 4632624366515210386, 4457129870110852870, 17868371918426695046, 15491749089632868398, 3903129746649350010, 11730329157482703963, 13362676418965584486, 6226315336624364369, 12940628154440446020, 5995730625702226605, 17080500880567388476, 17034166135852711986, 12615388967880237964, 16607446377225295242, 18120411465172808420, 15787446299618211950, 9620043234196185226, 9126458288620594261, 1060614255342882962, 9239977131371698978, 12617828668535245979, 11181865063178680417, 15582511285421893496, 5987843678629960553, 17386244475857748072, 9888528612616582462, 3595464981086127320, 9367439919957030621, 8550549043264059628, 18085192502605262261, 15407796931651607761, 298328856447100096, 17421750770842790234, 7872501740568656664, 10448096615740815737, 14188815967734612068, 16693009861392493023, 17789600806338082050, 8336869697002343684, 2654789055729331141, 2555141400888163156, 16517047579880288931, 13273651777149305664, 4389952680784057449, 12975614287925853036, 240304697575882478, 6279305865397923522, 583873442935862603, 14813213709621671969, 7518402263083839071, 7699243630994338007, 776675925129320514, 3161721386993647464, 17252271088371083361, 9042895028327730598, 17863118534771035424, 2610310289260073738, 3068384401569065116, 18117743184408431768, 10425084636492659263, 3202757335665379157, 1876980547904382981, 4461954182467642278, 7532602544065039437, 17563076800501299785, 16143257408892335352, 6295024592838238576, 10008317046802168803, 14724124565313108034, 17299868711699727533, 4895465631912272518, 17770579402527327428, 2830029028298029644, 10615879134485394366, 987571403500865241, 9762544400969694173, 16653514993868016982, 1624757165807484573, 204841906801488337, 15777934803209092178, 15414314932377081282, 3650194213562170847, 11376615561640372874, 4557464199802833195, 3324722857207389612, 10111951260843269854, 9569735001807245738, 3059295715511503958, 17685235258966059049, 10517342237401591825, 354103831077768891, 10947529916789799264, 9338838995601614704, 11063908090907358752, 5723362756156006336, 14617726084547208238, 7886038541673275570, 13563265626626102222, 10034675999158421059, 14492040540975587359, 4398047127547358009, 14009874952125454284, 16164064201877844513, 12793855159126477819, 7950190962625024443, 13134601873605010989, 1026250608253301715, 2324027021264506877, 3119872640450254566, 16891471480735182549, 925759926631512499, 11506481750981778838, 17165776305519574102, 6814319562472641991, 13079239135144701609, 13141241223890729352, 5513306421473738820, 3582378349717660269, 5730906620900438167, 5394537897260238331, 16297735367783243747, 18080087427118476356, 17599083483868974872, 15129459250026816827, 17475111262689115571, 13344954397330229420, 8420637573042348903, 6046669001445359623, 16319645399226821858, 7074786781366394509, 15634023809706170499, 4898837957007600689, 15844744975808700817, 390847525575164812, 18085692917222692170, 3214633710999277789, 5716739820665318296, 63348494580365313, 3020400304882660879, 607738189972524142, 3443940450944203675, 15881503064634772098, 5552098941850988078, 9290710216213469310, 296915641757819365, 7070434908109555948, 1790837242415017211, 14625333403779272734, 725994173179639547, 14482331486641754517, 9528949187291341636, 18024708427413949800, 17288887229748136390, 8899435903106243746, 17988248052919925310, 6947402444577155041, 6102401349327815535, 918032569817073273, 14091169229233872799, 11678332896348850445, 16667100324871710602, 18115288876096386167, 13321458589949243965, 1376780814704062680, 11226929164225688342, 1125421141839018337, 12521336644420774669, 3682001341451127051, 15900803215858589266, 1303755909781032328, 12097295241808717981, 13453712991233606943, 7026470544640004522, 10100797219731824718, 975024424540019315, 5056532385317840595, 17368627541712270955, 16035680985794411722, 5191685044041583197, 16235840560737586136, 2515620382857515504, 12335718154665377412, 9544737571567727217, 4957028513530967975, 15302002767586093347, 9620354081560709444, 3374303816262012102, 17037564459266931463, 17870173137731539879, 16515953066203089454, 15562674195074515656, 8935015972508533182, 8875739945546909864, 7333409272073094393, 6788020331206760892, 11319443782736110523, 4138122615952700192, 18070206751546527386, 2940188139423456884, 11736344620252426560, 3955689805771896586, 12904996292254923461, 14498489684711778472, 7465801477785039214, 476293544341988621, 15863251123627035814, 13619655021727337536, 17848938041797888676, 3547454720950500944, 4020413785537927524, 13936795933949041379, 5075641280008027370, 15618965771410566540, 4101472574574017389, 9212270156760100154, 8555337216799006376, 9145279087076965275, 1199695991452739777, 2713922159954688000, 10606067813488973233, 10972936715516040283, 6899706460023528980, 17491134457648128203, 10151760599490889167, 5374984912989270420, 13366347060282661666, 14999762991372500216, 663520553837103658, 7911434487847740217, 1335775454177731075, 6970149221482062030, 13820800718039914087, 9335839211241611714, 17931193805554364485, 6936941694454344305, 3154923838389543411, 3660932139853271008, 10616240878179739562, 51345774210789654];

pub(super) const POW19: [&'static [u64]; 13] = [
    &POW19_1,
    &POW19_2,
    &POW19_3,
    &POW19_4,
    &POW19_5,
    &POW19_6,
    &POW19_7,
    &POW19_8,
    &POW19_9,
    &POW19_10,
    &POW19_11,
    &POW19_12,
    &POW19_13,
];

/// Large powers (&[u64]) for base23 operations.
const POW23_1: [u64; 1] = [23];
const POW23_2: [u64; 1] = [529];
const POW23_3: [u64; 1] = [279841];
const POW23_4: [u64; 1] = [78310985281];
const POW23_5: [u64; 2] = [8291383209427512449, 332];
const POW23_6: [u64; 3] = [10963214168556935425, 12075501357860292979, 110522];
const POW23_7: [u64; 5] = [6169747395525227009, 18278596701859697445, 10143526335361400012, 18052964393545421928, 12215257182];
const POW23_8: [u64; 10] = [2314350813275137, 2115025458154065526, 13012907653031611278, 3246851852016756117, 11806541200520375937, 9084306458261185492, 12980781886615526130, 7070004871468253888, 1638555456635168298, 8];
const POW23_9: [u64; 19] = [13383179381829584897, 4986775222005391822, 16749980212696255657, 4061598081123432621, 768049018947466739, 6592967522174005057, 8903351024578555393, 5486204967384814563, 6120273838388396482, 13554115592753033289, 298252933424703083, 5550726760273253541, 10004568017234232307, 10100413347317564558, 5353328459616604482, 12441875649480567710, 4272456035716489785, 7915690000692603790, 65];
const POW23_10: [u64; 37] = [5457725428155387905, 3409833822158792114, 3566505380784054462, 2655768856853172843, 13248675731579966520, 16540455438375496078, 15949305013218048451, 7541623142077085031, 4152324958281516936, 684303725534263216, 15539784438307811164, 17104371202110529069, 4199610698829860400, 126822483240641232, 12825510680015966874, 17554055574591513199, 12420795136445382810, 2909397580955509369, 16532645984425360835, 8048795052905159307, 6713679763399778455, 8784718149221564753, 8638710942521937363, 13517696909744801057, 10460807820795012520, 8671609146121531134, 5519177235896658455, 11507164353531136392, 10536607744046307518, 4355128376509778204, 14502975696374556792, 3603174206751281377, 11214401716978930513, 13457942323576995558, 4669213468679131443, 17865481055429874212, 4280];
const POW23_11: [u64; 73] = [11846125655129530369, 4808347477151537698, 4984465170536406021, 17773229190307726871, 9475540574276464039, 7490002630238673270, 12829219606569497605, 1855490239264020182, 18196368192375820573, 16807403573600054938, 169585650986432335, 1845707536133458874, 13880561038756938083, 15243237806662982418, 17942748340492775874, 16207312265816437904, 11750147279302913858, 9049742493468517337, 5322923673175149077, 12242456034673219367, 11097550052789754831, 15650059140797413691, 17451696301993982208, 1724791760067987189, 8425470383802962159, 445880095952832449, 12779890271826700983, 11510117651182442642, 811221383614412327, 11252917946439608025, 1966070912675922366, 9276698529902483041, 10006374879804156549, 12910054506401765901, 10935255376046483643, 17542193306785054322, 2799013365688525807, 7547447332198403221, 9611560566708938589, 18053657461852001840, 12739768537000605532, 15560568499051768847, 402026060965106606, 3813214866015313496, 13855420058731889817, 423347996799679577, 11974719557522547716, 12457578402889776404, 15177833050588247673, 17014151973003054641, 7069613605995695685, 14924754741116128615, 2833285700561124132, 14488631686198386586, 10053937439451005014, 3747724373394791044, 9081924864020352751, 3006643698446027200, 5686022571631760529, 6303984184389542219, 16918272220940077886, 522813575954678783, 3394026677636394373, 17739110856692301776, 9009777335823375089, 8767502255116089843, 5811942416715429553, 10946884817876382206, 15547247254446397106, 11379149715474961117, 3415855189674114476, 3865253181294437007, 18326691];
const POW23_12: [u64; 145] = [11622517936107175937, 7033721139220014975, 17462596640339821761, 13443677624106482132, 13859025874579068688, 7280878587045926646, 5383064232978901626, 14665433874378760711, 7894817074399567738, 2041528587491127549, 11289859072721806396, 15722851455311617147, 17458663791908953193, 11373112974961266550, 17352366949201397809, 13694086727170229938, 15463470048916970364, 10570279842741120227, 6648193649700737751, 8601822496984129799, 18372388903764790934, 6554882423490887366, 13042954592236188882, 3808659751122712337, 13864998361267667814, 4936550449154763745, 1828997440316703799, 14178484846094336273, 8300160226004005939, 10650947050425965462, 11583438941158443082, 8522319677650037649, 1151356073008628140, 1868932738148428389, 14506340656346284949, 11817243760415981359, 17232585953382863483, 4753502805182177217, 12140144073638385110, 6047777126866781305, 8813512867009582516, 16214160100477068190, 11804216147256631092, 16758964429489891496, 817329583528750285, 10447211405305514968, 18187526514453193878, 15053852564892683104, 8972529117610110924, 10074677660977770203, 2060932658913772713, 1231641879598153894, 149117274952849823, 8839750144015468931, 13870849855808267005, 8497006295516812096, 12073998247659205592, 5227293461699406659, 12456857656474561288, 8071942982843138162, 17759584873234692073, 12408149989685761605, 966007088006790208, 15511204086555671740, 2111665739818137977, 10118791289794325443, 3239481064035042212, 4492850046702593696, 13966441049549479584, 8189105420526375921, 13025230708727756685, 1193466212743701307, 10414023183316180801, 15671669769341094794, 11459894969881142504, 9285576284817450377, 12794423314985937539, 1582486651183691040, 1233523445429108177, 15381656572259224358, 5839925333982045254, 1160227998025674076, 14621523935478174951, 11529055784409423191, 12535556463298536878, 11436518289385212637, 14678182288623217538, 1552974345701158423, 4147998753782449281, 1927652060510564509, 15088149282793322569, 14255865993427576407, 1023125521444459005, 3970740624906031112, 6047967177082775951, 2339662716940436578, 14355512922095874245, 4822772729108678019, 17320001634075024793, 14809631814461679339, 5210330158728763310, 4884444728559559679, 7018200998928663501, 4298433382992520523, 17042941735629279971, 10927395923749774306, 2302500185014965096, 9771934668912536138, 3884184797462724965, 2168628345276262561, 7005561876375487250, 9886177363664049122, 6514828189616609185, 7449477772310456349, 15522543591036378582, 7825624973021338899, 1410365973364396176, 14168293017624070645, 1640393222821385990, 10010974317741386045, 3623106050347539560, 12167346593779104567, 14151984978845758374, 2484940957914386867, 14114413731052178462, 12818973764128383727, 5194198120907027631, 4770998095731015738, 15004991160144901317, 12053912103781953592, 15326435702098550204, 3772177951370317322, 8517749116120725318, 17878047395783878861, 2238926480500866659, 17793138211716196325, 10628224830211866604, 56513344983428023, 17124432907531586525, 10482976782550925537, 14366608740333918588, 9778100743842486673, 9759653953317335926, 10589425421842329905, 335867610689676];
const POW23_13: [u64; 290] = [8394090400973619201, 11964303563521419425, 6680726081226746407, 10953973454617762836, 8204153382229311332, 16254041314256517652, 5382403309283490189, 10294598562963672778, 6611673214344934182, 3108252571142423500, 591264897553799654, 10077880485074314447, 3324111534544969485, 9312594108209533062, 17640948814700965781, 6012379191488054550, 18444371524971204512, 132618783111387324, 5019449967207124897, 3549205104136494386, 10235095930753063619, 11320997397158549987, 10742490818317644895, 3187751223385388430, 352423585976925038, 8780916933321333442, 11561688232024544532, 4202008599615167561, 4487691813656735111, 15134695176258169105, 6690960709403211122, 12918310920993471271, 11635100276931512145, 17857812523909118347, 5686500615257112446, 494865271069226148, 14150027739975964006, 8995172384109705470, 15431220502214132213, 3591973263550772996, 16271017589500618733, 17711203169741269068, 12892034546770696203, 5900598767950539192, 14193592364934362760, 14901999759013903579, 7732732328927894272, 16475560904594101226, 8078965955741398752, 977645218519838711, 15832342418236883999, 10072025098841136643, 1358419459364144280, 797847689283391326, 14659537555179771844, 9896675821218330168, 15415516967802058517, 7968045175669056426, 7424233202721636956, 17848094697634144248, 288525173312435345, 15810972518254383115, 9299311067109640492, 13667629587352480006, 10303757103824097738, 6600213728598220514, 6218622672662595799, 3670031549674590187, 9716451342226392591, 13877815784478946249, 3113816061294914377, 12653023432091871432, 4481451666031891832, 17212931850927052728, 1308733032955890568, 12132175452048556703, 11965835958759012878, 16435282950624677626, 4886753010812848853, 4623306558254786620, 13328724565787069334, 10052593477402542792, 1287374823782162814, 13719253410664960848, 13940737455354227577, 16156794396241594726, 9406872663445041426, 14460695329812970433, 8147602052595626465, 9759086079357316460, 10770202697768734650, 12141428714491122492, 3479738801678607218, 4116552336811862093, 4664785535989027905, 6781810929589108561, 1453495303439479551, 15755570378614253759, 960995512121360650, 1320078744371634240, 14071283408344620583, 15873589170615939567, 11844318309681113006, 18209960901656184091, 5509787699837863735, 16057237111836286318, 12144799626465867039, 11301164228354554871, 15538809017861144326, 3881789278651060396, 2083726758011249379, 7242075601495698008, 16929003188024569952, 2637582047221593007, 6164192295857524759, 4324715935100466646, 3442312090445348770, 5482847019968621410, 14416139992674855236, 13766108847076098732, 17515176161144990062, 1472195265852816965, 9558656307272696327, 8860336721938319348, 10424050158232995985, 17735942241223068755, 11554220001439961201, 704483198669109564, 2932341443912568886, 2824738056487663018, 4281496866134446893, 17265437450258721953, 3681879345413845992, 11515194834409798593, 985765253142548197, 2984023863142018257, 4834135584147244310, 10515176357474522511, 7861156381474504930, 15513420229788668624, 5820797276345237369, 11750855905078856569, 12777784995909442228, 16086254035200170068, 16636829547693408883, 4302160437312317603, 7894749045828366333, 1529440129469432054, 16283118102972817572, 13551968615829143045, 14141755494036163869, 10202408444107256095, 16162673438713215156, 16480653606869029657, 12896873037878662327, 15675140110468513855, 14886915089358542684, 774257548144727721, 3121297763916484210, 11244674068351451742, 6136457775661368394, 8276608028813063005, 4328806852273184293, 10725793814173142373, 8713207349328170016, 3314496893276770994, 6467297917521019219, 10832668641628016315, 890510633050784875, 13522061147310988258, 9295062529110389908, 940274273173921624, 17713793344650807607, 2144115015919032862, 1515271528422120562, 11617268519367395431, 10225339851466026999, 18356608905542242762, 15747650718811748381, 14361136259390419567, 9521043180435682096, 7032180939671307649, 4766943856803433589, 1788903151609336531, 3067111554243386815, 15396974384403506303, 17635357051125839211, 18410171674236714111, 13006404946048489254, 10175048494319231069, 13695997532684394127, 15701030627417961230, 15625543174530632057, 11047121066749531892, 17248796765549407344, 14686939862573595225, 14467382368559107625, 9735007144341017943, 14300551919264430841, 12199685552486464333, 7976771866390972828, 11019782864537458767, 12325239107485025410, 7336145268816036435, 10317789320724881313, 6268969282673032717, 11187057720524651362, 10412317757966782720, 9957223876294202238, 14797474393797369649, 12707890408232218246, 17954169933651423542, 16261922616103793114, 4333510071491197126, 9148091121522839756, 12080381731581946005, 6771848631704086130, 1804305449358901527, 12855875845526226822, 18335367474036144797, 14793893678735463667, 10645700488999161160, 1895996504247616045, 2382164017483054973, 10552216344087268433, 9021719584181091192, 3380188034160414725, 6249703865004425795, 64414635892261407, 12377384963568233814, 7307438968304536980, 8966232128834474186, 6786257565852201597, 10068981359548525447, 12985487761061821347, 15250068204821929612, 17796166089646982811, 15383811979808576214, 5387278521333793444, 14111476944260561375, 6563576519556684180, 13695943457067318209, 6918562023235029062, 14754075890773412567, 858163115551518614, 12023362342021158858, 3730097749382796530, 15782336360183107402, 11828711242459787363, 6771555216470897935, 7119406591441040624, 11698872050004396496, 4286498256299825297, 14024971287426850410, 12627222004472030216, 10526038749734500455, 15799257125352115074, 16543575070263732648, 5360930992960858150, 5480478235630490088, 10740957876631647568, 10856615013881049128, 6337895592574874879, 10548351078802045249, 10770232544197542452, 17203053735917901567, 5544703280273301876, 473028986463327892, 1992348869891386479, 18106593888504158793, 14963463231368059529, 16888696108434515023, 3701215063285536555, 10706766752220176757, 6658893699890277224, 11422230761371528275, 13455493321187216777, 2936016201779625065, 10645596013106226786, 16327988970334155784, 14017806230973566932, 5319754173859118381, 6276196983172202503, 9141821856366243840, 7861511871015121036, 2669567714201173617, 16996968587538889159, 2361484064688056998, 11927883869173258618, 6115282537];

pub(super) const POW23: [&'static [u64]; 13] = [
    &POW23_1,
    &POW23_2,
    &POW23_3,
    &POW23_4,
    &POW23_5,
    &POW23_6,
    &POW23_7,
    &POW23_8,
    &POW23_9,
    &POW23_10,
    &POW23_11,
    &POW23_12,
    &POW23_13,
];

/// Large powers (&[u64]) for base29 operations.
const POW29_1: [u64; 1] = [29];
const POW29_2: [u64; 1] = [841];
const POW29_3: [u64; 1] = [707281];
const POW29_4: [u64; 1] = [500246412961];
const POW29_5: [u64; 2] = [16390320477281116481, 13565];
const POW29_6: [u64; 3] = [9728714693370925697, 6745052611261206813, 184033331];
const POW29_7: [u64; 5] = [5757371679635727617, 453419600393655919, 7471178055056504086, 16196800870886799471, 33868267053539148];
const POW29_8: [u64; 10] = [15498448609686505985, 1479573139064493249, 1836875582269835795, 1814411116202214481, 16009278822815034249, 3793936265448736901, 7182808813944114636, 17021911425577363478, 18016738525341173714, 62182220809613];
const POW29_9: [u64; 20] = [16095552165416375297, 6065906482531612469, 15846163999557365237, 8013973177636272531, 9907319438467333809, 1691774050185876939, 1506028245701941645, 4265451072064456439, 3529530588555872352, 1638853873174462591, 6883747855773278130, 11889568804655462422, 8456300052243942764, 16223290542744403653, 2762925283991841243, 253267985127962974, 14089073124764984418, 12127786193190370253, 10931184201498586925, 209610355];
const POW29_10: [u64; 39] = [7418542219833059329, 958377938827997701, 12488373186104909143, 12529661491707363005, 2460871112196890430, 13301540322674214688, 2373733691634663140, 11423959455316010393, 18281459953449138674, 13513136808894472708, 3823417341457510714, 1658370468200076063, 97467081071724554, 7848891007640526021, 17045665495969248851, 12096572349860687818, 2344094882925129526, 16190726499474487633, 8661974748470910973, 2574678668507283601, 3938614083820384558, 14341609184753406313, 2327685548231144915, 13092203624281047501, 5927048675101651312, 11029220976556497723, 16060534061541073881, 12814669207404065063, 16627810676372102119, 9026340843146512580, 15159190325393838446, 4023118401698046761, 11640539626749296523, 1550915222204822306, 16884085217527839713, 11861828186682004783, 3690204447908116734, 18297612114356149756, 43936501171648119];
const POW29_11: [u64; 78] = [2994516997653811201, 12691238007485188813, 6425373631596055902, 15742770753423678927, 12204372028205694288, 5468214848723792535, 9013064258242214675, 3705670445566310522, 6816135216491761480, 7579681604803045464, 4606613900336899030, 12532494192450120462, 10977305613949161291, 2925401003903444641, 11434821894394303238, 6370559474830540587, 3613465365096045323, 8572921874219622351, 17686337502642682630, 9293099978060864798, 17797128149100621552, 16155222522427697112, 3181967258345772623, 17295243910487365923, 8334446766563669130, 9987032240221668744, 4134590021599940843, 10649547782386712269, 17907870508952217684, 7350151663967192535, 13809504305637163343, 40380992378335767, 4555217157101625376, 1657389040493062985, 2448044455405957695, 14590542673302313551, 4276642375845923056, 8771354597287485314, 17699373990153521820, 9154659546877076733, 12098470914195334408, 15510274657315649565, 2945274152627196618, 15547292285751739089, 3863178779199140492, 18239280759876840351, 8951674302212815712, 5207549104253473993, 12829105964069607756, 15630099553755898378, 18350513890796580112, 16016692600961659767, 11181977692592568416, 6673218275992797930, 3690766535465030925, 6533794652243942130, 11732497937469914712, 852954069083677346, 15781580274925636218, 7313857007886670976, 16710172042874726789, 11335644921839334192, 17642364469799383421, 8287572863569889806, 16034458160023464806, 15733292827351475864, 7974299796479031730, 7044659385783483718, 3797189105432088351, 14466915282265664182, 17729930178773628819, 895573073497407671, 12206919607548026764, 6507363199240370486, 14755257268128867927, 15742062737932432583, 11995317340732918802, 104648068379583];
const POW29_12: [u64; 156] = [13624873453324378113, 16385905459755676464, 1524305801788745086, 10199785704783688521, 1105651907887017695, 7899244504136605362, 18415256620208376992, 6527880665753083982, 682595803567740022, 16971614856922076940, 122533806241893053, 1353874090500713666, 7700237657957992551, 11127822942621606857, 1117749882174310955, 1258597230258737875, 7588632863614073926, 13138370241566658389, 2944598617928471419, 17686360850888548584, 10802613354916448913, 3714169153408764353, 6097871342973394581, 15861447995882643160, 10529542217748913313, 5856668093475572493, 7687895863558019677, 12605086561069481807, 7359120490786328322, 5569552760021637038, 4610304421820188056, 14547599253888017465, 11448162300671493140, 11818860935063076787, 9024368236844078846, 17611918172934723031, 629058103025294072, 16402630757077520187, 3011120034874656385, 559434539294690920, 7708404193241517444, 11475885645249324855, 7527987534261502946, 18429346260451766463, 16647774408649527759, 14994162011800902093, 1602818183595944455, 10416127526769434021, 3902238027102980241, 16221439502904488789, 12728402492485944773, 16073041623703233415, 12059726721016275106, 7545575059158739724, 2799238940044439918, 1672337105562087992, 8637211310967344193, 2407781877381905680, 11081849713304248562, 6021357575086118725, 7805169637362728481, 2625854993373891686, 16225294581782396586, 10062522529509829562, 2491408246686350605, 16868477542775958185, 5432403930965842681, 6401086498452275312, 12923560148084435631, 16773315028203435668, 8787070119132526524, 6463823535577679823, 13155598264862568438, 5435953435295016479, 14887580091845909428, 5662240093801646219, 6061361103497749674, 16748987890714927578, 8380355601067159254, 3333305983278680362, 5659126067788145105, 17749870175532152657, 16165175331899768700, 10227145147339710095, 10044125302402649256, 15178477263894883824, 10894099044530456123, 14560109165216863917, 17383533091118876692, 621825033718554903, 10839534769243474212, 1967962613229464445, 8169873286726584084, 10782901860247460926, 17093800990823904246, 11498611700774056582, 12410146132732634389, 7417803587808478058, 18297046186195412975, 1574754350240276490, 13353046326481463290, 703471129273705839, 9342410231302222619, 7177988852693229323, 731499736917740653, 13443044161710177268, 10283780089535375364, 15978203559738560802, 7963817190382519294, 5669156970634321340, 14472164925629166220, 13004679628433896001, 9604961982380928881, 16097595907957091063, 8580674506874034541, 5991654135140835361, 4486972720692276001, 14599506547892476808, 13925166205172986588, 11489825356002091398, 11118067556437148191, 11395708967825186605, 3829509361757685613, 15256482687844263043, 16220636668955199613, 9899470830714797674, 16171116048998105055, 9519063829182808481, 14866997540493315924, 16868409756818216339, 1021202624840046466, 11782253385860110106, 2818200589100936468, 12919226415367876759, 650908069644921607, 10017441333456359930, 3989108944068656321, 960976354279554772, 9757599012852014139, 18114660057832184138, 18167793868128559825, 14505503950682026051, 4506577842976861893, 3490506407674121260, 14721352082457615055, 5606132434995114951, 6758734482506628989, 1949658512938374708, 9038022040851963244, 4539935154943351555, 14491940671051821480, 13570801843566854467, 10590637167428855161, 4113671608170033059, 638731029910275814, 593666729];
const POW29_13: [u64; 311] = [13672226770128551937, 4294585427239528572, 11937131084527655176, 17121705376405822666, 7266228530481644789, 12046326213228550475, 4555057994774087724, 8142229442681275952, 14928982525547024142, 10590848912065017772, 204977530255868505, 18394854911726948882, 18072147853711708396, 12984137044024706349, 13009557613879130662, 13437977536707178674, 17194519815234671567, 17880973136611499925, 8740997228436187796, 1053992851950062740, 9457052323001348307, 12635519821631166958, 7816877192318698506, 718974763720009595, 10506931626216910574, 16677486741239744144, 3231254992931774931, 8235433747461888832, 724496508110913891, 13418937453673984204, 8909291817057944420, 14418648484529316905, 18043014680750553541, 5725476447770531156, 13071604278662220441, 10277659562569596333, 12018124774190765506, 17648076272580958966, 5779739214397276354, 16650875990066234185, 17578631890048416051, 18245706186939598453, 8860678737288244932, 2108635465551665383, 12676314908233341203, 4285804123234359081, 9277371795036436264, 10891868801908629004, 13397489614092183722, 15564677338119485008, 9665683407829948339, 5488201562995831037, 15013749743704512461, 5778162266745605791, 14886812807808528790, 168867009872405748, 7700062651581741459, 6387875535489181056, 9217246679453129609, 11592490233993784416, 17456249849289259204, 7719671028608500290, 5776354603165235091, 11902258013330924579, 16271941308134810423, 18175425490570157612, 1348150720221513076, 5588923701320423310, 14347935746438536406, 2596293928414773985, 12999246088959114720, 7853618653032698111, 7428832709538391314, 9170615543668590681, 12873617114721415899, 2287308408671855195, 15460664247921730262, 1081523048631284839, 6151194618794128608, 11273222781436349088, 13797604919627813256, 10624352073641598508, 630071154717618278, 11372236940584293328, 1075063172784885024, 5353969557588737765, 17451750398327390218, 8847663264773559928, 14748776361514840683, 18141609447845895554, 8182248027890039495, 7740296117300250315, 9983411951252605895, 8838835298932336410, 15822882019381304121, 7494054417011587712, 9900741832494288950, 1884928955842835785, 14171827897630066950, 13979799510826257080, 13513518815078312459, 5547695969646569639, 8530956960051361363, 12925328754320739957, 15636981282003148604, 12380992638017772181, 5493876552103757314, 215260643889624253, 12599522812737008379, 10618136163261717865, 865812928187561342, 18164096494692425166, 4255258782059127586, 1482350852033754088, 2695674783092434476, 612994748952243333, 5350516409712278067, 10643337985082357108, 7767606074667599560, 13335853206335095348, 17909273832462095134, 348073511241936160, 14336337316615481341, 12294498444798592895, 3468077374887439958, 14752296701514702839, 11605240111110396223, 9912105850349709991, 12222362274483646114, 5500320934311332049, 965322882796551125, 8120198151864100986, 10385638565545610254, 11099447317438769075, 18145701608326972194, 9211397194147565471, 16133140126293610187, 15479595949832460983, 8772975857916812745, 1084809613596598881, 5209298234534478403, 17558147171719107828, 143145869814217375, 10856698203553984473, 2659417222261508760, 16776485743584819636, 5302132120190972721, 4179156032527653547, 10978123522004167617, 8616903826794857138, 16682110447672369644, 17408038179970039463, 17186638068325799623, 12586354934200162415, 2233353304839136470, 4604182926246550683, 15020945466130945179, 16882044374210881607, 4338556115610530951, 2548212077346936596, 1411947313359297892, 10760208517239011678, 12093507522709487357, 13250275519469800494, 17582234765715613618, 2587511047896745958, 9212232785325628779, 18416663261885415016, 587958984336727576, 16770327872208757326, 18029866150989284266, 2155188481720710192, 12170084941625609208, 13109309650505330232, 8947648203486222025, 5888408458257150024, 14610620042876969685, 15423269234038144149, 3755865284152467362, 6346866449393971611, 1048506361728426237, 9870704850560462772, 10902661774531812828, 4199023600185360775, 6841388119581862720, 13682397273260178435, 14451847431964184851, 9525153246333444962, 17005489543042710365, 16211222296998776081, 15260265402027014562, 7763125742878812795, 13979706248482079267, 8676877617572732607, 6717568554186988777, 7451376909733293094, 12743147316357600209, 14813987449073120918, 14803395224357306623, 6217191927361854763, 15651965812852718609, 14440004895152758631, 13270702150255333623, 5389827381820702983, 3735068664526592820, 10857318640694862193, 10376694890261332559, 3933073728848971783, 697722641169826892, 16654090227270876633, 2460452273549607042, 8139664584320228460, 12550749769392292878, 14691474813019701742, 8199888084316731628, 11707952462140957816, 16114347695442949664, 4254129723503068617, 13905886209486906303, 1678761750672668626, 3225544376917705027, 4779593219040896651, 4235756478245421233, 5843573772009581114, 13665134646853522957, 8166624769996657068, 12911077716854219395, 16031871157703988923, 17416979802078865491, 8935601752687330771, 8735956307554644333, 16225905211746171707, 4197301432305286566, 8217235209443529821, 6568145665602340166, 4703736038695943549, 18166481118991346417, 9055754601443772842, 14714094804941228956, 16920404788456306665, 16524115921513210483, 641311670008165827, 15278175775893318136, 4907119125081600753, 5470711230848082435, 7100440935018849813, 13548915853787394088, 13590896704726324215, 13419458591969809595, 12770517692189405268, 1682411139436089322, 16204267049714979529, 2130875000887245762, 3898148472505848400, 14808356779381968102, 12947547547530892128, 17093910043024869675, 4525420012639340544, 13406279992640413066, 1729931621875839983, 16399898141312950768, 7129430414049908823, 17055498123847510422, 5949333034669238013, 13172939620181146406, 11403868551726675873, 6758381945319437250, 4959899602116544640, 3030437071703111193, 7620094948025377385, 17953437088637383479, 430815515899335460, 8526143794481228897, 2011335460140755665, 1673153626059617351, 16611732881434813086, 6443513401833815128, 6356927152578677596, 5197550056219683564, 15117200294690211492, 12015247322584645921, 9143591408719695076, 16336687030934349149, 553766647123672757, 2941286556052681945, 16789397649694586286, 12086132202659948792, 6535544241266924915, 10218166389643100138, 17860728039428683844, 16698865587722179966, 10428296414771730021, 2472961343093658568, 777962589860353634, 15699598097617775224, 16945956761022060145, 6034890250215295206, 16824146588235996674, 11627609953984916638, 15085182234564679451, 16046485513580920525, 5649255435865038088, 16906305800633423485, 18391011698312280946, 16404185211853238423, 4822232346815630437, 2160504333581284492, 7990377947715144481, 1965670057026283843, 11174877963137540449, 352440185162671667];

pub(super) const POW29: [&'static [u64]; 13] = [
    &POW29_1,
    &POW29_2,
    &POW29_3,
    &POW29_4,
    &POW29_5,
    &POW29_6,
    &POW29_7,
    &POW29_8,
    &POW29_9,
    &POW29_10,
    &POW29_11,
    &POW29_12,
    &POW29_13,
];

/// Large powers (&[u64]) for base31 operations.
const POW31_1: [u64; 1] = [31];
const POW31_2: [u64; 1] = [961];
const POW31_3: [u64; 1] = [923521];
const POW31_4: [u64; 1] = [852891037441];
const POW31_5: [u64; 2] = [12662688596514954753, 39433];
const POW31_6: [u64; 3] = [3671467063254694913, 12907182779550130112, 1555015626];
const POW31_7: [u64; 5] = [2398592399778478081, 16903472776956642306, 6096611049602248745, 16636903787979198184, 2418073599280260060];
const POW31_8: [u64; 10] = [16495141226337464321, 5497467942242379092, 739419886143237049, 15503879009878095970, 11682331906096634316, 16633417005805376854, 5372896706229367958, 9202442005912433102, 563103204607180020, 316970838223396679];
const POW31_9: [u64; 20] = [15485542806247563265, 7902121530818837975, 2174706260711399794, 8338441619710993323, 5174276498274060584, 13896057508626164711, 18375211818704524752, 3771896122404979996, 8975237466821512923, 3719531891742392080, 16278739063660681217, 4597651131527345692, 2186070395957176618, 13296270632358335916, 15407783350388521641, 5218389564425962599, 16684214730241765171, 12778720639429264303, 4999906995294690253, 5446517384454533];
const POW31_10: [u64; 40] = [9917852350074830849, 17503880052831590204, 446078003314555885, 8290200544094315544, 4545662562678721248, 4773755696042207422, 11638197421469811125, 5583541543002688187, 2928843055633941976, 958885388170378936, 3769648711024405821, 5876476779803596179, 11002952954355201516, 13871000240735738927, 17280625944737162989, 14126363476369511686, 15540015784356269088, 16121873610546913654, 12315657342730701215, 6625239742322092255, 7267729338210329014, 7304834554893687532, 7448184685073964747, 13915799753354305463, 15532808105003034689, 15560148693948667263, 6702446356212876218, 13874950973356027931, 2487265240908372712, 7423364546851580592, 16542076444295774186, 6667557158368925022, 1662731694557479534, 9710460046131384926, 2132134259642658908, 5536099200409622432, 7079630905631896838, 15765425182381143449, 6981407756766447719, 1608118565565];
const POW31_11: [u64; 80] = [2096357348270899201, 16522211005267270321, 7477919505160117322, 8806055114386868960, 3103435049531657831, 3379991644164106799, 4737739374697149255, 9945960765085644629, 7776246301742102048, 17399545307872502909, 3336726592735577432, 3519304755566256320, 5275788180193374204, 12928214378342167617, 15534345485858271159, 9401077179437188119, 7195141385339960711, 7142093030883132565, 14543884843609752529, 1217720379423662081, 12850287365802214228, 17344347135107428951, 12599061754132488689, 8259746063225165422, 339910009266162020, 17918745758552077552, 6268582040783762747, 5426821636267775363, 4395733309604733570, 6358602157561990726, 11221739565428542155, 2749886157802053331, 3189270605149490673, 4790389046718542725, 1175431124796898032, 5749001033556578690, 6912856700960811479, 4968629094888695034, 5837635138599290090, 3776654629561458848, 11336701517692035987, 1984651411556410646, 6931043715203064840, 6837691805643163316, 14367990737348130710, 17276342136548545114, 3105185803291383662, 12596699258178437907, 6470695596657158731, 3602704307378790153, 11572324985684752652, 11114547972589521268, 1092394893621389626, 10841797182274992700, 1040880730761485215, 16711988749278589650, 5975456085549041101, 14905526063676943009, 13367279695703674516, 6835338110419533612, 18343405583925227682, 126856704539218164, 4654555027808343551, 5185799915572738127, 15883434376460367703, 10459236391563286876, 9723337164163736994, 8768112576670327395, 2997638480561109889, 14755828647425496405, 1773069327573470181, 7247206901800033682, 11330645768649999049, 5069820474999096624, 5080077807929860435, 2674467631168657459, 5381001373866890151, 5389434896896673945, 14715966782098618198, 140189];
const POW31_12: [u64; 159] = [1801767598626373633, 11369215895344178997, 10557430481523398302, 14729514228510065525, 16360921955454372649, 16474683228536923574, 17648663066377562214, 4616891103789060010, 11068143261721723115, 1986645887088002957, 13290878115429655256, 3688668928960070024, 12512281909781684531, 7202283709776267072, 3967537723985850955, 12079529339314160258, 5789930103522033008, 6446685030039335642, 17807119147724672441, 3657430757286952433, 4399435073983627112, 18080853932637710552, 4422312687427527790, 7041879709312349878, 4779369405315517716, 17761075356942561993, 6886785584079733145, 6856167696222472649, 6677149285262446585, 14128635321123954901, 2647749906943380861, 4947686821001308616, 5044767174651025699, 2000890117376226065, 7696974985933478928, 13698435522203632260, 12508923657400466359, 15708418517218618222, 17674087902574982192, 2599698632235115523, 2009487300431793372, 9152382659123644566, 8381623589094130620, 9360768865282788157, 7841634244523839263, 5142811084696223554, 10567527345171480010, 16587773482736315677, 2641488119964491057, 11283016081783311237, 10720423912347695400, 5033579150548247328, 13355273399754189136, 51107983476714371, 16767129091656895127, 13287727447102009689, 17540684169108840875, 16056898477225800826, 15452534119249468253, 1584338096418635712, 17835157847873868573, 15761939049259095748, 17731276659510811437, 15878595503172808064, 13541637914930966895, 13453653161442836461, 18167456091839538328, 18255511530115413898, 4918856903308235200, 149229284494812489, 2557715426008933344, 6329903885342108338, 7318037208799124842, 2088260064299365610, 2541296462169285780, 381201140083506486, 16076846840076350151, 8462873072785783617, 660968055866686239, 2714493904717207769, 12375607733044388010, 5072867669619256914, 423086081630114977, 14280478669225037932, 17938032817920806759, 18247594851371119991, 16179063841019022056, 13021457957149068932, 8911307390539096499, 11363387932840668312, 10741435924015807141, 10029008094449397314, 16074918609567735355, 3769485278193873309, 9755372283020856168, 14717290698284082587, 7570733972839733749, 4298417382024000897, 13903774150610302172, 15293354607334066454, 528520764411840191, 15390551811956009819, 3379881677203840025, 13637932214547525934, 17660189041724368123, 11806060371417074758, 15647766708173899796, 7670709915778958063, 14579010623960808134, 3115030890575484558, 6390827240047220130, 3093427188698038429, 18400204352832039125, 13284388778413708181, 15266311760490059065, 12555628412866282735, 7422734806867121800, 9917331904149950467, 7716622572140393442, 4308002630539149169, 4299292758073020141, 11078221702723102710, 7192518176606606762, 14435348804115821404, 13062353273716910458, 13994439988643223997, 78194093488871065, 16673842407064744836, 2523733938373131892, 17363625493235470610, 12985783305889285413, 5814006926820796127, 14725299958835250512, 9524704170138330948, 2092960985130703422, 373732450919540444, 8163480067992673786, 14148234157378013578, 3255522486897147875, 12881327932855308105, 6404382367598296653, 8614596466670346051, 12047324956663877009, 4172218920524389996, 4699362730392253186, 8713226888015588849, 3933801823730961601, 9823349397494488408, 4982238783101836982, 11481357151755968809, 4766978584604408965, 18106032764723837673, 15784602917188118646, 13418700349702360957, 77586404521456507, 14219791363337228746, 4890203053901953780, 6486956095841198351, 19653179394];
const POW31_13: [u64; 318] = [11650932410935017473, 17308825409233552681, 15496923541467448409, 1777718871702572849, 9922250554759274416, 12138026234393869648, 17452061592037372959, 8941120299606061452, 14366819422178367459, 12093141130691423854, 6120245025799833153, 4040279058952228412, 16148669873983246463, 11638143459508968866, 7154962979814798744, 7446144282266149209, 14174761033366019694, 11005543689910023371, 4128945788305534352, 7916440503096344475, 17070759717638194282, 8317155700235419964, 16931165184121652232, 6107946258706111077, 17731633154006971892, 9975717563530952164, 17543341719370900445, 9068983835221482709, 11415618862125602468, 13941086487558922704, 9635074152356732409, 8609049941205301246, 5471271126836396598, 2529439458376343483, 5604462733361525308, 5071787135380346645, 9909017897886427767, 15318475760261214863, 15316661691465834839, 7269371500803889962, 18032035088825185820, 9351894071296179180, 7343963840109365284, 5474046747747064192, 17481971361736150682, 5824250518798481785, 16255331231101793892, 11457017040634759339, 4426275110417427081, 1672002347120187444, 1975148498547535928, 11542057410017607813, 1220219139718878911, 3572598416877263916, 17006271185639766323, 462877625934666647, 5946847649902211805, 10990578101662644446, 7321273047908499993, 11548771999759168406, 4552759373643571249, 6618206790756389, 13316001433771606947, 75035747373599413, 10537200199427443702, 840767934414474190, 2777096646401916111, 17012900311823701232, 7015161044925147448, 6556613106909146969, 3157487824339572799, 11834930013965627207, 4150587971056738845, 4060390407706833438, 3984973614331228862, 9699637788294727825, 7098321630753042945, 250364221365032952, 12893847110117037419, 11924286071111309505, 8393083471154342881, 5603413628441508744, 4312581983296816308, 17817980376780588471, 7428707413480964562, 13790918846651350003, 16839134508576563808, 15143176246629895881, 26735050067619462, 5603585605129569706, 1750160737609386776, 13568704574413602334, 3781635003327098853, 12897395712756630425, 2729856571522370295, 2992033563406299606, 14195997516689513778, 7401541414450269, 3031650221770855130, 12559199617131004638, 8885318091262764443, 7265380638052772864, 1962471378061357844, 3684153597631553019, 10238664161660321918, 12783244908359269213, 12391242514324497954, 1023711264845355161, 12452432713654839765, 13284783342897209511, 16557260712252730343, 5308303541438704709, 2796444403386340288, 15964531828291706736, 17988431333681334980, 14050372967446057331, 2909153184171088974, 18271130663105232364, 17469865582643271403, 9235655978445445898, 15404258371539441145, 5414561797197130298, 12710970338328138283, 11348287294622669205, 13279912660231133205, 10006247474864908844, 387503936696045632, 11946706255639811710, 11557870632698008761, 17437329406201043082, 16453976559258974555, 18392521437799244418, 5518103827549465462, 3974014970850441837, 15906277221207084410, 12801233926930718584, 4858365996896405222, 9322063613169093288, 14295953691080547753, 9592792123651163696, 2307344178546710630, 3386463638913702994, 9746093064647197259, 17360792881978099646, 2331390749971078807, 67001271839132128, 15325146603819551287, 2212628260682394667, 3686351591055346926, 18444798459840663871, 3754055313895642917, 3111892272160209815, 15016905147277324996, 15249576022718612023, 9687562159637011466, 13620931157765942584, 6190446801315715564, 10199083049527776302, 18141268778130065839, 9194745994890263134, 7235857422137094771, 3039910200489081515, 5415376942362531145, 16313633954549303183, 16461609570472238153, 9135277678097989755, 4294200396551742961, 13873006430789283232, 3023341343724205072, 16180504954216000185, 16609282451833813517, 16147311299516906931, 3865431442196887781, 12056989559936082473, 5047870703145606460, 1325407901341138823, 3862762561046689086, 12154167808814600764, 13559820430591455007, 16360437559998671104, 7527717115571819358, 10716582562115872527, 11456000201504763720, 10701796272554334104, 10721370524245846060, 12741499625978911616, 14421778075231438768, 11779380118632710772, 5424719334131978781, 5139480536351736997, 17661687414527592806, 11683842095404036105, 8502752269926502292, 11859733037943709207, 12494735198665940265, 8407405997702413068, 4768364384316304380, 18319322834390557454, 8429150892580430029, 9956937433087180707, 15428189518856272765, 4992651218965591961, 10432854511240697207, 18332416995451783647, 3108194795607589285, 10895053723708853661, 2479127734352181541, 3680448758879590275, 7893151660183717273, 13698422782505760429, 9058264674841042271, 8173577806118979126, 15059606718923206684, 6303849893315995452, 9663435245565856532, 10386953918449659613, 8365072188147552061, 5909105025045825689, 7505410059121943936, 14835187236522959824, 7178542398798756721, 3244101273793333014, 7478293355884534482, 9936708530048724800, 7214296726988684118, 11442302058569190230, 9285606747893989774, 9168915157885784775, 16961770236320521450, 10874898498687269396, 16592277389624644429, 3007013275672248960, 16211270761002642645, 8955452119018187856, 1991548249560329806, 16983391470441275738, 156816301123428631, 16056306118076063989, 3636726870096591928, 8947421734000646900, 11102942016938080406, 6119525769550479573, 96726746357708986, 12936505540798421749, 9178050386743348451, 5620134833181442437, 11762276505007076755, 12761772344156536488, 3679038526545223637, 13345584437885106473, 16425398117968312468, 15232164270082349060, 9367625489982087631, 15526319758859232235, 226839740591401608, 243271890237418965, 6068791731053606502, 9016003892101302373, 16144441092544578465, 1664847353881709656, 17029558723917215874, 6610972717941396232, 17795795228359356713, 15173020102679721202, 16500332964522840314, 13262352098506638269, 5415683019436064276, 9845938604751972372, 15011664267083886298, 9302815697041392426, 10134461814529250912, 13782101968955909012, 2357979049692918364, 6720070569549937826, 9714100880431638078, 14744526615439393795, 13157593180412954939, 13358340127501549181, 7202587685441141744, 3998092887006896176, 12440695122666175631, 6060298862568659312, 1778062782693401036, 3101316331066515899, 15959362652679781172, 3812580654417274552, 3179751990173014075, 4800884105328080242, 4555909187188415655, 10019168566451086821, 10203906477086999803, 9709465268035298374, 8222943895049045865, 13975784716964627816, 14156811051863448914, 5613088360083362056, 6658023700600195151, 10260390177620906511, 7253822460209371436, 2005358072289035384, 10384255809604537396, 10612173669347199378, 17872559304263195172, 12918681865001345859, 11169532485848227142, 18410164066596640797, 7557387013661437005, 8074018520354688200, 1695402573163373447, 2388608657305224726, 3851803170527561236, 8478879889311201066, 883591599761019226, 267303269300772726, 14564461833813888409, 3980592300144013488, 17312578832377593806, 20];

pub(super) const POW31: [&'static [u64]; 13] = [
    &POW31_1,
    &POW31_2,
    &POW31_3,
    &POW31_4,
    &POW31_5,
    &POW31_6,
    &POW31_7,
    &POW31_8,
    &POW31_9,
    &POW31_10,
    &POW31_11,
    &POW31_12,
    &POW31_13,
];

}}  // cfg_if
