/* rygel-gst-media-engine.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-gst-media-engine.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <config.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_GST_MEDIA_ENGINE (rygel_gst_media_engine_get_type ())
#define RYGEL_GST_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_MEDIA_ENGINE, RygelGstMediaEngine))
#define RYGEL_GST_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_MEDIA_ENGINE, RygelGstMediaEngineClass))
#define RYGEL_IS_GST_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_MEDIA_ENGINE))
#define RYGEL_IS_GST_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_MEDIA_ENGINE))
#define RYGEL_GST_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_MEDIA_ENGINE, RygelGstMediaEngineClass))

typedef struct _RygelGstMediaEngine RygelGstMediaEngine;
typedef struct _RygelGstMediaEngineClass RygelGstMediaEngineClass;
typedef struct _RygelGstMediaEnginePrivate RygelGstMediaEnginePrivate;

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;

#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;

#define RYGEL_TYPE_AAC_TRANSCODER (rygel_aac_transcoder_get_type ())
#define RYGEL_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoder))
#define RYGEL_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))
#define RYGEL_IS_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_IS_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_AAC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))

typedef struct _RygelAACTranscoder RygelAACTranscoder;
typedef struct _RygelAACTranscoderClass RygelAACTranscoderClass;

#define RYGEL_TYPE_AVC_TRANSCODER (rygel_avc_transcoder_get_type ())
#define RYGEL_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoder))
#define RYGEL_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))
#define RYGEL_IS_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_IS_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_AVC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))

typedef struct _RygelAVCTranscoder RygelAVCTranscoder;
typedef struct _RygelAVCTranscoderClass RygelAVCTranscoderClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _RygelGstMediaEngineGetResourcesForItemData RygelGstMediaEngineGetResourcesForItemData;

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _RygelGstMediaEngine {
	RygelMediaEngine parent_instance;
	RygelGstMediaEnginePrivate * priv;
};

struct _RygelGstMediaEngineClass {
	RygelMediaEngineClass parent_class;
};

struct _RygelGstMediaEnginePrivate {
	GList* dlna_profiles;
	GList* transcoders;
};

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD_EU = 0,
	RYGEL_MP2_TS_PROFILE_SD_NA,
	RYGEL_MP2_TS_PROFILE_HD_NA
} RygelMP2TSProfile;

struct _Block1Data {
	int _ref_count_;
	RygelGstMediaEngine* self;
	RygelMediaFileItem* item;
	gpointer _async_data_;
};

struct _RygelGstMediaEngineGetResourcesForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelGstMediaEngine* self;
	RygelMediaObject* object;
	GeeList* result;
	Block1Data* _data1_;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	gchar* source_uri;
	RygelMediaFileItem* _tmp3_;
	gchar* _tmp4_;
	gchar* scheme;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean uri_is_http;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GeeArrayList* resources;
	GeeArrayList* _tmp21_;
	RygelMediaResource* primary_res;
	RygelMediaFileItem* _tmp22_;
	RygelMediaResource* _tmp23_;
	RygelMediaResource* _tmp24_;
	RygelMediaResource* _tmp25_;
	GUPnPDLNAFlags _tmp26_;
	GUPnPDLNAFlags _tmp27_;
	gboolean _tmp28_;
	RygelMediaResource* http_res;
	RygelMediaResource* _tmp29_;
	RygelMediaResource* _tmp30_;
	RygelMediaResource* _tmp31_;
	GeeArrayList* _tmp32_;
	RygelMediaResource* _tmp33_;
	RygelMediaFileItem* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GList* list;
	GList* _tmp37_;
	GList* transcoder_collection;
	GList* transcoder_it;
	RygelGstTranscoder* _tmp38_;
	RygelGstTranscoder* transcoder;
	gboolean _tmp39_;
	RygelGstTranscoder* _tmp40_;
	RygelMediaFileItem* _tmp41_;
	guint _tmp42_;
	RygelGstTranscoder* _tmp43_;
	RygelMediaFileItem* _tmp44_;
	gboolean _tmp45_;
	RygelGstTranscoder* _tmp46_;
	RygelGstTranscoder* _tmp47_;
	GList* _tmp48_;
	GList* _vala1_transcoder_collection;
	GList* _vala1_transcoder_it;
	RygelGstTranscoder* _tmp49_;
	RygelGstTranscoder* _vala1_transcoder;
	RygelMediaResource* res;
	RygelGstTranscoder* _tmp50_;
	RygelMediaFileItem* _tmp51_;
	RygelMediaResource* _tmp52_;
	RygelMediaResource* _tmp53_;
	GeeArrayList* _tmp54_;
	RygelMediaResource* _tmp55_;
	gboolean _tmp56_;
	RygelMediaResource* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gboolean _tmp60_;
	GeeArrayList* _tmp61_;
	RygelMediaResource* _tmp62_;
	GeeArrayList* _tmp63_;
	RygelMediaResource* _tmp64_;
};


static gpointer rygel_gst_media_engine_parent_class = NULL;

GType rygel_gst_media_engine_get_type (void) G_GNUC_CONST;
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_MEDIA_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_MEDIA_ENGINE, RygelGstMediaEnginePrivate))
enum  {
	RYGEL_GST_MEDIA_ENGINE_DUMMY_PROPERTY
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelGstMediaEngine* rygel_gst_media_engine_new (void);
RygelGstMediaEngine* rygel_gst_media_engine_construct (GType object_type);
RygelL16Transcoder* rygel_l16_transcoder_new (void);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type);
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
RygelMP3Transcoder* rygel_mp3_transcoder_new (void);
RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type);
GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
RygelAACTranscoder* rygel_aac_transcoder_new (void);
RygelAACTranscoder* rygel_aac_transcoder_construct (GType object_type);
GType rygel_aac_transcoder_get_type (void) G_GNUC_CONST;
RygelAVCTranscoder* rygel_avc_transcoder_new (void);
RygelAVCTranscoder* rygel_avc_transcoder_construct (GType object_type);
GType rygel_avc_transcoder_get_type (void) G_GNUC_CONST;
static GList* rygel_gst_media_engine_real_get_dlna_profiles (RygelMediaEngine* base);
static void rygel_gst_media_engine_real_get_resources_for_item_data_free (gpointer _data);
static void rygel_gst_media_engine_real_get_resources_for_item_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_gst_media_engine_real_get_resources_for_item (RygelMediaEngine* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_gst_media_engine_real_get_resources_for_item_co (RygelGstMediaEngineGetResourcesForItemData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self, RygelMediaFileItem* item);
gboolean rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self, RygelMediaFileItem* item);
static gint ___lambda7_ (Block1Data* _data1_, RygelGstTranscoder* transcoder_1, RygelGstTranscoder* transcoder_2);
static gint ____lambda7__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item);
static RygelDataSource* rygel_gst_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base, RygelMediaObject* object, RygelMediaResource* resource, GError** error);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, RygelMediaResource* resource, GError** error);
RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, RygelMediaResource* resource, GError** error);
const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self);
RygelGstDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self, RygelMediaFileItem* item, RygelDataSource* src, GError** error);
static RygelDataSource* rygel_gst_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base, const gchar* source_uri, GError** error);
RygelDataSource* rygel_gst_media_engine_create_data_source_from_element (RygelGstMediaEngine* self, GstElement* element);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static GList* rygel_gst_media_engine_real_get_internal_protocol_schemes (RygelMediaEngine* base);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void rygel_gst_media_engine_finalize (GObject * obj);
RygelMediaEngine* module_get_instance (void);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
	return self ? rygel_dlna_profile_ref (self) : NULL;
}


RygelGstMediaEngine* rygel_gst_media_engine_construct (GType object_type) {
	RygelGstMediaEngine * self = NULL;
	gchar** args = NULL;
	gint args_length1;
	gint _args_size_;
	GUPnPDLNAProfileGuesser* discoverer = NULL;
	GUPnPDLNAProfileGuesser* _tmp0_;
	GUPnPDLNAProfileGuesser* _tmp1_;
	GList* _tmp2_;
	RygelDLNAProfile* _tmp13_;
	gboolean transcoding = FALSE;
	GeeArrayList* transcoder_list = NULL;
	GeeArrayList* _tmp14_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp15_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
	self = (RygelGstMediaEngine*) rygel_media_engine_construct (object_type);
	args = NULL;
	args_length1 = 0;
	_args_size_ = args_length1;
	gst_init (&args_length1, &args);
	gst_preset_set_app_dir (PRESET_DIR);
	_tmp0_ = gupnp_dlna_profile_guesser_new (TRUE, FALSE);
	discoverer = _tmp0_;
	_tmp1_ = discoverer;
	_tmp2_ = gupnp_dlna_profile_guesser_list_profiles (_tmp1_);
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp2_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			GUPnPDLNAProfile* _tmp3_;
			GUPnPDLNAProfile* profile = NULL;
			_tmp3_ = _g_object_ref0 ((GUPnPDLNAProfile*) profile_it->data);
			profile = _tmp3_;
			{
				RygelDLNAProfile* p = NULL;
				GUPnPDLNAProfile* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				GUPnPDLNAProfile* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				RygelDLNAProfile* _tmp10_;
				RygelDLNAProfile* _tmp11_;
				RygelDLNAProfile* _tmp12_;
				_tmp4_ = profile;
				_tmp5_ = gupnp_dlna_profile_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = profile;
				_tmp8_ = gupnp_dlna_profile_get_mime (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = rygel_dlna_profile_new (_tmp6_, _tmp9_);
				p = _tmp10_;
				_tmp11_ = p;
				_tmp12_ = _rygel_dlna_profile_ref0 (_tmp11_);
				self->priv->dlna_profiles = g_list_prepend (self->priv->dlna_profiles, _tmp12_);
				_rygel_dlna_profile_unref0 (p);
				_g_object_unref0 (profile);
			}
		}
	}
	_tmp13_ = rygel_dlna_profile_new ("DIDL_S", "text/xml");
	self->priv->dlna_profiles = g_list_prepend (self->priv->dlna_profiles, _tmp13_);
	self->priv->dlna_profiles = g_list_reverse (self->priv->dlna_profiles);
	transcoding = TRUE;
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	transcoder_list = _tmp14_;
	_tmp15_ = rygel_meta_config_get_default ();
	config = _tmp15_;
	{
		gboolean _tmp16_ = FALSE;
		RygelMetaConfig* _tmp17_;
		gboolean _tmp18_;
		GeeArrayList* _tmp19_ = NULL;
		RygelMetaConfig* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _tmp22_;
		_tmp17_ = config;
		_tmp18_ = rygel_configuration_get_transcoding ((RygelConfiguration*) _tmp17_, &_inner_error_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		transcoding = _tmp16_;
		_tmp20_ = config;
		_tmp21_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp20_, "GstMediaEngine", "transcoders", &_inner_error_);
		_tmp19_ = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp22_ = _tmp19_;
		_tmp19_ = NULL;
		_g_object_unref0 (transcoder_list);
		transcoder_list = _tmp22_;
		_g_object_unref0 (_tmp19_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		_g_object_unref0 (transcoder_list);
		_g_object_unref0 (discoverer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp23_ = transcoding;
	if (_tmp23_) {
		{
			GeeArrayList* _transcoder_list = NULL;
			GeeArrayList* _tmp24_;
			GeeArrayList* _tmp25_;
			gint _transcoder_size = 0;
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _transcoder_index = 0;
			_tmp24_ = transcoder_list;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_transcoder_list = _tmp25_;
			_tmp26_ = _transcoder_list;
			_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_transcoder_size = _tmp28_;
			_transcoder_index = -1;
			while (TRUE) {
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gchar* transcoder = NULL;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gpointer _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				GQuark _tmp38_ = 0U;
				static GQuark _tmp37_label0 = 0;
				static GQuark _tmp37_label1 = 0;
				static GQuark _tmp37_label2 = 0;
				static GQuark _tmp37_label3 = 0;
				static GQuark _tmp37_label4 = 0;
				static GQuark _tmp37_label5 = 0;
				_tmp29_ = _transcoder_index;
				_transcoder_index = _tmp29_ + 1;
				_tmp30_ = _transcoder_index;
				_tmp31_ = _transcoder_size;
				if (!(_tmp30_ < _tmp31_)) {
					break;
				}
				_tmp32_ = _transcoder_list;
				_tmp33_ = _transcoder_index;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
				transcoder = (gchar*) _tmp34_;
				_tmp35_ = transcoder;
				_tmp36_ = _tmp35_;
				_tmp38_ = (NULL == _tmp36_) ? 0 : g_quark_from_string (_tmp36_);
				if (_tmp38_ == ((0 != _tmp37_label0) ? _tmp37_label0 : (_tmp37_label0 = g_quark_from_static_string ("lpcm")))) {
					switch (0) {
						default:
						{
							RygelL16Transcoder* _tmp39_;
							_tmp39_ = rygel_l16_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp39_);
							break;
						}
					}
				} else if (_tmp38_ == ((0 != _tmp37_label1) ? _tmp37_label1 : (_tmp37_label1 = g_quark_from_static_string ("mp3")))) {
					switch (0) {
						default:
						{
							RygelMP3Transcoder* _tmp40_;
							_tmp40_ = rygel_mp3_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp40_);
							break;
						}
					}
				} else if (_tmp38_ == ((0 != _tmp37_label2) ? _tmp37_label2 : (_tmp37_label2 = g_quark_from_static_string ("mp2ts")))) {
					switch (0) {
						default:
						{
							RygelMP2TSTranscoder* _tmp41_;
							RygelMP2TSTranscoder* _tmp42_;
							RygelMP2TSTranscoder* _tmp43_;
							_tmp41_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD_EU);
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp41_);
							_tmp42_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD_NA);
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp42_);
							_tmp43_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_HD_NA);
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp43_);
							break;
						}
					}
				} else if (_tmp38_ == ((0 != _tmp37_label3) ? _tmp37_label3 : (_tmp37_label3 = g_quark_from_static_string ("wmv")))) {
					switch (0) {
						default:
						{
							RygelWMVTranscoder* _tmp44_;
							_tmp44_ = rygel_wmv_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp44_);
							break;
						}
					}
				} else if (_tmp38_ == ((0 != _tmp37_label4) ? _tmp37_label4 : (_tmp37_label4 = g_quark_from_static_string ("aac")))) {
					switch (0) {
						default:
						{
							RygelAACTranscoder* _tmp45_;
							_tmp45_ = rygel_aac_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp45_);
							break;
						}
					}
				} else if (_tmp38_ == ((0 != _tmp37_label5) ? _tmp37_label5 : (_tmp37_label5 = g_quark_from_static_string ("avc")))) {
					switch (0) {
						default:
						{
							RygelAVCTranscoder* _tmp46_;
							_tmp46_ = rygel_avc_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp46_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp47_;
							_tmp47_ = transcoder;
							g_debug ("rygel-gst-media-engine.vala:100: Unsupported transcoder \"%s\"", _tmp47_);
							break;
						}
					}
				}
				_g_free0 (transcoder);
			}
			_g_object_unref0 (_transcoder_list);
		}
		self->priv->transcoders = g_list_reverse (self->priv->transcoders);
	}
	_g_object_unref0 (config);
	_g_object_unref0 (transcoder_list);
	_g_object_unref0 (discoverer);
	return self;
}


RygelGstMediaEngine* rygel_gst_media_engine_new (void) {
	return rygel_gst_media_engine_construct (RYGEL_TYPE_GST_MEDIA_ENGINE);
}


static GList* rygel_gst_media_engine_real_get_dlna_profiles (RygelMediaEngine* base) {
	RygelGstMediaEngine * self;
	GList* result = NULL;
	GList* _tmp0_;
	self = (RygelGstMediaEngine*) base;
	_tmp0_ = self->priv->dlna_profiles;
	result = _tmp0_;
	return result;
}


static void rygel_gst_media_engine_real_get_resources_for_item_data_free (gpointer _data) {
	RygelGstMediaEngineGetResourcesForItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelGstMediaEngineGetResourcesForItemData, _data_);
}


static void rygel_gst_media_engine_real_get_resources_for_item_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelGstMediaEngineGetResourcesForItemData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_gst_media_engine_real_get_resources_for_item (RygelMediaEngine* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelGstMediaEngine * self;
	RygelGstMediaEngineGetResourcesForItemData* _data_;
	RygelGstMediaEngine* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	self = (RygelGstMediaEngine*) base;
	_data_ = g_slice_new0 (RygelGstMediaEngineGetResourcesForItemData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_gst_media_engine_real_get_resources_for_item_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_gst_media_engine_real_get_resources_for_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp2_;
	rygel_gst_media_engine_real_get_resources_for_item_co (_data_);
}


static GeeList* rygel_gst_media_engine_real_get_resources_for_item_finish (RygelMediaEngine* base, GAsyncResult* _res_) {
	GeeList* result;
	RygelGstMediaEngineGetResourcesForItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelGstMediaEngine* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->item);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gint ___lambda7_ (Block1Data* _data1_, RygelGstTranscoder* transcoder_1, RygelGstTranscoder* transcoder_2) {
	RygelGstMediaEngine* self;
	gint result = 0;
	RygelGstTranscoder* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	guint _tmp2_;
	RygelGstTranscoder* _tmp3_;
	RygelMediaFileItem* _tmp4_;
	guint _tmp5_;
	self = _data1_->self;
	g_return_val_if_fail (transcoder_1 != NULL, 0);
	g_return_val_if_fail (transcoder_2 != NULL, 0);
	_tmp0_ = transcoder_1;
	_tmp1_ = _data1_->item;
	_tmp2_ = rygel_gst_transcoder_get_distance (_tmp0_, _tmp1_);
	_tmp3_ = transcoder_2;
	_tmp4_ = _data1_->item;
	_tmp5_ = rygel_gst_transcoder_get_distance (_tmp3_, _tmp4_);
	result = (gint) (_tmp2_ - _tmp5_);
	return result;
}


static gint ____lambda7__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = ___lambda7_ (self, (RygelGstTranscoder*) a, (RygelGstTranscoder*) b);
	return result;
}


static gboolean rygel_gst_media_engine_real_get_resources_for_item_co (RygelGstMediaEngineGetResourcesForItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		g_warning ("rygel-gst-media-engine.vala:116: Can only process file-based MediaObje" \
"cts (MediaFileItems)");
		_data_->result = NULL;
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->object;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp1_) : NULL);
	_data_->_data1_->item = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->_data1_->item;
	_data_->_tmp4_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp3_);
	_data_->source_uri = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->source_uri;
	_data_->_tmp6_ = g_uri_parse_scheme (_data_->_tmp5_);
	_data_->scheme = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->scheme;
	_data_->_tmp8_ = g_str_has_prefix (_data_->_tmp7_, "http");
	_data_->uri_is_http = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->scheme;
	if (_data_->_tmp9_ == NULL) {
		_data_->_tmp10_ = _data_->source_uri;
		g_warning (_ ("Invalid URI without prefix: %s"), _data_->_tmp10_);
		_data_->result = NULL;
		_g_free0 (_data_->scheme);
		_g_free0 (_data_->source_uri);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->source_uri;
	_data_->_tmp12_ = _data_->scheme;
	g_debug ("rygel-gst-media-engine.vala:135: get_resources_for_item(%s), protocol:" \
" %s", _data_->_tmp11_, _data_->_tmp12_);
	_data_->_tmp15_ = _data_->scheme;
	_data_->_tmp16_ = gst_uri_protocol_is_supported (GST_URI_SRC, _data_->_tmp15_);
	if (!_data_->_tmp16_) {
		_data_->_tmp17_ = _data_->scheme;
		_data_->_tmp14_ = g_strcmp0 (_data_->_tmp17_, "gst-launch") != 0;
	} else {
		_data_->_tmp14_ = FALSE;
	}
	if (_data_->_tmp14_) {
		_data_->_tmp18_ = _data_->scheme;
		_data_->_tmp13_ = g_strcmp0 (_data_->_tmp18_, "dvd") != 0;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (_data_->_tmp13_) {
		_data_->_tmp19_ = _data_->source_uri;
		_data_->_tmp20_ = _data_->scheme;
		g_warning (_ ("Can’t process URI %s with protocol %s"), _data_->_tmp19_, _data_->_tmp20_);
		_data_->result = NULL;
		_g_free0 (_data_->scheme);
		_g_free0 (_data_->source_uri);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = gee_array_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->resources = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->_data1_->item;
	_data_->_tmp23_ = rygel_media_file_item_get_primary_resource (_data_->_tmp22_);
	_data_->primary_res = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->primary_res;
	_data_->_tmp25_ = _data_->primary_res;
	_data_->_tmp26_ = rygel_media_resource_get_dlna_flags (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	rygel_media_resource_set_dlna_flags (_data_->_tmp25_, _data_->_tmp27_ | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	_data_->_tmp28_ = _data_->uri_is_http;
	if (!_data_->_tmp28_) {
		_data_->_tmp29_ = _data_->primary_res;
		_data_->_tmp30_ = rygel_media_resource_new_from_resource ("primary_http", _data_->_tmp29_);
		_data_->http_res = _data_->_tmp30_;
		_data_->_tmp31_ = _data_->http_res;
		rygel_media_resource_set_uri (_data_->_tmp31_, "");
		_data_->_tmp32_ = _data_->resources;
		_data_->_tmp33_ = _data_->http_res;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp32_, _data_->_tmp33_);
		_g_object_unref0 (_data_->http_res);
	}
	_data_->_tmp34_ = _data_->_data1_->item;
	_data_->_tmp35_ = rygel_media_file_item_get_place_holder (_data_->_tmp34_);
	_data_->_tmp36_ = _data_->_tmp35_;
	if (!_data_->_tmp36_) {
		_data_->list = NULL;
		_data_->_tmp37_ = _data_->self->priv->transcoders;
		{
			_data_->transcoder_collection = _data_->_tmp37_;
			for (_data_->transcoder_it = _data_->transcoder_collection; _data_->transcoder_it != NULL; _data_->transcoder_it = _data_->transcoder_it->next) {
				_data_->_tmp38_ = _g_object_ref0 ((RygelGstTranscoder*) _data_->transcoder_it->data);
				_data_->transcoder = _data_->_tmp38_;
				{
					_data_->_tmp40_ = _data_->transcoder;
					_data_->_tmp41_ = _data_->_data1_->item;
					_data_->_tmp42_ = rygel_gst_transcoder_get_distance (_data_->_tmp40_, _data_->_tmp41_);
					if (_data_->_tmp42_ != G_MAXUINT) {
						_data_->_tmp43_ = _data_->transcoder;
						_data_->_tmp44_ = _data_->_data1_->item;
						_data_->_tmp45_ = rygel_gst_transcoder_transcoding_necessary (_data_->_tmp43_, _data_->_tmp44_);
						_data_->_tmp39_ = _data_->_tmp45_;
					} else {
						_data_->_tmp39_ = FALSE;
					}
					if (_data_->_tmp39_) {
						_data_->_tmp46_ = _data_->transcoder;
						_data_->_tmp47_ = _g_object_ref0 (_data_->_tmp46_);
						_data_->list = g_list_append (_data_->list, _data_->_tmp47_);
					}
					_g_object_unref0 (_data_->transcoder);
				}
			}
		}
		_data_->list = g_list_sort_with_data (_data_->list, ____lambda7__gcompare_data_func, _data_->_data1_);
		_data_->_tmp48_ = _data_->list;
		{
			_data_->_vala1_transcoder_collection = _data_->_tmp48_;
			for (_data_->_vala1_transcoder_it = _data_->_vala1_transcoder_collection; _data_->_vala1_transcoder_it != NULL; _data_->_vala1_transcoder_it = _data_->_vala1_transcoder_it->next) {
				_data_->_tmp49_ = _g_object_ref0 ((RygelGstTranscoder*) _data_->_vala1_transcoder_it->data);
				_data_->_vala1_transcoder = _data_->_tmp49_;
				{
					_data_->_tmp50_ = _data_->_vala1_transcoder;
					_data_->_tmp51_ = _data_->_data1_->item;
					_data_->_tmp52_ = rygel_gst_transcoder_get_resource_for_item (_data_->_tmp50_, _data_->_tmp51_);
					_data_->res = _data_->_tmp52_;
					_data_->_tmp53_ = _data_->res;
					if (_data_->_tmp53_ != NULL) {
						_data_->_tmp54_ = _data_->resources;
						_data_->_tmp55_ = _data_->res;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp54_, _data_->_tmp55_);
					}
					_g_object_unref0 (_data_->res);
					_g_object_unref0 (_data_->_vala1_transcoder);
				}
			}
		}
		__g_list_free__g_object_unref0_0 (_data_->list);
	}
	_data_->_tmp57_ = _data_->primary_res;
	_data_->_tmp58_ = rygel_media_resource_get_uri (_data_->_tmp57_);
	_data_->_tmp59_ = _data_->_tmp58_;
	if (_data_->_tmp59_ != NULL) {
		_data_->_tmp60_ = _data_->uri_is_http;
		_data_->_tmp56_ = _data_->_tmp60_;
	} else {
		_data_->_tmp56_ = FALSE;
	}
	if (_data_->_tmp56_) {
		_data_->_tmp61_ = _data_->resources;
		_data_->_tmp62_ = _data_->primary_res;
		gee_abstract_list_insert ((GeeAbstractList*) _data_->_tmp61_, 0, _data_->_tmp62_);
	} else {
		_data_->_tmp63_ = _data_->resources;
		_data_->_tmp64_ = _data_->primary_res;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp63_, _data_->_tmp64_);
	}
	_data_->result = (GeeList*) _data_->resources;
	_g_object_unref0 (_data_->primary_res);
	_g_free0 (_data_->scheme);
	_g_free0 (_data_->source_uri);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static RygelDataSource* rygel_gst_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base, RygelMediaObject* object, RygelMediaResource* resource, GError** error) {
	RygelGstMediaEngine * self;
	RygelDataSource* result = NULL;
	RygelMediaObject* _tmp0_;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	gchar* source_uri = NULL;
	RygelMediaFileItem* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	RygelGstDataSource* data_source = NULL;
	const gchar* _tmp6_;
	RygelMediaResource* _tmp7_;
	RygelGstDataSource* _tmp8_;
	RygelMediaResource* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RygelMediaResource* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaResource* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	RygelMediaResource* _tmp18_;
	GUPnPDLNAConversion _tmp19_;
	GUPnPDLNAConversion _tmp20_;
	GError * _inner_error_ = NULL;
	self = (RygelGstMediaEngine*) base;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		g_warning ("rygel-gst-media-engine.vala:203: Can only process file-based MediaObje" \
"cts (MediaFileItems)");
		result = NULL;
		return result;
	}
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp1_) : NULL);
	item = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _tmp3_);
	source_uri = _tmp4_;
	_tmp5_ = source_uri;
	g_debug ("rygel-gst-media-engine.vala:211: creating data source for %s", _tmp5_);
	_tmp6_ = source_uri;
	_tmp7_ = resource;
	_tmp8_ = rygel_gst_data_source_new (_tmp6_, _tmp7_, &_inner_error_);
	data_source = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (source_uri);
		_g_object_unref0 (item);
		return NULL;
	}
	_tmp9_ = resource;
	_tmp10_ = rygel_media_resource_get_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = resource;
	_tmp13_ = rygel_media_resource_get_dlna_profile (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = resource;
	_tmp16_ = rygel_media_resource_get_mime_type (_tmp15_);
	_tmp17_ = _tmp16_;
	g_debug ("rygel-gst-media-engine.vala:214: MediaResource %s, profile %s, mime_ty" \
"pe %s", _tmp11_, _tmp14_, _tmp17_);
	_g_free0 (_tmp11_);
	_tmp18_ = resource;
	_tmp19_ = rygel_media_resource_get_dlna_conversion (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == GUPNP_DLNA_CONVERSION_TRANSCODED) {
		GList* _tmp21_;
		_tmp21_ = self->priv->transcoders;
		{
			GList* transcoder_collection = NULL;
			GList* transcoder_it = NULL;
			transcoder_collection = _tmp21_;
			for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
				RygelGstTranscoder* _tmp22_;
				RygelGstTranscoder* transcoder = NULL;
				_tmp22_ = _g_object_ref0 ((RygelGstTranscoder*) transcoder_it->data);
				transcoder = _tmp22_;
				{
					RygelGstTranscoder* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					RygelMediaResource* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gboolean _tmp29_;
					_tmp23_ = transcoder;
					_tmp24_ = rygel_gst_transcoder_get_name (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = resource;
					_tmp27_ = rygel_media_resource_get_name (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strcmp0 (_tmp25_, _tmp28_) == 0;
					_g_free0 (_tmp28_);
					if (_tmp29_) {
						RygelGstTranscoder* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						RygelGstTranscoder* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						RygelGstDataSource* _tmp36_ = NULL;
						RygelGstTranscoder* _tmp37_;
						RygelMediaFileItem* _tmp38_;
						RygelGstDataSource* _tmp39_;
						RygelGstDataSource* _tmp40_;
						RygelGstDataSource* _tmp41_;
						_tmp30_ = transcoder;
						_tmp31_ = rygel_gst_transcoder_get_name (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = transcoder;
						_tmp34_ = rygel_gst_transcoder_get_dlna_profile (_tmp33_);
						_tmp35_ = _tmp34_;
						g_debug ("Creating data source from transcoder %s " "with DLNA profile %s", _tmp32_, _tmp35_);
						_tmp37_ = transcoder;
						_tmp38_ = item;
						_tmp39_ = data_source;
						_tmp40_ = rygel_gst_transcoder_create_source (_tmp37_, _tmp38_, (RygelDataSource*) _tmp39_, &_inner_error_);
						_tmp36_ = _tmp40_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (transcoder);
							_g_object_unref0 (data_source);
							_g_free0 (source_uri);
							_g_object_unref0 (item);
							return NULL;
						}
						_tmp41_ = _tmp36_;
						_tmp36_ = NULL;
						_g_object_unref0 (data_source);
						data_source = _tmp41_;
						_g_object_unref0 (_tmp36_);
						_g_object_unref0 (transcoder);
						break;
					}
					_g_object_unref0 (transcoder);
				}
			}
		}
	}
	result = (RygelDataSource*) data_source;
	_g_free0 (source_uri);
	_g_object_unref0 (item);
	return result;
}


static RygelDataSource* rygel_gst_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base, const gchar* source_uri, GError** error) {
	RygelGstMediaEngine * self;
	RygelDataSource* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelGstMediaEngine*) base;
	g_return_val_if_fail (source_uri != NULL, NULL);
	{
		const gchar* _tmp0_;
		RygelGstDataSource* _tmp1_ = NULL;
		const gchar* _tmp2_;
		RygelGstDataSource* _tmp3_;
		RygelGstDataSource* _tmp4_;
		_tmp0_ = source_uri;
		g_debug ("rygel-gst-media-engine.vala:238: creating data source for %s", _tmp0_);
		_tmp2_ = source_uri;
		_tmp3_ = rygel_gst_data_source_new (_tmp2_, NULL, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = (RygelDataSource*) _tmp4_;
		_g_object_unref0 (_tmp1_);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = source_uri;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning (_ ("Failed to create GStreamer data source for %s: %s"), _tmp5_, _tmp7_);
		result = NULL;
		_g_error_free0 (_error_);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


RygelDataSource* rygel_gst_media_engine_create_data_source_from_element (RygelGstMediaEngine* self, GstElement* element) {
	RygelDataSource* result = NULL;
	GstElement* _tmp0_;
	RygelGstDataSource* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = element;
	_tmp1_ = rygel_gst_data_source_new_from_element (_tmp0_);
	result = (RygelDataSource*) _tmp1_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static GList* rygel_gst_media_engine_real_get_internal_protocol_schemes (RygelMediaEngine* base) {
	RygelGstMediaEngine * self;
	GList* result = NULL;
	GList* list = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelGstMediaEngine*) base;
	list = NULL;
	_tmp0_ = g_strdup ("dvd");
	list = g_list_prepend (list, _tmp0_);
	_tmp1_ = g_strdup ("gst-launch");
	list = g_list_prepend (list, _tmp1_);
	result = list;
	return result;
}


static void rygel_gst_media_engine_class_init (RygelGstMediaEngineClass * klass) {
	rygel_gst_media_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstMediaEnginePrivate));
	((RygelMediaEngineClass *) klass)->get_dlna_profiles = (GList* (*) (RygelMediaEngine *)) rygel_gst_media_engine_real_get_dlna_profiles;
	((RygelMediaEngineClass *) klass)->get_resources_for_item = (void (*) (RygelMediaEngine *, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_gst_media_engine_real_get_resources_for_item;
	((RygelMediaEngineClass *) klass)->get_resources_for_item_finish = (GeeList* (*) (RygelMediaEngine *, GAsyncResult*)) rygel_gst_media_engine_real_get_resources_for_item_finish;
	((RygelMediaEngineClass *) klass)->create_data_source_for_resource = (RygelDataSource* (*) (RygelMediaEngine *, RygelMediaObject*, RygelMediaResource*, GError**)) rygel_gst_media_engine_real_create_data_source_for_resource;
	((RygelMediaEngineClass *) klass)->create_data_source_for_uri = (RygelDataSource* (*) (RygelMediaEngine *, const gchar*, GError**)) rygel_gst_media_engine_real_create_data_source_for_uri;
	((RygelMediaEngineClass *) klass)->get_internal_protocol_schemes = (GList* (*) (RygelMediaEngine *)) rygel_gst_media_engine_real_get_internal_protocol_schemes;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_media_engine_finalize;
}


static void rygel_gst_media_engine_instance_init (RygelGstMediaEngine * self) {
	self->priv = RYGEL_GST_MEDIA_ENGINE_GET_PRIVATE (self);
	self->priv->dlna_profiles = NULL;
	self->priv->transcoders = NULL;
}


static void rygel_gst_media_engine_finalize (GObject * obj) {
	RygelGstMediaEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_MEDIA_ENGINE, RygelGstMediaEngine);
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->dlna_profiles);
	__g_list_free__g_object_unref0_0 (self->priv->transcoders);
	G_OBJECT_CLASS (rygel_gst_media_engine_parent_class)->finalize (obj);
}


GType rygel_gst_media_engine_get_type (void) {
	static volatile gsize rygel_gst_media_engine_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_media_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstMediaEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_media_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstMediaEngine), 0, (GInstanceInitFunc) rygel_gst_media_engine_instance_init, NULL };
		GType rygel_gst_media_engine_type_id;
		rygel_gst_media_engine_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ENGINE, "RygelGstMediaEngine", &g_define_type_info, 0);
		g_once_init_leave (&rygel_gst_media_engine_type_id__volatile, rygel_gst_media_engine_type_id);
	}
	return rygel_gst_media_engine_type_id__volatile;
}


RygelMediaEngine* module_get_instance (void) {
	RygelMediaEngine* result = NULL;
	RygelGstMediaEngine* _tmp0_;
	_tmp0_ = rygel_gst_media_engine_new ();
	result = (RygelMediaEngine*) _tmp0_;
	return result;
}



