static const byte kEoB1ChargenStartLevelsPC98[60] = {
	0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x01,
	0x02, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x02,
	0x02, 0x02, 0x00, 0x02, 0x01, 0x01, 0x02, 0x03,
	0x03, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x02,
	0x01, 0x02, 0x01, 0x03, 0x02, 0x02, 0x00, 0x02,
	0x02, 0x02, 0x00, 0x02
};

static const ByteProvider kEoB1ChargenStartLevelsPC98Provider = { ARRAYSIZE(kEoB1ChargenStartLevelsPC98), kEoB1ChargenStartLevelsPC98 };

static const byte kEoB1ChargenClassMinStatsPC98[90] = {
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00,
	0x0E, 0x0D, 0x0E, 0x00, 0x0C, 0x00, 0x0D, 0x00,
	0x09, 0x11, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x0D, 0x00,
	0x0E, 0x0D, 0x0E, 0x00, 0x00, 0x09, 0x09, 0x00,
	0x00, 0x00
};

static const ByteProvider kEoB1ChargenClassMinStatsPC98Provider = { ARRAYSIZE(kEoB1ChargenClassMinStatsPC98), kEoB1ChargenClassMinStatsPC98 };

static const byte kEoB1ChargenRaceMinStatsPC98[36] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08,
	0x03, 0x07, 0x06, 0x08, 0x03, 0x04, 0x03, 0x06,
	0x06, 0x03, 0x08, 0x03, 0x03, 0x03, 0x0C, 0x02,
	0x06, 0x07, 0x02, 0x03, 0x08, 0x03, 0x07, 0x06,
	0x03, 0x08, 0x0A, 0x06
};

static const ByteProvider kEoB1ChargenRaceMinStatsPC98Provider = { ARRAYSIZE(kEoB1ChargenRaceMinStatsPC98), kEoB1ChargenRaceMinStatsPC98 };

static const uint16 kEoB1ChargenRaceMaxStatsPC98[36] = {
	0x6412, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x6412, 0x0012,
	0x0012, 0x0013, 0x0011, 0x0012, 0x6412, 0x0012, 0x0012, 0x0012,
	0x0012, 0x0012, 0x6412, 0x0012, 0x0012, 0x0011, 0x0013, 0x0010,
	0x6412, 0x0013, 0x0011, 0x0012, 0x0012, 0x0012, 0x0011, 0x0012,
	0x0011, 0x0013, 0x0012, 0x0012
};

static const Uint16Provider kEoB1ChargenRaceMaxStatsPC98Provider = { ARRAYSIZE(kEoB1ChargenRaceMaxStatsPC98), kEoB1ChargenRaceMaxStatsPC98 };

static const byte kEoB1SaveThrowTable1PC98[50] = {
	0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x07, 0x05,
	0x04, 0x03, 0x12, 0x10, 0x0F, 0x0D, 0x0C, 0x0A,
	0x09, 0x07, 0x06, 0x05, 0x11, 0x0F, 0x0E, 0x0C,
	0x0B, 0x09, 0x08, 0x06, 0x05, 0x04, 0x14, 0x11,
	0x10, 0x0D, 0x0C, 0x09, 0x08, 0x05, 0x04, 0x04,
	0x13, 0x11, 0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08,
	0x07, 0x06
};

static const ByteProvider kEoB1SaveThrowTable1PC98Provider = { ARRAYSIZE(kEoB1SaveThrowTable1PC98), kEoB1SaveThrowTable1PC98 };

static const byte kEoB1SaveThrowTable2PC98[25] = {
	0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x0B, 0x09, 0x07,
	0x05, 0x03, 0x0D, 0x0B, 0x09, 0x07, 0x05, 0x0F,
	0x0D, 0x0B, 0x09, 0x07, 0x0C, 0x0A, 0x08, 0x06,
	0x04
};

static const ByteProvider kEoB1SaveThrowTable2PC98Provider = { ARRAYSIZE(kEoB1SaveThrowTable2PC98), kEoB1SaveThrowTable2PC98 };

static const byte kEoB1SaveThrowTable3PC98[35] = {
	0x0A, 0x09, 0x07, 0x06, 0x05, 0x04, 0x02, 0x0E,
	0x0D, 0x0B, 0x0A, 0x09, 0x08, 0x06, 0x0D, 0x0C,
	0x0A, 0x09, 0x08, 0x07, 0x05, 0x10, 0x0F, 0x0D,
	0x0C, 0x0B, 0x0A, 0x08, 0x0F, 0x0E, 0x0C, 0x0B,
	0x0A, 0x09, 0x07
};

static const ByteProvider kEoB1SaveThrowTable3PC98Provider = { ARRAYSIZE(kEoB1SaveThrowTable3PC98), kEoB1SaveThrowTable3PC98 };

static const byte kEoB1SaveThrowTable4PC98[30] = {
	0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x0E, 0x0C,
	0x0A, 0x08, 0x06, 0x07, 0x0C, 0x0B, 0x0A, 0x09,
	0x08, 0x04, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B,
	0x0F, 0x0D, 0x0B, 0x09, 0x07, 0x05
};

static const ByteProvider kEoB1SaveThrowTable4PC98Provider = { ARRAYSIZE(kEoB1SaveThrowTable4PC98), kEoB1SaveThrowTable4PC98 };

static const byte kEoB1SaveThrwLvlIndexPC98[6] = {
	0x11, 0x15, 0x13, 0x15, 0x11, 0x11
};

static const ByteProvider kEoB1SaveThrwLvlIndexPC98Provider = { ARRAYSIZE(kEoB1SaveThrwLvlIndexPC98), kEoB1SaveThrwLvlIndexPC98 };

static const byte kEoB1SaveThrwModDivPC98[6] = {
	0x02, 0x05, 0x03, 0x04, 0x02, 0x02
};

static const ByteProvider kEoB1SaveThrwModDivPC98Provider = { ARRAYSIZE(kEoB1SaveThrwModDivPC98), kEoB1SaveThrwModDivPC98 };

static const byte kEoB1SaveThrwModExtPC98[6] = {
	0x0A, 0x05, 0x07, 0x06, 0x0A, 0x0A
};

static const ByteProvider kEoB1SaveThrwModExtPC98Provider = { ARRAYSIZE(kEoB1SaveThrwModExtPC98), kEoB1SaveThrwModExtPC98 };

static const char *const kEoB1IntroFilesOpeningPC98[8] = {
	"SSI.BIN",
	"AND.BIN",
	"PON2.BIN",
	"PRESENT.BIN",
	"DAND.BIN",
	"EOBTITLE.BIN",
	"WESTWOOD.BIN",
	""
};

static const StringListProvider kEoB1IntroFilesOpeningPC98Provider = { ARRAYSIZE(kEoB1IntroFilesOpeningPC98), kEoB1IntroFilesOpeningPC98 };

static const char *const kEoB1IntroFilesTowerPC98[2] = {
	"",
	"TOWRMAGE.BIN"
};

static const StringListProvider kEoB1IntroFilesTowerPC98Provider = { ARRAYSIZE(kEoB1IntroFilesTowerPC98), kEoB1IntroFilesTowerPC98 };

static const char *const kEoB1IntroFilesOrbPC98[2] = {
	"ORB.BIN",
	"TOWRMAGE.BIN"
};

static const StringListProvider kEoB1IntroFilesOrbPC98Provider = { ARRAYSIZE(kEoB1IntroFilesOrbPC98), kEoB1IntroFilesOrbPC98 };

static const char *const kEoB1IntroFilesWdEntryPC98[4] = {
	"",
	"WTRDP1.BIN",
	"WTRDP2.BIN",
	"WTRDP3.BIN"
};

static const StringListProvider kEoB1IntroFilesWdEntryPC98Provider = { ARRAYSIZE(kEoB1IntroFilesWdEntryPC98), kEoB1IntroFilesWdEntryPC98 };

static const char *const kEoB1IntroFilesKingPC98[2] = {
	"KING.BIN",
	"ADVENTUR.BIN"
};

static const StringListProvider kEoB1IntroFilesKingPC98Provider = { ARRAYSIZE(kEoB1IntroFilesKingPC98), kEoB1IntroFilesKingPC98 };

static const char *const kEoB1IntroFilesHandsPC98[1] = {
	"HANDS.BIN"
};

static const StringListProvider kEoB1IntroFilesHandsPC98Provider = { ARRAYSIZE(kEoB1IntroFilesHandsPC98), kEoB1IntroFilesHandsPC98 };

static const char *const kEoB1IntroFilesWdExitPC98[5] = {
	"WTRDP3.BIN",
	"",
	"ORB.BIN",
	"TUNNEL.BIN",
	""
};

static const StringListProvider kEoB1IntroFilesWdExitPC98Provider = { ARRAYSIZE(kEoB1IntroFilesWdExitPC98), kEoB1IntroFilesWdExitPC98 };

static const char *const kEoB1IntroFilesTunnelPC98[2] = {
	"AVALANCH.BIN",
	"ZOOMTUNL.BIN"
};

static const StringListProvider kEoB1IntroFilesTunnelPC98Provider = { ARRAYSIZE(kEoB1IntroFilesTunnelPC98), kEoB1IntroFilesTunnelPC98 };

static const byte kEoB1IntroOpeningFrmDelayPC98[7] = {
	0x46, 0x32, 0x19, 0x32, 0x19, 0x46, 0x32
};

static const ByteProvider kEoB1IntroOpeningFrmDelayPC98Provider = { ARRAYSIZE(kEoB1IntroOpeningFrmDelayPC98), kEoB1IntroOpeningFrmDelayPC98 };

static const byte kEoB1IntroWdEncodeXPC98[31] = {
	0x00, 0x18, 0x02, 0x04, 0x1A, 0x05, 0x10, 0x06,
	0x10, 0x07, 0x11, 0x04, 0x13, 0x05, 0x06, 0x13,
	0x09, 0x14, 0x0B, 0x0D, 0x16, 0x0D, 0x16, 0x0E,
	0x1A, 0x0E, 0x17, 0x0F, 0x1B, 0x0F, 0x17
};

static const ByteProvider kEoB1IntroWdEncodeXPC98Provider = { ARRAYSIZE(kEoB1IntroWdEncodeXPC98), kEoB1IntroWdEncodeXPC98 };

static const byte kEoB1IntroWdEncodeYPC98[31] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01
};

static const ByteProvider kEoB1IntroWdEncodeYPC98Provider = { ARRAYSIZE(kEoB1IntroWdEncodeYPC98), kEoB1IntroWdEncodeYPC98 };

static const byte kEoB1IntroWdEncodeWHPC98[31] = {
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static const ByteProvider kEoB1IntroWdEncodeWHPC98Provider = { ARRAYSIZE(kEoB1IntroWdEncodeWHPC98), kEoB1IntroWdEncodeWHPC98 };

static const uint16 kEoB1IntroWdDsXPC98[31] = {
	0x0120, 0x0120, 0x0120, 0x0130, 0x0130, 0x00B2, 0x00B2, 0x00BC,
	0x00BC, 0x00AE, 0x00AE, 0x0125, 0x0125, 0x0125, 0x0101, 0x0101,
	0x00E9, 0x00E9, 0x00E9, 0x00AB, 0x00AB, 0x00CC, 0x00CC, 0x00F0,
	0x00F0, 0x010C, 0x010C, 0x00E0, 0x00E0, 0x00BA, 0x00BA
};

static const Uint16Provider kEoB1IntroWdDsXPC98Provider = { ARRAYSIZE(kEoB1IntroWdDsXPC98), kEoB1IntroWdDsXPC98 };

static const byte kEoB1IntroWdDsYPC98[31] = {
	0x28, 0x28, 0x28, 0x38, 0x38, 0x26, 0x26, 0x1D,
	0x1D, 0x34, 0x34, 0x50, 0x50, 0x50, 0x50, 0x50,
	0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x2A, 0x66,
	0x66, 0x67, 0x67, 0x1C, 0x1C, 0x44, 0x44
};

static const ByteProvider kEoB1IntroWdDsYPC98Provider = { ARRAYSIZE(kEoB1IntroWdDsYPC98), kEoB1IntroWdDsYPC98 };

static const byte kEoB1IntroTvlX1PC98[6] = {
	0x00, 0x08, 0x10, 0x00, 0x0F, 0x00
};

static const ByteProvider kEoB1IntroTvlX1PC98Provider = { ARRAYSIZE(kEoB1IntroTvlX1PC98), kEoB1IntroTvlX1PC98 };

static const byte kEoB1IntroTvlY1PC98[6] = {
	0x00, 0x00, 0x00, 0x30, 0x36, 0x86
};

static const ByteProvider kEoB1IntroTvlY1PC98Provider = { ARRAYSIZE(kEoB1IntroTvlY1PC98), kEoB1IntroTvlY1PC98 };

static const byte kEoB1IntroTvlX2PC98[6] = {
	0x10, 0x10, 0x0F, 0x0C, 0x0B, 0x0B
};

static const ByteProvider kEoB1IntroTvlX2PC98Provider = { ARRAYSIZE(kEoB1IntroTvlX2PC98), kEoB1IntroTvlX2PC98 };

static const byte kEoB1IntroTvlY2PC98[6] = {
	0x35, 0x35, 0x35, 0x35, 0x35, 0x61
};

static const ByteProvider kEoB1IntroTvlY2PC98Provider = { ARRAYSIZE(kEoB1IntroTvlY2PC98), kEoB1IntroTvlY2PC98 };

static const byte kEoB1IntroTvlWPC98[6] = {
	0x08, 0x08, 0x0B, 0x0F, 0x12, 0x12
};

static const ByteProvider kEoB1IntroTvlWPC98Provider = { ARRAYSIZE(kEoB1IntroTvlWPC98), kEoB1IntroTvlWPC98 };

static const byte kEoB1IntroTvlHPC98[6] = {
	0x1A, 0x30, 0x36, 0x45, 0x50, 0x28
};

static const ByteProvider kEoB1IntroTvlHPC98Provider = { ARRAYSIZE(kEoB1IntroTvlHPC98), kEoB1IntroTvlHPC98 };

static const byte kEoB1DoorShapeDefsPC98[96] = {
	0x00, 0x00, 0x0a, 0x48, 0x11, 0x98, 0x07, 0x2f,
	0x19, 0x48, 0x04, 0x1d, 0x0a, 0x00, 0x0a, 0x48,
	0x1d, 0x48, 0x07, 0x2f, 0x19, 0x68, 0x04, 0x1d,
	0x14, 0x00, 0x06, 0x48, 0x24, 0x48, 0x04, 0x2f,
	0x1e, 0x78, 0x03, 0x1d, 0x1a, 0x00, 0x0c, 0x48,
	0x00, 0x90, 0x07, 0x29, 0x21, 0x78, 0x04, 0x1b,
	0x00, 0xbc, 0x0a, 0x0c, 0x0a, 0xbc, 0x06, 0x08,
	0x0a, 0xc4, 0x04, 0x02, 0x07, 0x4a, 0x09, 0x37,
	0x00, 0x4a, 0x07, 0x25, 0x07, 0xa0, 0x05, 0x17,
	0x07, 0x82, 0x09, 0x1c, 0x00, 0x70, 0x07, 0x13,
	0x0c, 0xa0, 0x05, 0x0b, 0x10, 0x48, 0x09, 0x4b,
	0x18, 0x98, 0x07, 0x2e, 0x1f, 0x98, 0x04, 0x1d
};

static const ByteProvider kEoB1DoorShapeDefsPC98Provider = { ARRAYSIZE(kEoB1DoorShapeDefsPC98), kEoB1DoorShapeDefsPC98 };

static const byte kEoB1DoorSwitchShapeDefsPC98[96] = {
	0x25, 0x78, 0x01, 0x07, 0x25, 0x88, 0x01, 0x03,
	0x25, 0x90, 0x01, 0x01, 0x25, 0x78, 0x01, 0x07,
	0x25, 0x88, 0x01, 0x03, 0x25, 0x90, 0x01, 0x01,
	0x26, 0x78, 0x01, 0x0b, 0x26, 0x88, 0x01, 0x06,
	0x26, 0x90, 0x01, 0x04, 0x27, 0x78, 0x01, 0x0e,
	0x27, 0x88, 0x01, 0x08, 0x25, 0x90, 0x01, 0x01,
	0x25, 0x78, 0x01, 0x07, 0x25, 0x88, 0x01, 0x03,
	0x25, 0x90, 0x01, 0x01, 0x25, 0x98, 0x01, 0x0b,
	0x25, 0xa8, 0x01, 0x06, 0x25, 0xb0, 0x01, 0x04,
	0x25, 0x98, 0x01, 0x0b, 0x25, 0xa8, 0x01, 0x05,
	0x25, 0xb0, 0x01, 0x04, 0x26, 0x98, 0x01, 0x0a,
	0x26, 0xa8, 0x01, 0x04, 0x25, 0x90, 0x01, 0x01
};

static const ByteProvider kEoB1DoorSwitchShapeDefsPC98Provider = { ARRAYSIZE(kEoB1DoorSwitchShapeDefsPC98), kEoB1DoorSwitchShapeDefsPC98 };

static const byte kEoB1DoorSwitchCoordsPC98[48] = {
	0x82, 0x24, 0x74, 0x27, 0x00, 0x00, 0x82, 0x24,
	0x74, 0x27, 0x00, 0x00, 0x5b, 0x36, 0x5a, 0x33,
	0x5a, 0x2d, 0x88, 0x26, 0x74, 0x29, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24,
	0x73, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x2b, 0x74, 0x2b, 0x00, 0x00
};

static const ByteProvider kEoB1DoorSwitchCoordsPC98Provider = { ARRAYSIZE(kEoB1DoorSwitchCoordsPC98), kEoB1DoorSwitchCoordsPC98 };

static const byte kEoB1MonsterPropertiesPC98[594] = {
	0x07, 0x12, 0xff, 0x01, 0x01, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x02, 0x4b,
	0x02, 0xff, 0x00, 0x07, 0x11, 0x02, 0x01, 0x01,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x78, 0x00,
	0x01, 0x38, 0x39, 0x00, 0xff, 0x00, 0x05, 0x11,
	0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x0c, 0x04, 0x00, 0x00,
	0x00, 0x41, 0x00, 0x00, 0x42, 0x43, 0x00, 0x02,
	0x00, 0x08, 0x0f, 0x02, 0x01, 0x01, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x49,
	0x4a, 0x00, 0x03, 0x00, 0x04, 0x10, 0x02, 0x02,
	0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0xaf,
	0x00, 0x02, 0x36, 0x37, 0x04, 0xff, 0x14, 0x05,
	0x11, 0x03, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x03, 0x00,
	0x00, 0x00, 0x41, 0x00, 0x00, 0x2f, 0x30, 0x00,
	0xff, 0x00, 0x06, 0x13, 0x02, 0x01, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x02, 0x00, 0x00, 0x00, 0x8a, 0x02, 0x02,
	0x31, 0x26, 0x00, 0xff, 0x00, 0x03, 0x0c, 0x07,
	0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0xda, 0x02, 0x00, 0x2d, 0x2e, 0x00, 0xff, 0x00,
	0x05, 0x07, 0x0a, 0x01, 0x01, 0x08, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04,
	0x00, 0x00, 0x00, 0xdc, 0x05, 0x00, 0x40, 0x41,
	0x00, 0x07, 0x00, 0x04, 0x0f, 0x06, 0x02, 0x01,
	0x08, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0xcf, 0x03,
	0x01, 0x27, 0x28, 0x00, 0xff, 0x00, 0x05, 0x0d,
	0x06, 0x03, 0x01, 0x08, 0x00, 0x01, 0x04, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00,
	0x00, 0x78, 0x05, 0x02, 0x25, 0x24, 0x00, 0xff,
	0x00, 0x04, 0x0d, 0x05, 0x02, 0x01, 0x04, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0xe2, 0x04, 0x00, 0x3e,
	0x3f, 0x00, 0xff, 0x00, 0x04, 0x0f, 0x04, 0x01,
	0x01, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x8a,
	0x02, 0x00, 0x2b, 0x2c, 0x00, 0xff, 0x3c, 0xff,
	0x07, 0x0a, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00,
	0x00, 0x00, 0x10, 0x27, 0x02, 0x44, 0x45, 0x00,
	0xff, 0x64, 0xff, 0x07, 0x09, 0x01, 0x03, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x03, 0x00, 0x00, 0x00, 0xd0, 0x07, 0x00,
	0x1f, 0xff, 0x08, 0xff, 0x00, 0x03, 0x0d, 0x07,
	0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0x00,
	0x88, 0x13, 0x02, 0x29, 0x2a, 0x02, 0xff, 0x3c,
	0x05, 0x0d, 0x07, 0x01, 0x01, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x02,
	0x00, 0x00, 0x00, 0x88, 0x13, 0x00, 0x34, 0x35,
	0x02, 0xff, 0x00, 0x05, 0x0b, 0x08, 0x01, 0x05,
	0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x40, 0x1f,
	0x00, 0x3a, 0x3b, 0xff, 0xff, 0x5a, 0x02, 0x0f,
	0x05, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x02, 0x00, 0x00,
	0x00, 0x0e, 0x01, 0x02, 0x3c, 0x3d, 0x00, 0xff,
	0x00, 0xfe, 0x0d, 0x08, 0x01, 0x06, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x02, 0x00, 0x00, 0x00, 0xa0, 0x0f, 0x02, 0x48,
	0x47, 0x00, 0xff, 0x32, 0x04, 0x0d, 0x07, 0x01,
	0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0xcf,
	0x03, 0x01, 0x33, 0x32, 0x00, 0xff, 0x28, 0x00,
	0x05, 0x23, 0x01, 0x01, 0x64, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00,
	0x00, 0x00, 0xb0, 0x36, 0x02, 0xff, 0xff, 0xff,
	0xff, 0x64
};

static const ByteProvider kEoB1MonsterPropertiesPC98Provider = { ARRAYSIZE(kEoB1MonsterPropertiesPC98), kEoB1MonsterPropertiesPC98 };

static const byte kEoB1EnemyMageSpellListPC98[10] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x05,
	0x06, 0x00
};

static const ByteProvider kEoB1EnemyMageSpellListPC98Provider = { ARRAYSIZE(kEoB1EnemyMageSpellListPC98), kEoB1EnemyMageSpellListPC98 };

static const byte kEoB1EnemyMageSfxPC98[10] = {
	0x00, 0x55, 0x55, 0x55, 0x55, 0x62, 0x62, 0x1F,
	0x62, 0x02
};

static const ByteProvider kEoB1EnemyMageSfxPC98Provider = { ARRAYSIZE(kEoB1EnemyMageSfxPC98), kEoB1EnemyMageSfxPC98 };

static const byte kEoB1BeholderSpellListPC98[4] = {
	0x02, 0x0A, 0x0B, 0x62
};

static const ByteProvider kEoB1BeholderSpellListPC98Provider = { ARRAYSIZE(kEoB1BeholderSpellListPC98), kEoB1BeholderSpellListPC98 };

static const byte kEoB1BeholderSfxPC98[4] = {
	0x62, 0x53, 0x40, 0x00
};

static const ByteProvider kEoB1BeholderSfxPC98Provider = { ARRAYSIZE(kEoB1BeholderSfxPC98), kEoB1BeholderSfxPC98 };

static const byte kEoB1NpcShpDataPC98[76] = {
	0x00, 0x00, 0x06, 0x40, 0x06, 0x00, 0x07, 0x48,
	0x0d, 0x00, 0x06, 0x30, 0x13, 0x00, 0x05, 0x38,
	0x18, 0x00, 0x05, 0x38, 0x1d, 0x00, 0x05, 0x38,
	0x22, 0x00, 0x06, 0x48, 0x00, 0x48, 0x06, 0x56,
	0x06, 0x48, 0x05, 0x40, 0x0b, 0x48, 0x05, 0x40,
	0x10, 0x48, 0x05, 0x30, 0x06, 0x88, 0x03, 0x18,
	0x09, 0x88, 0x03, 0x18, 0x0c, 0x88, 0x03, 0x18,
	0x0f, 0x88, 0x03, 0x18, 0x12, 0x88, 0x03, 0x18,
	0x15, 0x88, 0x03, 0x18, 0x18, 0x48, 0x06, 0x58,
	0x1e, 0x48, 0x0a, 0x48
};

static const ByteProvider kEoB1NpcShpDataPC98Provider = { ARRAYSIZE(kEoB1NpcShpDataPC98), kEoB1NpcShpDataPC98 };

static const byte kEoB1NpcSubShpIndex1PC98[6] = {
	0x09, 0x08, 0x08, 0x09, 0x09, 0x0A
};

static const ByteProvider kEoB1NpcSubShpIndex1PC98Provider = { ARRAYSIZE(kEoB1NpcSubShpIndex1PC98), kEoB1NpcSubShpIndex1PC98 };

static const byte kEoB1NpcSubShpIndex2PC98[6] = {
	0x0D, 0x0B, 0x0C, 0x0E, 0x0F, 0x10
};

static const ByteProvider kEoB1NpcSubShpIndex2PC98Provider = { ARRAYSIZE(kEoB1NpcSubShpIndex2PC98), kEoB1NpcSubShpIndex2PC98 };

static const byte kEoB1NpcSubShpYPC98[6] = {
	0x34, 0x31, 0x31, 0x34, 0x34, 0x45
};

static const ByteProvider kEoB1NpcSubShpYPC98Provider = { ARRAYSIZE(kEoB1NpcSubShpYPC98), kEoB1NpcSubShpYPC98 };

static const char *const kEoB1EnchantedStringPC98[1] = {
	"%s+%d"
};

static const StringListProvider kEoB1EnchantedStringPC98Provider = { ARRAYSIZE(kEoB1EnchantedStringPC98), kEoB1EnchantedStringPC98 };

static const byte kEoB1SpellLevelsMagePC98[26] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x05, 0x00
};

static const ByteProvider kEoB1SpellLevelsMagePC98Provider = { ARRAYSIZE(kEoB1SpellLevelsMagePC98), kEoB1SpellLevelsMagePC98 };

static const byte kEoB1SpellLevelsClericPC98[25] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x01,
	0x00
};

static const ByteProvider kEoB1SpellLevelsClericPC98Provider = { ARRAYSIZE(kEoB1SpellLevelsClericPC98), kEoB1SpellLevelsClericPC98 };

static const byte kEoB1NumSpellsClericPC98[50] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x00, 0x00, 0x03, 0x03, 0x01, 0x00,
	0x00, 0x03, 0x03, 0x02, 0x00, 0x00, 0x03, 0x03,
	0x02, 0x01, 0x00, 0x03, 0x03, 0x03, 0x02, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x01, 0x04, 0x04, 0x03,
	0x03, 0x02
};

static const ByteProvider kEoB1NumSpellsClericPC98Provider = { ARRAYSIZE(kEoB1NumSpellsClericPC98), kEoB1NumSpellsClericPC98 };

static const byte kEoB1NumSpellsWisAdjPC98[40] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x01, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x02, 0x02, 0x01, 0x00, 0x00, 0x02, 0x02,
	0x01, 0x01, 0x00, 0x03, 0x02, 0x01, 0x02, 0x00
};

static const ByteProvider kEoB1NumSpellsWisAdjPC98Provider = { ARRAYSIZE(kEoB1NumSpellsWisAdjPC98), kEoB1NumSpellsWisAdjPC98 };

static const byte kEoB1NumSpellsPalPC98[60] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x02,
	0x02, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB1NumSpellsPalPC98Provider = { ARRAYSIZE(kEoB1NumSpellsPalPC98), kEoB1NumSpellsPalPC98 };

static const byte kEoB1NumSpellsMagePC98[55] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01, 0x00,
	0x00, 0x04, 0x02, 0x02, 0x00, 0x00, 0x04, 0x03,
	0x02, 0x01, 0x00, 0x04, 0x03, 0x03, 0x02, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x01, 0x04, 0x04, 0x03,
	0x02, 0x02, 0x04, 0x04, 0x04, 0x03, 0x03
};

static const ByteProvider kEoB1NumSpellsMagePC98Provider = { ARRAYSIZE(kEoB1NumSpellsMagePC98), kEoB1NumSpellsMagePC98 };

static const uint32 kEoB1ExperienceTable0PC98[12] = {
	0x00000000, 0x000007D0, 0x00000FA0, 0x00001F40, 0x00003E80, 0x00007D00, 0x0000FA00, 0x0001E848,
	0x0003D090, 0x0007A120, 0x000B71B0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable0PC98Provider = { ARRAYSIZE(kEoB1ExperienceTable0PC98), kEoB1ExperienceTable0PC98 };

static const uint32 kEoB1ExperienceTable1PC98[12] = {
	0x00000000, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x0000EA60, 0x00015F90,
	0x00020F58, 0x0003D090, 0x0005B8D8, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable1PC98Provider = { ARRAYSIZE(kEoB1ExperienceTable1PC98), kEoB1ExperienceTable1PC98 };

static const uint32 kEoB1ExperienceTable2PC98[11] = {
	0x00000000, 0x000005DC, 0x00000BB8, 0x00001770, 0x000032C8, 0x00006B6C, 0x0000D6D8, 0x0001ADB0,
	0x00036EE8, 0x0006DDD0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable2PC98Provider = { ARRAYSIZE(kEoB1ExperienceTable2PC98), kEoB1ExperienceTable2PC98 };

static const uint32 kEoB1ExperienceTable3PC98[12] = {
	0x00000000, 0x000004E2, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x00011170,
	0x0001ADB0, 0x00027100, 0x00035B60, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable3PC98Provider = { ARRAYSIZE(kEoB1ExperienceTable3PC98), kEoB1ExperienceTable3PC98 };

static const uint32 kEoB1ExperienceTable4PC98[12] = {
	0x00000000, 0x000008CA, 0x00001194, 0x00002328, 0x00004650, 0x00008CA0, 0x000124F8, 0x000249F0,
	0x000493E0, 0x000927C0, 0x000DBBA0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable4PC98Provider = { ARRAYSIZE(kEoB1ExperienceTable4PC98), kEoB1ExperienceTable4PC98 };

static const byte kEoB1ExpObjectTblIndexPC98[9] = {
	0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
	0x00
};

static const ByteProvider kEoB1ExpObjectTblIndexPC98Provider = { ARRAYSIZE(kEoB1ExpObjectTblIndexPC98), kEoB1ExpObjectTblIndexPC98 };

static const byte kEoB1ExpObjectShpStartPC98[4] = {
	0x07, 0x0C, 0x0F, 0x12
};

static const ByteProvider kEoB1ExpObjectShpStartPC98Provider = { ARRAYSIZE(kEoB1ExpObjectShpStartPC98), kEoB1ExpObjectShpStartPC98 };

static const byte kEoB1ExpObjectTbl1PC98[13] = {
	0x0F, 0x05, 0x0F, 0x05, 0x06, 0x05, 0x06, 0x08,
	0x06, 0x08, 0x06, 0x08, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl1PC98Provider = { ARRAYSIZE(kEoB1ExpObjectTbl1PC98), kEoB1ExpObjectTbl1PC98 };

static const byte kEoB1ExpObjectTbl2PC98[10] = {
	0x0F, 0x09, 0x0F, 0x09, 0x02, 0x0A, 0x0B, 0x0A,
	0x0B, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl2PC98Provider = { ARRAYSIZE(kEoB1ExpObjectTbl2PC98), kEoB1ExpObjectTbl2PC98 };

static const byte kEoB1ExpObjectTbl3PC98[11] = {
	0x05, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x0B,
	0x03, 0x0B, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl3PC98Provider = { ARRAYSIZE(kEoB1ExpObjectTbl3PC98), kEoB1ExpObjectTbl3PC98 };

static const byte kEoB1ExpObjectYPC98[4] = {
	0x77, 0x67, 0x4F, 0x3F
};

static const ByteProvider kEoB1ExpObjectYPC98Provider = { ARRAYSIZE(kEoB1ExpObjectYPC98), kEoB1ExpObjectYPC98 };

static const byte kEoB1SparkDefStepsPC98[8] = {
	0x40, 0x90, 0xE4, 0xB9, 0x6E, 0x1B, 0x06, 0x01
};

static const ByteProvider kEoB1SparkDefStepsPC98Provider = { ARRAYSIZE(kEoB1SparkDefStepsPC98), kEoB1SparkDefStepsPC98 };

static const byte kEoB1SparkDefSubStepsPC98[4] = {
	0xC0, 0x30, 0x0C, 0x03
};

static const ByteProvider kEoB1SparkDefSubStepsPC98Provider = { ARRAYSIZE(kEoB1SparkDefSubStepsPC98), kEoB1SparkDefSubStepsPC98 };

static const byte kEoB1SparkDefShiftPC98[4] = {
	0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB1SparkDefShiftPC98Provider = { ARRAYSIZE(kEoB1SparkDefShiftPC98), kEoB1SparkDefShiftPC98 };

static const byte kEoB1SparkDefAddPC98[8] = {
	0x08, 0x06, 0x1C, 0x14, 0x0D, 0x18, 0x0D, 0x0F
};

static const ByteProvider kEoB1SparkDefAddPC98Provider = { ARRAYSIZE(kEoB1SparkDefAddPC98), kEoB1SparkDefAddPC98 };

static const byte kEoB1SparkDefXPC98[6] = {
	0x17, 0x20, 0x17, 0x20, 0x17, 0x20
};

static const ByteProvider kEoB1SparkDefXPC98Provider = { ARRAYSIZE(kEoB1SparkDefXPC98), kEoB1SparkDefXPC98 };

static const byte kEoB1SparkDefYPC98[6] = {
	0x02, 0x02, 0x34, 0x34, 0x66, 0x66
};

static const ByteProvider kEoB1SparkDefYPC98Provider = { ARRAYSIZE(kEoB1SparkDefYPC98), kEoB1SparkDefYPC98 };

static const uint32 kEoB1SparkOfFlags1PC98[11] = {
	0x40000000, 0x95000000, 0xEA550000, 0xBFAA5400, 0x6AFFA954, 0x15AAFEA9, 0x0055ABFE, 0x000056AB,
	0x00000156, 0x00000001, 0x00000000
};

static const Uint32Provider kEoB1SparkOfFlags1PC98Provider = { ARRAYSIZE(kEoB1SparkOfFlags1PC98), kEoB1SparkOfFlags1PC98 };

static const uint32 kEoB1SparkOfFlags2PC98[16] = {
	0xC0000000, 0x30000000, 0x0C000000, 0x03000000, 0x00C00000, 0x00300000, 0x000C0000, 0x00030000,
	0x0000C000, 0x00003000, 0x00000C00, 0x00000300, 0x000000C0, 0x00000030, 0x0000000C, 0x00000003
};

static const Uint32Provider kEoB1SparkOfFlags2PC98Provider = { ARRAYSIZE(kEoB1SparkOfFlags2PC98), kEoB1SparkOfFlags2PC98 };

static const byte kEoB1SparkOfShiftPC98[16] = {
	0x1E, 0x1C, 0x1A, 0x18, 0x16, 0x14, 0x12, 0x10,
	0x0E, 0x0C, 0x0A, 0x08, 0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB1SparkOfShiftPC98Provider = { ARRAYSIZE(kEoB1SparkOfShiftPC98), kEoB1SparkOfShiftPC98 };

static const byte kEoB1SparkOfXPC98[16] = {
	0x50, 0x70, 0x30, 0x68, 0x20, 0x60, 0x38, 0x78,
	0x80, 0x48, 0x58, 0x28, 0x60, 0x40, 0x70, 0x48
};

static const ByteProvider kEoB1SparkOfXPC98Provider = { ARRAYSIZE(kEoB1SparkOfXPC98), kEoB1SparkOfXPC98 };

static const byte kEoB1SparkOfYPC98[16] = {
	0x31, 0x2B, 0x48, 0x17, 0x16, 0x48, 0x35, 0x1B,
	0x43, 0x2E, 0x24, 0x28, 0x38, 0x1C, 0x16, 0x44
};

static const ByteProvider kEoB1SparkOfYPC98Provider = { ARRAYSIZE(kEoB1SparkOfYPC98), kEoB1SparkOfYPC98 };

static const byte kEoB1SpellPropertiesPC98[1007] = {
	0x6a, 0x18, 0xaf, 0x2b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6b, 0x18, 0xaf, 0x2b, 0x01,
	0xfd, 0x0f, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x7b, 0x10, 0x2e, 0x1b, 0x5c, 0x00, 0x74, 0x18,
	0xaf, 0x2b, 0x00, 0x8e, 0x10, 0x2e, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57,
	0x01, 0x87, 0x18, 0xaf, 0x2b, 0x08, 0x61, 0x11,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x11,
	0x2e, 0x1b, 0x5f, 0x00, 0x9c, 0x18, 0xaf, 0x2b,
	0x00, 0xd0, 0x11, 0x2e, 0x1b, 0xf0, 0x11, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x55, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xaf, 0x18, 0xaf, 0x2b, 0x04, 0x22,
	0x12, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x78,
	0x12, 0x2e, 0x1b, 0x5c, 0x00, 0xb8, 0x18, 0xaf,
	0x2b, 0x02, 0x9c, 0x12, 0x2e, 0x1b, 0x00, 0x00,
	0x00, 0x00, 0x43, 0x13, 0x2e, 0x1b, 0x58, 0x00,
	0xcf, 0x18, 0xaf, 0x2b, 0x01, 0x8f, 0x13, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0xb1, 0x13, 0x2e,
	0x1b, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x18,
	0xaf, 0x2b, 0x00, 0xd2, 0x13, 0x2e, 0x1b, 0xf3,
	0x13, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x60,
	0x01, 0xfb, 0x18, 0xaf, 0x2b, 0x00, 0x27, 0x14,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x14, 0x19, 0xaf, 0x2b,
	0x01, 0x2c, 0x14, 0x2e, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00, 0x29,
	0x19, 0xaf, 0x2b, 0x00, 0x36, 0x15, 0x2e, 0x1b,
	0x57, 0x15, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x62, 0x01, 0x38, 0x19, 0xaf, 0x2b, 0x00, 0x85,
	0x15, 0x2e, 0x1b, 0xa6, 0x15, 0x2e, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0x63, 0x01, 0x49, 0x19, 0xaf,
	0x2b, 0x08, 0xd4, 0x15, 0x2e, 0x1b, 0x00, 0x00,
	0x00, 0x00, 0x39, 0x16, 0x2e, 0x1b, 0x64, 0x00,
	0x52, 0x19, 0xaf, 0x2b, 0x00, 0x4f, 0x16, 0x2e,
	0x1b, 0x70, 0x16, 0x2e, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x65, 0x01, 0x65, 0x19, 0xaf, 0x2b, 0x08,
	0x24, 0x17, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0xb1, 0x13, 0x2e, 0x1b, 0x5e, 0x00, 0x90, 0x19,
	0xaf, 0x2b, 0x00, 0x5d, 0x17, 0x2e, 0x1b, 0x7e,
	0x17, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x01, 0xa5, 0x19, 0xaf, 0x2b, 0x02, 0xac, 0x17,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x18,
	0x2e, 0x1b, 0x66, 0x00, 0xba, 0x19, 0xaf, 0x2b,
	0x00, 0x6a, 0x18, 0x2e, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x01, 0xc1,
	0x19, 0xaf, 0x2b, 0x00, 0x2c, 0x19, 0x2e, 0x1b,
	0x4d, 0x19, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x59, 0x01, 0xd2, 0x19, 0xaf, 0x2b, 0x01, 0xe5,
	0x19, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5d, 0x00, 0xe1, 0x19, 0xaf,
	0x2b, 0x00, 0x5d, 0x1a, 0x2e, 0x1b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xee, 0x19, 0xaf, 0x2b, 0x00, 0x62, 0x1a, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x76, 0x01, 0x05, 0x1a, 0xaf, 0x2b, 0x00,
	0xa1, 0x1b, 0x2e, 0x1b, 0xc2, 0x1b, 0x2e, 0x1b,
	0x00, 0x00, 0x00, 0x00, 0x65, 0x01, 0x1a, 0x1a,
	0xaf, 0x2b, 0x08, 0x76, 0x1c, 0x2e, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0xbb, 0x1c, 0x2e, 0x1b, 0x5b,
	0x00, 0x21, 0x1a, 0xaf, 0x2b, 0x01, 0xc8, 0x1c,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x68, 0x00, 0x38, 0x1a, 0xaf, 0x2b,
	0x00, 0xeb, 0x1c, 0x2e, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x01, 0x51,
	0x1a, 0xaf, 0x2b, 0x08, 0x61, 0x11, 0x2e, 0x1b,
	0x00, 0x00, 0x00, 0x00, 0xaa, 0x11, 0x2e, 0x1b,
	0x5f, 0x00, 0x66, 0x1a, 0xaf, 0x2b, 0x01, 0x02,
	0x1d, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x37,
	0x1d, 0x2e, 0x1b, 0x6e, 0x00, 0x7f, 0x1a, 0xaf,
	0x2b, 0x01, 0x4d, 0x1d, 0x2e, 0x1b, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x1e, 0x2e, 0x1b, 0x5b, 0x00,
	0x86, 0x1a, 0xaf, 0x2b, 0x02, 0xfe, 0x1e, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x43, 0x13, 0x2e,
	0x1b, 0x63, 0x00, 0x99, 0x1a, 0xaf, 0x2b, 0x00,
	0x4f, 0x16, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x65, 0x01, 0xac, 0x1a,
	0xaf, 0x2b, 0x01, 0x3b, 0x1e, 0x2e, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0x98, 0x1e, 0x2e, 0x1b, 0x6f,
	0x00, 0xbd, 0x1a, 0xaf, 0x2b, 0x08, 0x8c, 0x1f,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x70, 0x00, 0xd0, 0x1a, 0xaf, 0x2b,
	0x01, 0x2c, 0x14, 0x2e, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00, 0xe5,
	0x1a, 0xaf, 0x2b, 0x04, 0xab, 0x1f, 0x2e, 0x1b,
	0x00, 0x00, 0x00, 0x00, 0xeb, 0x1f, 0x2e, 0x1b,
	0x71, 0x00, 0xfc, 0x1a, 0xaf, 0x2b, 0x08, 0x0c,
	0x20, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x20, 0x2e, 0x1b, 0x5b, 0x00, 0x07, 0x1b, 0xaf,
	0x2b, 0x08, 0x4e, 0x20, 0x2e, 0x1b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x00,
	0x1c, 0x1b, 0xaf, 0x2b, 0x01, 0x9c, 0x20, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x69, 0x00, 0x37, 0x1b, 0xaf, 0x2b, 0x00,
	0xc3, 0x20, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x01, 0x52, 0x1b,
	0xaf, 0x2b, 0x01, 0xdb, 0x20, 0x2e, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73,
	0x00, 0x6d, 0x1b, 0xaf, 0x2b, 0x08, 0x03, 0x21,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x61, 0x21,
	0x2e, 0x1b, 0x6e, 0x00, 0x8a, 0x1b, 0xaf, 0x2b,
	0x04, 0x9a, 0x21, 0x2e, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0xa7,
	0x1b, 0xaf, 0x2b, 0x01, 0xa4, 0x21, 0x2e, 0x1b,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6a, 0x00, 0xc6, 0x1b, 0xaf, 0x2b, 0x00, 0xcb,
	0x21, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6c, 0x01, 0xe5, 0x1b, 0xaf,
	0x2b, 0x00, 0xe3, 0x21, 0x2e, 0x1b, 0x04, 0x22,
	0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x62, 0x01,
	0xfa, 0x1b, 0xaf, 0x2b, 0x01, 0x26, 0x22, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x75, 0x00, 0x09, 0x1c, 0xaf, 0x2b, 0x01,
	0xa4, 0x23, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x1c, 0x1c,
	0xaf, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68,
	0x22, 0x2e, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x75,
	0x00, 0x1d, 0x1c, 0xaf, 0x2b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x8a, 0x22, 0x2e, 0x1b, 0x00, 0x00,
	0x00, 0x00, 0x75, 0x00, 0x1e, 0x1c, 0xaf, 0x2b,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x23, 0x2e,
	0x1b, 0x00, 0x00, 0x00, 0x00, 0x75, 0x00
};

static const ByteProvider kEoB1SpellPropertiesPC98Provider = { ARRAYSIZE(kEoB1SpellPropertiesPC98), kEoB1SpellPropertiesPC98 };

static const byte kEoB1MagicFlightPropsPC98[80] = {
	0x04, 0xff, 0x41, 0x09, 0x0a, 0xff, 0x04, 0x05,
	0x0d, 0xff, 0x7a, 0x06, 0x0e, 0xff, 0x0c, 0x05,
	0x10, 0xff, 0x4a, 0x0a, 0x12, 0x06, 0x38, 0x07,
	0x15, 0x06, 0x7a, 0x08, 0x19, 0xff, 0x4a, 0x0a,
	0x2f, 0xff, 0x4b, 0x06, 0x32, 0xff, 0x09, 0x07,
	0x33, 0xff, 0x09, 0x0a, 0x34, 0xff, 0x09, 0x0a,
	0x01, 0x01, 0x00, 0x00, 0x03, 0xfd, 0x02, 0xfe,
	0x01, 0xff, 0x00, 0x00, 0x98, 0x00, 0x18, 0x00,
	0x78, 0x00, 0x38, 0x00, 0x58, 0x00, 0x40, 0x40,
	0x38, 0x38, 0x38, 0x38, 0xe0, 0x20, 0x01, 0xff
};

static const ByteProvider kEoB1MagicFlightPropsPC98Provider = { ARRAYSIZE(kEoB1MagicFlightPropsPC98), kEoB1MagicFlightPropsPC98 };

static const byte kEoB1TurnUndeadEffectPC98[140] = {
	0x0a, 0x07, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0d, 0x0a,
	0x07, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x10, 0x0d, 0x0a, 0x07,
	0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x14, 0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0x14,
	0x13, 0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0x63, 0x63, 0x14, 0x13,
	0x10, 0x0d, 0x0a, 0x07, 0x04, 0x00, 0x00, 0x00,
	0x00, 0xff, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10,
	0x0d, 0x0a, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x63, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0d,
	0x0a, 0x07, 0x07, 0x04, 0x04, 0x00, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0d, 0x0a,
	0x0a, 0x07, 0x07, 0x04
};

static const ByteProvider kEoB1TurnUndeadEffectPC98Provider = { ARRAYSIZE(kEoB1TurnUndeadEffectPC98), kEoB1TurnUndeadEffectPC98 };

static const byte kEoB1BurningHandsDestPC98[8] = {
	0x02, 0x03, 0x00, 0x02, 0x00, 0x01, 0x01, 0x03
};

static const ByteProvider kEoB1BurningHandsDestPC98Provider = { ARRAYSIZE(kEoB1BurningHandsDestPC98), kEoB1BurningHandsDestPC98 };

static const byte kEoB1ConeOfColdDest1PC98[7] = {
	0xE0, 0xC0, 0xC1, 0xBF, 0xA0, 0x9F, 0xA1
};

static const ByteProvider kEoB1ConeOfColdDest1PC98Provider = { ARRAYSIZE(kEoB1ConeOfColdDest1PC98), kEoB1ConeOfColdDest1PC98 };

static const byte kEoB1ConeOfColdDest2PC98[7] = {
	0x01, 0x02, 0xE2, 0x22, 0x03, 0xE3, 0x23
};

static const ByteProvider kEoB1ConeOfColdDest2PC98Provider = { ARRAYSIZE(kEoB1ConeOfColdDest2PC98), kEoB1ConeOfColdDest2PC98 };

static const byte kEoB1ConeOfColdDest3PC98[7] = {
	0x20, 0x40, 0x3F, 0x41, 0x60, 0x5F, 0x61
};

static const ByteProvider kEoB1ConeOfColdDest3PC98Provider = { ARRAYSIZE(kEoB1ConeOfColdDest3PC98), kEoB1ConeOfColdDest3PC98 };

static const byte kEoB1ConeOfColdDest4PC98[7] = {
	0xFF, 0xFE, 0x1E, 0xDE, 0xFD, 0x1D, 0xDD
};

static const ByteProvider kEoB1ConeOfColdDest4PC98Provider = { ARRAYSIZE(kEoB1ConeOfColdDest4PC98), kEoB1ConeOfColdDest4PC98 };

static const byte kEoB1ConeOfColdGfxTblPC98[8] = {
	0x0F, 0x09, 0x0F, 0x09, 0x02, 0x0A, 0x02, 0x00
};

static const ByteProvider kEoB1ConeOfColdGfxTblPC98Provider = { ARRAYSIZE(kEoB1ConeOfColdGfxTblPC98), kEoB1ConeOfColdGfxTblPC98 };

static const byte kEoB1DscDoorShapeIndexPC98[32] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03
};

static const ByteProvider kEoB1DscDoorShapeIndexPC98Provider = { ARRAYSIZE(kEoB1DscDoorShapeIndexPC98), kEoB1DscDoorShapeIndexPC98 };

static const byte kEoB1WllFlagPresetPC98[25] = {
	0x07, 0x00, 0x40, 0xA8, 0x88, 0x88, 0x88, 0x9F,
	0xA8, 0x88, 0x88, 0x88, 0x9F, 0xAA, 0x8A, 0x8A,
	0x8A, 0x9F, 0xAA, 0x8A, 0x8A, 0x8A, 0x9F, 0x03,
	0x03
};

static const ByteProvider kEoB1WllFlagPresetPC98Provider = { ARRAYSIZE(kEoB1WllFlagPresetPC98), kEoB1WllFlagPresetPC98 };

static const uint16 kEoB1DscShapeCoordsPC98[180] = {
	0xFF91, 0xFFC1, 0xFFA1, 0xFFC1, 0xFF75, 0xFFC5, 0xFF8B, 0xFFC5,
	0xFF88, 0xFFC3, 0xFFB4, 0xFFC1, 0xFFC4, 0xFFC1, 0xFFA1, 0xFFC5,
	0xFFB6, 0xFFC5, 0xFFB0, 0xFFC3, 0xFFD5, 0xFFC1, 0xFFE5, 0xFFC1,
	0xFFCB, 0xFFC5, 0xFFE1, 0xFFC5, 0xFFD8, 0xFFC3, 0xFFF8, 0xFFC1,
	0x0008, 0xFFC1, 0xFFF6, 0xFFC5, 0x000A, 0xFFC5, 0x0000, 0xFFC3,
	0x001B, 0xFFC1, 0x002B, 0xFFC1, 0x001F, 0xFFC5, 0x0035, 0xFFC5,
	0x0028, 0xFFC3, 0x003C, 0xFFC1, 0x004C, 0xFFC1, 0x004A, 0xFFC5,
	0x005F, 0xFFC5, 0x0050, 0xFFC3, 0x005F, 0xFFC1, 0x006F, 0xFFC1,
	0x0075, 0xFFC5, 0x008B, 0xFFC5, 0x0078, 0xFFC3, 0xFF8A, 0xFFCB,
	0xFFA4, 0xFFCB, 0xFF68, 0xFFD3, 0xFF88, 0xFFD3, 0xFF8A, 0xFFCE,
	0xFFBE, 0xFFCB, 0xFFD8, 0xFFCB, 0xFFAC, 0xFFD3, 0xFFCD, 0xFFD3,
	0xFFC5, 0xFFCE, 0xFFF3, 0xFFCB, 0x000D, 0xFFCB, 0xFFF0, 0xFFD3,
	0x0010, 0xFFD3, 0x0000, 0xFFCE, 0x0028, 0xFFCB, 0x0042, 0xFFCB,
	0x0033, 0xFFD3, 0x0054, 0xFFD3, 0x003B, 0xFFCE, 0x005C, 0xFFCB,
	0x0076, 0xFFCB, 0x0078, 0xFFD3, 0x0098, 0xFFD3, 0x0076, 0xFFCE,
	0xFF92, 0xFFDD, 0xFFBD, 0xFFDD, 0xFF74, 0xFFEA, 0xFFAD, 0xFFEA,
	0xFF9E, 0xFFE2, 0xFFEA, 0xFFDD, 0x0016, 0xFFDD, 0xFFE5, 0xFFEA,
	0x001B, 0xFFEA, 0x0000, 0xFFE2, 0x0043, 0xFFDD, 0x006E, 0xFFDD,
	0x0053, 0xFFEA, 0x008C, 0xFFEA, 0x0062, 0xFFE2, 0xFF80, 0xFFFC,
	0x0080, 0xFFFC, 0xFF80, 0xFFBE, 0x0080, 0xFFBE, 0x0080, 0x0000,
	0xFFDA, 0xFFFC, 0x0026, 0xFFFC, 0xFFDA, 0xFFBE, 0x0026, 0xFFBE,
	0x0000, 0x0000, 0xFF80, 0xFFFC, 0x0080, 0xFFFC, 0xFF80, 0xFFBE,
	0x0080, 0xFFBE, 0x0080, 0x0000
};

static const Uint16Provider kEoB1DscShapeCoordsPC98Provider = { ARRAYSIZE(kEoB1DscShapeCoordsPC98), kEoB1DscShapeCoordsPC98 };

static const byte kEoB1DscDoorScaleOffsPC98[32] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F
};

static const ByteProvider kEoB1DscDoorScaleOffsPC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleOffsPC98), kEoB1DscDoorScaleOffsPC98 };

static const byte kEoB1DscDoorScaleMult1PC98[4] = {
	0x08, 0x0C, 0x12, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult1PC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleMult1PC98), kEoB1DscDoorScaleMult1PC98 };

static const byte kEoB1DscDoorScaleMult2PC98[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult2PC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleMult2PC98), kEoB1DscDoorScaleMult2PC98 };

static const byte kEoB1DscDoorScaleMult3PC98[4] = {
	0x04, 0x06, 0x09, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult3PC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleMult3PC98), kEoB1DscDoorScaleMult3PC98 };

static const byte kEoB1DscDoorScaleMult4PC98[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult4PC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleMult4PC98), kEoB1DscDoorScaleMult4PC98 };

static const byte kEoB1DscDoorScaleMult5PC98[4] = {
	0x07, 0x0B, 0x0E, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult5PC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleMult5PC98), kEoB1DscDoorScaleMult5PC98 };

static const byte kEoB1DscDoorScaleMult6PC98[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult6PC98Provider = { ARRAYSIZE(kEoB1DscDoorScaleMult6PC98), kEoB1DscDoorScaleMult6PC98 };

static const byte kEoB1DscDoorXEPC98[32] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F
};

static const ByteProvider kEoB1DscDoorXEPC98Provider = { ARRAYSIZE(kEoB1DscDoorXEPC98), kEoB1DscDoorXEPC98 };

static const byte kEoB1DscDoorY1PC98[4] = {
	0x3A, 0x47, 0x56, 0x00
};

static const ByteProvider kEoB1DscDoorY1PC98Provider = { ARRAYSIZE(kEoB1DscDoorY1PC98), kEoB1DscDoorY1PC98 };

static const byte kEoB1DscDoorY3PC98[4] = {
	0x20, 0x20, 0x18, 0x00
};

static const ByteProvider kEoB1DscDoorY3PC98Provider = { ARRAYSIZE(kEoB1DscDoorY3PC98), kEoB1DscDoorY3PC98 };

static const byte kEoB1DscDoorY4PC98[4] = {
	0x1E, 0x18, 0x10, 0x30
};

static const ByteProvider kEoB1DscDoorY4PC98Provider = { ARRAYSIZE(kEoB1DscDoorY4PC98), kEoB1DscDoorY4PC98 };

static const byte kEoB1DscDoorY5PC98[4] = {
	0x30, 0x34, 0x3B, 0x3A
};

static const ByteProvider kEoB1DscDoorY5PC98Provider = { ARRAYSIZE(kEoB1DscDoorY5PC98), kEoB1DscDoorY5PC98 };

static const byte kEoB1DscDoorY6PC98[4] = {
	0x3A, 0x45, 0x5A, 0x00
};

static const ByteProvider kEoB1DscDoorY6PC98Provider = { ARRAYSIZE(kEoB1DscDoorY6PC98), kEoB1DscDoorY6PC98 };

static const byte kEoB1DscDoorY7PC98[4] = {
	0x3B, 0x47, 0x58, 0x00
};

static const ByteProvider kEoB1DscDoorY7PC98Provider = { ARRAYSIZE(kEoB1DscDoorY7PC98), kEoB1DscDoorY7PC98 };

static const uint16 kEoB1DscDoorCoordsExtPC98[36] = {
	0x0000, 0x0000, 0xFFE8, 0x0010, 0x0020, 0x0040, 0x0048, 0x0068,
	0x0070, 0x0090, 0x00A0, 0x00C8, 0x0000, 0x0000, 0x0000, 0x0000,
	0xFFE8, 0x0030, 0x0038, 0x0078, 0x0080, 0x00C8, 0x0000, 0x0000,
	0xFFA8, 0x0020, 0x0028, 0x0088, 0x0090, 0x0108, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000
};

static const Uint16Provider kEoB1DscDoorCoordsExtPC98Provider = { ARRAYSIZE(kEoB1DscDoorCoordsExtPC98), kEoB1DscDoorCoordsExtPC98 };

static const byte kEoB1DscDoorFrameY1PC98[32] = {
	0x20, 0x18, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x18, 0x00, 0x1E, 0x18, 0x10, 0x00,
	0x3A, 0x48, 0x60, 0x78, 0x3A, 0x46, 0x56, 0x00,
	0x78, 0x78, 0x78, 0x78, 0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB1DscDoorFrameY1PC98Provider = { ARRAYSIZE(kEoB1DscDoorFrameY1PC98), kEoB1DscDoorFrameY1PC98 };

static const byte kEoB1DscDoorFrameY2PC98[32] = {
	0x20, 0x18, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x18, 0x00, 0x1E, 0x18, 0x10, 0x00,
	0x3A, 0x48, 0x60, 0x78, 0x3A, 0x46, 0x56, 0x00,
	0x78, 0x78, 0x78, 0x78, 0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB1DscDoorFrameY2PC98Provider = { ARRAYSIZE(kEoB1DscDoorFrameY2PC98), kEoB1DscDoorFrameY2PC98 };

static const byte kEoB1DscDoorFrameIndex1PC98[12] = {
	0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x08,
	0x08, 0x0C, 0x0C, 0x1C
};

static const ByteProvider kEoB1DscDoorFrameIndex1PC98Provider = { ARRAYSIZE(kEoB1DscDoorFrameIndex1PC98), kEoB1DscDoorFrameIndex1PC98 };

static const byte kEoB1DscDoorFrameIndex2PC98[12] = {
	0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x10, 0x10,
	0x10, 0x14, 0x14, 0x18
};

static const ByteProvider kEoB1DscDoorFrameIndex2PC98Provider = { ARRAYSIZE(kEoB1DscDoorFrameIndex2PC98), kEoB1DscDoorFrameIndex2PC98 };

static const byte kEoB1DscItemPosIndexPC98[16] = {
	0x00, 0x01, 0x02, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x03, 0x02, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02
};

static const ByteProvider kEoB1DscItemPosIndexPC98Provider = { ARRAYSIZE(kEoB1DscItemPosIndexPC98), kEoB1DscItemPosIndexPC98 };

static const uint16 kEoB1DscItemShpXPC98[18] = {
	0xFFC8, 0xFFF8, 0x0028, 0x0058, 0x0088, 0x00B8, 0x00E8, 0xFFB8,
	0x0008, 0x0058, 0x00A8, 0x00F8, 0xFFD8, 0x0058, 0x00D8, 0xFFA8,
	0x0058, 0x0108
};

static const Uint16Provider kEoB1DscItemShpXPC98Provider = { ARRAYSIZE(kEoB1DscItemShpXPC98), kEoB1DscItemShpXPC98 };

static const byte kEoB1DscItemScaleIndexPC98[18] = {
	0xFF, 0xFF, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF,
	0x25, 0x00
};

static const ByteProvider kEoB1DscItemScaleIndexPC98Provider = { ARRAYSIZE(kEoB1DscItemScaleIndexPC98), kEoB1DscItemScaleIndexPC98 };

static const byte kEoB1DscItemTileIndexPC98[18] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x09, 0xFF, 0x0B,
	0x0C, 0x0D
};

static const ByteProvider kEoB1DscItemTileIndexPC98Provider = { ARRAYSIZE(kEoB1DscItemTileIndexPC98), kEoB1DscItemTileIndexPC98 };

static const byte kEoB1DscItemShapeMapPC98[90] = {
	0x00, 0x00, 0x00, 0x04, 0x01, 0x02, 0x03, 0x04,
	0x05, 0x06, 0x07, 0x07, 0x12, 0x06, 0x0F, 0x12,
	0x14, 0x17, 0x13, 0x11, 0x15, 0x0D, 0x09, 0x09,
	0x16, 0x1F, 0x0C, 0x23, 0x0C, 0x0C, 0x0C, 0x0B,
	0x0A, 0x1C, 0x1C, 0x1A, 0x1B, 0x21, 0x1D, 0x1D,
	0x22, 0x22, 0x22, 0x00, 0x08, 0x00, 0x25, 0x18,
	0x16, 0x17, 0x16, 0x17, 0x16, 0x17, 0x19, 0x23,
	0x10, 0x1E, 0x24, 0x18, 0x1C, 0x20, 0x12, 0x21,
	0x1E, 0x23, 0x1C, 0x00, 0x20, 0x11, 0x11, 0x0D,
	0x1F, 0x09, 0x09, 0x15, 0x15, 0x0F, 0x05, 0x0C,
	0x1E, 0x1E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1B,
	0x1B, 0x00
};

static const ByteProvider kEoB1DscItemShapeMapPC98Provider = { ARRAYSIZE(kEoB1DscItemShapeMapPC98), kEoB1DscItemShapeMapPC98 };

static const byte kEoB1DscTelptrShpCoordsPC98[156] = {
	0x0C, 0x07, 0x1A, 0x01, 0x3E, 0x03, 0x0C, 0x1A,
	0x2A, 0x13, 0x40, 0x18, 0x02, 0x2D, 0x16, 0x25,
	0x28, 0x32, 0x36, 0x27, 0x0A, 0x3E, 0x16, 0x49,
	0x3E, 0x44, 0x06, 0x06, 0x2A, 0x04, 0x37, 0x0A,
	0x04, 0x1B, 0x1A, 0x16, 0x37, 0x1D, 0x0E, 0x2A,
	0x1B, 0x35, 0x2E, 0x28, 0x42, 0x30, 0x06, 0x47,
	0x06, 0x47, 0x2D, 0x4C, 0x0A, 0x04, 0x14, 0x00,
	0x2E, 0x01, 0x0C, 0x10, 0x1F, 0x10, 0x2F, 0x10,
	0x12, 0x18, 0x28, 0x1D, 0x01, 0x21, 0x08, 0x2A,
	0x11, 0x32, 0x2F, 0x2E, 0x1F, 0x25, 0x02, 0x02,
	0x01, 0x11, 0x01, 0x2F, 0x08, 0x1E, 0x11, 0x0E,
	0x11, 0x26, 0x1C, 0x01, 0x1E, 0x19, 0x1F, 0x33,
	0x24, 0x11, 0x26, 0x05, 0x28, 0x2B, 0x2F, 0x22,
	0x00, 0x13, 0x05, 0x01, 0x06, 0x08, 0x09, 0x0C,
	0x04, 0x1A, 0x08, 0x1F, 0x12, 0x05, 0x12, 0x15,
	0x16, 0x10, 0x1A, 0x08, 0x1A, 0x1D, 0x0A, 0x00,
	0x0A, 0x00, 0x00, 0x09, 0x00, 0x1E, 0x04, 0x11,
	0x08, 0x16, 0x08, 0x06, 0x10, 0x00, 0x11, 0x0D,
	0x12, 0x20, 0x15, 0x02, 0x14, 0x09, 0x16, 0x1B,
	0x1A, 0x14, 0x1A, 0x14
};

static const ByteProvider kEoB1DscTelptrShpCoordsPC98Provider = { ARRAYSIZE(kEoB1DscTelptrShpCoordsPC98), kEoB1DscTelptrShpCoordsPC98 };

static const byte kEoB1PortalSeqDataPC98[126] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x04, 0x00, 0x03, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04,
	0x00, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02,
	0x02, 0x03, 0x01, 0x04, 0x00, 0x02, 0x01, 0x03,
	0x02, 0x04, 0x03, 0x02, 0x04, 0x03, 0x03, 0x04,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x05, 0x04, 0x06, 0x03, 0x07,
	0x02, 0x08, 0x02, 0x08, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x00, 0x0A, 0xFF, 0xFF
};

static const ByteProvider kEoB1PortalSeqDataPC98Provider = { ARRAYSIZE(kEoB1PortalSeqDataPC98), kEoB1PortalSeqDataPC98 };

static const byte kEoB1DscMonsterFrmOffsTbl1PC98[32] = {
	0x04, 0xFE, 0x01, 0x03, 0x03, 0x04, 0xFE, 0x01,
	0x01, 0x03, 0x04, 0xFE, 0xFE, 0x01, 0x03, 0x04,
	0xFC, 0xFD, 0xFF, 0x02, 0x02, 0xFC, 0xFD, 0xFF,
	0xFF, 0x02, 0xFC, 0xFD, 0xFD, 0xFF, 0x02, 0xFC
};

static const ByteProvider kEoB1DscMonsterFrmOffsTbl1PC98Provider = { ARRAYSIZE(kEoB1DscMonsterFrmOffsTbl1PC98), kEoB1DscMonsterFrmOffsTbl1PC98 };

static const byte kEoB1DscMonsterFrmOffsTbl2PC98[32] = {
	0x04, 0xFE, 0x01, 0x03, 0x03, 0x04, 0xFE, 0x01,
	0x01, 0x03, 0x04, 0xFE, 0xFE, 0x01, 0x03, 0x04,
	0x04, 0xFD, 0x01, 0x02, 0x02, 0x04, 0xFD, 0x01,
	0x01, 0x02, 0x04, 0xFD, 0xFD, 0x01, 0x02, 0x04
};

static const ByteProvider kEoB1DscMonsterFrmOffsTbl2PC98Provider = { ARRAYSIZE(kEoB1DscMonsterFrmOffsTbl2PC98), kEoB1DscMonsterFrmOffsTbl2PC98 };

static const uint16 kEoB1InvSlotXPC98[27] = {
	0x00E6, 0x0116, 0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7,
	0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7,
	0x00E1, 0x00E0, 0x00E1, 0x012A, 0x011F, 0x0115, 0x012C, 0x012C,
	0x012C, 0x00E4, 0x00F0
};

static const Uint16Provider kEoB1InvSlotXPC98Provider = { ARRAYSIZE(kEoB1InvSlotXPC98), kEoB1InvSlotXPC98 };

static const byte kEoB1InvSlotYPC98[27] = {
	0x74, 0x74, 0x28, 0x28, 0x3A, 0x3A, 0x4C, 0x4C,
	0x5E, 0x5E, 0x70, 0x70, 0x82, 0x82, 0x94, 0x94,
	0x38, 0x4C, 0x60, 0x37, 0x4B, 0x89, 0x5E, 0x70,
	0x82, 0x88, 0x88
};

static const ByteProvider kEoB1InvSlotYPC98Provider = { ARRAYSIZE(kEoB1InvSlotYPC98), kEoB1InvSlotYPC98 };

static const uint16 kEoB1SlotValidationFlagsPC98[27] = {
	0x0008, 0x0008, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0x0001, 0x0002, 0x0004, 0x0020, 0x0040, 0x0010, 0xFFFF, 0x0080,
	0x0080, 0x0100, 0x0100
};

static const Uint16Provider kEoB1SlotValidationFlagsPC98Provider = { ARRAYSIZE(kEoB1SlotValidationFlagsPC98), kEoB1SlotValidationFlagsPC98 };

static const byte kEoB1ProjectileWeaponTypesPC98[8] = {
	0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x12
};

static const ByteProvider kEoB1ProjectileWeaponTypesPC98Provider = { ARRAYSIZE(kEoB1ProjectileWeaponTypesPC98), kEoB1ProjectileWeaponTypesPC98 };

static const byte kEoB1WandTypesPC98[7] = {
	0x00, 0x12, 0x18, 0x28, 0x0D, 0xFF, 0x04
};

static const ByteProvider kEoB1WandTypesPC98Provider = { ARRAYSIZE(kEoB1WandTypesPC98), kEoB1WandTypesPC98 };

static const byte kEoB1DrawObjPosIndexPC98[20] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x02, 0x00, 0x03,
	0x01, 0x04, 0x02, 0x03, 0x00, 0x01, 0x04, 0x01,
	0x03, 0x00, 0x02, 0x04
};

static const ByteProvider kEoB1DrawObjPosIndexPC98Provider = { ARRAYSIZE(kEoB1DrawObjPosIndexPC98), kEoB1DrawObjPosIndexPC98 };

static const byte kEoB1FlightObjFlipIndexPC98[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB1FlightObjFlipIndexPC98Provider = { ARRAYSIZE(kEoB1FlightObjFlipIndexPC98), kEoB1FlightObjFlipIndexPC98 };

static const byte kEoB1FlightObjShpMapPC98[88] = {
	0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01,
	0xFF, 0xFF, 0x03, 0xFF, 0x05, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static const ByteProvider kEoB1FlightObjShpMapPC98Provider = { ARRAYSIZE(kEoB1FlightObjShpMapPC98), kEoB1FlightObjShpMapPC98 };

static const byte kEoB1FlightObjSclIndexPC98[72] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03,
	0xFF, 0xFF, 0x03, 0x03, 0xFF, 0xFF, 0x03, 0x03,
	0xFF, 0xFF, 0x03, 0x03, 0xFF, 0xFF, 0x03, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static const ByteProvider kEoB1FlightObjSclIndexPC98Provider = { ARRAYSIZE(kEoB1FlightObjSclIndexPC98), kEoB1FlightObjSclIndexPC98 };

static const byte kEoB1DscShapeIndexPC98[36] = {
	0x01, 0x01, 0x04, 0x0A, 0x04, 0x08, 0x04, 0x01,
	0x04, 0xF8, 0x04, 0xF6, 0x00, 0x00, 0x03, 0x09,
	0x03, 0x07, 0x03, 0x01, 0x03, 0xF9, 0x03, 0xF7,
	0x02, 0x06, 0x02, 0x01, 0x02, 0xFA, 0x01, 0x05,
	0x01, 0x01, 0x01, 0xFB
};

static const ByteProvider kEoB1DscShapeIndexPC98Provider = { ARRAYSIZE(kEoB1DscShapeIndexPC98), kEoB1DscShapeIndexPC98 };

static const uint16 kEoB1DscXPC98[18] = {
	0xFF70, 0xFFA0, 0xFFD0, 0x0000, 0x0030, 0x0060, 0x0090, 0xFF60,
	0xFFB0, 0x0000, 0x0050, 0x00A0, 0xFF80, 0x0000, 0x0080, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB1DscXPC98Provider = { ARRAYSIZE(kEoB1DscXPC98), kEoB1DscXPC98 };

static const byte kEoB1DscTileIndexPC98[18] = {
	0x00, 0x06, 0x01, 0x05, 0x02, 0x04, 0x03, 0x07,
	0x0B, 0x08, 0x0A, 0x09, 0x0C, 0x0E, 0x0D, 0x0F,
	0x11, 0x10
};

static const ByteProvider kEoB1DscTileIndexPC98Provider = { ARRAYSIZE(kEoB1DscTileIndexPC98), kEoB1DscTileIndexPC98 };

static const byte kEoB1DscDimData1PC98[324] = {
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD8, 0xD7, 0xD8, 0xD8, 0x02, 0xD8, 0xD8, 0xD8,
	0xD8, 0xFE, 0xD7, 0xD8, 0xD8, 0xD8, 0xD7, 0x03,
	0xD8, 0xFD, 0xD8, 0xD8, 0xD8, 0xFE, 0xD8, 0x08,
	0xD8, 0xD8, 0xD8, 0xFE, 0xD7, 0x06, 0xD8, 0xD8,
	0xFA, 0x03, 0xD8, 0xFD, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xFA, 0xD7,
	0x10, 0xD8, 0xFD, 0xD7, 0x13, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xF2, 0xD8, 0x14, 0xD8, 0xD8,
	0xD8, 0xF0, 0xD7, 0x14, 0xD8, 0xED, 0x10, 0xD8,
	0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8, 0xEC, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD7, 0x14, 0xD8, 0xED,
	0xD7, 0xD8, 0xD8, 0x13, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0x06, 0xD8, 0xD8, 0xFA, 0x03, 0xD8, 0xFD,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xFA, 0xD8, 0x10, 0xD8, 0xFD, 0xD7,
	0x13, 0xFD, 0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xF0, 0xD8, 0xD8,
	0xD8, 0xED, 0x10, 0xD8, 0xD8, 0x13, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0x03, 0xD8, 0xFD,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xFD, 0xD8,
	0x13, 0xFD, 0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xED, 0xD8, 0xD8, 0xD8, 0x13, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8
};

static const ByteProvider kEoB1DscDimData1PC98Provider = { ARRAYSIZE(kEoB1DscDimData1PC98), kEoB1DscDimData1PC98 };

static const byte kEoB1DscDimData2PC98[648] = {
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x02, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x04, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x16, 0x00, 0x00, 0x03,
	0x00, 0x16, 0x03, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x16, 0x00, 0x08,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x02,
	0x16, 0x00, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x08, 0x0E,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x06, 0x10,
	0x00, 0x13, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x0E, 0x16,
	0x00, 0x16, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x16, 0x00, 0x00, 0x14,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x14, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x12, 0x16, 0x14, 0x16, 0x00, 0x16, 0x13, 0x16,
	0x16, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x00, 0x16,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x07, 0x0F,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x03, 0x16, 0x00, 0x16,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16
};

static const ByteProvider kEoB1DscDimData2PC98Provider = { ARRAYSIZE(kEoB1DscDimData2PC98), kEoB1DscDimData2PC98 };

static const byte kEoB1DscBlockMapPC98[12] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB1DscBlockMapPC98Provider = { ARRAYSIZE(kEoB1DscBlockMapPC98), kEoB1DscBlockMapPC98 };

static const byte kEoB1DscDimMapPC98[18] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03,
	0x03, 0x03
};

static const ByteProvider kEoB1DscDimMapPC98Provider = { ARRAYSIZE(kEoB1DscDimMapPC98), kEoB1DscDimMapPC98 };

static const byte kEoB1DscBlockIndexPC98[72] = {
	0x9D, 0x9E, 0x9F, 0xA0, 0xA1, 0xA2, 0xA3, 0xBE,
	0xBF, 0xC0, 0xC1, 0xC2, 0xDF, 0xE0, 0xE1, 0xFF,
	0x00, 0x01, 0xA3, 0xC3, 0xE3, 0x03, 0x23, 0x43,
	0x63, 0xC2, 0xE2, 0x02, 0x22, 0x42, 0xE1, 0x01,
	0x21, 0xE0, 0x00, 0x20, 0x63, 0x62, 0x61, 0x60,
	0x5F, 0x5E, 0x5D, 0x42, 0x41, 0x40, 0x3F, 0x3E,
	0x21, 0x20, 0x1F, 0x01, 0x00, 0xFF, 0x5D, 0x3D,
	0x1D, 0xFD, 0xDD, 0xBD, 0x9D, 0x3E, 0x1E, 0xFE,
	0xDE, 0xBE, 0x1F, 0xFF, 0xDF, 0x20, 0x00, 0xE0
};

static const ByteProvider kEoB1DscBlockIndexPC98Provider = { ARRAYSIZE(kEoB1DscBlockIndexPC98), kEoB1DscBlockIndexPC98 };

static const byte kEoB1ClassModifierFlagsPC98[15] = {
	0x01, 0x01, 0x05, 0x02, 0x04, 0x08, 0x05, 0x09,
	0x03, 0x0B, 0x0A, 0x0C, 0x07, 0x05, 0x06
};

static const ByteProvider kEoB1ClassModifierFlagsPC98Provider = { ARRAYSIZE(kEoB1ClassModifierFlagsPC98), kEoB1ClassModifierFlagsPC98 };

static const byte kEoB1MonsterStepTable01PC98[4] = {
	0xE0, 0x01, 0x20, 0xFF
};

static const ByteProvider kEoB1MonsterStepTable01PC98Provider = { ARRAYSIZE(kEoB1MonsterStepTable01PC98), kEoB1MonsterStepTable01PC98 };

static const byte kEoB1MonsterStepTable2PC98[8] = {
	0x07, 0xFA, 0x05, 0xFC, 0x03, 0xFE, 0x01, 0x00
};

static const ByteProvider kEoB1MonsterStepTable2PC98Provider = { ARRAYSIZE(kEoB1MonsterStepTable2PC98), kEoB1MonsterStepTable2PC98 };

static const byte kEoB1MonsterStepTable3PC98[8] = {
	0xF9, 0x06, 0xFB, 0x04, 0xFD, 0x02, 0xFF, 0x00
};

static const ByteProvider kEoB1MonsterStepTable3PC98Provider = { ARRAYSIZE(kEoB1MonsterStepTable3PC98), kEoB1MonsterStepTable3PC98 };

static const byte kEoB1MonsterCloseAttPosTable1PC98[4] = {
	0x00, 0x01, 0x03, 0x02
};

static const ByteProvider kEoB1MonsterCloseAttPosTable1PC98Provider = { ARRAYSIZE(kEoB1MonsterCloseAttPosTable1PC98), kEoB1MonsterCloseAttPosTable1PC98 };

static const byte kEoB1MonsterCloseAttPosTable21PC98[8] = {
	0x00, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03
};

static const ByteProvider kEoB1MonsterCloseAttPosTable21PC98Provider = { ARRAYSIZE(kEoB1MonsterCloseAttPosTable21PC98), kEoB1MonsterCloseAttPosTable21PC98 };

static const byte kEoB1MonsterCloseAttChkTable1PC98[16] = {
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00
};

static const ByteProvider kEoB1MonsterCloseAttChkTable1PC98Provider = { ARRAYSIZE(kEoB1MonsterCloseAttChkTable1PC98), kEoB1MonsterCloseAttChkTable1PC98 };

static const byte kEoB1MonsterCloseAttChkTable2PC98[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB1MonsterCloseAttChkTable2PC98Provider = { ARRAYSIZE(kEoB1MonsterCloseAttChkTable2PC98), kEoB1MonsterCloseAttChkTable2PC98 };

static const byte kEoB1MonsterCloseAttDstTable1PC98[16] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB1MonsterCloseAttDstTable1PC98Provider = { ARRAYSIZE(kEoB1MonsterCloseAttDstTable1PC98), kEoB1MonsterCloseAttDstTable1PC98 };

static const byte kEoB1MonsterCloseAttDstTable2PC98[48] = {
	0x01, 0x00, 0x03, 0x02, 0x05, 0x04, 0x00, 0x01,
	0x02, 0x03, 0x04, 0x05, 0x05, 0x03, 0x01, 0x04,
	0x02, 0x00, 0x01, 0x03, 0x05, 0x00, 0x02, 0x04,
	0x04, 0x05, 0x02, 0x03, 0x00, 0x01, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x02, 0x04, 0x01,
	0x03, 0x05, 0x04, 0x02, 0x00, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB1MonsterCloseAttDstTable2PC98Provider = { ARRAYSIZE(kEoB1MonsterCloseAttDstTable2PC98), kEoB1MonsterCloseAttDstTable2PC98 };

static const byte kEoB1MonsterProximityTablePC98[32] = {
	0x02, 0x03, 0x00, 0x01, 0x03, 0x02, 0x01, 0x00,
	0x00, 0x02, 0x01, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x01, 0x00, 0x03, 0x02, 0x00, 0x01, 0x02, 0x03,
	0x03, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB1MonsterProximityTablePC98Provider = { ARRAYSIZE(kEoB1MonsterProximityTablePC98), kEoB1MonsterProximityTablePC98 };

static const byte kEoB1FindBlockMonstersTablePC98[64] = {
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00,
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00
};

static const ByteProvider kEoB1FindBlockMonstersTablePC98Provider = { ARRAYSIZE(kEoB1FindBlockMonstersTablePC98), kEoB1FindBlockMonstersTablePC98 };

static const byte kEoB1MonsterDirChangeTablePC98[48] = {
	0xFF, 0x06, 0x02, 0xFF, 0x04, 0x05, 0x03, 0xFF,
	0x00, 0x07, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xDF, 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF,
	0x01, 0x00, 0x1F, 0x00, 0x20, 0x00, 0x21, 0x00,
	0xC0, 0xFF, 0xA0, 0xFF, 0x02, 0x00, 0x03, 0x00,
	0x40, 0x00, 0x60, 0x00, 0xFE, 0xFF, 0xFD, 0xFF
};

static const ByteProvider kEoB1MonsterDirChangeTablePC98Provider = { ARRAYSIZE(kEoB1MonsterDirChangeTablePC98), kEoB1MonsterDirChangeTablePC98 };

static const uint16 kEoB1EncodeMonsterDefsPC98[168] = {
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0028, 0x000c, 0x0038,
	0x0013, 0x0028, 0x000c, 0x0038, 0x001f, 0x0000, 0x0007, 0x0060,
	0x0000, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060,
	0x000e, 0x0060, 0x0005, 0x0038, 0x0007, 0x0000, 0x0007, 0x0028,
	0x000e, 0x0000, 0x0007, 0x0028, 0x0013, 0x0060, 0x0005, 0x0038,
	0x0018, 0x0060, 0x0005, 0x0038, 0x001d, 0x0060, 0x0005, 0x0038,
	0x000e, 0x0098, 0x0003, 0x0020, 0x0011, 0x00a0, 0x0004, 0x0018,
	0x0015, 0x00a0, 0x0004, 0x0018, 0x0019, 0x0098, 0x0003, 0x0020,
	0x001c, 0x0098, 0x0003, 0x0020, 0x001f, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0000, 0x0007, 0x0060,
	0x000e, 0x0000, 0x0007, 0x0060, 0x0015, 0x0000, 0x0007, 0x0060,
	0x001c, 0x0000, 0x0007, 0x0060, 0x0000, 0x0060, 0x0007, 0x0060,
	0x0007, 0x0060, 0x0005, 0x0038, 0x000c, 0x0060, 0x0005, 0x0038,
	0x0011, 0x0060, 0x0005, 0x0038, 0x0016, 0x0060, 0x0005, 0x0038,
	0x001b, 0x0060, 0x0005, 0x0038, 0x0020, 0x0060, 0x0005, 0x0038,
	0x0007, 0x0098, 0x0003, 0x0020, 0x000a, 0x0098, 0x0003, 0x0020,
	0x000d, 0x0098, 0x0003, 0x0020, 0x0010, 0x0098, 0x0003, 0x0020,
	0x0013, 0x0098, 0x0003, 0x0020, 0x0016, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x000a, 0x0058, 0x000a, 0x0000, 0x000a, 0x0058,
	0x0014, 0x0000, 0x000a, 0x0058, 0x001e, 0x0000, 0x000a, 0x0058,
	0x0000, 0x0058, 0x000a, 0x0058, 0x000a, 0x0058, 0x000a, 0x0058
};

static const Uint16Provider kEoB1EncodeMonsterDefsPC98Provider = { ARRAYSIZE(kEoB1EncodeMonsterDefsPC98), kEoB1EncodeMonsterDefsPC98 };

static const EoBCharacter kEoB1NpcPresetsPC98[9] = {
	{ 0x00, 0x01,
	  18, 18, 59, 59,  5,  5, 11, 11, 14, 14, 16, 16,  9,  9,
	    45,   45, 10, 0, 1, 0, 2, -1, 100, { 4, 0, 0 },
	  { 0x00001F40, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  17, 17,  0,  0,  9,  9, 15, 15, 13, 13, 18, 18, 17, 17,
	    55,   55, 10, 0, 0, 0, 0, -2, 100, { 7, 0, 0 },
	  { 0x000130B0, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  11, 11,  0,  0, 17, 17, 13, 13, 18, 18,  8,  8, 12, 12,
	    20,   20, 10, 0, 4, 3, 4, -3, 100, { 7, 0, 0 },
	  { 0x00011170, 0x00000000, 0x00000000 }, 0x00B3126B,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  10, 10,  0,  0, 12, 12,  9,  9, 15, 15, 17, 17, 17, 17,
	    52,   52, 10, 0, 4, 4, 0, -4, 100, { 6, 0, 0 },
	  { 0x00004E20, 0x00000000, 0x00000000 }, 0xFFFFFFFF,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  16, 16,  0,  0, 14, 14, 16, 16, 18, 18, 17, 17,  7,  7,
	    45,   45, 10, 0, 1, 1, 2, -5, 100, { 6, 0, 0 },
	  { 0x0000CF08, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  17, 17,  0,  0, 11, 11, 14, 14, 19, 19, 18, 18, 16, 16,
	    32,   32, 10, 0, 10, 5, 5, -6, 100, { 5, 0, 0 },
	  { 0x00002D3F, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  17, 17,  0,  0, 11, 11, 15, 15, 15, 15, 19, 19,  9,  9,
	     3,   45,  3, 0, 6, 0, 1, -7, 25, { 5, 0, 0 },
	  { 0x00003F6A, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0029, 0x0000, 0x002B, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  18, 18, 29, 29, 13, 13, 11, 11, 16, 16, 17, 17, 14, 14,
	    28,   28, 10, 0, 6, 0, 0, -8, 100, { 3, 0, 0 },
	  { 0x000013A0, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0024, 0x0000, 0x0030, 0x0037, 0x0037, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0029, 0x0000, 0x002B, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01,
	  18, 18, 92, 92, 15, 15, 15, 15, 12, 12, 19, 19, 17, 17,
	     3,   45,  3, 0, 6, 0, 1, -9, 25, { 5, 0, 0 },
	  { 0x00001F40, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } }
};

static const EoBCharacterProvider kEoB1NpcPresetsPC98Provider = { ARRAYSIZE(kEoB1NpcPresetsPC98), kEoB1NpcPresetsPC98 };

static const byte kEoB1Palettes16cPC98[480] = {
	0x00, 0x00, 0x00, 0x00, 0x0b, 0x05, 0x09, 0x06, 0x0a, 0x08, 0x03, 0x04, 0x06, 0x04, 0x02, 0x0c,
	0x0e, 0x06, 0x0c, 0x0f, 0x09, 0x07, 0x0a, 0x05, 0x04, 0x08, 0x04, 0x0a, 0x0a, 0x0d, 0x04, 0x04,
	0x0a, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x04, 0x04, 0x06, 0x08, 0x08, 0x09, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x06, 0x05, 0x08, 0x08, 0x08, 0x0a, 0x03, 0x0c, 0x04, 0x00, 0x06, 0x00, 0x0d,
	0x0e, 0x08, 0x08, 0x0f, 0x08, 0x06, 0x06, 0x03, 0x00, 0x0a, 0x02, 0x04, 0x04, 0x07, 0x0a, 0x09,
	0x0c, 0x04, 0x04, 0x06, 0x03, 0x03, 0x03, 0x04, 0x04, 0x06, 0x09, 0x0c, 0x06, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x00, 0x0b, 0x05, 0x07, 0x03, 0x0b, 0x09, 0x08, 0x0d, 0x0a, 0x0d, 0x02, 0x0c,
	0x0e, 0x05, 0x0b, 0x0d, 0x08, 0x07, 0x0a, 0x05, 0x05, 0x08, 0x04, 0x0d, 0x0d, 0x0f, 0x04, 0x04,
	0x0a, 0x02, 0x02, 0x05, 0x02, 0x02, 0x02, 0x04, 0x04, 0x06, 0x0b, 0x0a, 0x0c, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x02, 0x0c, 0x03, 0x09, 0x09, 0x0c, 0x04, 0x07, 0x03, 0x04, 0x04, 0x04, 0x0c,
	0x0e, 0x04, 0x0a, 0x0d, 0x08, 0x07, 0x09, 0x04, 0x01, 0x09, 0x02, 0x0c, 0x0c, 0x0f, 0x05, 0x04,
	0x0a, 0x02, 0x02, 0x05, 0x02, 0x02, 0x02, 0x06, 0x07, 0x06, 0x0a, 0x09, 0x08, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x00, 0x0b, 0x05, 0x09, 0x06, 0x0a, 0x08, 0x03, 0x04, 0x06, 0x04, 0x02, 0x0c,
	0x0e, 0x06, 0x0c, 0x0f, 0x09, 0x07, 0x0a, 0x05, 0x04, 0x08, 0x04, 0x0a, 0x0a, 0x0d, 0x04, 0x04,
	0x0a, 0x02, 0x02, 0x07, 0x02, 0x02, 0x02, 0x04, 0x04, 0x06, 0x07, 0x07, 0x08, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x04, 0x09, 0x06, 0x0f, 0x05, 0x05, 0x0a, 0x00, 0x02, 0x07, 0x00, 0x04, 0x07,
	0x07, 0x09, 0x0c, 0x0e, 0x0a, 0x07, 0x0a, 0x05, 0x04, 0x07, 0x04, 0x08, 0x08, 0x09, 0x0a, 0x0a,
	0x0b, 0x05, 0x05, 0x08, 0x02, 0x05, 0x02, 0x0b, 0x0c, 0x0b, 0x0c, 0x0d, 0x0c, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x0f, 0x0e, 0x0b, 0x0f, 0x0e, 0x08, 0x0d, 0x0d, 0x03, 0x0b, 0x09, 0x00, 0x0d,
	0x0b, 0x00, 0x0f, 0x01, 0x04, 0x0c, 0x00, 0x04, 0x0a, 0x04, 0x03, 0x07, 0x09, 0x03, 0x07, 0x05,
	0x02, 0x05, 0x04, 0x07, 0x08, 0x05, 0x09, 0x0b, 0x09, 0x0a, 0x0c, 0x0a, 0x0b, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x0d, 0x0e, 0x0b, 0x0c, 0x0d, 0x0b, 0x09, 0x0c, 0x06, 0x04, 0x05, 0x04, 0x0b,
	0x0d, 0x08, 0x0b, 0x0c, 0x00, 0x06, 0x08, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x0c, 0x08, 0x06,
	0x0f, 0x04, 0x03, 0x05, 0x00, 0x00, 0x00, 0x04, 0x02, 0x08, 0x06, 0x01, 0x0d, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x0d, 0x0e, 0x0b, 0x0c, 0x0d, 0x0a, 0x09, 0x0c, 0x06, 0x04, 0x05, 0x04, 0x0b,
	0x0d, 0x08, 0x0b, 0x0c, 0x0a, 0x05, 0x08, 0x03, 0x04, 0x05, 0x02, 0x05, 0x00, 0x00, 0x09, 0x00,
	0x00, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x06, 0x06, 0x08, 0x0f, 0x01, 0x03, 0x0f, 0x0f, 0x0f,
	0x00, 0x00, 0x00, 0x0d, 0x0e, 0x0b, 0x0e, 0x0f, 0x0b, 0x09, 0x0c, 0x06, 0x07, 0x08, 0x07, 0x0b,
	0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x05, 0x08, 0x03, 0x04, 0x06, 0x04, 0x06, 0x05, 0x04, 0x09, 0x07,
	0x07, 0x0c, 0x0c, 0x0c, 0x02, 0x03, 0x02, 0x09, 0x09, 0x0a, 0x0c, 0x08, 0x08, 0x0f, 0x0f, 0x0f
};

static const ByteProvider kEoB1Palettes16cPC98Provider = { ARRAYSIZE(kEoB1Palettes16cPC98), kEoB1Palettes16cPC98 };

static const byte kEoB1PalCycleDataPC98[725] = {
	0x00, 0xff, 0x20, 0xff, 0xfd, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e, 0x00,
	0x1e, 0x20, 0xff, 0xee, 0x00, 0x32, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e,
	0x20, 0xff, 0xdf, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20,
	0xff, 0xd0, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20, 0xff,
	0xc1, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0xb2,
	0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0xa3, 0x00,
	0x32, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0x94, 0x00, 0x32,
	0xff, 0x1e, 0xff, 0x1e, 0xff, 0x1e, 0xff, 0x1e, 0xff, 0x1e, 0x20, 0xff, 0x85, 0x00, 0x32, 0x00,
	0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0x76, 0x00, 0x32, 0x00, 0x1e,
	0xff, 0x1e, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0x67, 0x00, 0x32, 0xff, 0x1e, 0xff,
	0x1e, 0xff, 0x1e, 0xff, 0x1e, 0xff, 0x1e, 0x20, 0xff, 0x58, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e,
	0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0x49, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0xff,
	0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0x3a, 0x00, 0x32, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e,
	0xff, 0x1e, 0x00, 0x1e, 0x20, 0xff, 0x2b, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00,
	0x1e, 0x00, 0x1e, 0x20, 0xff, 0x1c, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e,
	0x00, 0x1e, 0x20, 0xff, 0x0d, 0x00, 0x32, 0x00, 0x1e, 0x00, 0x1e, 0xff, 0x1e, 0x00, 0x1e, 0x00,
	0x1e, 0x20, 0xfe, 0xfe, 0x00, 0x32, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e, 0x01, 0x1e, 0x00, 0x1e,
	0x20, 0xfe, 0xef, 0xfd, 0x01, 0x03, 0x01, 0x20, 0xff, 0xfb, 0xff, 0x01, 0x01, 0x01, 0x20, 0xff,
	0xfb, 0xff, 0x01, 0x01, 0x01, 0x20, 0xff, 0xfb, 0xfd, 0x01, 0x03, 0x01, 0x20, 0xff, 0xfb, 0xfe,
	0x01, 0x02, 0x01, 0x20, 0xff, 0xfb, 0xff, 0x01, 0x01, 0x01, 0x20, 0xff, 0xfb, 0x00, 0x01, 0x00,
	0x01, 0x20, 0xff, 0xfb, 0xff, 0x01, 0x01, 0x01, 0x20, 0xff, 0xfb, 0xff, 0x01, 0x01, 0x01, 0x20,
	0xff, 0xfb, 0x00, 0x01, 0x00, 0x01, 0x20, 0xff, 0xfb, 0xff, 0x01, 0x01, 0x01, 0x20, 0xff, 0xfb,
	0xff, 0x01, 0x01, 0x01, 0x20, 0xff, 0xfb, 0x00, 0x01, 0x00, 0x01, 0x20, 0xff, 0xfb, 0xff, 0x01,
	0x01, 0x01, 0x20, 0xff, 0xfb, 0xfe, 0x01, 0x02, 0x01, 0x20, 0xff, 0xfb, 0x00, 0x05, 0x00, 0x05,
	0xff, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x00, 0x05,
	0x20, 0xff, 0xeb, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00,
	0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0xff, 0x05, 0xff, 0x05, 0xff, 0x05,
	0xff, 0x05, 0xff, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x20, 0xff,
	0xeb, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00,
	0x05, 0x01, 0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05,
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0xff,
	0x05, 0xff, 0x05, 0xff, 0x05, 0xff, 0x05, 0x00, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01,
	0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05,
	0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0x00, 0x05, 0xff,
	0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00,
	0x05, 0x20, 0xff, 0xeb, 0xff, 0x05, 0xff, 0x05, 0xff, 0x05, 0xff, 0x05, 0x00, 0x05, 0x01, 0x05,
	0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0x00, 0x05, 0x00, 0x05, 0xff,
	0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x00, 0x05, 0x20,
	0xff, 0xeb, 0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x01, 0x05, 0x00, 0x05,
	0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x20, 0xff, 0xeb, 0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00,
	0x05, 0xff, 0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x20, 0xff, 0xeb,
	0x00, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05,
	0x00, 0x05, 0x00, 0x05, 0x20, 0xff, 0xeb, 0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0xff,
	0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05, 0x20, 0xff, 0xeb, 0x00, 0x05,
	0xff, 0x05, 0x00, 0x05, 0xff, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x00, 0x05, 0x01, 0x05,
	0x00, 0x05, 0x20, 0xff, 0xeb
};

static const ByteProvider kEoB1PalCycleDataPC98Provider = { ARRAYSIZE(kEoB1PalCycleDataPC98), kEoB1PalCycleDataPC98 };

static const uint16 kEoB1PalCycleStyle1PC98[96] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0023, 0x0001,
	0x0014, 0x0001, 0x0005, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0050, 0x0001,
	0x0041, 0x0001, 0x0032, 0x0001, 0x007d, 0x0001, 0x006e, 0x0001,
	0x005f, 0x0001, 0x00aa, 0x0001, 0x009b, 0x0001, 0x008c, 0x0001,
	0x00d7, 0x0001, 0x00c8, 0x0001, 0x00b9, 0x0001, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0104, 0x0001, 0x00f5, 0x0001, 0x00e6, 0x0001, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const Uint16Provider kEoB1PalCycleStyle1PC98Provider = { ARRAYSIZE(kEoB1PalCycleStyle1PC98), kEoB1PalCycleStyle1PC98 };

static const uint16 kEoB1PalCycleStyle2PC98[96] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0121, 0x0001,
	0x011a, 0x0001, 0x0113, 0x0001, 0x0136, 0x0001, 0x012f, 0x0001,
	0x0128, 0x0001, 0x014b, 0x0001, 0x0144, 0x0001, 0x013d, 0x0001,
	0x0160, 0x0001, 0x0159, 0x0001, 0x0152, 0x0001, 0x0175, 0x0001,
	0x016e, 0x0001, 0x0167, 0x0001, 0x01aa, 0x0001, 0x0193, 0x0001,
	0x017c, 0x0001, 0x01ef, 0x0001, 0x01d8, 0x0001, 0x01c1, 0x0001,
	0x0234, 0x0001, 0x021d, 0x0001, 0x0206, 0x0001, 0x0279, 0x0001,
	0x0262, 0x0001, 0x024b, 0x0001, 0x02be, 0x0001, 0x02a7, 0x0001,
	0x0290, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

static const Uint16Provider kEoB1PalCycleStyle2PC98Provider = { ARRAYSIZE(kEoB1PalCycleStyle2PC98), kEoB1PalCycleStyle2PC98 };

static const byte kEoB1FinaleEyesAnimPC98[50] = {
	0x00, 0x14, 0x01, 0x03, 0x00, 0x1e, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x14, 0x01, 0x03,
	0x04, 0x0f, 0x03, 0x03, 0x02, 0x03, 0x01, 0x0a, 0x01, 0x02, 0x00, 0x14, 0x02, 0x03, 0x03, 0x03,
	0x04, 0x28, 0x03, 0x03, 0x02, 0x03, 0x01, 0x0a, 0x01, 0x03, 0x00, 0x14, 0x00, 0x14, 0x01, 0x03,
	0x64, 0x64
};

static const ByteProvider kEoB1FinaleEyesAnimPC98Provider = { ARRAYSIZE(kEoB1FinaleEyesAnimPC98), kEoB1FinaleEyesAnimPC98 };

static const uint16 kEoB1FinaleHandsAnimPC98[30] = {
	0xffd8, 0x0028, 0xffe2, 0x002d, 0xffec, 0x0032, 0xfff6, 0x0030,
	0x0000, 0x002d, 0x0004, 0x002d, 0x0006, 0x002d, 0x0006, 0x002d,
	0x0006, 0x002d, 0x0006, 0x002d, 0x0006, 0x002d, 0x0006, 0x002d,
	0x0006, 0x002d, 0x0006, 0x002d, 0x0309, 0x0309
};

static const Uint16Provider kEoB1FinaleHandsAnimPC98Provider = { ARRAYSIZE(kEoB1FinaleHandsAnimPC98), kEoB1FinaleHandsAnimPC98 };

static const uint16 kEoB1FinaleHandsAnim2PC98[30] = {
	0x00a0, 0x0028, 0x00a0, 0x0028, 0x00a0, 0x0028, 0x0096, 0x002d,
	0x008c, 0x002d, 0x0082, 0x0032, 0x0078, 0x0036, 0x006e, 0x0039,
	0x0064, 0x0037, 0x005a, 0x0034, 0x004e, 0x0031, 0x0040, 0x002e,
	0x0038, 0x002b, 0x0032, 0x0028, 0x0309, 0x0309
};

static const Uint16Provider kEoB1FinaleHandsAnim2PC98Provider = { ARRAYSIZE(kEoB1FinaleHandsAnim2PC98), kEoB1FinaleHandsAnim2PC98 };

static const byte kEoB1FinaleHandsAnim3PC98[50] = {
	0x00, 0x02, 0x05, 0x07, 0x09, 0x07, 0x05, 0x02,
	0x00, 0x02, 0x05, 0x07, 0x09, 0x07, 0x05, 0x02,
	0x00, 0x02, 0x05, 0x07, 0x09, 0x07, 0x05, 0x02,
	0x00, 0x02, 0x05, 0x07, 0x09, 0x07, 0x05, 0x02
};

static const ByteProvider kEoB1FinaleHandsAnim3PC98Provider = { ARRAYSIZE(kEoB1FinaleHandsAnim3PC98), kEoB1FinaleHandsAnim3PC98 };

static const byte kEoB1CreditsCharWdthPC98[128] = {
	0x0b, 0x0a, 0x09, 0x0b, 0x0a, 0x09, 0x0a, 0x0b,
	0x06, 0x08, 0x0c, 0x09, 0x0d, 0x0c, 0x09, 0x0a,
	0x09, 0x0b, 0x09, 0x0b, 0x0c, 0x0e, 0x0c, 0x0d,
	0x0b, 0x0a, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x09, 0x08, 0x07, 0x0a, 0x07, 0x07, 0x08, 0x09,
	0x06, 0x05, 0x08, 0x04, 0x0f, 0x0a, 0x08, 0x0a,
	0x09, 0x07, 0x07, 0x06, 0x0a, 0x09, 0x0e, 0x0c,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB1CreditsCharWdthPC98Provider = { ARRAYSIZE(kEoB1CreditsCharWdthPC98), kEoB1CreditsCharWdthPC98 };

static const uint16 kEoB1Ascii2SjisTable1PC98[30] = {
	0x4b83, 0x4d83, 0x4f83, 0x5183, 0x5383, 0x5583, 0x5783, 0x5983,
	0x5b83, 0x5d83, 0x5f83, 0x6183, 0x6483, 0x6683, 0x6883, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x6f83, 0x7283, 0x7583, 0x7883,
	0x7b83, 0x7083, 0x7383, 0x7683, 0x7983, 0x7c83
};

static const Uint16Provider kEoB1Ascii2SjisTable1PC98Provider = { ARRAYSIZE(kEoB1Ascii2SjisTable1PC98), kEoB1Ascii2SjisTable1PC98 };

static const uint16 kEoB1Ascii2SjisTable2PC98[160] = {
	0x4081, 0x3981, 0x3a81, 0x9481, 0x9081, 0x9381, 0x9581, 0x8c81,
	0x6981, 0x6a81, 0x9681, 0x7b81, 0x4381, 0x7c81, 0x4481, 0x5e81,
	0x4f82, 0x5082, 0x5182, 0x5282, 0x5382, 0x5482, 0x5582, 0x5682,
	0x5782, 0x5882, 0x4681, 0x4781, 0x7181, 0x8181, 0x7281, 0x4881,
	0x9781, 0x6082, 0x6182, 0x6282, 0x6382, 0x6482, 0x6582, 0x6682,
	0x6782, 0x6882, 0x6982, 0x6a82, 0x6b82, 0x6c82, 0x6d82, 0x6e82,
	0x6f82, 0x7082, 0x7182, 0x7282, 0x7382, 0x7482, 0x7582, 0x7682,
	0x7782, 0x7882, 0x7982, 0x6d81, 0x8f81, 0x6e81, 0x4f81, 0x5181,
	0x4081, 0x8182, 0x8282, 0x8382, 0x8482, 0x8582, 0x8682, 0x8782,
	0x8882, 0x8982, 0x8a82, 0x8b82, 0x8c82, 0x8d82, 0x8e82, 0x8f82,
	0x9082, 0x9182, 0x9282, 0x9382, 0x9482, 0x9582, 0x9682, 0x9782,
	0x9882, 0x9982, 0x9a82, 0x6f81, 0x6281, 0x7081, 0x6081, 0x4081,
	0x4081, 0x4281, 0x7581, 0x7681, 0x4181, 0x4581, 0x9283, 0x4083,
	0x4283, 0x4483, 0x4683, 0x4883, 0x8383, 0x8583, 0x8783, 0x6283,
	0x5b81, 0x4183, 0x4383, 0x4583, 0x4783, 0x4983, 0x4a83, 0x4c83,
	0x4e83, 0x5083, 0x5283, 0x5483, 0x5683, 0x5883, 0x5a83, 0x5c83,
	0x5e83, 0x6083, 0x6383, 0x6583, 0x6783, 0x6983, 0x6a83, 0x6b83,
	0x6c83, 0x6d83, 0x6e83, 0x7183, 0x7483, 0x7783, 0x7a83, 0x7d83,
	0x7e83, 0x8083, 0x8183, 0x8283, 0x8483, 0x8683, 0x8883, 0x8983,
	0x8a83, 0x8b83, 0x8c83, 0x8d83, 0x8f83, 0x9383, 0x4a81, 0x4b81
};

static const Uint16Provider kEoB1Ascii2SjisTable2PC98Provider = { ARRAYSIZE(kEoB1Ascii2SjisTable2PC98), kEoB1Ascii2SjisTable2PC98 };

static const uint8 kEoB1FontLookupTablePC98[275] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x01, 0x01, 0x01, 0x01,
	0x0c, 0x0d, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x0f, 0x10, 0x01, 0x11,
	0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x13, 0x14, 0x01, 0x01, 0x15, 0x16,
	0x17, 0x18, 0x01, 0x01, 0x01, 0x01, 0x19, 0x1a,
	0x01, 0x01, 0x01, 0x01, 0x1b, 0x1c, 0x01, 0x01,
	0x01, 0x01, 0x1d, 0x01, 0x1e, 0x1f, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x20, 0x21, 0x01, 0x01, 0x22, 0x23, 0x24, 0x25,
	0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d,
	0x2e, 0x2f, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
	0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e,
	0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x47, 0x48, 0x49, 0x4a, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
	0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
	0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
	0x61, 0x62, 0x63, 0x64, 0x65, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x66, 0x67, 0x68, 0x69, 0x6a,
	0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72,
	0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a,
	0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x82,
	0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a,
	0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92,
	0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a,
	0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2,
	0xa3, 0xa4, 0x01, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9,
	0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0xb0, 0xb1,
	0xb2, 0xb3, 0xb4, 0x01, 0x01, 0xb5, 0xb6, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01
};

static const ByteProvider kEoB1FontLookupTablePC98Provider = { ARRAYSIZE(kEoB1FontLookupTablePC98), kEoB1FontLookupTablePC98 };

static const char *const kEoB1SoundFilesIntroPC98[2] = {
	"DUM",
	"EOBOP"
};

static const StringListProvider kEoB1SoundFilesIntroPC98Provider = { ARRAYSIZE(kEoB1SoundFilesIntroPC98), kEoB1SoundFilesIntroPC98 };

static const char *const kEoB1SoundFilesIngamePC98[14] = {
	"DUM",
	"E1.OBJ",
	"E2.OBJ",
	"E2.OBJ",
	"E7.OBJ",
	"E7.OBJ",
	"E5.OBJ",
	"E5.OBJ",
	"E4.OBJ",
	"E4.OBJ",
	"E8.OBJ",
	"E8.OBJ",
	"E3.OBJ",
	"E6.OBJ"
};

static const StringListProvider kEoB1SoundFilesIngamePC98Provider = { ARRAYSIZE(kEoB1SoundFilesIngamePC98), kEoB1SoundFilesIngamePC98 };

static const char *const kEoB1SoundFilesFinalePC98[2] = {
	"DUM",
	"EOBEND"
};

static const StringListProvider kEoB1SoundFilesFinalePC98Provider = { ARRAYSIZE(kEoB1SoundFilesFinalePC98), kEoB1SoundFilesFinalePC98 };
