#version 330

layout(lines) in;
layout(triangle_strip, max_vertices = 103) out;
//layout(line_strip, max_vertices = 80) out;

uniform mat4 pmv;
uniform mat3 normalMatrix;
uniform int dontshowSymElement[200];
uniform int dontshowSymOperation[200];
uniform int dssesize=0;
uniform int dssosize=0;
uniform float axisThickness=0.04;

in float coli[];
in float oprn[];
out vec3 Normal;
out float col;

const int segments = 5;
const float PI = 3.14159265359f;

out gl_PerVertex{
  vec4 gl_Position;
};




void main() {
  for (int i=0; i<dssesize; i++) if ((dontshowSymElement[i]==coli[0])||(dontshowSymElement[i]==coli[1])) return;
  for (int i=0; i<dssosize; i++) if ((dontshowSymOperation[i]==oprn[0])||(dontshowSymOperation[i]==oprn[1])) return;
  /*
  gl_Position = pmv*gl_in[0].gl_Position;
  col = coli[0];
  Normal = normalMatrix*vec3(1,0,0);
  EmitVertex();
  gl_Position = pmv*gl_in[1].gl_Position;
  col = coli[1];
  Normal = normalMatrix*vec3(1,0,0);
  EmitVertex();
  EndPrimitive();
 */
  vec4 start = gl_in[0].gl_Position;
  vec4 end = gl_in[1].gl_Position;
  start.w = 1.0;
  end.w = 1.0;
  vec3 direction   = normalize(end.xyz - start.xyz);
  float l = length(end.xyz - start.xyz);
  vec3 lot = (abs(dot(direction, vec3(1, 0, 0))) > 0.8)?
              (abs(dot(direction, vec3(0, 1, 0))) > 0.8)?
              normalize(cross(direction, vec3(0, 0, 1))):
              normalize(cross(direction, vec3(0, 1, 0))):
              normalize(cross(direction, vec3(1, 0, 0)));
  vec3 lot2 = normalize(cross(direction,lot));
  vec3 r = vec3(0,0,0);
  float rad = axisThickness;
  vec3 vert=vec3(0,0,0);
  for (int i = 0; i <= 2*segments; i++){
      r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;

      vert = start.xyz  + rad * r;
      gl_Position = pmv* vec4(vert, 1);
      Normal = normalize(normalMatrix * r);
      col = coli[0];
      EmitVertex();

      vert = end.xyz  + rad * r;
      gl_Position = pmv* vec4(vert , 1);
      Normal = normalize(normalMatrix * r);
      col = coli[1];
      EmitVertex();
  }
  EndPrimitive();

}


/*
for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = start.xyz  + rad * r;
    gl_Position = pmv* vec4(vert, 1);
    Normal = normalMatrix * r;
    bondlength = l;
    _an = toan;
    _style = tostyle;//abs(styleI[0]-styleI[1]);
    distance_from_start = 0.0;
    EmitVertex();
    vert = end.xyz  + rad * r;
    gl_Position = pmv* vec4(vert , 1);
    Normal = normalMatrix * r;
    distance_from_start = 1.0;
    bondlength = l;
    _an = toan;
    _style = tostyle;//abs(styleI[0]-styleI[1]);
    EmitVertex();
}
EndPrimitive();
*/
