# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** opendocument text generation

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/odf.rb;hb=HEAD]

=end
module SiSU_XML_ODF_ODT
  require_relative 'se_hub_particulars'                 # se_hub_particulars.rb
    include SiSU_Particulars
  require_relative 'ao'                                 # ao.rb
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  require_relative 'xml_parts'                          # xml_parts.rb
  require_relative 'xml_odf_odt_format'                 # xml_odf_odt_format.rb
    include SiSU_XML_ODF_ODT_Format
  require_relative 'shared_metadata'                    # shared_metadata.rb
  require_relative 'txt_shared'                         # txt_shared.rb
  require_relative 'xml_shared'                         # xml_shared.rb
    include SiSU_XML_Munge
  require_relative 'xml_persist'                        # xml_persist.rb
  @@alt_id_count,@@alt_id_count=0,0
  class Source
    begin
      require 'zlib'
      require 'find'
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
        error('zlib or find NOT FOUND (LoadError)')
    end
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
      @@endnotes_para=[]
    end
    def read
      begin
        @md,@env,@ao_array=@particulars.md,@particulars.env,@particulars.ao_array
        unless  @opt.act[:quiet][:set]==:on
          tool=(@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? "#{@env.program.odf_viewer} file://#{@md.file.output_path.odt.dir}/#{@md.file.base_filename.odt}"
          : "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
          (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'Opendocument (ODF:ODT)',
              tool
            ).green_hi_blue
          : SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'Opendocument (ODF:ODT)',
              tool
            ).green_title_hi
          if (@opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              @opt.fns,
              'file://' \
              + @md.file.output_path.odt.dir + '/' \
              + @md.file.base_filename.odt
            ).flow
          end
        end
        SiSU_XML_ODF_ODT::Source::Scroll.new(@particulars).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        Dir.chdir(@opt.f_pth[:pth])
      end
    end
    private
    class Scroll <Source
      require_relative 'txt_shared'                     # txt_shared.rb
      include SiSU_Parts_XML
      @@img_count=0
      @@docstart=true
      @@fns=nil
      def initialize(particulars)
        @md,@env,@ao_array=particulars.md,particulars.env,particulars.ao_array
        @make=SiSU_Env::ProcessingSettings.new(@md)
        @tab="\t"
        @br=(@md.opt.act[:maintenance][:set]==:on) \
        ? '' : ''
      end
      def songsheet
        begin
          @per=SiSU_XML_Persist::Persist.new
          pre
          @data=markup(@ao_array)
          publish
        ensure
          SiSU_XML_Persist::Persist.new.persist_init
          unless (@md.opt.act[:verbose_plus][:set]==:on \
          || @md.opt.act[:maintenance][:set]==:on)
            if @env.processing_path.odt =~/od[ft]/
              #p "rm -r #{@env.processing_path.odt}" if @md.opt.selections.str =~/v/
              FileUtils::rm_r(@env.processing_path.odf_pth)
              #system("rm -r #{@env.processing_path.odt}")
            end
          end
        end
      end
      def break_line
        (@md.opt.act[:maintenance][:set]==:on) \
        ? "\n" : ''
      end
      # Used for extraction of endnotes from paragraphs
      def extract_endnotes(dob='')
        notes=dob.obj.scan(/#{Mx[:en_a_o]}(\d+\s+.+?)#{Mx[:en_a_c]}/)[1] #FIX
        @n=[]
        notes.each do |n| #high cost to deal with <br> appropriately within odf, consider
          n=n.dup.to_s
          if n =~/#{Mx[:br_line]}/
            fix=n.split(/#{Mx[:br_line]}/) #watch #added
            fix.each do |x|
              if x =~/\S+/ then @n << x
              end
            end
          else                  @n << n
          end
        end
      end
      def odf_book_idx
      if @md.book_idx
        idx_arr=[]
        idx_raw=SiSU_Particulars::CombinedSingleton.
          instance.get_idx_raw(@md.opt).raw_idx
        idx_raw.each do |x|
          x=if x.is_a?(String)
            SiSU_XML_ODF_ODT_Format::FormatBookIndex.new(x).
              book_idx_bookmark
          else nil
          end
          idx_arr << x.strip if x.is_a?(String)
        end
        @per.book_idx=idx_arr.join
      end
      end
      def odf_metadata
        @per.metadata=SiSU_Metadata::Summary.new(@md).
          odf.metadata
      end
      def odf_tail
        manifest="#{@md.file.output_path.manifest.url}/#{@md.file.base_filename.manifest}"
        @per.tail << %{<text:p text:style-name="P_normal">Available document outputs: <br /> &lt;<text:a xl:type="simple" xl:href="#{manifest}">#{manifest}</text:a>&gt;</text:p>}
        @per.tail << %{\n<text:p text:style-name="P_normal">SiSU: &lt;<text:a xl:type="simple" xl:href="http://www.jus.uio.no/lm">www.jus.uio.no/sisu</text:a>&gt; and &lt;<text:a xl:type="simple" xl:href="http://www.sisudoc.org">www.sisudoc.org</text:a>&gt;</text:p>}
        @per.tail << "\n</office:text></office:body></office:document-content>"
      end
      def set_bookmark_tag(dob)
        SiSU_XML_ODF_ODT_Format::Tags.new.set_bookmark_tag(dob)
      end
      def heading(dob,p_num)
        dob=footnote(dob)
        m=/#{$1}/
        breakpage=''
        if @md.fns \
        and @md.fns != '' \
        and @md.fns !=@@fns
          @@docstart=true
          @@fns=@md.fns
        end
        unless @@docstart
          breakpage=if (@md.pagenew || @md.pagebreak) \
          and (@md.pagenew =~m or @md.pagebreak =~m)
            '<text:p text:style-name="P_normal_page_new"> </text:p>'
          elsif @md.pageline \
          and @md.pageline =~m #fix
          else ''
          end
        end
        @@docstart=false
        if dob.use_ != :dummy
          dob.tmp=dob.obj
          dob.obj=%{#{breakpage}<text:h text:style-name="H_#{dob.ln}" text:outline-level="#{dob.ln}">} \
          + %{#{p_num[:set_ref]}#{set_bookmark_tag(dob)}#{dob.obj}#{p_num[:display]}</text:h>}
        else dob.tmp,dob.obj='',''
        end
        dob
      end
      def toc(dob,p_num)
        hardspace=(dob.lv =~/[A-D]/i) \
        ? '<text:p text:style-name="Standard"/>'
        : ''
        toc_heading=dob.ocn \
        ? (%{<text:bookmark-ref text:reference-format="text" text:ref-name="#{dob.ocn}">} \
          + %{#{dob.tmp}</text:bookmark-ref>})
        : dob.tmp
        dob.obj=%{<text:h text:style-name="H_#{dob.ln}" text:outline-level="#{dob.ln}">} \
        + %{#{toc_heading}</text:h>#{hardspace}}
        dob
      end
      def image_src(i)
        if @md.fns =~/\.ss[tm]$/ \
        and FileTest.file?("#{@env.path.image_source_include(@md)}/#{i}") #review
          @env.path.image_source_include(@md)
        elsif @md.opt.f_pth[:pth] =~/\/\S+?\/sisupod\/\S+?\/sisupod\/doc/
          pt=/(\/\S+?\/sisupod\/\S+?\/sisupod)\/doc/.match(@md.opt.f_pth[:pth])[1]
          img_src=pt + '/image'
          if FileTest.file?("#{img_src}/#{i}")
            img_src
          else
            SiSU_Screen::Ansi.new(
              @md.opt.act[:color_state][:set],
              "ERROR - image:",
              %{"#{i}" missing},
              "search locations: #{@env.path.image_source_include_local}," \
              + "#{@env.path.image_source_include_remote} and" \
              + "#{@env.path.image_source_include}"
            ).error2 unless @md.opt.act[:quiet][:set]==:on
            nil
          end
        elsif @md.fns =~/\.ss[tm]$/ \
        and FileTest.file?("#{@env.path.image_source_include_local}/#{i}") #review
          @env.path.image_source_include_local
        elsif @md.fns =~/\.ss[tm]$/ \
        and FileTest.file?("#{@env.path.image_source_sisu_includes(@md)}/#{i}")
          @env.path.image_source_sisu_includes(@md)
        elsif @md.fns =~/\.-ss[tm]$/ \
        and FileTest.file?("#{@env.path.image_source_include_remote}/#{i}")
          @env.path.image_source_include_remote
        else
          SiSU_Screen::Ansi.new(
            @md.opt.act[:color_state][:set],
            "ERROR - image:",
              %{"#{i}" missing},
              "search locations: " \
              + @env.path.image_source_include_local + ',' \
              + @env.path.image_source_include_remote + 'and' \
              + @env.path.image_source_include \
              + @md.opt.sisu_data_dir?
          ).error2 unless @md.opt.act[:quiet][:set]==:on
          nil
        end
      end
      def image_odf(img)
        # copy image to od image directory (unless exists)
        # divide pixel dimension by 37.79485 and retain 3 decimal places
        m=img[1]
        i=/^(\S+?\.(?:png|jpg|gif))/.match(m).captures.join \
          if m =~/^(\S+?\.(?:png|jpg|gif))/
        c=/^\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"/.match(m).captures.join \
          if m =~/^\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"/
        w,h=/\s(\d+)x(\d+)/.match(m).captures if m =~/\s\d+x\d+/
        w=(w.to_i/37.79485).to_s
        h=(h.to_i/37.79485).to_s
        h=/([0-9]+\.\d{0,3})/.match(h).captures.join
        w=/([0-9]+\.\d{0,3})/.match(w).captures.join
        image_source=image_src(i)
        if image_source
          if FileTest.file?("#{image_source}/#{i}")
            FileUtils::cp(
              "#{image_source}/#{i}",
              "#{@env.processing_path.odt}/Pictures/#{i}"
            )
          else STDERR.puts %{\t*WARN* did not find image - "#{image_source}/#{i}" [#{__FILE__}:#{__LINE__}]}
          end
        end
        img=if i.to_s =~/jpg|png|gif/ \
        and h.to_s =~/\d/ \
        and w.to_s =~/\d/
          @@img_count +=1
          %{<draw:frame draw:style-name="fr1" draw:name="graphics#{@@img_count}" text:anchor-type="as-char" svg:width="#{w}cm" svg:height="#{h}cm" draw:z-index="2"><draw:image xl:href="Pictures/#{i}" xl:type="simple" xl:show="embed" xl:actuate="onLoad"/></draw:frame>#{c}} #anchor-type: as-char or paragraph or char or ...
        else %{<text:p text:style-name="P_normal">[image omitted]</text:p>}
        end
      end
      def image(dob)
        m=if dob.obj =~/#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
          dob.obj.scan(/(#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]})/)
        elsif dob.obj =~/#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}image/
          dob.obj.scan(/(#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}(image))/)
        else nil
        end
        if m then m.each do |i|
            cont,url=i[1],i[2]
            cont=cont.gsub(/([)(\]\[])/,"\\\\\\1").
              gsub(/([+?])/,"\\\\\\1") # incorrect handling of +
            url=url.gsub(/([+?])/,"\\\\\\1")
            dob.obj=dob.obj.sub(/#{Mx[:lnk_o]}[ ]*#{cont}[ ]*#{Mx[:lnk_c]}image/m,image_odf(i)).
              sub(/#{Mx[:lnk_o]}[ ]*#{cont}[ ]*#{Mx[:lnk_c]}#{Mx[:url_o]}#{url}#{Mx[:url_c]}/m,image_odf(i)).
              sub(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def text_link_odf(txt,url,trail)
        txt=txt.gsub(/(\\\+)/,'+') #this is convoluted, and risky :-(
        url=url.gsub(/(\\\+)/,'+') #this is convoluted, and risky :-(
        map_nametags=SiSU_Particulars::CombinedSingleton.
          instance.get_map_nametags(@md).nametags_map
        t=case url
        when /^https?:/
          %{<text:a xl:type="simple" xl:href="#{url}">#{txt.strip}</text:a>#{trail}}
        when /^:/                 # site same document collection html link
          url=url.gsub(/^:/,"#{@env.url.root}/")
          %{<text:a xl:type="simple" xl:href="#{url}">#{txt.strip}</text:a>#{trail}}
        when /^\.\.\//                 # site same document collection html link
          url=url.gsub(/^\.\.\//,"#{@env.url.root}/")
          %{<text:a xl:type="simple" xl:href="#{url}">#{txt.strip}</text:a>#{trail}}
        else                           # document internal link
          if map_nametags[url] \
          and map_nametags[url][:segname]
          else p "NOT FOUND name_tags: #{url}"
          end
          t=map_nametags[url] \
          && map_nametags[url][:segname] \
          ? (%{<text:a xl:type="simple" xl:href="#{@env.url.root}/#{@md.fnb}/#{map_nametags[url][:segname]}#{Sfx[:html]}##{url}">} \
            + %{#{txt.strip}</text:a>#{trail}})
          : %{#{txt.strip}#{trail}}
        end
        t
      end
      def text_link_odf_bookmark(txt,url,trail)
        SiSU_Particulars::CombinedSingleton.instance.get_map_nametags(@md).nametags_map
        %{<text:bookmark-ref text:reference-format="text" text:ref-name="#{url}">#{txt.strip}</text:bookmark-ref>#{trail}}
      end
      def text_link(dob)
        m=dob.obj.scan(/(#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]})/) #sort
        if m
          m.each do |i|
            txt,url,trail=i[1],i[2]
            txt=txt.gsub(/([)(\]\[])/,"\\\\\\1").
              gsub(/([+?*])/,"\\\\\\1") # problems with +
            url=url.gsub(/([+?])/,"\\\\\\1") # problems with +
            dob.obj=dob.obj.gsub(/#{Mx[:lnk_o]}[ ]*#{txt}#{Mx[:lnk_c]}#{Mx[:url_o]}#{url}#{Mx[:url_c]}/m,
                text_link_odf(txt,url,trail)). #make sure trailing ']' are not caught in url
              gsub(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def text_link_relative(dob)
        m=dob.obj.scan(/(#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:rel_o]}(\S+?)#{Mx[:rel_c]})/) #sort
        if m
          m.each do |i|
            txt,url,trail=i[1],i[2]
            txt=txt.gsub(/([)(\]\[])/,"\\\\\\1").
              gsub(/([+?*])/,"\\\\\\1") # problems with +
            url=url.gsub(/([+?])/,"\\\\\\1") # problems with +
            dob.obj=dob.obj.gsub(/#{Mx[:lnk_o]}[ ]*#{txt}#{Mx[:lnk_c]}#{Mx[:rel_o]}#{url}#{Mx[:rel_c]}/m,
                text_link_odf_bookmark(txt,url,trail)). #make sure trailing ']' are not caught in url
              gsub(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def text_link_relative_(dob)
        m=dob.obj.scan(/(#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:rel_o]}(\S+?)#{Mx[:rel_c]})/) #sort
        if m
          m.each do |i|
            txt,url,trail=i[1],i[2]
            txt=txt.gsub(/([)(\]\[])/,"\\\\\\1")
            dob.obj=dob.obj.gsub(/#{Mx[:lnk_o]}[ ]*#{txt}#{Mx[:lnk_c]}#{Mx[:rel_o]}#{url}#{Mx[:rel_c]}/m,
                text_link_odf(txt,url,trail)). #make sure trailing ']' are not caught in url
              gsub(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def normal(dob,p_num)                                                           #P1 - P3
        dob=footnote(dob)
        dob.obj=dob.obj.gsub(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
            '<text:a xl:type="simple" xl:href="\1">\1</text:a>'). #http ftp matches escaped, no decoration
          gsub(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,
            %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="mailto:\\1">\\1</text:a>#{the_url_decoration.xml_close}}).
          gsub(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
            %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="\\1">\\1</text:a>#{the_url_decoration.xml_close}}) #http ftp matches with decoration
        dob.obj= if dob.is==:para \
        and dob.indent.to_s =~/[0-9]/ \
        and dob.indent == dob.hang
          %{<text:p text:style-name="P_indent_#{dob.indent}">#{p_num[:set_ref]}#{set_bookmark_tag(dob)}#{dob.obj}#{p_num[:display]}</text:p>}
        elsif dob.is==:para \
        and dob.hang.to_s =~/[0-9]/ \
        and dob.indent != dob.hang
          %{<text:p text:style-name="P_h#{dob.hang}_i#{dob.indent}">#{p_num[:set_ref]}#{set_bookmark_tag(dob)}#{dob.obj}#{p_num[:display]}</text:p>}
        else %{<text:p text:style-name="P_normal">#{p_num[:set_ref]}#{set_bookmark_tag(dob)}#{dob.obj}#{p_num[:display]}</text:p>}
        end
        dob
      end
      def fontface(dob)
      end
      def footnote_urls(str)
        str=str.gsub(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
          %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="\\1">\\1</text:a>#{the_url_decoration.xml_close}})
        str=text_link(str) if str =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
        str=text_link_relative(str) if str =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/
        str
      end
      def footnote(t_o)
        str=if defined? t_o.obj then t_o.obj
        elsif t_o.is_a?(String) then t_o
        end
        if str
          @astx||=10000
          @astxs||=20000
          if str =~/#{Mx[:en_a_o]}\d+\s+/
            str=str.gsub(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/,
              '<text:note text:id="ftn\1" text:note-class="footnote"><text:note-citation>\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>')
          end
          if str =~/#{Mx[:en_a_o]}([*]+)\s+/
            a=$1.gsub(/([*])/,"\\\\\\1")
              str=str.gsub(/#{Mx[:en_a_o]}([*]+)\s+(.+?)#{Mx[:en_a_c]}/,
                %{<text:note text:id="ftn#{@astx.to_s}" text:note-class="footnote"><text:note-citation text:label="\\1">\\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \\2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>})
              @astxs+=1
          end
          if str=~/#{Mx[:en_a_o]}[*+]+\s/
            asterisk=str.scan(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)#{Mx[:en_a_c]}/)
            asterisk.each do |x|
              a=x[0].gsub(/([*+])/,"\\\\\\1")
              str=group_clean(str)
              str=footnote_urls(str)
              str=str.gsub(/#{Mx[:en_a_o]}(#{a})\s+(.+?)#{Mx[:en_a_c]}/,
                %{<text:note text:id="ftn#{@astx.to_s}" text:note-class="footnote"><text:note-citation text:label="\\1">\\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \\2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>})
              @astx+=1
            end
          end
          if str=~/#{Mx[:en_b_o]}[*+]\d+\s/
            asterisk=str.scan(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)#{Mx[:en_b_c]}/)
            asterisk.each do |x|
              a=x[0].gsub(/([*+])/,"\\\\\\1")
              str=group_clean(str)
              str=footnote_urls(str)
              str=str.gsub(/#{Mx[:en_b_o]}(#{a})\s+(.+?)#{Mx[:en_b_c]}/,
                %{<text:note text:id="ftn#{@astx.to_s}" text:note-class="footnote"><text:note-citation text:label="\\1">\\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \\2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>})
              @astx+=1
            end
          end
        end
        if defined? t_o.obj     then t_o.obj=str
        elsif t_o.is_a?(String) then t_o=str
        end
        t_o
      end
      def group_clean(str)
        str=str.gsub(/&amp;nbsp;|&nbsp;|#{Mx[:nbsp]}/,'&#160;').
          gsub(/</,'&lt;').gsub(/>/,'&gt;').
          gsub(/&lt;(text:span text:style-name="Span_\S+?"|\/text:span)&gt;/,'<\1>'). #works, not ideal
          gsub(/#{Mx[:br_line]}/,'<br />').
          gsub(/&lt;br(?:\s+\/)?&gt;/,'<br />')
      end
      def poem(dob,p_num)                                                             #P4 #same as group
        parray=[]
        dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each_with_index do |parablock,i|
          set_ref=(i==0) ? "#{p_num[:set_ref]}#{set_bookmark_tag(dob)}" : ''
          parablock=group_clean(parablock)
          parablock=footnote(parablock)
          parray << %{<text:p text:style-name="P_group">#{set_ref}#{parablock}</text:p>} if parablock =~/\S+/
        end
        dob.obj=parray.join \
        + %{<text:p text:style-name="P_group">#{p_num[:display]}</text:p>} \
        + '<text:p text:style-name="Standard"/>'
        dob
      end
      def group(dob,p_num)                                                            #P4 #same as verse
        parray=[]
        dob.obj=dob.obj.gsub(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
            '<text:a xl:type="simple" xl:href="\1">\1</text:a>'). #http ftp matches escaped, no decoration
          gsub(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,
            %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="mailto:\\1">\\1</text:a>#{the_url_decoration.xml_close}}).
          gsub(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
            %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="\\1">\\1</text:a>#{the_url_decoration.xml_close}}) #http ftp matches with decoration
        dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each_with_index do |parablock,i|
          set_ref=(i==0) ? "#{p_num[:set_ref]}#{set_bookmark_tag(dob)}" : ''
          parablock=group_clean(parablock)
          parablock=parablock.gsub(/&lt;text:a xl:type="simple" xl:href="(.+?)"&gt;/m,
              '<text:a xl:type="simple" xl:href="\1">').
            gsub(/&lt;(\/text:a)&gt;/,'<\1>').
            gsub(/&lt;(text:note text:id=.+?)&gt;/,'<\1>').
            gsub(/&lt;(text:p text:style-name="Footnote")&gt;/,'<\1>').
            gsub(/&lt;(\/?text:(?:note-citation|note-body|note|p))&gt;/,'<\1>')
          parablock=footnote(parablock)
          parray << %{<text:p text:style-name="P_group">#{set_ref}#{parablock}</text:p>} if parablock =~/\S+/
        end
        dob.obj=parray.join \
        + %{<text:p text:style-name="P_group">#{p_num[:display]}</text:p>} \
        + '<text:p text:style-name="Standard"/>'
        dob
      end
      def block(dob,p_num)                                                            #P4 #same as verse
        parray=[]
        dob.obj=dob.obj.gsub(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
            '<text:a xl:type="simple" xl:href="\1">\1</text:a>'). #http ftp matches escaped, no decoration
          gsub(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,
            %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="mailto:\\1">\\1</text:a>#{the_url_decoration.xml_close}}).
          gsub(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
            %{#{the_url_decoration.xml_open}<text:a xl:type="simple" xl:href="\\1">\\1</text:a>#{the_url_decoration.xml_close}}) #http ftp matches with decoration
        dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each_with_index do |parablock,i|
          set_ref=(i==0) ? "#{p_num[:set_ref]}#{set_bookmark_tag(dob)}" : ''
          parablock=group_clean(parablock)
          parablock=parablock.gsub(/&lt;text:a xl:type="simple" xl:href="(.+?)"&gt;/m,
              '<text:a xl:type="simple" xl:href="\1">').
            gsub(/&lt;(\/text:a)&gt;/,'<\1>').
            gsub(/&lt;(text:note text:id=.+?)&gt;/,'<\1>').
            gsub(/&lt;(text:p text:style-name="Footnote")&gt;/,'<\1>').
            gsub(/&lt;(\/?text:(?:note-citation|note-body|note|p))&gt;/,'<\1>')
          parablock=footnote(parablock)
          parray << %{<text:p text:style-name="P_group">#{set_ref}#{parablock}</text:p>} \
            if parablock =~/\S+/
        end
        dob.obj=parray.join \
        + %{<text:p text:style-name="P_group">#{p_num[:display]}</text:p>} \
        + '<text:p text:style-name="Standard"/>'
        dob
      end
      def code(dob,p_num)                                                             #P5
        if dob.is==:code
          dob.obj=dob.obj.gsub(/\s\s/,'&#160;&#160;')
          parray=[]
          dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each_with_index do |parablock,i|
            set_ref=(i==0) ? "#{p_num[:set_ref]}#{set_bookmark_tag(dob)}" : ''
            parablock=group_clean(parablock)
            parablock=parablock.gsub(/^\s*$/,'<br />').
              gsub(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
                '<text:a xl:type="simple" xl:href="\1">\1</text:a>') #http ftp matches escaped, no decoration
            parray << %{<text:p text:style-name="P_code">#{set_ref}#{parablock}</text:p>} if parablock =~/\S+/
          end
          dob.obj=parray.join \
          + %{<text:p text:style-name="P_group">#{p_num[:display]}</text:p>} \
          + '<text:p text:style-name="Standard"/>'
        end
        dob
      end
      def table(dob,p_num)                                                            #
        if dob.is ==:table
          dob=footnote(dob) #check
          table=SiSU_XML_ODF_ODT_Format::Table.new(@md,dob,p_num)
          dob=table.table
        end
        dob
      end
      def obj_break(dob)
        if dob.is ==:break
          br=SiSU_XML_ODF_ODT_Format::FormatObjBreak.new(@md,dob)
          if dob.obj==Mx[:br_page] \
          or dob.obj==Mx[:br_page_new]
            dob=br.br_page
          elsif dob.obj==Mx[:br_page_line]
            dob=br.br_page_line
          elsif dob.obj==Mx[:br_obj]
            dob=br.obj_sep
          end
        end
        dob
      end
      def odf_structure(md,dob)
        @md,@dob=md,dob
        dob=if dob.is !=:code
          dob=image(dob) if dob.obj =~/#{Mx[:lnk_o]}[ ]*\S+?\.(?:png|jpg|gif)\s.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/
          dob=text_link(dob) if dob.obj =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
          dob=text_link_relative(dob) if dob.obj =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/
          dob
        else dob
        end
        p_num={ display: '', set_ref: '' }
        if dob.is !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
          if @make.build.odt_ocn?
            if defined? dob.ocn \
            and dob.ocn.is_a?(Fixnum)
              p_num=SiSU_XML_ODF_ODT_Format::ParagraphNumber.new(@make,dob.ocn).set_bookmark_and_display
            end
          end
        end
        if dob.is==:heading
          @per.body << heading(dob,p_num).obj << break_line*2
          if SiSU_Env::ProcessingSettings.new(md).build.toc?
            if dob.lv =~/[A-D1]/i
              @per.toc << toc(dob,p_num).obj
            end
          end
        elsif dob.is ==:verse
          @per.body << poem(dob,p_num).obj << break_line*2
        elsif dob.is==:group
          @per.body << group(dob,p_num).obj << break_line*2
        elsif dob.is==:block
          @per.body << block(dob,p_num).obj << break_line*2
        elsif dob.is==:code
          @per.body << code(dob,p_num).obj << break_line*2
        elsif dob.is==:table #elsif dob.obj =~ /<!Th?¡/u
          @per.body << table(dob,p_num).obj << break_line*2
        elsif dob.is==:break
          @per.body << obj_break(dob).obj << break_line*2
        else
          @per.body << normal(dob,p_num).obj << break_line*2 # main text, contents, body KEEP
        end
        @@endnotes_para=[]
      end
      def tidywords(wordlist)
        wordlist
      end
      def markup(data)                                                                 # Used for major markup instructions
        #safe_characters=/[^a-zA-Z0-9}{\/?,."';:)(><\-_&!@%~#\]\[*=$| \n+`#{Mx[:tc_p]}]/u
        dir=SiSU_Env::InfoEnv.new(@md.fns)
        dir.path.odt_bld
        @data_mod,@endnotes,@level,@cont,@copen,@odf_contents_close=Array.new(6){[]}
        @rcdc=false
        (0..7).each { |x| @cont[x]=@level[x]=false }
        (4..7).each { |x| @odf_contents_close[x]='' }
        odf_tail #($1,$2)
        bullet=image_src('bullet_09.png')
        if bullet
          if FileTest.file?("#{bullet}/bullet_09.png")
            FileUtils::cp("#{bullet}/bullet_09.png","#{@env.processing_path.odt}/Pictures/.")
          else STDERR.puts %{\t*WARN* did not find image - "#{bullet}/bullet_09.png" [#{__FILE__}:#{__LINE__}]}
          end
        end
        odf_book_idx
        odf_metadata
        data.each do |dob|
          #p dob.obj if dob.obj =~safe_characters and @md.opt.selections.str =~/V/ #KEEP
          dob.obj='' if dob.obj =~/#{Mx[:lv_o]}\d+:.*?#{Mx[:lv_c]}.+?#{Mx[:pa_non_object_dummy_heading]}/ #fix Mx[:lv_o]
          para_array=[]
          dob.obj=dob.obj.gsub(/</,'&lt;').gsub(/>/,'&gt;')
          word=dob.obj.scan(/\S+|\n/)
          if word
            word.each do |w| # _ - / # | : ! ^ ~
              unless dob =~/^(?:#{Rx[:meta]}|%+ )/m
                w=w.gsub(/&#(?:126|152);/,'~'). #126 usual
                  gsub(/&nbsp;/,'&#160;')
                if w !~/(?:&\S{2,7}?;)+/
                  w=w.gsub(/&/,'&amp;')
                end
                if w !~/&\S{1,7}?;(?:&\S{1,7}?;)+/    #imperfect
                  w=w.gsub(/(&\S{1,7};)+&/,'\1&amp;')
                end
              end
              para_array << w
            end
            dob.obj=para_array.join(' ')
            dob.obj=dob.obj.strip
          end
          if dob.is==:code #{Mx[:gr_o]}code#{Mx[:gr_c]}/ #fix #code-block: angle brackets special characters #fix
            dob.obj=dob.obj.gsub(/(^|[^}])_(?:<|&lt;)/m,'\1&lt;').gsub(/(^|[^}])_(?:>|&gt;)/m,'\1&gt;').
              gsub(/(^|[^}])_(?:<|&lt;)/m,'\1&lt;').gsub(/(^|[^}])_(?:>|&gt;)/m,'\1&gt;')
          end
          if dob.of==:block
            dob.obj=dob.obj.gsub(/#{Mx[:gl_bullet]}/,'● ')
          end
          dob.obj=dob.obj.gsub(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>').
            gsub(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'<ins>\1</ins>').
            gsub(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'<cite>\1</cite>').
            gsub(/#{Mx[:tag_o]}\S+?#{Mx[:tag_c]}/,
              '<text:bookmark-start text:name="\1"/><text:bookmark-end text:name="\1"/>'). #check
            gsub(/#{Mx[:mk_o]}#([a-zA-Z]+)#{Mx[:mk_c]}/,'&\1;').
            gsub(/#{Mx[:mk_o]}(#[0-9]+)#{Mx[:mk_c]}/,'&\1;').
            gsub(/#{Mx[:mk_o]}[~-]##{Mx[:mk_c]}/,'')
          if dob.is==:para \
          and dob.bullet_
            dob.obj='<draw:frame draw:style-name="gr1" text:anchor-type="as-char" svg:width="0.22cm" svg:height="0.22cm" draw:z-index="2"><draw:image xl:href="Pictures/bullet_09.png" xl:type="simple" xl:show="embed" xl:actuate="onLoad"/></draw:frame> ' +
              dob.obj
          end
          dob.obj=dob.obj.gsub(/#{Mx[:br_line]}/,'<br />').
            gsub(/&#169;/,'©'). #too arbitrary
            gsub(/.+?<-#>/,'').                                           # remove dummy headings (used by html) #check
            gsub(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,
              '<text:span text:style-name="Span_bold">\1</text:span>').
            gsub(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,
              '<text:span text:style-name="Span_italic">\1</text:span>').
            gsub(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,
              '<text:span text:style-name="Span_underscore">\1</text:span>').
            gsub(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,
              '<text:span text:style-name="Span_superscript">\1</text:span>').
            gsub(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,
              '<text:span text:style-name="Span_subscript">\1</text:span>').
            gsub(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,
              '<text:span text:style-name="Span_monospace">\1</text:span>').
            gsub(/­/u,'-').
            gsub(/ /u, ' ').       # space identify
            gsub(/ /u, ' ').       # space identify
            gsub(/·/u,'*').
            gsub(/[­–—]/u,'-').   #— – chk
            gsub(/ < /i,'&#060;').
            gsub(/\\copy(?:right)?\b/,'&#169;').
            gsub(/\\trademark\b|\\tm\b/,'&#174;').
            gsub(/\44/,'&#36;'). #$ watch
            gsub(/<a href=".+?">(.+?)<\/a>/,'\1').
            gsub(/#{Mx[:mk_o]}name#\S+?#{Mx[:mk_c]}/,'')                                       # remove name links
          wordlist=dob.obj.scan(/\S+/)
          dob.obj=tidywords(wordlist).join(' ').strip
          @rcdc=true if @rcdc==false \
          and (dob.obj =~/~metadata/ \
          or dob =~/#{Mx[:lv_o]}1:meta#{Mx[:lv_x]}\s*Document Information/) #fix Mx[:lv_o]
          if dob.is !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/ #check
            if defined? dob.ocn and dob.ocn =~/\d+/
              @p_num=SiSU_XML_ODF_ODT_Format::ParagraphNumber.new(@make,dob.ocn)
            end
            if dob.is ==:heading \
            || dob.is ==:para \
            || dob.is ==:group \
            || dob.is ==:verse \
            || dob.is ==:code \
            || dob.is ==:table \
            || dob.is ==:break
              odf_structure(@md,dob)
            end
            if dob.obj ## Clean Prepared Text
              dob.obj=dob.obj.gsub(/<!.+!>/,' ').
                gsub(/#{Mx[:tc_o]}.+?#{Mx[:tc_c]}/,' ').
                gsub(/<:\S+>/,' ')
            end
          end
        end
      end
      def pre
        table=if @md.flag_tables
          x=<<WOK
  <style:style style:name="Table1" style:family="table"><style:table-properties style:width="16.999cm" table:align="margins"/></style:style>
  <style:style style:name="Table1.A" style:family="table-column"><style:table-column-properties style:column-width="16.999cm" style:rel-column-width="65535*"/></style:style>
  <style:style style:name="Table1.B" style:family="table-column"><style:table-column-properties style:column-width="8.499cm" style:rel-column-width="32767*"/></style:style>
  <style:style style:name="Table1.C" style:family="table-column"><style:table-column-properties style:column-width="5.666cm" style:rel-column-width="21845*"/></style:style>
  <style:style style:name="Table1.D" style:family="table-column"><style:table-column-properties style:column-width="4.349cm" style:rel-column-width="16383*"/></style:style>
  <style:style style:name="Table1.E" style:family="table-column"><style:table-column-properties style:column-width="3.399cm" style:rel-column-width="13107*"/></style:style>
  <style:style style:name="Table1.F" style:family="table-column"><style:table-column-properties style:column-width="2.833cm" style:rel-column-width="10922*"/></style:style>
  <style:style style:name="Table1.G" style:family="table-column"><style:table-column-properties style:column-width="2.428cm" style:rel-column-width="9362*"/></style:style>
  <style:style style:name="Table1.H" style:family="table-column"><style:table-column-properties style:column-width="2.124cm" style:rel-column-width="8191*"/></style:style>
  <style:style style:name="Table2" style:family="table"><style:table-properties style:width="16.999cm" table:align="margins"/></style:style>
  <style:style style:name="Table2.A" style:family="table-column"><style:table-column-properties style:column-width="16.999cm" style:rel-column-width="65535*"/></style:style>
  <style:style style:name="Table2.B" style:family="table-column"><style:table-column-properties style:column-width="8.499cm" style:rel-column-width="32767*"/></style:style>
  <style:style style:name="Table2.C" style:family="table-column"><style:table-column-properties style:column-width="5.666cm" style:rel-column-width="21845*"/></style:style>
  <style:style style:name="Table2.D" style:family="table-column"><style:table-column-properties style:column-width="4.349cm" style:rel-column-width="16383*"/></style:style>
  <style:style style:name="Table2.E" style:family="table-column"><style:table-column-properties style:column-width="3.999cm" style:rel-column-width="13107*"/></style:style>
  <style:style style:name="Table2.F" style:family="table-column"><style:table-column-properties style:column-width="2.833cm" style:rel-column-width="10922*"/></style:style>
  <style:style style:name="Table2.G" style:family="table-column"><style:table-column-properties style:column-width="2.428cm" style:rel-column-width="9362*"/></style:style>
  <style:style style:name="Table2.H" style:family="table-column"><style:table-column-properties style:column-width="2.124cm" style:rel-column-width="8191*"/></style:style>
  <style:style style:name="Table2.I" style:family="table-column"><style:table-column-properties style:column-width="1.8887cm" style:rel-column-width="7281*"/></style:style>
  <style:style style:name="Table2.J" style:family="table-column"><style:table-column-properties style:column-width="1.6999cm" style:rel-column-width="6553*"/></style:style>
  <style:style style:name="Table2.K" style:family="table-column"><style:table-column-properties style:column-width="1.5453cm" style:rel-column-width="5957*"/></style:style>
  <style:style style:name="Table2.L" style:family="table-column"><style:table-column-properties style:column-width="1.416cm" style:rel-column-width="5461*"/></style:style>
  <style:style style:name="Table2.M" style:family="table-column"><style:table-column-properties style:column-width="1.307" style:rel-column-width="5041*"/></style:style>
  <style:style style:name="Table2.N" style:family="table-column"><style:table-column-properties style:column-width="1.214cm" style:rel-column-width="4681*"/></style:style>
WOK
          x=x.strip
          x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
          x
        else ''
        end
        x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-content xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xl="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:rpt="http://openoffice.org/2005/report" xmlns:of="urn:oasis:names:tc:opendocument:xmlns:of:1.2" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:grddl="http://www.w3.org/2003/g/data-view#" xmlns:tableooo="http://openoffice.org/2009/table" xmlns:field="urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0" xmlns:formx="urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0" xmlns:css3t="http://www.w3.org/TR/css3-text/" office:version="1.2"><office:scripts/>
<office:font-face-decls><style:font-face style:name="DejaVu Sans Mono" svg:font-family="'DejaVu Sans Mono'" style:font-adornments="Book" style:font-family-generic="modern" style:font-pitch="fixed"/><style:font-face style:name="Inconsolata" svg:font-family="Inconsolata" style:font-adornments="Regular" style:font-pitch="fixed"/><style:font-face style:name="Liberation Mono" svg:font-family="'Liberation Mono'" style:font-adornments="Regular" style:font-family-generic="modern" style:font-pitch="fixed"/><style:font-face style:name="DejaVu Sans" svg:font-family="'DejaVu Sans'" style:font-adornments="ExtraLight" style:font-family-generic="swiss" style:font-pitch="variable"/><style:font-face style:name="Nimbus Sans L" svg:font-family="&apos;Nimbus Sans L&apos;" style:font-pitch="variable"/><style:font-face style:name="Tahoma" svg:font-family="Tahoma, Lucidasans, &apos;Lucida Sans&apos;, &apos;Arial Unicode MS&apos;" style:font-pitch="variable"/><style:font-face style:name="Nimbus Roman No9 L" svg:font-family="&apos;Nimbus Roman No9 L&apos;" style:font-family-generic="roman" style:font-pitch="variable"/><style:font-face style:name="Bitstream Vera Sans" svg:font-family="&apos;Bitstream Vera Sans&apos;" style:font-family-generic="swiss" style:font-pitch="variable"/></office:font-face-decls>
<office:automatic-styles>
#{table}
  <style:style style:name="P_table_cell" style:family="paragraph" style:parent-style-name="Table_Contents"><style:paragraph-properties fo:text-align="justify" style:justify-single-word="false"/></style:style>
</office:automatic-styles>
<office:body>
  <office:text text:use-soft-page-breaks="true">
    <office:forms form:automatic-focus="false" form:apply-design-mode="false"/>
    <text:sequence-decls><text:sequence-decl text:display-outline-level="0" text:name="Illustration"/><text:sequence-decl text:display-outline-level="0" text:name="Table"/><text:sequence-decl text:display-outline-level="0" text:name="Text"/><text:sequence-decl text:display-outline-level="0" text:name="Drawing"/></text:sequence-decls>
WOK
        x=x.strip
        x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
        @per.head << x
      end
      def publish
        content=[]
        br_pg='<text:p text:style-name="P_normal_page_new"> </text:p>'
        content <<
          @per.head <<
          @per.toc <<
          br_pg <<
          @per.body <<
          @per.book_idx <<
          br_pg <<
          @per.metadata <<
          @per.tail
        SiSU_XML_ODF_ODT::Source::Output.new(content,@md,@env).odf
        @@odf={ head: [], toc: [], body: [], tail: [], book_idx: [], metadata: [] }
      end
    end
    class Output <Source
      def initialize(content,md,env)
        @content,@md,@env=content,md,env
      end
      def odf                                                           #%odf output
        env=SiSU_Env::FileOp.new(@md)
        env.mkdir
        header=SiSU_XML_ODF_ODT_Format::ODT_Head_1_2.new(@md)
        filename="#{@env.processing_path.odt}/manifest.rdf"
        od=File.new(filename,'w+')
        od << header.manifest_rdf
        od.close
        filename="#{@env.processing_path.odt}/META-INF/manifest.xml"
        od=File.new(filename,'w+')
        od << header.meta_inf_manifest_xml(@md)
        od.close
        filename="#{@env.processing_path.odt}/meta.xml"
        od=File.new(filename,'w+')
        od << header.meta_xml
        od.close
        filename="#{@env.processing_path.odt}/settings.xml"
        od=File.new(filename,'w+')
        od << header.settings_xml
        od.close
        filename="#{@env.processing_path.odt}/styles.xml"
        od=File.new(filename,'w+')
        od << header.styles_xml
        od.close
        filename="#{@env.processing_path.odt}/mimetype"
        od=File.new(filename,'w+')
        od << header.mimetype
        od.close
        env.make_path(@env.processing_path.odt)
        env.make_path(@md.file.output_path.odt.dir)
        filename="#{@env.processing_path.odt}/content.xml"
        od=File.new(filename,'w+')
        @content.compact.each do |para|                                                # this is a hack
          od.puts para unless para =~/\A\s*\Z/
        end
        od.close
        opendoc=@md.file.base_filename.odt #watch where output by language
        FileUtils::mkdir_p(@md.file.output_path.odt.dir) \
          unless FileTest.directory?(@md.file.output_path.odt.dir)
        if FileTest.directory?(@env.processing_path.odt) \
        and SiSU_Env::SystemCall.new.zip
          pwd=Dir.pwd
          Dir.chdir(@env.processing_path.odt)
          system("
            zip -qr #{opendoc} *
          ")
          FileUtils::mv(opendoc, @md.file.place_file.odt.dir)
          Dir.chdir(pwd)
        else
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).mark('*EXITED odf* zip program not found') unless SiSU_Env::SystemCall.new.zip
        end
      end
    end
  end
end
__END__
