#### Problem description

Be sure your description clearly answers the following questions:

- What are you trying to achieve?
- What is the expected result?
- What are you seeing instead?

#### Steps/code to reproduce the problem

In order for us to be able to solve your problem, we have to be able to reproduce it on our end.
Without reproducing the problem, it is unlikely that we'll be able to help you.

Include full tracebacks, logs and datasets if necessary.
Please keep the examples minimal ([minimal reproducible example](https://stackoverflow.com/help/minimal-reproducible-example)).

#### Versions

Please provide the output of:

```python
import platform, sys, smart_open
print(platform.platform())
print("Python", sys.version)
print("smart_open", smart_open.__version__)
```

#### Checklist

Before you create the issue, please make sure you have:

- [ ] Described the problem clearly
- [ ] Provided a minimal reproducible example, including any required data
- [ ] Provided the version numbers of the relevant software
