# Shard

Shard is an engine agnostic RTS AI framework for games. Currently implementing the Spring RTS Engine. It provides a C++ API with wrappers for a writing AI code in a lua environment.

The best documentation is at https://shard.tomjn.com although there's some of the most prominent information below

## Building For The Spring Engine

For *nix operating systems, clone into the AI directory giving a Shard folder alongside the other AIs, and build the engine as normal. Shard will be built along with the other AIs automatically if all is set up correctly.

For users of visual studio, a project is provided, but you will need a Spring Engine to test with, and source code with the appropriate libraries and wrappers required for general AI work. In particular you will need to acquire the C++ AI Wrappers which can be generated via the *nix build system.

## Writing AIs With Shard

If you have a prebuilt copy of Shard ( as comes with every install of the Spring Engine ), you don't need to build Shard to use it, you need only a text editor and knowledge of lua.

## Directory Structure

### data

This folder contains the lua AI, and is copied as is into the target AI folder by the spring engines make files. This is also where you will find the AIInfo.lua etc

#### data/preload

This folder contains some core files that underpin the structure of the API, namely the definition of an AI module, and the tables that wrap around whatever engine is being used at the time. `api.lua` will load files from a subfolder depending on the environment it finds itself in.

When using the AI in a new environment, be sure to pass units through `shardify_unit` before passing units to the main Shard AI object acquired via `ai.lua` so that Shard can use the functions it expects.

### lib

This contains the dependent libraries specific to the AI. Currently only the lua 5 VM is present. The Spring Engine API and headers are included with the game engine itself. Some of these headers and APIs are automatically generated by AWK scripts when the engine is built.

### src

This folder contains the stub AI itself, the C++ component that interfaces with the engine and provides the lua environment Shards AI logic runs in. cpptestai is the main object that handles the engines events and translates them, wrapping unit objects etc. CTestAI is the object that calls the lua environment etc. If you're building a pure C++ AI, you may want to replace this class with your own and remove or repurpose the lua code.

### vstudio

A Visual Studio 2010 project. It may work but it's recommended you use the Spring Engine build system
