/*
 * $Id: XMLEventConsumerDelegateTest.java,v 1.3 2004-08-19 15:58:17 cniles Exp $
 * 
 * Copyright (c) 2004, Christian Niles, Unit12
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *		*   Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 * 
 *	    *	Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 * 
 *      *   Neither the name of Christian Niles, Unit12, nor the names of its
 *          contributors may be used to endorse or promote products derived from
 *          this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package javanet.staxutils;

import java.io.StringWriter;
import java.io.Writer;

import javanet.staxutils.io.StreamEventWriter;

import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

/**
 *
 * @author Christian Niles
 * @version $Revision: 1.3 $
 */
public class XMLEventConsumerDelegateTest extends StAXTestCase {

    public void testWriteElement() throws Exception {

        // construct writers
        StringWriter writer = new StringWriter();
        XMLEventWriter eventWriter = createEventWriter(writer);

        // create an empty element
        XMLEventConsumerDelegate out = createDelegate(eventWriter);
        out.addStartElement("element", null);
        out.addEndElement("element");

        // flush the writers
        eventWriter.flush();
        writer.flush();

        // test the result
        String xml = writer.getBuffer().toString();
        assertEquals("XML output failed (" + xml + ")", "<element/>", xml);

    }

    public void testWriteTextElement() throws Exception {

        StringWriter writer = new StringWriter();
        XMLEventWriter eventWriter = createEventWriter(writer);

        XMLEventConsumerDelegate out = createDelegate(eventWriter);
        out.addTextElement("element", "text", null);

        eventWriter.flush();
        writer.flush();

        String xml = writer.getBuffer().toString();

        assertEquals("XML output failed (" + xml + ")",
                "<element>text</element>", xml);

    }

    protected XMLEventConsumerDelegate createDelegate(XMLEventWriter eventWriter) {

        return new XMLEventConsumerDelegate(eventWriter, eventFactory);

    }

    protected XMLEventWriter createEventWriter(Writer writer)
            throws XMLStreamException {

        return new StreamEventWriter(writer);

    }

}