/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DETAILSPARAM_H
#define _SC_DETAILSPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/svn.h"


/**
 * Parameter class for DetailsCmd.
 */
class DetailsParam : public ScParam
{
public:
  DetailsParam( const sc::String& pathOrUrl ) : _pathOrUrl(pathOrUrl)
  {
  }

  ~DetailsParam()
  {
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }


  sc::String& getReposRoot()
  {
    return _root;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(DetailsParam);

private:
  // in
  sc::String      _pathOrUrl;
  // out
  svn::Revnumber  _revnum;
  sc::String      _root;
};

#endif // _SC_DETAILSPARAM_H
