C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                        SUBROUTINE AFECTF
C                       *****************
C
C     -----------------------------------
     * (NSF1,NSF2,NSF3,ICFA,
     *  NDIM,NDIELE,NELEMS,NDMATS,NBFACE,
     *  NODES,NREFAC,NPOINS,NREFS)
C     -----------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             AFFECTATION DES FACES DE TYPE IDEAS                      *
C             MISES SUR DEES THIN SHELL                                *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C    NSF1..23 !    !    ! Numero des neuds sommets de la face          !
C !  ICFA     !    !    ! COULEUR DE LA FACE                           !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEMES                       !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELEMENTS(2=triangles,3=tetraed)!
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES SOLIDES (volumiques)    !
C !  NODES    ! TE ! D  ! CONNECTIVITE                                 !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS PAR ELEMENTS                !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELEMENTS                            !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NDIM,NDIELE,NELEMS,NDMATS,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFAC(NELEMS,NBFACE)
      INTEGER NPOINS,NREFS(NPOINS)
C
C.. Variables internes
      INTEGER I,J
      INTEGER N1,N2,N3,N4,N5,N6,NR1,NR2,NR3,NR4,NR5,NR6
C
C     NARE(noeud,arete), NFAC(noeud,face)
      INTEGER NARE(3,3),NFAC(6,4)
C
      INTEGER OK,NSF1,NSF2,NSF3,ICFA
C***********************************************************************
C
      DATA NARE/1,2,4,  2,3,5,  3,1,6/
      DATA NFAC/1,2,3,5,6,7,  1,2,4,5,9,8,  1,3,4,7,10,8,  2,3,4,6,10,9/
C
C     1- INITIALISATIONS
C     ------------------
C
C
C     2- CAS D'UN MAILLAGE EN TRIANGLES ( a faire au 27/07/01)
C     =================================
C
      IF (NCTHFS.EQ.3 .AND. NDIELE.EQ.2) THEN
C
        DO 200 J=1,NBFACE
          DO 210 I=1,NELEMS
C
C           Numeros des 3 noeuds de l'arete : 1----3----2
            N3 = NODES(I,NARE(3,J))
C
            IF (NSF3.EQ.N3) NREFAC(I,J) = ICFA
C
  210   CONTINUE
  200  CONTINUE
C
C
C     3- CAS D'UN MAILLAGE EN TETRAEDRES
C     ==================================
C
      ELSEIF (NDIELE.EQ.3) THEN
C
         DO  J=1,NBFACE
            DO I=1,NELEMS
C                                                     3
C                                                   /  \
C           Numeros des 3 noeuds de la face :             
C                                                /        \                    C                                               1----- -----2
            N1 = NODES(I,NFAC(1,J))
            N2 = NODES(I,NFAC(2,J))
            N3 = NODES(I,NFAC(3,J))
C
C
C           Mise en place de la reference de face courante
            OK = 0
            IF (NSF1.EQ.N1.AND.NSF2.EQ.N2.AND.NSF3.EQ.N3) OK = 1
            IF (NSF1.EQ.N1.AND.NSF2.EQ.N3.AND.NSF3.EQ.N2) OK = 1
            IF (NSF1.EQ.N2.AND.NSF2.EQ.N3.AND.NSF3.EQ.N1) OK = 1
            IF (NSF1.EQ.N2.AND.NSF2.EQ.N1.AND.NSF3.EQ.N3) OK = 1
            IF (NSF1.EQ.N3.AND.NSF2.EQ.N1.AND.NSF3.EQ.N2) OK = 1
            IF (NSF1.EQ.N3.AND.NSF2.EQ.N2.AND.NSF3.EQ.N1) OK = 1
C
C           Si OK il s'agit effectivement d'une face de bord
            IF (OK.EQ.1) NREFAC(I,J) = ICFA
C
            ENDDO
         ENDDO
C
C
      ELSE
C
C     5- CAS D'ERREUR
C     ===============
        WRITE(NFECRA,5000)
        STOP
C
      ENDIF
C
C--------
C FORMATS
C--------
 5000 FORMAT(//,' %% ERREUR AFECFA : ON N''EST DANS AUCUNE DES ', 
     &           'CONFIGURATIONS PREVUES')
C
      END
