# $Id: stripes.tcl 1513 2008-10-15 17:39:41Z sergei $
# "Stripes" chat plugin for Tkabber -- colorizes background of
# whole messages in chat windows.
#
# Written by Konstantin Khomoutov <flatworm@users.sourceforge.net>
# See license.terms for the terms of distribution.
# See README for usage details.

# Color for odd and even messages can be tuned separately
# using the Tk option database (or XRDB) like this:
# option add *Chat.oddBackground  gray77
# option add *Chat.evenBackground gray84

namespace eval stripes {
    variable state

    hook::add open_chat_post_hook \
	[namespace current]::setup_chat_window
    hook::add draw_message_post_hook \
	[namespace current]::on_message_drawn
}

proc stripes::setup_chat_window {chatid type} {
    variable state

    set cw [::chat::chat_win $chatid]
    set mw [::chat::winid $chatid]

    set bgodd [option get $mw oddBackground Chat]
    if {$bgodd != ""} {
	$cw tag configure odd -background $bgodd
    }
    set bgeven [option get $mw evenBackground Chat]
    if {$bgeven != ""} {
	$cw tag configure even -background $bgeven
    }

    set state($cw,last) 1.0
    set state($cw,tag) odd

    bind $cw <Destroy> +[list [namespace current]::cleanup $cw %W]
}

proc stripes::cleanup {w1 w2} {
    if {![string equal $w1 $w2]} return

    variable state
    unset state($w1,last)
    unset state($w1,tag)
}

proc stripes::on_message_drawn {chatid from type body x} {
    if {![chat::is_opened $chatid]} return

    set cw [::chat::chat_win $chatid]

    variable state
    upvar 0 state($cw,last) last
    upvar 0 state($cw,tag)  tag

    set now [$cw index {end - 1 char}]
    if {[$cw compare $last < $now]} {
	$cw tag add $tag $last $now
	if {[string equal $tag even]} {
	    set tag odd
	} else {
	    set tag even
	}
    }

    set last $now
}

# vim:ts=8:sw=4:sts=4:noet
